#include "colors.inc"
#include "textures.inc"
#include "disturb.inc"

global_settings { assumed_gamma 2.9 }

// camera {location <1,1.4,-51> look_at <5.6,0.5,-40>}
camera {location <0,7,-62.5> look_at <0,7,5> }

light_source { <-100,15,-44> color Gold }
light_source { <-100,15,-44> color Red }
light_source { <0,7,-50> color White }


                   // The checker floor

   box {<-35,-0.5,-80> <35,-0.6,30> pigment {checker White, Gray70}
	finish { phong_size 10 phong 0.2 reflection 0.1 refraction 0.3} }

                  // The grass outside

   box {<-500,-0.6,-100> <500,-0.7,100> pigment { ForestGreen}
	finish { ambient 0.4} normal {bumps 0.8 scale 0.4} }

                  // The sky sphere

   sphere { 1, 250 scale <1,0.25,1>
           pigment { Sky scale 11 translate -13*y rotate <12,0,23>}
	   finish {ambient 1 diffuse 0.1} hollow }
   fog { distance 300 color rgb <1,0.6554,0.3909>
          fog_type 2 fog_offset 3 fog_alt 11 }

                  // Some objects

   object {Floor}
   object {Blackboard}
   object {Desk1}
   object {Garb rotate <-80,30,0> translate <-5,0.5,-3>}
   object {Clock scale 2 translate <0,21.5,4.45> finish {ambient 0.5}}
   object {Poster_2 scale 1.1 rotate <0,90,0> translate <20.45,4,-25>}
   object {Poster scale 0.6 rotate <90,60,0> translate <5.6,-0.45,-44>
           normal {bumps 0.1 scale 0.4} }

                  // The walls'n ceiling

union {
   object {Wall_L translate -8*x}
   object {Wall_R translate 8*x}
   object {Wall_F translate -72*z}
   object {Ceiling pigment {White}
            finish {phong_size 1 phong 0.2}
            normal {crackle scale 0.26} }
           pigment {White}  finish {phong_size 1 phong 0.2} }
   object {Wall_F pigment {White} }

			       // Chairs, lot of chairs...

union {
   object {Chair rotate 31*y translate <-11,1.8,0.6>}
   object {Chair rotate -66*y translate <11,1.8,0.6>}
   object {Chair rotate 50*y translate <-8,1.8,-1>}
   object {Chair rotate -50*y translate <14,1.8,0.6>}
   object {Chair rotate 31*y translate <-2,1.3,-44>}
   object {Chair rotate -45*y translate <18,1.3,-20>}
   object {Chair rotate -42*y translate <18,1.3,-22>}
   object {Chair rotate -36*y translate <14,1.3,-24>}
   object {Chair rotate -45*y translate <15,1.3,-26>}
   object {Chair rotate -45*y translate <17,1.3,-30>}
   object {Chair rotate -45*y translate <18,1.3,-34>}
   object {Chair rotate -5*y translate <18,1.3,-36>}
   object {Chair rotate -45*y translate <15,1.3,-38>}
   object {Chair rotate 39*y translate <-15,1.3,-25>}
   object {Chair rotate 121*y translate <-4,1.3,-24>}
   object {Chair rotate -118*y translate <11,1.3,-25>}
   object {Chair rotate <-93,30,0> translate <2,0.45,-37>}
   object {Chair rotate <-93,0,0> translate <-15,0.45,-15>}
   object {Broken_Chair rotate <-20,0,90> translate <-6,0.47,-39>}
   object {Chair rotate <30,0,90> translate <-11,0.47,-16>}
   object {Chair rotate <30,0,90> translate <-10,0.47,-26>}
   object {Chair rotate <131,-130,0> translate <11,0.26,-15>}
   object {Chair rotate <131,72,0> translate <8,0.26,-33>}
   object {Broken_Chair_2 rotate <131,-160,0> translate <2,0.26,-45>}
          texture {DMFWood6 scale 0.4} }

                  // The kid's desks

   object {Desk rotate 15*y translate <-2,1.5,-42>
        texture {DMFWood6 scale 1.1} }
   object {Desk rotate <90,35,0> translate <-11,0.6,-41>
        texture {DMFWood6 scale 1.7} }
   object {Desk rotate -15*y translate <-9,1.5,-15>
        texture {DMFWood6 scale 1.1} }
   object {Desk rotate -45*y translate <1,1.5,-8>
        texture {DMFWood6 scale 1.3} }
   object {Desk rotate 45*y translate <6,1.5,-8.9>
        texture {DMFWood6 scale 1.3} }
   object {Desk rotate 25*y translate <14,1.5,-15>
        texture {DMFWood6 scale 1.1} }
   object {Desk rotate <180,20,0> translate <-2,1.1,-31>
        texture {DMFWood6 scale 2.3} }
   object {Desk rotate <180,50,0> translate <5,1.1,-19>
        texture {DMFWood6 scale 2.3} }
   object {Desk rotate <0,0,-90> translate <-6,1.1,-27>
        texture {DMFWood6 scale 2.3} }
   object {Desk_L rotate <-10,0,90> translate <3,1.4,-29>
        texture {DMFWood6 scale 2.3} }
   object {Desk rotate <0,0,90> translate <12,1.1,-39>
        texture {DMFWood6 scale 2.3} }
   object {Desk rotate 33*y translate <-18,2,3>
        texture {DMFWood6 scale 2.5} }
   object {Desk rotate -33*y translate <-14,2,2>
        texture {DMFWood6 scale 2.5} }


                  // Ceiling's neon boxes

   object {Neon scale 2  translate <-11,25,0>}
   object {Neon scale 2  translate <-11,25,-10>}
   object {Neon scale 2  translate <-11,25,-30>}
   object {Neon scale 2  translate <-11,25,-40>}
   object {Neon scale 2  translate <-11,25,-50>}
   object {Neon scale 2  translate <-11,25,-60>}
   object {Neon scale 2  translate <10,25,0>}
   object {Neon scale 2  translate <10,25,-10>}
   object {Neon scale 2  translate <10,25,-20>}
   object {Neon scale 2  translate <10,25,-30>}
   object {Neon scale 2  translate <10,25,-40>}
   object {Neon scale 2  translate <10,25,-50>}
   object {Neon scale 2  translate <10,25,-60>}

               // A box with just one neon left:

   object {Neon_Box scale 2 translate <-11,25,-20>}
   object {Neon_lite scale 2 rotate <0,4,-3.5>
           translate <-11,24.2,-20.5>}

               // The unbroken one:

   object {Neon_lite scale <1.7,2,2> rotate 50*y
           translate <5,-0.43,-44>}

               // No doubt about it, these are unusable:

   object {Violenced_Neon rotate 135*y scale 2
           translate <-4.9,-0.43,-44> pigment {White}
           finish {ambient 0.1 diffuse 0.9
                   phong 0.8 phong_size 150} }

union {
   object { Very_Little_Piece_Of_Glass scale 2 translate <-4.2,-0.43,-46>}
   object {Broken_Neon scale 2 rotate 10*x translate <-6,-0.43,-46>}
           pigment {White}
           finish {ambient 0.1 diffuse 0.9
                   phong 0.8 phong_size 150} }



object {File_1 scale 0.8 rotate <-31,0,90> translate <-11,0.5,-30>}
object {Drawer scale 0.8 rotate <-17,0,90> translate <9,0.3,-37>}


object {Earth scale 0.4 translate <11,0.6,-43>}

			      // Little stores in the windows

   object {Store pigment {White}
	   finish {ambient 0.6 phong 1} }
   object {Store pigment {White} translate -15.5*z
 	   finish {ambient 0.6 phong 1} }
   object {Store pigment {White} translate z*-15.5*2
 	   finish {ambient 0.6 phong 1} }

                 // Books
union {
object {Blue_Book rotate <0,0,0> translate <1.1,-1.2,0>}
object {Pale_Blue_Book rotate <0,10,0> translate <0,-1.2,0>}
object {Green_Book rotate <0,10,0> translate <-1.1,-1.2,0>}
object {Green_Book rotate <30,90,0> translate <0.5,-0.45,0.7>}
object {Red_Book rotate <0,30,0> translate <0,-0.9,0>}
object {Red_Book rotate <0,-30,0> translate <-0.8,-1,0>}
object {Red_Book rotate <0,-10,0> translate <0,-0.7,0>}
translate <-10,0.9,-45.5>}

union {
object {Green_Book  translate <-1.1,0,0.2> }
object {Green_Book  translate <-1.2,0.25,-0.1>}
object {Green_Book  translate <-1.0,0.45,0.1>}
object {Green_Book  translate <-1.1,0.65,-0.2>}
object {Green_Book rotate 44*y translate <-1.3,0.85,0.3>}
object {Green_Book  translate <-1.1,1.05,-0.4>}

object {Green_Book  translate <1.2,0,-2>}
object {Green_Book  translate <1.2,0.25,-2.1>}
object {Green_Book  translate <1.3,0.45,-2.13>}
object {Green_Book  translate <1.34,0.65,-2.02>}
object {Green_Book rotate 63*y translate <1.4,0.85,-1.3>}

object {Green_Book  translate <1.09,0.0,0.2>}
object {Green_Book  translate <1.21,0.25,0.1>}
object {Green_Book  translate <1.01,0.45,0>}
object {Green_Book  translate <1.1,0.65,0>}
object {Green_Book  translate <1.2,0.85,-0.1>}
object {Green_Book rotate 60*y translate <1.06,1.05,0.6>}
object {Green_Book  translate <1.13,1.25,0.1>}
object {Green_Book  translate <1.1,1.45,0>}
object {Green_Book  translate <1.1,1.65,0>}
object {Green_Book rotate -20*y translate <1.1,1.85,-0.3>}
translate <3.8,-0.2,-40>}

object {Open_Book_3 scale <1,1,1> rotate 18*y translate <4.2,-0.35,-47>}
object {Open_Book_2 scale <0.5,0.5,1.1>
	rotate 28*y translate <8.7,-0.42,-46.5>}

union {
object {Smashed_Mirror scale 1.4 translate <0,-0.5,-45>}
object {Smashed_Mirror scale 1.6 translate <-0.4,-0.5,-42>}
object {Smashed_Mirror scale 1.5 rotate 90*y translate <0.2,-0.5,-44>}
        pigment {White} finish {Mirror}}


/*************************************************************************/
                  // This is the end of file //
