// Bougie

#include "colors.inc"
#include "textures.inc"
#include "finish.inc"

#declare coulee1= lathe {
	cubic_spline
	9,
	<0,   -1.51>,
	< 0.1, -1.5>,
	< 0.3, -1.4>,
	< 0.4, -1.2> ,
	< 0.4, -1>,
	< 0.3, -0.7>,
	< 0.1, -0.4>,
	< 0.01,    0>,
	< 0,  0.5>

	scale <0.5, 1, 0.5>
	scale 2/3
}

#declare coulee2= lathe {
	cubic_spline
	9,
	<0,   -2.1>,
	< 0.1, -2>,
	< 0.3, -1.9>,
	< 0.4, -1.7> ,
	< 0.4, -1>,
	< 0.3, -0.7>,
	< 0.1, -0.4>,
	< 0.1,    0>,
	< 0,  0.5>

	scale <0.5, 1, 0.5>
	scale 0.5
}

#declare meche=blob {
	cylinder { 
		<0,0,0>,
		<0,0.8,0>,
		0.1,
		1
		pigment { Black }
	}

	cylinder {
		<0,0.80000001,0>,
		<0,1,0>
		0.1,
		1
		pigment { color rgb <1, 0.7, 0.6> }
	}
}


#declare flamme=lathe {
	cubic_spline
	9,
	<0,   -1.51>,
	< 0.1, -1.5>,
	< 0.3, -1.4>,
	< 0.4, -1.2> ,
	< 0.4, -1>,
	< 0.3, -0.7>,
	< 0.1, -0.4>,
	< 0.01,    0>,
	< 0,  0.5>

	translate <0, 1.2, 0>
	scale 2/3
	
	pigment { color rgbt<1, 1, 1, 1> }
	halo {
		emitting
		spherical_mapping
		linear
		color_map {
			[ 0	color rgbt < 1, 1,   0  ,  1  > ]
			[ 0.60  color rgbt < 1, 1,   0.5, -1  > ]
			[ 0.65	color rgbt < 1, 1,   0,   -1  > ]
			[ 0.75	color rgbt < 1, 0.5, 0,	  -0.5> ]
			[ 0.80	color rgbt < 1, 0,   0,   -0.5> ]
			[ 0.90  color rgbt < 0, 0,   0.6,   0.5 > ]
			[ 0.99  color rgbt < 0, 0,   0,    0.5  > ]
			[ 1  	color rgbt < 0, 0,   0,    0.75 > ]
		}
		samples 5
		
		turbulence < 0, 0.5, 0 >
		octaves 3
		lambda 3.0
		omega 0.5
	}
	hollow
	no_shadow
}


#declare corp=difference {
	merge {
		cylinder {
			<0,0,0>,
			<0,1,0>,
			1
			scale <0.5, 2, 0.5>
		}
	
		object{
			coulee1
			translate x*0.5
			rotate y*45
			translate <0, 1.45, 0>
		}

		object{
			coulee2
			translate x*0.5
			rotate y*130
			translate <0, 1.7, 0>
		}
	}

	sor {
		5,
		< 0.0, 0>,
		< 0.5, 0.25>,
		< 1.0, 1>,
		< 2.0, 4>,
		< 3.0, 9>
		scale <1, 0.25, 1>
		rotate <3,0,6>
		translate <0,0.75,0>
		rotate <0,-90,0>
		scale <0.5, 2, 0.5>
	}
}

	
#declare UnBoutCire=difference {
		sphere { < 0, 0, 0 >, 1 }
		box { <4,0,4>, <-4,-4,-4> }

		scale <1, 0.2, 1>
	}

#declare TrucEnBas=difference {
	blob {
		threshold 0.5
		sphere { <0, -0.5, -0.5>, 1, 1 }
		sphere { < -0.2, 0, -0.2>, 0.5, 1 }
		cylinder { <0,-1,0>, <0,0.5,0>, 0.9999, 1}
		scale <1, 0.75, 1>
	}

	box { <10,0,10>, <-10,-60, -10> }

	pigment { color rgb <1, 1, 0.75> }
	finish  { phong 0.5 }
	normal { crackle 
		scale 0.75}
}

#declare CireEnBas=merge {
	object { UnBoutCire
		scale 0.5
		translate <0.3, 0, 0.2>
	}

	object { UnBoutCire
		scale 0.75
		translate <-0.2, 0, 0.1>
	}

	object { UnBoutCire
		scale 0.25
		translate <-.3, 0, 0.05>
	}

	object { UnBoutCire
		scale 0.6
		translate <0.2, 0, 0.4>
	}

	object { UnBoutCire
		scale 0.3
		translate <-0.6, 0, 0.3>
	}

	scale <1.8,1.2,1.8>

	pigment { color rgb <1, 1, 0.75> }
	finish  { phong 0.5 }
	normal { crackle scale 0.75}
}
 
#declare bougie= union {

	object { CireEnBas scale <0.5, 1, 0.5> }
	object { corp }
	object { meche scale  <1, 2.3, 1> }
	object { TrucEnBas }
	object { CireEnBas scale <1, 0.3, 1> }

	pigment { color rgb <1, 1, 0.75> }
	finish  { phong 0.5 }
}

#declare bougieAllumee= union {
	object { bougie }
	object { flamme scale 1.5 translate <0, 2.2, 0> }
}