// Persistence of Vision Raytracer
// L'cole proprement dite

/******************************************************************************
   A faire:
******************************************************************************/

/******************************************************************************

        textures

******************************************************************************/

#declare Ecole_CPlatre=color rgb<1, .95, .9>*1
#declare Ecole_PContour=pigment{color Black}

#declare Ecole_NPlastique= normal{
   bumps 0.0
   }

#declare Ecole_PExplosion =pigment {
   bozo
   color_map{
      [0 0.5 color Clear color Clear]
      [0.5 1 color red 0 green 0 blue 0 transmit 1 color Black]
      }
   scale 100
   }
#declare Ecole_TExplosion = texture {
      pigment {Ecole_PExplosion }
      normal {
         brick 1.0
         brick_size <20, 10, 10>   // size of brick
         mortar 2       // width of mortar
         }
      }
#declare Ecole_PPorte=pigment{color <.05, .4, .15>*.3 }
#declare Ecole_NPorte=normal{crackle 1 bump_size 2 scale 15}

#declare Ecole_FPorte=finish{
   ambient 0.1
   diffuse 0.6
   phong 0.15
   phong_size 10
   }

/******************************************************************************

        objets

******************************************************************************/

#declare Ecole_HF=height_field{
  tga "map_1.tga"     // the file name to read
 water_level .001 // truncate/clip below N (0.0 ... 1.0)
 translate <-.5, -0.1, -.5>
 scale <2000, 1000, 3000>
 translate 100*y
}

#declare Ecole_Shape_Porte=difference{
   box {<1, 1, -2> <79.5, 249, 2>}
   box {<7, 20, 0> <75, 100, 3>}
   box {<7, 120, 0> <75, 240, 3>}
   }

#declare Ecole_Porte1_=object {
   Ecole_Shape_Porte
   texture {
      pigment {Ecole_PPorte translate 652542}
      normal  {Ecole_NPorte}
      finish  {Ecole_FPorte}
      }
   texture {pigment {Ecole_PExplosion } translate <80, 0, 0>}
   }

#declare Ecole_Porte2_=object {
   Ecole_Shape_Porte scale <-1, 1, 1>
   texture {
      pigment {Ecole_PPorte translate 987424}
      normal  {Ecole_NPorte}
      finish  {Ecole_FPorte}
      }
   texture {pigment {Ecole_PExplosion } translate < 80, 0, 0> rotate -30*y rotate -10*x}
   }

#declare Ecole_Bouton=object{
   sphere {0, 1 scale <5, 5, 2>}
   texture {
      pigment {colour rgb<1, 1, .5>*.827}
      finish {
         ambient 0.25
         diffuse 0.65
         brilliance 6.0
         phong 1.0    phong_size 100    metallic
         reflection 0.45
         }
      }
  }

#declare Ecole_Porte1=union{
   object {Ecole_Porte1_}
   object {Ecole_Bouton translate <40, 110, 5>}
   translate <-80, 0, 0>
   }

#declare Ecole_Porte2=union{
   object {Ecole_Porte2_}
   object {Ecole_Bouton translate <-40, 110, 5>}
   translate < 80, 0, 0>
   }

#declare Ecole_Porte3=object{
   difference{
      cylinder {<0, 250, -20> <0, 250, 2> 79}
      difference{
         cylinder {<0, 250, 0> <0, 250, 5> 70}
         box {<-110, 0, -2> <110, 260, 10>}
         }
      box {<-110,   0, -25> <110, 250, 5>}
      box {<-110, 330, -25> <110, 900, 5>}
      }
   texture {
      pigment {Ecole_PPorte translate 9874137}
      normal  {Ecole_NPorte}
      finish  {Ecole_FPorte}
      }
   texture {pigment {Ecole_PExplosion }}
   }

#declare Ecole_Mur1=object{////////////////////////// Briques
   difference{
      intersection{
         union{
            box {<-320, 0, -15> <320, 2500, 1>}
            box {<-1000, 0, -315> <-310, 2500, -301>}
            box {<  310, 0, -315> <1000, 2500, -301>}
            box {<-320, 0, -315> <-310, 2500,  1>}
            box {< 310, 0, -315> < 320, 2500,  1>}
            }
         Ecole_HF
         }
      cylinder {<0, 250, -20> <0, 250, 2> 100}
      box {<-81, -1, -20> <81, 251, 10>}
      box {<-470, 100, -520> <-370, 230, 10> translate -150*x}
      box {<-250, 100, -520> <-150, 230, 10>}
      box {< 150, 100, -520> < 250, 230, 10>}
      box {< 370, 100, -520> < 470, 230, 10> translate 150*x}
      box {<-470, 100, -520> <-370, 230, 10> translate 300*y translate -150*x}
      box {<-250, 100, -520> <-150, 230, 10> translate 300*y}
      box {< 150, 100, -520> < 250, 230, 10> translate 300*y}
      box {< 370, 100, -520> < 470, 230, 10> translate 300*y translate 150*x}
      box {<-1000, 330,-520> <1000, 360, 2>}
      box {<-15, 0 ,0> <15, 2500, 10> translate -310*x}
      box {<-15, 0 ,0> <15, 2500, 10> translate  310*x}
      //cylinder {0, 2500*y, 15 translate -310*x}
      //cylinder {0, 2500*y, 15 translate  310*x}
      }
   texture {
      pigment {
         //brick color Gray60, color rgb<1, .9, .8>*.3
         brick color Gray30, color rgb<1, .7, .6>*.7
         brick_size <20, 10, 17>   // size of brick
         mortar 2       // width of mortar
         }
      }
   texture {Ecole_TExplosion}
   }

#declare Ecole_Mur2=object{////////////////////////// Intrieur
   intersection{
      union{
         box {<-2000, 0, -1500> <-1995, 2500, 0>}
         box {< 1995, 0, -1500> < 2000, 2500, 0>}
         box {<-150, 0, -1500> <-145, 2500, 0>}
         box {< 145, 0, -1500> < 150, 2500, 0>}
         box {<-2000, 0, -800> < 2000, 2500,-795>}
         //box {<-2000, 0, -1000> < 2000, 2500,-995>}
         box {<-2000, 0, -1500> < 2000, 2500,-1495>}
         box {<-2000, 300, -1500> < 2000, 310, -310>}
         box {< -315, 300, -315> <  315, 310, 0>}
         }
      Ecole_HF
      }
   texture {
      pigment {color rgb <1, .9, .8>*.3}
      //normal {crackle 1 scale 5}
      finish {ambient 0.6}
      }
   texture {pigment {Ecole_PExplosion }}
   }

#declare Ecole_Mur3=object{////////////////////////// Carreaux de pltre
   intersection{
      union{
         box {<- 320, 329.1,-20> < 320, 360, 10>}
         box {<-1000, 329.1,-320> <-310, 360,-290>}
         box {<  310, 329.1,-320> <1000, 360,-290>}
         box {<-1000,   0,-320> <1000,  25,-290>}
         box {< -320,   0,-20> < -80,  25, 10>}
         box {<   80,   0,-20> < 320,  25, 10>}
         box {< -100,   0,-20> < -80, 250, 10>}
         box {< -120,  60,-20> < -80,  90, 10>}
         box {< -120, 120,-20> < -80, 150, 10>}
         box {< -120, 180,-20> < -80, 210, 10>}
         box {<   80,  60,-20> < 120,  90, 10>}
         box {<   80, 120,-20> < 120, 150, 10>}
         box {<   80, 180,-20> < 120, 210, 10>}
         box {<   80,   0,-20> < 100, 250, 10>}
         //box {< -100, 250,-20> < 100, 270, 2>}
         box {<-15, 0 ,0> <15, 2500, 10> translate -310*x}
         box {<-15, 0 ,0> <15, 2500, 10> translate  310*x}
         //cylinder {0, 2500*y, 15 translate -310*x}
         //cylinder {0, 2500*y, 15 translate  310*x}
         }
      Ecole_HF
      }
   texture {
      pigment {
         brick color Gray50, color Ecole_CPlatre 
         brick_size <40,30,1000>   // size of brick
         mortar 1       // width of mortar
         translate -500*z
         }
      }
   texture {pigment {Ecole_PExplosion }}
   }

#declare Ecole_Mur4=object{////////////////////////// Carreaux de pltre
   difference{
      cylinder {<0, 250, -20> <0, 250, 10> 100}
      cylinder {<0, 250, -25> <0, 250, 15>  80}
      box {<-110,   0, -25> <110, 250, 15>}
      box {<-110, 329.1, -25> <110, 900, 15>}
      }
   texture {
      pigment {
         radial color_map{
            [0 0.5 color Red color Red] // sans importance
            [0.5+0/12 0.5+1/12 color Ecole_CPlatre color Ecole_CPlatre ]
            [0.5+1/12 0.5+1/12+.002 color Gray50 color Gray50]
            [0.5+1/12+.002 0.5+2/12 color Ecole_CPlatre color Ecole_CPlatre ]
            [0.5+2/12 0.5+2/12+.002 color Gray50 color Gray50]
            [0.5+2/12+.002 0.5+3/12 color Ecole_CPlatre color Ecole_CPlatre ]
            [0.5+3/12 0.5+3/12+.002 color Gray50 color Gray50]
            [0.5+3/12+.002 0.5+4/12 color Ecole_CPlatre color Ecole_CPlatre ]
            [0.5+4/12 0.5+4/12+.002 color Gray50 color Gray50]
            [0.5+4/12+.002 0.5+5/12 color Ecole_CPlatre color Ecole_CPlatre ]
            [0.5+5/12 0.5+5/12+.002 color Gray50 color Gray50]
            [0.5+5/12+.002 0.5+6/12 color Ecole_CPlatre color Ecole_CPlatre ]
            }
         }
      rotate -90*x
      translate 250*y
      }
   texture {pigment {Ecole_PExplosion }}
   }
#declare Ecole_Bord1 = box {<-55, -2, -6> <55, 5, 3>}

#declare Ecole_Bord=object{
   intersection{
      union{
         object {Ecole_Bord1 translate <-420, 100, -300> translate -150*x}
         object {Ecole_Bord1 translate <-420, 228, -300> translate -150*x}
         object {Ecole_Bord1 translate <420, 100, -300> translate 150*x}
         object {Ecole_Bord1 translate <420, 228, -300> translate 150*x}
         object {Ecole_Bord1 translate <-200, 100, 0>}
         object {Ecole_Bord1 translate <-200, 228, 0>}
         object {Ecole_Bord1 translate <200, 100, 0>}
         object {Ecole_Bord1 translate <200, 228, 0>}
         object {Ecole_Bord1 translate <-420, 100, -300> translate 300*y translate -150*x}
         object {Ecole_Bord1 translate <-420, 228, -300> translate 300*y translate -150*x}
         object {Ecole_Bord1 translate <420, 100, -300> translate 300*y translate 150*x}
         object {Ecole_Bord1 translate <420, 228, -300> translate 300*y translate 150*x}
         object {Ecole_Bord1 translate <-200, 100, 0> translate 300*y}
         object {Ecole_Bord1 translate <-200, 228, 0> translate 300*y}
         object {Ecole_Bord1 translate <200, 100, 0> translate 300*y}
         object {Ecole_Bord1 translate <200, 228, 0> translate 300*y}
         }
      Ecole_HF
      }
   texture {
      pigment {
         brick color Gray40, color rgb <.3, .1, .1>
         brick_size <2,1,1>   // size of brick
         mortar 0.01       // width of mortar
         scale <10, 100, 10>
         translate -20*y
         rotate 90*y}
      normal {crackle 1 scale 5}
      }
   texture {pigment {Ecole_PExplosion }}
   }

#declare Ecole_Barreaux1=object{
   union{
      cylinder {<-30, 5, 0> <-30, 125, 0> 1.5}
      cylinder {<  0, 5, 0> <  0, 125, 0> 1.5}
      cylinder {< 30, 5, 0> < 30, 125, 0> 1.5}
      box {<-55, 30, -2> <55, 31, 2>}
      box {<-55, 100, -2> <55, 101, 2>}
      }
   texture {
      pigment {color Black}
      normal {crackle 1 scale 5}
      finish {Shiny}
      }
   translate -3*z
   }

#declare Ecole_Barreaux=intersection{
   union{
      object {Ecole_Barreaux1 translate <-420, 100, -300> translate -150*x}
      object {Ecole_Barreaux1 translate <-200, 100, 0>}
      object {Ecole_Barreaux1 translate <200, 100, 0>}
      object {Ecole_Barreaux1 translate <420, 100, -300> translate 150*x}
      object {Ecole_Barreaux1 translate <-420, 100, -300> translate 300*y translate -150*x}
      object {Ecole_Barreaux1 translate <-200, 100, 0> translate 300*y}
      object {Ecole_Barreaux1 translate <200, 100, 0> translate 300*y}
      object {Ecole_Barreaux1 translate <420, 100, -300> translate 300*y translate 150*x}
      }
   Ecole_HF
   }

#declare Ecole_Cadre_Fenetre=object{
   difference{
      box {<0, 0, -2> <50, 130, 2>}
      box {<5,   5, -5> <47,  44, 5>}
      box {<5,  46, -5> <47,  85, 5>}
      box {<5,  87, -5> <47, 127, 5>}
      }
   texture{
      pigment{Ecole_PPorte}
      }
   }

#declare Ecole_seed= seed(2)
#declare Ecole_Fenetres=union{
#declare Ecole_i=0
#while (Ecole_i < 8)
   union{
      object {Ecole_Cadre_Fenetre}
      object {
         box {<2, 2, -.5> <49, 129, .5>}
         texture {
            pigment {
               bozo color_map {
                  [0 0.6 color rgbt <.8, .8, .8, .8> color rgbt <.8, .8, .8, .8>]
                  [0.6 1 color Clear color Clear]
                  }
               }
            scale 50
            translate 100000*rand(Ecole_seed)
            }
         }
      rotate 80*rand(Ecole_seed)*y
      rotate -10*rand(Ecole_seed)*x
      #if ( mod (Ecole_i, 2) = 0)
         scale <-1, 1, 1> translate 100*x
      #end
      #switch (int(Ecole_i/2))
         #case (0) translate <-470, 100, -305>  translate -150*x #break
         #case (1) translate <-250, 100, -5> #break
         #case (2) translate < 150, 100, -5> #break
         #case (3) translate < 370, 100, -305>  translate 150*x #break
      #end
      }
   #declare Ecole_i  =Ecole_i + 1
#end
   }

#declare Ecole=union{

   object {Ecole_Porte1}
   object {Ecole_Porte2 translate -80*x rotate 10*x rotate 30*y translate 80*x}
   object {Ecole_Porte3}
   object {Ecole_Mur1}
   object {Ecole_Mur2}
   object {Ecole_Mur3}
   object {Ecole_Mur4}
   object {Ecole_Bord}
   object {Ecole_Barreaux}
   object {Ecole_Fenetres}
   }
