// Persistence of Vision Raytracer
// Cour, nuages...

#debug "Decor..."
/******************************************************************************
   A faire:
   essais 160x120 -a dcor seul:
          sans BB: 8'05
          avec BB: 1'28
******************************************************************************/


/******************************************************************************

        textures

******************************************************************************/

#declare Decor_PContour=pigment{color Black}

#declare Decor_NPlastique= normal{
   bumps 0.0
   }

#declare Decor_PCloud3 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 1.00 green 0.85 blue 0.60
                    color red 0.80 green 0.30 blue 0.30]
        [0.1, 0.5   color red 0.80 green 0.30 blue 0.30
                    color rgb <0.30, 0.20, 0.40>*.2/.3 ]//47-47-79
        [0.5, 1.001 color rgb <0.30, 0.20, 0.40>*.2/.3
                    color rgb <0.13, 0.13, 0.13>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

#declare Decor_TFeuille= texture{
   pigment {
      bozo
      color_map{
         [0 0.5 color Yellow color Yellow]
         [0.5 1 color Yellow color rgb <.5, .1, .1>]
         }
      scale 1
      }
   normal {crackle 5 scale 1}
   }



/******************************************************************************

        objets

******************************************************************************/

#declare Decor_Ciel=
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.30, 0.20, 0.40>*.2/.3 ]
            [0.15 Decor_PCloud3 scale <0.05, 0.40, 0.05> rotate z*30 ]
            [0.45 Decor_PCloud3 scale <0.25, 0.15, 0.50> ]
        }
    scale <1, 1, 1> rotate -0*x
    }
}

#declare Decor_Sol=object {
   plane {y, 0}
   texture {
      pigment {color rgb <.25, .2, .15>}
      normal {bumps .6 scale 2}
      }
   }

#declare Decor_Shape_Feuille1=object{
   sphere {0, 1}
   scale <3, .1, 1>
   translate 2*x
   }

#declare Decor_Shape_Feuille=union{
   object {Decor_Shape_Feuille1 rotate -80*y}
   object {Decor_Shape_Feuille1 rotate -40*y}
   object {Decor_Shape_Feuille1 rotate   0*y}
   object {Decor_Shape_Feuille1 rotate  40*y}
   object {Decor_Shape_Feuille1 rotate  80*y}
   cone {<-2, 0, 0> .3 <2, 0, 0> 0}
   translate 0.1*y
   scale <2, 1, 1.2>
   bounded_by {
      box {<-2, -.2, -5> <5, .4, 5>}
      }
   }

#declare Decor_i=0
#declare Decor_seed=seed(1)
#declare Decor_Feuilles=union{
   #while (Decor_i < 600)
      object{
         Decor_Shape_Feuille
         texture {Decor_TFeuille translate 10000*rand(Decor_seed)}
         scale <.8+.4*rand(Decor_seed), 1, .8+.4*rand(Decor_seed)>
         rotate 360*rand(Decor_seed)*y
         translate <-800+1600*rand(Decor_seed), 0, -950+950*rand(Decor_seed)>
         }
      #declare Decor_i = Decor_i+1
   #end
   bounded_by {box {<-800, -.1, -950> <800, 1, 0>}}
   }

#declare Decor=union{
   object {Decor_Sol}
   object {Decor_Feuilles}
   }

#debug " ok.\n"

