// Persistence of Vision Raytracer
// Theme "school" 03-04/97
// Sizes in cm
// Proportions pour cadrage classique 800x600

global_settings {
   max_trace_level 6
   adc_bailout 1/255
   assumed_gamma 1.9
   }

/******************************************************************************

        Gnralits

******************************************************************************/

#include "colors.inc"
#include "textures.inc"

#include "cadre.inc"
#include "decor.inc"
#include "banc.inc"
#include "martien.inc"
#include "groupe.inc"
#include "batiment.inc"
#include "squelette.inc"

#render "Includes ok.\n"

#declare Vue=1
#declare WideLight = 1

#declare Vue_Test=camera {
   orthographic
   location -30 * z
   up        y*50
   right     -4/3 * x*50
   direction z // Vue globale
   rotate 180 * y
   }

#declare Vue_1=camera {
   perspective
   location  <0, 0, 15>
   up        y*50
   right     -4/3 * x*50
   look_at   <0, 0, 0>
   angle 65 //Attention: angle  la base et non sur la diagonale!
}

#declare Lampes=object{ light_source{<-200, 370, 295> color White}}

#declare Lampes_E=object {
   light_source {
      <-250, 320, 295> // light's position
      color White
      area_light
      <100, 0, 0> <0, 100, 0> // lights spread out across this distance (x * y)
      4, 4
      adaptive 0
      jitter
      }
   }

/******************************************************************************

        Scne complte

******************************************************************************/
#declare Test = union {
   //object {Martien scale .45 rotate 60*y translate <0, 6, -5>}
   object {Squelette scale .25 rotate 0*y translate <0, 6, -5>}
   //object {Tete scale .8 rotate 40*y translate <0, 0, 0>}
   }

#declare Sub_Scene1=union{
   object {Decor translate <0, 0, 0>}
   object {Banc translate <-220, 0, -400>}
   object {Banc translate <  20, 0, -400>}
   object {Banc translate <-200, 0, -440>}
   object {Banc translate <   0, 0, -440>}
   object {Chaise translate < 0, 0, -380>}
   object {Squelette translate <0, 101, -385>}
   object {Ecole translate < 0, -1, -600>}
   object {Groupe}
   }

#declare Scene1=union{
   object {Cadre no_shadow translate <0, 0, 0>}
   object {Sub_Scene1 translate <0, -150, -70> rotate 0*x rotate 4*z}
   }


#switch (Vue)
   #case (0)
      camera {Vue_Test}
      object {Test rotate 0*y scale 1}
      //sky_sphere { Decor_Ciel }
      #break
   #case (1)
      camera {Vue_1}
      sky_sphere { Decor_Ciel }
      object {Scene1 rotate 0*y translate -50*z}
   #break
#end

#ifdef (WideLight)
   object {Lampes_E}
   #debug "Lumieres etendues\n"
#else
   object {Lampes}
   #debug "Lumieres ponctuelles\n"
#end
