// Persistence of Vision Raytracer
// Martien type "Mars Attacks!"

/******************************************************************************
   A faire:
******************************************************************************/

#ifndef (MARTIEN_CONST)

/******************************************************************************

        textures

******************************************************************************/
#declare Martien_Green = color rgb <.3, .7, .5>
#declare Martien_PScaphandre=pigment{color Martien_Green }
#declare Martien_PChaussure=pigment{color Martien_Green }
#declare Martien_PSemelle=pigment{color Gray10}
#declare Martien_PGant=pigment{color Martien_Green }
#declare Martien_PBouteilles=pigment{color rgb <.8, .4, .3>}
#declare Martien_PPlaque=pigment{color Gray20}

#declare Martien_NScaphandre=normal{bumps 0.3 scale 5 bump_size 0.5}
#declare Martien_NSemelle=normal{bumps 0.3 scale 1 bump_size 1.5}

#declare Martien_FPlaque=finish{
   ambient 0.1
   diffuse 0.6
   phong 0.25
   phong_size 10
   }//Glossy
#declare Martien_FScaphandre=finish{
   ambient 0.1
   diffuse 0.6
   phong 0.15
   phong_size 10
   }
#declare Martien_FCloche=finish {
   specular 10.0
   roughness 0.001
   ambient 0.0
   ambient 1.0
   diffuse 0.0
   reflection 0.1
   refraction 1.0
   ior 1.1
   }

/******************************************************************************

        paramtres

******************************************************************************/

#declare Martien_Trans_JD1= transform {rotate -50*x rotate -10*y} //hanche
#declare Martien_Trans_JD2= transform {rotate 50*x}  //genou
#declare Martien_Trans_JG1= transform {rotate -50*x rotate 10*y} //hanche
#declare Martien_Trans_JG2= transform {rotate 50*x}  //genou
#declare Martien_Trans_BD1= transform {rotate -50*z rotate -10*y} //paule
#declare Martien_Trans_BD2= transform {rotate -50*x rotate 10*y}  //coude
#declare Martien_Trans_BG1= transform {rotate 50*z rotate 10*y} //paule
#declare Martien_Trans_BG2= transform {rotate -50*x rotate -10*y}  //coude
#declare Martien_Trans_T= transform {rotate 0*y}  //tete

#declare Martien_X=8

/******************************************************************************

        objets "fixes"

******************************************************************************/

#declare Martien_Tronc=object {
   union {
      box {<-Martien_X, -30, -5> <Martien_X, -5, 5>}
      cylinder {<-Martien_X-5, 0, 0> <Martien_X+5, 0, 0> 1 scale <1, 5, 5> translate <0, -5, 0>}
      cylinder {<0, -30, 0> <0, -5, 0> 1 scale <5, 1, 5> translate <-Martien_X, 0, 0>}
      cylinder {<0, -30, 0> <0, -5, 0> 1 scale <5, 1, 5> translate <Martien_X, 0, 0>}
      sphere {0, 1 scale <5, 5, 5> translate <-Martien_X-5, -5, 0>}
      sphere {0, 1 scale <5, 5, 5> translate < Martien_X+5, -5, 0>}
      cylinder {<-Martien_X, 0, 0> <Martien_X, 0, 0> 1 scale <1, 5, 5> translate <0, -30, 0>}
      sphere {0, 1 scale <5, 5, 5> translate <-Martien_X, -30, 0>}
      sphere {0, 1 scale <5, 5, 5> translate < Martien_X, -30, 0>}
      }
   texture{
      pigment {Martien_PScaphandre}
      normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   //bounded_by {box {<-Martien_X-5, -35, -5> <Martien_X+5, 0, 5>}}
   }

#declare Martien_Plaque=object{
   union {
      cone {<0, -10, 0> 5 <0, 2, 0> 10}
      cylinder {<0, 1, 0> <0, 3, 0> 12}
      intersection {
         box {<-20, -20, 4> <20, 0, 8>}
         difference{
            union{
               cylinder {<0, 0, 0> <0, 0, 9> 1 scale <Martien_X, 5, 1> translate -10*y}
               box {<-Martien_X, -10, 0> <Martien_X, 3, 9>}
               }
            cylinder {<0, 0, 7> <0, 0, 10> 1 scale <Martien_X-2, 5-2, 1> translate -10*y}
            box {<-Martien_X+2, -10, 7> <Martien_X-2, 3, 10>}
            }
         }
      torus {7, 1 scale <1.5, 1.5, 1.1> rotate 40*z translate <-8, -15, 0>}
      torus {7, 1 scale <1.5, 1.5, 1.1> rotate -40*z translate <8, -15, 0>}
      cylinder {<0, -6, 0> <0, -6, 8> 3}
      sphere {<0, -6, 8> 2}
      }
   texture{
      pigment {Martien_PPlaque}
      finish {Martien_FPlaque}
      }
   }

#declare Martien_Bouteille_H=22

#declare Martien_Bouteille=object{
   union {
      sphere {<0, 0, 0> 5}
      cylinder {<0, 0, 0> <0, -Martien_Bouteille_H, 0> 5}
      sphere {<0, -Martien_Bouteille_H, 0> 5}
      cylinder {<0, -2, 0> <0, -3, 0> 6}
      cylinder {<0,  -4, 0> <0, -5, 0> 6}
      cylinder {<0, -Martien_Bouteille_H+2, 0> <0, -Martien_Bouteille_H+3, 0> 6}
      cylinder {<0, -Martien_Bouteille_H+4, 0> <0, -Martien_Bouteille_H+5, 0> 6}
      }
   texture{
      pigment {Martien_PBouteilles}
      finish  {Martien_FScaphandre}
      }
   }

#declare Martien_Piece_0=intersection{
   sphere {0, 1 scale <5, 3, 5>}
   box {<-6, 0, -6> <6, 4, 6>}
   }

#declare Martien_Jambe1=object{
   union {
      sphere {0, 1 scale <5, 5, 5> translate < 0, 0, 0>}
      object {Martien_Piece_0 translate -3*y}
      object {Martien_Piece_0 translate -5*y}
      object {Martien_Piece_0 translate -7*y}
      object {Martien_Piece_0 translate -9*y}
      object {Martien_Piece_0 translate -11*y}
      object {Martien_Piece_0 translate -13*y}
      object {Martien_Piece_0 translate -15*y}
      sphere {0, 1 scale <5, 5, 5> translate <0, -15, 0>}
      }
   texture{
      pigment {Martien_PScaphandre}
      normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   //bounded_by {box {<-5, -20, -5> <5, 5, 5>}}
   }

#declare Martien_Jambe2_1=object{
   union {
      sphere {0, 1 scale <5, 5, 5> translate < 0, 0, 0>}
      object {Martien_Piece_0 translate -3*y}
      object {Martien_Piece_0 translate -5*y}
      cylinder {<0, -5, 0> <0, -10, 0> 5 translate <0, 0, 0>}
      sphere {0, 1 scale <5, 5, 5> translate <0, -10, 0>}
      }
   texture{
      pigment {Martien_PScaphandre}
      normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   //bounded_by {box {<-5, -15, -5> <5, 5, 5>}}
   }

#declare Martien_Jambe2_2=object{
   union {
      cylinder {<0, -5, 0> <0, -18, 0> 5.01 translate <0, 0, 0>}
      intersection{
         union{
            cylinder {<0, 0, 0> <0, 0, 10> 1 scale <5, 4, 1> translate -18*y}
            sphere {0, 1 scale <5, 4, 3> translate < 0, -18, 10>}
            }
         box {<-6, -18, -6> <6, -10, 20>}
         }
      }
   texture{
      pigment {Martien_PChaussure}
      //normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   }

#declare Martien_Jambe2_3=object{
   difference{
      union{
         cylinder {<0, -18, 0> <0, -20, 0> 5.5}
         box {<-5.5, -20, 0> <5.5, -18, 10>}
         cylinder {<0, -18, 0> <0, -20, 0> 1 scale <5.5, 1, 3.5> translate 10*z}
         }
      box {<-10, -21, 2> <10, -18.5, 6>}
      }
   texture{
      pigment {Martien_PSemelle}
      normal  {Martien_NSemelle}
      finish  {Martien_FScaphandre}
      }
   }

#declare Martien_Jambe2=union{
      object {Martien_Jambe2_1}
      object {Martien_Jambe2_2}
      object {Martien_Jambe2_3}
   }

#declare Martien_Piece_1=intersection{
   sphere {0, 1 scale <4, 3, 4>}
   box {<-5, 0, -5> <5, 4, 5>}
   }

#declare Martien_Bras1=object{
   union {
      object {Martien_Piece_1 translate -3*y}
      object {Martien_Piece_1 translate -5*y}
      object {Martien_Piece_1 translate -7*y}
      object {Martien_Piece_1 translate -9*y}
      object {Martien_Piece_1 translate -11*y}
      object {Martien_Piece_1 translate -13*y}
      object {Martien_Piece_1 translate -15*y}
      sphere {0, 4 translate <0, -15, 0>}
      }
   texture{
      pigment {Martien_PScaphandre}
      normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   //bounded_by {box {<-4, -19, -4> <4, 0, 4>}}
   }

#declare Martien_Bras2_1=object{
   union {
      sphere {0, 4 translate < 0, 0, 0>}
      object {Martien_Piece_1 translate -3*y}
      object {Martien_Piece_1 scale <3.75/4, 1, 3.75/4> translate -5*y}
      object {Martien_Piece_1 scale <3.5/4,  1,  3.5/4> translate -7*y}
      object {Martien_Piece_1 scale <3.25/4, 1, 3.25/4> translate -9*y}
      sphere {0, 3 translate <0, -10, 0>}
      }
   texture{
      pigment {Martien_PScaphandre}
      normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   //bounded_by {box {<-4, -13, -4> <4, 4, 4>}}
   }

#declare Martien_Bras2_2=object{
   union {
      sphere {0, 1 scale <6, 3, 1.5>}
      sphere {0, 1 scale <1.25, 2, 1.25> translate <-5,   -2, 0>}
      sphere {0, 1 scale <1.25, 4, 1.25> translate <-2.5, -4, 0>}
      sphere {0, 1 scale <1.25, 4, 1.25> translate < 0,   -4, 0>}
      sphere {0, 1 scale <1.25, 4, 1.25> translate < 2.5, -4, 0>}
      sphere {0, 1 scale <1.25, 4, 1.25> translate < 5,   -4, 0>}
      }
   texture{
      pigment {Martien_PGant}
      normal  {Martien_NScaphandre}
      finish  {Martien_FScaphandre}
      }
   scale <.9, 1.2, .9>
   translate -15*y
   }

#declare Martien_Bras2=union{
      object {Martien_Bras2_1}
      object {Martien_Bras2_2}
   }

#declare Martien_Cloche=object{
   intersection{
      difference{
         quartic {
            < 1.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0, -1.0,
              0.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
              0.0,  0.0,  0.0,   0.0, 0.0,  1.0,  0.0,  0.0,  0.0,  0.0,
              0.0,  0.0,  1.0,   0.0, 0.0 >
            }
         quartic {
            < 1.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0, -1.0,
              0.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
              0.0,  0.0,  0.0,   0.0, 0.0,  1.0,  0.0,  0.0,  0.0,  0.0,
              0.0,  0.0,  1.0,   0.0, 0.0 >
            scale .98
            }
         bounded_by { sphere { <0, 0, 0>, 2 } }
         rotate 90*z scale <40, 45, 48> translate -13*y
         }
      box {<-50, -.5, -50> <50, 70, 50>}
      }
   texture{
      pigment {color Clear filter 1.0}
      finish {Martien_FCloche}
      }
   //texture{pigment{color Red}}
   }

#declare MARTIEN_CONST=1
#end
#include "tete.inc"

/******************************************************************************

        objets "mobiles"

******************************************************************************/

#declare Martien=union{
   object {Martien_Tronc}
   object {Martien_Plaque}
   object {Martien_Bouteille translate < 6, -4, -10>}
   object {Martien_Bouteille translate <-6, -4, -10>}
   object {Martien_Cloche transform Martien_Trans_T translate 3*y}
   object {Tete transform Martien_Trans_T scale 0.8 translate <0, 22, -3>}
   union {
      object {Martien_Jambe1}
      object {Martien_Jambe2 transform Martien_Trans_JD2 translate -15*y}
      transform Martien_Trans_JD1 translate <-Martien_X, -30, 0>
      }
   union {
      object {Martien_Jambe1}
      object {Martien_Jambe2 transform Martien_Trans_JG2 translate -15*y}
      transform Martien_Trans_JG1 translate <Martien_X, -30, 0>
      }
   union {
      object {Martien_Bras1}
      object {Martien_Bras2 transform Martien_Trans_BD2 translate -15*y}
      transform Martien_Trans_BD1 translate <-Martien_X-5, -5, 0>
      }
   union {
      object {Martien_Bras1}
      object {Martien_Bras2 scale <-1, 1, 1> transform Martien_Trans_BG2 translate -15*y}
      transform Martien_Trans_BG1 translate <Martien_X+5, -5, 0>
      }
   }
