// Persistence of Vision Raytracer
// Squelette type "Mars Attacks!"

/******************************************************************************
   A faire:
******************************************************************************/


/******************************************************************************

        textures

******************************************************************************/
#declare Squelette_P0=pigment{color Gray90}
#declare Squelette_CVert=color Green*.6
#declare Squelette_P=pigment{
   bozo color_map{
      [0.00 color Gray90]
      [0.30 color Gray90]
      [0.50 color Squelette_CVert]
      [1.00 color Squelette_CVert]
      }
   scale 40
   }
#declare Squelette_N=normal{bumps 0.3 scale 5 bump_size 0.5}
#declare Squelette_F_=finish{
   ambient 0.1
   diffuse 0.6
   phong 0.25
   phong_size 10
   }//Glossy
#declare Squelette_F=finish{Shiny}//Glossy
#declare Squelette_PFace=pigment{
   image_map {
      gif "squ3.gif"
      map_type 2 //cylindre
      once
      interpolate 2
      filter 2, 1.0
      }
   }
   
#declare Squelette_THalo =
   texture {
      pigment {colour Clear}
      halo {
         linear
         max_value 1.0
         spherical_mapping
         emitting
         turbulence 0.5
         colour_map {
            [0 color rgbt <0.0, 1.0, 0.0, 1.0>]
            [1 color rgbt <0.5, 1.0, 0.5, 0.5>]
         }
         samples 10
      }
   }

/******************************************************************************

        paramtres

******************************************************************************/

#declare Squelette_Trans_JD1= transform {rotate -90*x rotate 20*y} //hanche
#declare Squelette_Trans_JD2= transform {rotate  80*x}  //genou
#declare Squelette_Trans_JG1= transform {rotate -100*x rotate -20*y} //hanche
#declare Squelette_Trans_JG2= transform {rotate  90*x}  //genou
#declare Squelette_Trans_BD1= transform {rotate -40*z rotate  80*y} //paule
#declare Squelette_Trans_BD2= transform {rotate -40*x rotate  10*y}  //coude
#declare Squelette_Trans_BG1= transform {rotate  40*z rotate -80*y}  //paule
#declare Squelette_Trans_BG2= transform {rotate -40*x rotate -10*y}  //coude
#declare Squelette_Trans_T=   transform {rotate 3*y}  //tete

#declare Squelette_X=15

/******************************************************************************

        objets "fixes"

******************************************************************************/

#declare Squelette_Cote=difference{
   cylinder {-.3*y, .3*y, 1 }
   cylinder {-y, y, .97 }
   intersection{
      plane { x, 0 rotate  15*y}
      plane {-x, 0 rotate -15*y}
      }
   translate z
   }

#declare Squelette_Omoplate=difference{
   sphere {0, 1 scale <10, 20, 3>}
   sphere {0, 1 scale <10, 20, 3> translate z}
   box {<-20, -30, 0> <20, 30, 5>}
   box {<-20, 0, -5> <20, 30, 5>}
   box {<-30, -30, -5> <0, 30, 5> rotate 30*z}
   rotate -20*z
   translate -10*x
   scale .8
   }


#declare Squelette_Tronc=object {
   union {
      cylinder {<0, -30, 0> <0, 0, 0> .5}
      sphere {0, 1 scale <2, .5, 1.5> translate  5*y}
      sphere {0, 1 scale <2, .5, 1.5> translate  4*y}
      sphere {0, 1 scale <2, .5, 1.5> translate  3*y}
      sphere {0, 1 scale <2, .5, 1.5> translate  2*y}
      sphere {0, 1 scale <2, .5, 1.5> translate  1*y}
      sphere {0, 1 scale <2, .5, 1.5> translate  0*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -1*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -2*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -3*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -4*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -5*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -6*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -7*y}
      sphere {0, 1 scale <2, .5, 1.5> translate -8*y}
      //cylinder {<-Squelette_X, 0, 0> <Squelette_X, 0, 0> .5 translate <0, -4, 0>}
      cylinder {<-Squelette_X, -2, 0> <0, 0, 0> .5 translate <0, -4, 0>}
      cylinder {<0, 0, 0> <Squelette_X, -2, 0> .5 translate <0, -4, 0>}
      union{
         sphere {0, 1 scale <2.0, 1, 1.5> translate -9*y}
         sphere {0, 1 scale <2.25, 1, 1.6> translate -11*y}
         sphere {0, 1 scale <2.5, 1, 1.6> translate -13*y}
         sphere {0, 1 scale <2.75, 1, 1.7> translate -15*y}
         sphere {0, 1 scale <3, 1, 1.8> translate -17*y}
         sphere {0, 1 scale <3.3, 1, 1.8> translate -19*y}
         sphere {0, 1 scale <3.7, 1, 1.9> translate -21*y}
         sphere {0, 1 scale <4.2, 1, 1.9> translate -23*y}
         sphere {0, 1 scale <  5, 1,   2> translate -25*y}
         translate 0*y
         }
      difference{
         union{
            object {Squelette_Cote scale <  11, 1, 6> rotate 29*x translate -9*y}
            object {Squelette_Cote scale <  11.8, 1, 7> rotate 31*x translate -10*y}
            object {Squelette_Cote scale <  12.6, 1, 8> rotate 33*x translate -11*y}
            object {Squelette_Cote scale <  13.4, 1, 9> rotate 35*x translate -12*y}
            object {Squelette_Cote scale <  14.2, 1, 10> rotate 37*x translate -13*y}
            object {Squelette_Cote scale <  15, 1, 10> rotate 39*x translate -14*y}
            object {Squelette_Cote scale <  15, 1, 10> rotate 41*x translate -15*y}
            object {Squelette_Cote scale <  15, 1, 10> rotate 43*x translate -16*y}
            object {Squelette_Cote scale <  14, 1, 10> rotate 45*x translate -17*y}
            }
         sphere {0, 1 scale <10, 20, 10> translate <0, -35, 10>}
         translate  13*y
         scale <.9, 1, .8>
         translate -13*y
         translate 5*y
         }
      difference{
         union{
            sphere {0, 1 scale <3, 6, 1> rotate  20*z translate <-7, -30, 0>}
            sphere {0, 1 scale <3, 6, 1> rotate -20*z translate < 7, -30, 0>}
            sphere {0, 1 scale <5, 3, 1> translate < 0, -28, 0>}
            }
         cylinder {-20*z, 20*z, 1 scale <6, 3, 1> translate -31*y}
         cylinder {-20*z, 20*z, 1 scale <6, 3, 1> rotate -30*z translate <-14, -29, 0>}
         cylinder {-20*z, 20*z, 1 scale <6, 3, 1> rotate  30*z translate < 14, -29, 0>}
         }
      object {Squelette_Omoplate scale <1, 1, 1> translate <Squelette_X, -4, 0>}
      object {Squelette_Omoplate scale <-1, 1, 1> translate <-Squelette_X, -4, 0>}
      }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   }


#declare Squelette_Jambe1=object{ //fmur=90, h=390.
   union {
      sphere {0, 1 scale 2 translate < 0, 0, 0>}
      cylinder {0, -35*y, 1 scale <1.8, 1, 1.1>}
      sphere {0, 1 scale 2.5 translate <0, -35, 0>}
      }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   }

#declare Squelette_Jambe2_1=object{
   union {
      sphere {0, 1 scale 2 translate < 0, 0, 0>}
      cylinder {<0, 0, 0> <0, -30, 0> 1 scale <.8, 1, 1.8> translate <-1, 0, 0>}
      cylinder {<0, 0, 0> <0, -30, 0> 1 scale <.8, 1, 1.8> translate < 1, 0, 0>}
      sphere {0, 1 scale <3, 1, 2> translate <0, -30, 0>}
      }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   }

#declare Squelette_Jambe2_3=object{
      union{
         cylinder {<0, -30, 0> <   3, -32, 5> .4}
         cylinder {<0, -30, 0> < 1.5, -32, 5> .4}
         cylinder {<0, -30, 0> <   0, -32, 5> .4}
         cylinder {<0, -30, 0> <-1.5, -32, 5> .4}
         cylinder {<0, -30, 0> <  -3, -32, 5> .4}
         cylinder {<   3, -32, 5> <   3, -33, 15> .4}
         cylinder {< 1.5, -32, 5> < 1.5, -33, 15> .4}
         cylinder {<   0, -32, 5> <   0, -33, 15> .4}
         cylinder {<-1.5, -32, 5> <-1.5, -33, 15> .4}
         cylinder {<  -3, -32, 5> <  -3, -33, 15> .4}
         }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   }

#declare Squelette_Jambe2=union{
      object {Squelette_Jambe2_1}
      object {Squelette_Jambe2_3}
   }

#declare Martien_Piece_1=intersection{
   sphere {0, 1 scale <4, 3, 4>}
   box {<-5, 0, -5> <5, 4, 5>}
   }

#declare Squelette_Bras1=object{ //humrus=60, h=390.
   union {
      sphere {0, 1 scale 2 translate < 0, 0, 0>}
      cone {0, 1, -25*y, 1.5 scale <1, 1, 1>}
      cone {0, 2, -25*y, 1 scale <1, 1, 1>}
      sphere {0, 1 scale 1.5 translate <0, -25, 0>}
      }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   }


#declare Squelette_Bras2_1=object{
   union {
      sphere {0, 1.5 translate < 0, 0, 0>}
      cone {0, .5, -25*y, 1 scale <1, 1, 1> translate  .5*x}
      cone {0, 1, -25*y, .5 scale <1, 1, 1> translate  .5*x}
      cone {0, .5, -25*y, 1 scale <1, 1, 1> translate -.5*x}
      cone {0, 1, -25*y, .5 scale <1, 1, 1> translate -.5*x}
      sphere {0, 1.5 translate <0, -25, 0>}
      }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   }

#declare Squelette_Bras2_2=object{
   union {
      union{
         cylinder {<0, -25, 0> <   3, -30, 0> .4}
         cylinder {<0, -25, 0> < 1.5, -30, 0> .4}
         cylinder {<0, -25, 0> <   0, -30, 0> .4}
         cylinder {<0, -25, 0> <-1.5, -30, 0> .4}
         cylinder {<0, -25, 0> <  -3, -30, 0> .4}
         cylinder {<   3, -30, 0> <   3, -35, 0> .4}
         cylinder {< 1.5, -30, 0> < 1.5, -37, 0> .4}
         cylinder {<   0, -30, 0> <   0, -38, 0> .4}
         cylinder {<-1.5, -30, 0> <-1.5, -37, 0> .4}
         cylinder {<  -3, -30, 0> <  -3, -32, 0> .4}
         }
      }
   texture{
      pigment {Squelette_P}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   scale <1, 1, 1>
   }

#declare Squelette_Bras2=union{
      object {Squelette_Bras2_1}
      object {Squelette_Bras2_2}
   }

//#include "tete.inc"
#declare Squelette_Face=object{
   difference{
      union{
         difference{
            sphere {0, 1 scale <10, 12, 12> rotate 20*x}
            cylinder {-100*z, 100*z, 1 scale <12, 9, 9> rotate -30*x translate 28*z}
            }
         difference{
            cone {-20*y, 1, 0, .4 scale <8.5, 1, 8> rotate 170*x translate <0, -20, 8>}
            plane {y, -10 rotate -5*x}
            }
         cone {-2*y, 1, 2*y, .4 scale <2, 1, 2> rotate -20*x translate <0, -2, 12>}
         sphere {0, 1 scale <5, 2, 3> rotate -40*x translate <-4, 2, 10>}
         sphere {0, 1 scale <5, 2, 3> rotate -40*x translate < 4, 2, 10>}
         }
      sphere { 0, 1 scale <3, 3, 5> rotate -20*x translate <-4, -1, 12>}
      sphere { 0, 1 scale <3, 3, 5> rotate -20*x translate < 4, -1, 12>}
      }
   texture {
      pigment {color Squelette_CVert}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   texture {
      pigment{Squelette_PFace rotate 90*y translate -.56*y scale 50 translate <0, 0, 0>}
      //normal{Tete_NFace}
      }
   }

#declare Squelette_Machoire=object{
         difference{
            cone {-20*y, 1, 0, .4 scale <8.5, 1, 8> rotate 170*x translate <0, -20, 8>}
            plane {-y, 10 rotate 5*x}
            plane {y, -12 rotate 15*x}
            }
   texture {
      pigment {color Squelette_CVert}
      normal  {Squelette_N}
      finish  {Squelette_F}
      }
   texture {
      pigment{Squelette_PFace rotate 90*y translate -.56*y scale 50 translate <0, 0, 0>}
      //normal{Tete_NFace}
      }
   }

#declare Squelette_Fumee=object{
   sphere {0, 1}
   hollow
   texture{Squelette_THalo}
   }

/******************************************************************************

        objets "mobiles"

******************************************************************************/

#declare Squelette=union{
   object {Squelette_Tronc scale <1.5, 1.9, 1.3>}
   union{
      object {Squelette_Face rotate -10*x translate <0, 0, 10>}
      object {Squelette_Machoire rotate -10*x translate <0, 0, 10>}
      scale 1.1 translate <0, 10, -6>
      }
   union {
      object {Squelette_Jambe1}
      object {Squelette_Jambe2 transform Squelette_Trans_JD2 translate -35*y}
      transform Squelette_Trans_JD1 translate <-10, -63, 0>
      }
   union {
      object {Squelette_Jambe1}
      object {Squelette_Jambe2 transform Squelette_Trans_JG2 translate -35*y}
      transform Squelette_Trans_JG1 translate <10, -63, 0>
      }

   union {
      object {Squelette_Bras1}
      object {Squelette_Bras2 transform Squelette_Trans_BD2 translate -25*y}
      transform Squelette_Trans_BD1 translate <-Squelette_X-6, -9-2, 0>
      }
   union {
      object {Squelette_Bras1}
      object {Squelette_Bras2 scale <-1, 1, 1> transform Squelette_Trans_BG2 translate -25*y}
      transform Squelette_Trans_BG1 translate <Squelette_X+6, -9-2, 0>
      }
   object{Squelette_Fumee scale <Squelette_X*2, 80, 20> translate <0, 20, 0>}
   //rotate 90*y
   }
