// Persistence of Vision Raytracer
// Tte de martien type "Mars Attacks!"

#ifndef (TETE_CONST)

/******************************************************************************
   A faire:
******************************************************************************/


/******************************************************************************

        textures

******************************************************************************/

#declare Tete_PLobe0=pigment{color rgb <.7, .7, .4>}
#declare Tete_PLobe=pigment{
   bozo color_map{
      [0 1 color rgb <.7, .7, .4> color rgb <.7, .4, .4>]
      }
   scale 10
   }
#declare Tete_PFace0=pigment{color Gray30}
#declare Tete_PFace=pigment{
   image_map {
      png "tete2.png"
      map_type 2 //cylindre
      once
      interpolate 2
      //filter 0, 1.0
      }
   }

#declare Tete_NLobe=normal{ agate 0.6 scale 3 bump_size 2}
#declare Tete_NFace=normal{ bumps 0.6 scale .2 bump_size .3}

#declare Tete_FLobe=finish{phong 0.8 phong_size 200}

/******************************************************************************

        objets

******************************************************************************/

#declare Tete_Lobe=object{
   sphere {0, 1 scale <10, 15, 20> rotate 10*x}
   texture{
      pigment{Tete_PLobe}
      normal{Tete_NLobe}
      finish{Tete_FLobe}
      }
   }

#declare Tete_Face=object{
   difference{
      union{
         difference{
            sphere {0, 1 scale <10, 12, 12> rotate 20*x}
            cylinder {-100*z, 100*z, 1 scale <12, 9, 9> rotate -30*x translate 28*z}
            }
         difference{
            cone {-20*y, 1, 0, .4 scale <8.5, 1, 8> rotate 170*x translate <0, -20, 8>}
            plane {y, -10 rotate -5*x}
            }
//         difference{
//            cone {-20*y, 1, 0, .4 scale <8.5, 1, 8> rotate 170*x translate <0, -20, 8>}
//            plane {-y, 10 rotate 5*x}
//            plane {y, -12 rotate 15*x}
//            }
         cone {-2*y, 1, 2*y, .4 scale <2, 1, 2> rotate -20*x translate <0, -2, 12>}
         sphere {0, 1 scale <5, 2, 3> rotate -40*x translate <-4, 2, 10>}
         sphere {0, 1 scale <5, 2, 3> rotate -40*x translate < 4, 2, 10>}
         //cylinder {<0, -1, 0> <0, -9, 0> 1 scale <3, 1, 2> translate <0, 0, 10>}
         //sphere {0, 1 scale <3, 3, 2> translate < 0, -9, 10>}
         //cylinder {<0, 0, 0> <0, 0, 10> 1 scale <3, 3, 1> translate <0, -9, 0>}
         }
      sphere { 0, 1 scale <3, 3, 5> rotate -20*x translate <-4, -1, 12>}
      sphere { 0, 1 scale <3, 3, 5> rotate -20*x translate < 4, -1, 12>}
      }
   texture {
      pigment{Tete_PFace0}
      normal{Tete_NFace}
      }
   texture {
      pigment{Tete_PFace rotate 90*y translate -.56*y scale 50 translate <0, 0, 0>}
      normal{Tete_NFace}
      }
   }

#declare Tete_Machoire=object{
         difference{
            cone {-20*y, 1, 0, .4 scale <8.5, 1, 8> rotate 170*x translate <0, -20, 8>}
            plane {-y, 10 rotate 5*x}
            plane {y, -12 rotate 15*x}
            }
   texture {
      pigment{Tete_PFace0}
      normal{Tete_NFace}
      }
   texture {
      pigment{Tete_PFace rotate 90*y translate -.56*y scale 50 translate <0, 0, 0>}
      normal{Tete_NFace}
      }
   }

#declare Tete_Cou=object{
   cylinder {<0, 10, 0> <0, -30, 0> 4}
   texture {
      pigment{Tete_PLobe0}
      }
   }

#declare Tete_Oeil=object{
   sphere {0, 1}
   texture{
      pigment {
         gradient z color_map {
            [0 0.9 color Gray90 color Gray90]
            [0.9 0.99 color Red color Red]
            [0.99 1 color Black color Black]
            }
         }
      }
   scale 2.5
   }

#declare Tete_seed=seed(4)
#declare TETE_CONST=1
#end

#declare Tete_Trans_0= transform {rotate 20*rand(Tete_seed)*y rotate 360*rand(Tete_seed)*z} //oeil
#declare Tete_Trans_1= transform {translate <0, 10, 0> rotate (-8+20*rand(Tete_seed))*x translate <0, -10, 0>} //mchoire

#declare Tete=union{
   object {Tete_Lobe rotate 10*y rotate 10*z translate -5*x}
   object {Tete_Lobe scale <-1, 1, 1> rotate -10*y rotate -10*z translate 5*x}
   object {Tete_Face rotate -10*x translate <0, -8, 10>}
   object {Tete_Machoire transform Tete_Trans_1 rotate -10*x translate <0, -8, 10>}
   object {Tete_Cou  translate <0, 0, 5>}
   object {Tete_Oeil transform Tete_Trans_0 translate < 4, -7, 20>}
   object {Tete_Oeil transform Tete_Trans_0 translate <-4, -7, 20>}
   }
