/*                    Units are expressed in centimeters          */

#include "colors.inc"
#include "golds.inc"
#include "woods.inc"
/*-------------------------------------------------CAMERA--------------*/
camera {
   location <500,200,0>
   look_at <400,50,1000>
   angle 95
}
/*-------------------------------------------------BACKGROUNT---------*/
background {color Cyan}
/*-------------------------------------------------LIGHT--------------*/
light_source {<100,300,050> color White}            /* Internal light */
light_source {<-1000,300,300> color White}          /* External light */
light_source {<1000,400,800> color White}           /* Corridoi light */   
/*-------------------------------------------------WOOD---------------*/
#declare legno = 
   texture {
      T_Wood35 
      finish {specular 0.15 roughness 0.025 ambient 0.25 reflection 0.05 diffuse 0.8}
      rotate y*90 
      rotate <10, 0, 15> 
      scale <2,1,1> 
      translate -3*x
   }
/*--------------------------------------------------VETRO-------------*/
#declare vetro=
   texture {
      pigment {color rgbf<0.9,0.9,1,0.9>}
      finish {phong 1}
   }
/*-------------------------------------------------ARGENTO------------*/
#declare argento=      
texture {
   pigment {color rgb<0.7,0.7,0.7>}
   finish {
      phong 1 
      ambient 0.3 
      diffuse 0.8 
      reflection 0.1 
      metallic 
      brilliance 4
   }
}
/*-------------------------------------------------VERDE BANCHI-------*/
#declare verdebanchi=
texture {
   pigment {
      wood
      color_map {
         [0.7 color red 0.3 green 1.0 blue 0.7]
         [1.0 color red 0.8 green 0.8 blue 0.8]
      }
      turbulence 0.5
   }
   finish {ambient 0.4 diffuse 0.8}
}
/*-------------------------------------------------VERDE--------------*/
#declare verde=
texture {
   pigment {color rgb <0.1,0.6,0.0>}
   finish {phong 1 ambient 0.4 diffuse 0.8}
}
/*--------------------------------------------------FLOOR-------------*/
#declare floo =
box {
   <0,-10,0>,<50000,0,10000>
   texture {
      pigment {checker color White color Black}
      finish {ambient 0.4 diffuse 0.7 reflection 0.08}
      scale <30,1,30>
   }
}
/*--------------------------------------------------ERBA--------------*/
#declare erba =
box {
   <-10000,-10,0>,<-10,0,10000>
   texture {
      pigment {color rgb<0.6,1.0,0.6>}
      finish {ambient 0.4 diffuse 0.7 crand 0.3}
   }
}
/*--------------------------------------------------------------------*/
#declare ocra=rgb<0.8,0.7,0.1>
#declare biancosporco=rgb<0.8,0.8,0.8>
/*--------------------------------------------------WALL 1------------*/
#declare wall1=
union {
   /*------------WALL 1a-----------*/
   box {
      <-20,0,0>,<0,200,1000>
      texture {
         pigment {color ocra}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   /*------------Midline-----------*/
   box {
      <-20,200,0>,<0,205,1000>
      texture {
         pigment {color Black}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   /*------------WALL 1b-----------*/
   box {
      <-20,205,0>,<0,500,1000>
      texture {
         pigment {color biancosporco}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
}
/*---------------------------LEFT DOOR 1 2 3-----*/
#declare wall1=
difference {
   object {wall1}
   box {<-30,0,650>,<10,250,800> texture {legno}}              /* 1 */
   cylinder {<-30,250,725>,<10,250,725>,75 texture {legno}}    /* 1 */
   box {<-30,0,450>,<10,250,600> texture {legno}}              /* 2 */
   cylinder {<-30,250,525>,<10,250,525>,75 texture {legno}}    /* 2 */
   box {<-30,0,250>,<10,250,400> texture {legno}}              /* 3 */
   cylinder {<-30,250,325>,<10,250,325>,75 texture {legno}}    /* 3 */
}
/*------------------------------GLASS OF THE DOOR 1 2 3----*/
#declare finestre=
merge {
   box {
      <-20,0,650>,<0,250,800> 
      texture {vetro}
   }
   cylinder {
      <-20,250,725>,<0,250,725>,75 
      texture {vetro}
   }
   box {
      <-20,0,450>,<0,250,600> 
      texture {vetro}
   }
   cylinder {
      <-20,250,525>,<0,250,525>,75 
      texture {vetro}
   }
   box {
      <-20,0,250>,<0,250,400> 
      texture {vetro}
   }
   cylinder {
      <-20,250,325>,<0,250,325>,75 
      texture {vetro}
   }
}
/*--------------------------------------------------TRAVI LEGNO FINES-*/
#declare travi=
union {
   cylinder {
      <-10,0,725>,<-10,325,725>,10
      texture {legno}
   }
   cylinder {
      <-10,0,525>,<-10,325,525>,10
      texture {legno}
   }
   cylinder {
      <-10,0,325>,<-10,325,325>,10
      texture {legno}
   }
   cylinder {
      <-10,250,650>,<-10,250,800>,10
      texture {legno}
   }
   cylinder {
      <-10,250,450>,<-10,250,600>,10
      texture {legno}
   }
   cylinder {
      <-10,250,250>,<-10,250,400>,10
      texture {legno}
   }
   cylinder {
      <-10,180,650>,<-10,180,800>,10
      texture {legno}
   }
   cylinder {
      <-10,180,450>,<-10,180,600>,10
      texture {legno}
   }
   cylinder {
      <-10,180,250>,<-10,180,400>,10
      texture {legno}
   }
   cylinder {
      <-10,110,650>,<-10,110,800>,10
      texture {legno}
   }
   cylinder {
      <-10,110,450>,<-10,110,600>,10
      texture {legno}
   }
   cylinder {
      <-10,110,250>,<-10,110,400>,10
      texture {legno}
   }
}
/*--------------------------------------------------WALL 2------------*/
#declare wall2=
union {
   /*------------WALL 2a-----------*/
   box {
      <0,0,1000>,<800,200,1020>
      texture {
         pigment {color ocra}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   /*------------Midline-----------*/
   box {
      <0,200,1000>,<800,205,1020>
      texture {
         pigment {color Black}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   /*------------WALL 2b-----------*/
   box {
      <0,205,1000>,<800,500,1020>
      texture {
         pigment {color biancosporco}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
}
/*--------------------------------------------------WALL 3------------*/
#declare wall3=
union {
   /*------------WALL 3a-----------*/
   box {
      <800,0,0>,<820,200,1000>
      texture {
         pigment {color ocra}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   /*------------Midline-----------*/
   box {
      <800,200,0>,<820,205,1000>
      texture {
         pigment {color Black}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
   /*------------WALL 3b-----------*/
   box {
      <800,205,0>,<820,500,1000>
      texture {
         pigment {color biancosporco}
         finish {ambient 0.4 diffuse 0.7}
      }
   }
}
/*---------------------------RIGHT DOOR 4-----*/
#declare wall3=
difference {
   object {wall3}
   box {
      <790,-10,650>,<830,250,800> 
      texture {
         pigment {color rgb <0.3,0.3,0.3>}
         finish {ambient 0.4 diffuse 0.8}
      }
   }
}
#declare wall3=
union {
   object {wall3}
   box {
      <799,0,640>,<800,260,650>
      texture {
         pigment {color rgb <0.3,0.3,0.3>}
         finish {ambient 0.4 diffuse 0.8}
      }
   }
   box {
      <799,0,800>,<800,260,810>
      texture {
         pigment {color rgb <0.3,0.3,0.3>}
         finish {ambient 0.4 diffuse 0.8}
      }
   }
   box {
      <799,250,650>,<800,260,800>
      texture {
         pigment {color rgb <0.3,0.3,0.3>}
         finish {ambient 0.4 diffuse 0.8}
      }
   }
}
/*--------------------------------EXTERNAL RIGHT----WALL 4------------*/
#declare wall4=
box {
   <1200,0,0>,<1210,500,10000>
   texture {
      pigment {color biancosporco}
      finish {ambient 0.4 diffuse 0.7}
   }
}
/*--------------------------------------------------ROOF--------------*/
#declare roof=
box {
   <0,500,0>,<800,510,1000>   
   texture {
      pigment {color biancosporco}
      finish {ambient 0.4 diffuse 0.7}
   }
}
/*--------------------------------------------------CARTINA MONDO-----*/
declare cartina1=
box {
   <0,0,0>,<200,127,1>
   texture {
      pigment {
         image_map {
            gif "geogr1.gif"     /*  Source GIF = 400 x 254  */
         }
         scale <200,127,1>
      }
   }
   translate <100,220,999>
}
/*--------------------------------------------------CARTINA INGHILTER-*/
declare cartina2=
box {
   <0,0,0>,<100,125,1>
   texture {
      pigment {
         image_map {
            gif "inghilt.gif"     /*  Source GIF = 303 x 359  */
         }
         scale <100,125,1>
      }
   }
   rotate <0,90,0>
   translate <799,220,600>
}
/*--------------------------------------------------CARTINA ITALIA----*/
declare cartina3=
box {
   <0,0,0>,<100,109,1>
   texture {
      pigment {
         image_map {
            gif "italia.gif"     /*  Source GIF = 462 x 499  */
         }
         scale <100,109,1>
      }
   }
   rotate <0,90,0>
   translate <799,220,470>
}

/*--------------------------------------------------CROCE GESU'-------*/
#declare croce=
union {
   cylinder {
      <400,220,1000>,<400,350,1000>,8
      texture {legno}
   }
   cylinder {
      <360,310,1000>,<440,310,1000>,8
      texture {legno}
   }
}
/*---------------------------------------------FOTO PRESIDENTE--------*/
declare presidente=
box {
   <0,0,0>,<80,95,1>
   texture {
      pigment {
         image_map {
            gif "scalfaro.gif"     /*  Source GIF = 316 x 374  */
         }
         scale <80,95,1>
      }
   }
   translate <570,220,999>
}
/*---------------------------------------------LAMPADARI--------------*/
#declare lampadari=
union {
   cylinder {
      <400,350,650>,<400,500,650>,2
      texture {argento}
   }
   sphere {
      <400,350,650>,30
      texture {
         pigment {color White}
         finish {phong 1 ambient 0.4 diffuse 0.7}
      }
   }
   cylinder {
      <400,350,350>,<400,500,350>,2
      texture {argento}
   }
   sphere {
      <400,350,350>,30
      texture {
         pigment {color White}
         finish {phong 1 ambient 0.4 diffuse 0.7}
      }
   }
}
/*---------------------------------------------ALTOPARLANTE-----------*/
#declare altoparlante=
union {
   box {
      <380,400,980>,<420,450,1000>
      texture {legno}
   }
   box {
      <390,410,979>,<410,440,980>
      texture {pigment {color Black}}
   }
}
/*--------------------------------------------------CATTEDRA----------*/
#declare cattedra=
union {
   box {                                             /* Piano argent*/
      <299,100.1,549>,<501,101.9,651>
      texture {argento}
   }
   box {                                             /* Piano verde */
      <300,100,550>,<500,102,650>
      texture {verdebanchi}
   }
   cylinder {                                        /* Piede 1 */
      <310,0,560>,<310,100,560>,2
      texture {verde}
   }
   cylinder {                                        /* Piede 2 */
      <490,0,560>,<490,100,560>,2
      texture {verde}
   }
   cylinder {                                        /* Piede 3 */
      <310,0,640>,<310,100,640>,2
      texture {verde}
   }
   cylinder {                                        /* Piede 4 */
      <490,0,640>,<490,100,640>,2
      texture {verde}
   }
   box {                                             /* Asse 1 */
      <312,30,558>,<488,80,562>
      texture {legno}
   }
   box {                                             /* Asse 2 */
      <308,30,562>,<312,80,638>
      texture {legno}
   }
}
/*--------------------------------------------------BANCO-------------*/
#declare banco=
union {
   box {                                             /* Piano argent*/
      <-0.5,99.9,-0.5>,<200.5,101.9,50.5>
      texture {argento}
   }
   box {                                             /* Piano verde */
      <0,100,0>,<200,102,50>
      texture {verdebanchi}
   }
   cylinder {                                        /* Piede 1 */
      <10,0,10>,<10,100,10>,2
      texture {verde}
   }
   cylinder {                                        /* Piede 2 */
      <190,0,10>,<190,100,10>,2
      texture {verde}
   }
   cylinder {                                        /* Piede 3 */
      <10,0,40>,<10,100,40>,2
      texture {verde}
   }
   cylinder {                                        /* Piede 4 */
      <190,0,40>,<190,100,40>,2
      texture {verde}
   }
   cylinder {                                        /* Piede A */
      <10,15,10>,<10,15,40>,2
      texture {verde}
   }
   cylinder {                                        /* Piede B */
      <190,15,10>,<190,15,40>,2
      texture {verde}
   }
   cylinder {                                        /* Poggiapiedi */
      <10,15,30>,<190,15,30>,2
      texture {verde}
   }
   box {                                             /* Asse 1 */
      <12,80,12>,<188,81,38>
      texture {legno}
   }
   box {                                             /* Asse 2 */
      <12,80,38>,<188,87,40>
      texture {legno}
   }
}
#declare banco=
difference {
   object {banco}
   cylinder {<80,80,40>,<80,120,40>,3 pigment {color Black}}
   cylinder {<180,80,40>,<180,120,40>,3 pigment {color Black}}
}
/*--------------------------------------------------MANIGLIE----------*/
#declare maniglie=
union {
   cylinder {<0,110,725>,<10,110,725>,2 texture {argento}}
   cylinder {<0,110,525>,<10,110,525>,2 texture {argento}}
   cylinder {<0,110,325>,<10,110,325>,2 texture {argento}}
}
/*---------------------------------------------LAVAGNA----------------*/
declare lavagna=
union {
   box {
      <0,0,0>,<150,120,1>
      texture {
         pigment {
            image_map {
               gif "lavagna.gif"     /*  Source GIF = 400 x 284  */
            }
            scale <150,120,1>
         }
      }
   }
   box {
      <-10,-10,0.1>,<160,130,0.9>
      texture {legno}
   }
}
#declare lavagna=
union {
   object {lavagna translate <0,-70,-0> rotate <30,0,0> translate <0,170,0>}
   cylinder {<-15,20,0.5>,<-15,190,0.5>,5 texture {verde}} /* |      */
   cylinder {<165,20,0.5>,<165,190,0.5>,5 texture {verde}} /*      | */
   cylinder {<-15,80,0.5>,<165,80,0.5>,5 texture {verde}} /*  ----  */
   cylinder {<-15,20,0.5>,<165,20,0.5>,5 texture {verde}} /*  ----  */
   cylinder {<-15,5,-30>,<-15,5,30>,5 texture {verde}} /* base1  */
   cylinder {<165,5,-30>,<165,5,30>,5 texture {verde}} /* base2  */
   rotate <0,17,0>
   translate <560,0,850>
}
/*---------------------------------------------CESTINO----------------*/
#declare cestino=
cylinder {
   <785,0,985>,<785,40,985>,15
   open
   texture {
      pigment {color Red}
      finish {phong 1 ambient 0.4 diffuse 0.8}
   }
}
/*---------------------------------------------SEDIA------------------*/
#declare sedia=
union {
   box {
      <-20,50,-20>,<20,51,20> 
      texture {
         pigment {color rgb <0.7,0.6,0.3>}
         finish {ambient 0.4 diffuse 0.8 phong 1}
      }
   }
   cylinder {<-20,0,-20>,<-20,50,-20>,1.5 texture {verde}}
   cylinder {<20,0,-20>,<20,50,-20>,1.5 texture {verde}}
   cylinder {<-15,0,20>,<-15,108,20>,1.5 texture {verde}}
   cylinder {<15,0,20>,<15,108,20>,1.5 texture {verde}}
   box {
      <-20,80,18>,<20,115,18.5> 
      texture {
         pigment {color rgb <0.7,0.6,0.3>}
         finish {ambient 0.4 diffuse 0.8 phong 1}
      }
   }
}
/*---------------------------------------------APPENDI ABITI----------*/   
#declare appendiabiti=
union {
   box {
      <798,190,290>,<800,210,550>
      texture {
         pigment {color Blue}
         finish {phong 1 ambient 0.4 diffuse 0.8}
      }
   }
   #declare kk=300
   #while (kk<=540)
      sphere {
         <793,200,kk>,5 
         pigment {color Red} 
         finish {phong 1 ambient 0.4 diffuse 0.8}
      }
      #declare kk=kk+20
   #end
}



/*=======================PUT OBJECTS IN THE SCENE==================*/
object {floo}
object {wall1} 
object {wall2}    
object {wall3}
object {wall4}
object {roof}
object {erba}
object {finestre}
object {cartina1}
object {cartina2}
object {cartina3}
object {travi}
object {croce}
object {presidente}
object {lampadari}
object {altoparlante}
object {maniglie}                          
object {banco translate <140,0,100>}
object {banco translate <460,0,100>}
object {banco translate <140,0,220>}
object {banco translate <460,0,220>}
object {banco translate <140,0,340>}
object {banco translate <460,0,340>}
object {banco translate <140,0,460>}      
object {cattedra translate <-100,0,100>} 
object {cestino}           
object {sedia rotate <0,180,0> translate <195,0,220>}
object {sedia rotate <0,180,0> translate <265,0,220>}
object {sedia rotate <0,180,0> translate <515,0,220>}
object {sedia rotate <0,180,0> translate <585,0,220>}
object {sedia rotate <0,180,0> translate <195,0,340>}
object {sedia rotate <0,180,0> translate <265,0,340>}
object {sedia rotate <0,180,0> translate <515,0,340>}
object {sedia rotate <0,180,0> translate <585,0,340>}
object {sedia rotate <0,180,0> translate <195,0,460>}
object {sedia rotate <0,180,0> translate <265,0,460>}
object {sedia translate <300,0,750>} 
object {appendiabiti}
object {lavagna}   
