//**************************************************************************
// Alphabet object
//**************************************************************************

#declare Box =
texture {
    pigment { granite
	color_map
	{
    [0.333 color rgbf<0.900 0.800 0.700 0.0>]
    [0.667 color rgbf<0.875 0.775 0.665 0.0>]
    [1.000 color rgbf<0.850 0.750 0.650 0.0>]
	}
    turbulence .88262
    scale .1355
	}
    finish { phong 1 phong_size 281 reflection 0.05 }

}

#declare Alphabet = texture {
pigment { image_map { tga IMAGE_FILE } scale 2 translate <-1, -1, -1> }
//normal { bump_map { tga IMAGE_FILE bump_size 4 once } scale 2 translate <-1,-1,-1> }
finish { ambient 0.5 }
}

#declare Block = union {
#declare Y = 0

#while (Y < 360)
    box { <-1, -1, -1> <1, 1, -.9>  texture { Alphabet } rotate y*Y}
//    cylinder { <-1, 1, -1> <1, 1, -1>, .065 texture { Box } rotate y*Y }
//    cylinder { <-1, 1, -1> <-1, -1, -1>, .065 texture { Box } rotate y*Y }
//    cylinder { <-1, -1, -1> <1, -1, -1>, .065 texture { Box } rotate y*Y }
    #declare Y = Y + 90
#end
box { <-1, -1, -1> <1, 1, -.9>  texture { Alphabet } rotate x*90}

difference {
    box { <-1.275, -1.1275, -1.1275> <1.1275, 1.1275, 1.1275> texture { Box } }
    box { <-2, -1, -1> <2, 1, 1> texture { Box } }
    box { <-1, -2, -1> <1, 2, 1> texture { Box } }
    box { <-1, -1, -2> <1, 1, 2> texture { Box } }
    }
}


/*---------------------------------------------------------------------------
Grade One -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/


