#include "colors.inc"
#include "lego.inc"
#include "train.inc"


global_settings { assumed_gamma 1.8 }

// Finish for crayon wrapper
#declare IMAGE_FINISH =
    finish {
        diffuse 0.65
        ambient 0.118
        roughness 0.846
        crand .052
        phong 0.88 phong_size 48
    }


// Finish for crayon chalk
#declare FINISH =
    finish {
        diffuse 0.53
        ambient 0.148
        roughness 0.76
        crand 0.02109
        phong 0.95 phong_size 58
    }


#declare IMAGE_SHINY_RED = texture {
    pigment { image_map { tga "RED.TGA" map_type 2 } scale <.5,7,.5> 
                rotate y*-114 }
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_GREEN = texture {
    pigment { image_map { tga "GREEN.TGA" map_type 2 } scale <.5,7,.5> } 
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_BLUE = texture {
    pigment { image_map { tga "BLUE.TGA" map_type 2 } scale <.5,7,.5> }
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_YELLOW = texture {
    pigment { image_map { tga "YELLOW.TGA" map_type 2 } scale <.5,7,.5>
                rotate y*-64 }
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_PURPLE = texture {
    pigment { image_map { tga "PURPLE.TGA" map_type 2 } scale <.5,7,.5> 
                rotate y*-34 }
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_GRAY = texture {
    pigment { image_map { tga "GRAY.TGA" map_type 2 } scale <.5,7,.5> 
                rotate y*-84 }
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_ORANGE = texture {
    pigment { image_map { tga "ORANGE.TGA" map_type 2 } scale <.5,7,.5>
                rotate y*14 }
    finish { IMAGE_FINISH }
}

#declare IMAGE_SHINY_WHITE = texture {
    pigment { image_map { tga "WHITE.TGA" map_type 2 } scale <.5,7,.5> 
                rotate y*-89 }
    finish { IMAGE_FINISH }
}

#declare WALLS = texture {
pigment { color rgb<2 2 2> }
finish { ambient 1 }
}

box { <0 0 0>, <888, 888, 888>
      translate <-444, -444, -444>
      texture { WALLS }
      no_shadow hollow
    }                  

#declare PAPER_IMAGE = texture {
    pigment {
        image_map {  tga "PICTURE.TGA" map_type 0 }
         rotate x*90
         scale <17 1 23>
        }
        finish { ambient .1997 }
}

#declare PAPER = texture {
    pigment { color rgb<1 1 1> }
    finish { specular 1 ambient .684 }
}

#declare SHINY_RED = texture {
    pigment { color rgbf<.88 0 0 0> }
    finish { FINISH }
}

#declare SHINY_GREEN = texture {
    pigment { color rgbf<0 .88 0 0> }
    finish { FINISH }
}

#declare SHINY_BLUE = texture {
    pigment { color rgbf<0 0 .88 0> }
    finish { FINISH }
}

#declare SHINY_YELLOW = texture {
    pigment { color rgbf<.88 .88 0 0> }
    finish { FINISH }
}

#declare SHINY_PURPLE = texture {
    pigment { color rgbf<.88 0 .88 0> }
    finish { FINISH }
}

#declare GRAY = texture {
    pigment { color rgbf<0.78, 0.78, 0.78, 0> }
    finish { FINISH }
}

#declare SHINY_ORANGE = texture {
    pigment { color rgbf<0.88, 0.45, 0, 0> }
    finish { FINISH }
}

#declare SHINY_WHITE = texture {
    pigment { color rgbf<1, 1, 1, 0>  }
    finish { FINISH }
}

#declare SHINY_BLACK = texture {
    pigment { color rgbf<0, 0, 0, 0> }
    finish { FINISH }
}

#declare BOX = texture {
    pigment { color rgbf<.43 .43 1 0> }
    finish { phong 1 phong_size 250 reflection .005 }
}


#declare FLOOR =
texture {
    pigment { bozo
	color_map
	{
	[0.200 color rgbf<0.867 0.750 0.650 0.000>]
	[0.400 color rgbf<0.833 0.700 0.600 0.000>]
	[0.600 color rgbf<0.800 0.650 0.550 0.000>]
	[0.800 color rgbf<0.767 0.600 0.500 0.000>]
	[1.000 color rgbf<0.733 0.550 0.450 0.000>]
	}
	turbulence 0.921
    scale 1.733
	}
 finish { roughness 0.788 crand 0.275 ambient 0.416 phong 0.71 phong_size 40 }
}

    plane { y, 0.0 
        scale <50, 50, 50>
        translate <0, -0.1, 0>
        texture { FLOOR }
        no_shadow
    }

    light_source { <75, 76.16, -95>
        color rgb .68889
        spotlight
        point_at <0, 0, 0>
        radius 200
        falloff 205
        tightness 1
    }

#declare LCx = 0
#declare LCz = 0

#while (LCx < 3)

    #declare LCz = 0

    #while (LCz < 3)
        light_source { <-80 + (LCx * 80), 150, -80 + (LCz * 80)>
            color rgb .2108
            spotlight
            point_at <-80 + (LCx * 80), 0, -80 + (LCz * 80)>
            radius 310
            falloff 315
            tightness 1.20
    //      shadowless
            }
        #declare LCz = LCz + 1
    #end

    #declare LCx = LCx + 1
#end


// Alphabet blocks, Legos, and toy train
#declare AllAlphabet =
union {
    #declare IMAGE_FILE = "P.TGA"
    #include "ALPHABET.INC"
    object { Block }

    #declare IMAGE_FILE = "O.TGA"
    #include "ALPHABET.INC"
    object { Block translate <3.75, 0, 1.25> }

    #declare IMAGE_FILE = "V.TGA"
    #include "ALPHABET.INC"
    object { Block translate <3, 2.225, 1.2751> rotate y*39 }

    #declare IMAGE_FILE = "R.TGA"
    #include "ALPHABET.INC"
    object { Block translate <-1.2, 0, -2.75> rotate y*-3 }

    #declare IMAGE_FILE = "A.TGA"
    #include "ALPHABET.INC"
    object { Block translate <2.25,  0, -3.1> rotate y*-30 }

    #declare IMAGE_FILE = "Y.TGA"
    #include "ALPHABET.INC"
    object { Block translate <4.5, 0, -3> rotate y*39 }
}

object { AllLegos translate <-25, -.1, 17> }
object { AllAlphabet translate <1, 1.125, 14> scale 2}
object { Train translate <-25, -45, 5> scale .85 rotate x*-90 }

/*---------------------------------------------------------------------------
Grade One -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
----------------------------------------------------------------------------*/
