#include "gnlgrad1.inc"

camera {
  location <15, 15.132, -20.883>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <2.0099, 1.19599, .8428>
  }


union {  // Layer name: MAIN

    //***********************************************************************
    // White crayon
    //***********************************************************************
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5
        texture { IMAGE_SHINY_WHITE }
        rotate <90, .0, .0>
        rotate <.0, 18.4349, .0>
        translate <12.8559, 0.5, -5.43237>
        
    }
    torus { 0.375, 0.125 
        texture { SHINY_WHITE }
        rotate <90, .0, .0>
        rotate <.0, 18.4349, .0>
        translate <12.8559, 0.5, -5.43237>
        
    }

    difference {
    cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45  
        texture { SHINY_WHITE }
        rotate <90, .0, .0>
        rotate <.0, 18.4349, .0>
        translate <12.5396, 0.5, -6.38105>
        
    }
    box { <0.0, 0.0, 0.0>, <1, 1, 1> 
        texture { SHINY_WHITE }
        rotate <.0, 45, .0>
        translate <11.4916, 0, -6.51792>
    }
    }


    //***********************************************************************
    // Orange crayon
    //***********************************************************************

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5
        texture { IMAGE_SHINY_ORANGE }
        rotate <90, .0, .0>
        rotate <.0, 292.62, .0>
        translate <0.00584794, 0.5, -9.30376>
        
    }
    torus { 0.375, 0.125 
        texture { SHINY_ORANGE }
        rotate <90, .0, .0>
        rotate <.0, 292.62, .0>
        translate <0.00584794, 0.5, -9.30376>
        
    }
    difference {
        difference {
        cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45  
            texture { SHINY_ORANGE }
            rotate <90, .0, .0>
            rotate <.0, 292.62, .0>
            translate <0.9289249, 0.5, -9.68837>
            
        }

        box { <0.0, 0.0, 0.0>, <1, 1, 1> 
            texture { SHINY_ORANGE }
            rotate <.0, 355, .0>
            translate <0.09383778, 0, -10.7824>
        }
        }
    box { <0.0, 0.0, 0.0>, <1, 1, 1>
        texture { SHINY_ORANGE }
        translate <0.8996805, 0, -10.0088>
    }
    }
    //***********************************************************************
    // Gray crayon
    //***********************************************************************

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5  
        texture { IMAGE_SHINY_GRAY }
        rotate <101, .0, .0>
        rotate <.0, 270, .0>
        translate <-3.45851, 1.69494, 0.7624559>
        
    }
    torus { 0.375, 0.125 
        texture { GRAY }
        rotate <101, .0, .0>
        rotate <.0, 270, .0>
        translate <-3.45851, 1.69494, 0.7624559>
        
    }
    difference {
    cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45  
        texture { GRAY }
        rotate <101, .0, .0>
        rotate <.0, 270, .0>
        translate <-2.46868, 1.89786, 0.7550575>
        
    }
    box { <0.0, 0.0, 0.0>, <1, 1, 1> 
        texture { GRAY }
        rotate <25, .0, .0>
        rotate <.0, 90, .0>
        translate <-3.08196, 2.14337, 1.25>
    }
    }
    //***********************************************************************
    // Red crayon
    //***********************************************************************

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5
        texture { IMAGE_SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, 12.5288, .0>
        translate <-4.65079, 0.5, -0.9285612>
        
    }
    torus { 0.375, 0.125 
        texture { SHINY_RED }
        rotate <90, .0, .0>
        rotate <.0, 12.5288, .0>
        translate <-4.65079, 0.5, -0.9285612>
        
    }

    difference {
        difference {
        cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45
            texture { SHINY_RED }
            rotate <90, .0, .0>
            rotate <.0, 12.5288, .0>
            translate <-4.86772, 0.5, -1.90475>
        
        }
        box { <0.0, 0.0, 0.0>, <1, 1, 1> 
            texture { SHINY_RED }
            rotate <.0, 45, .0>
            translate <-4.98323, 0, -1.95602>
        }
        }
    box { <0.0, 0.0, 0.0>, <1, 1, 1>
        texture { SHINY_RED }
        rotate <25, .0, .0>
        rotate <.0, 90, .0>
        translate <-3.08196, 2.14337, 1.25>
    }
    }
    //***********************************************************************
    // Yellow crayon
    //***********************************************************************

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5
        texture { IMAGE_SHINY_YELLOW }
        rotate <90, .0, .0>
        translate <9, 0.5, -2>
        
    }

    torus { 0.375, 0.125 
        texture { SHINY_YELLOW }
        rotate <90, .0, .0>
        translate <9, 0.5, -2>
        
    }
    difference {
    cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45  
        texture { SHINY_YELLOW }
        rotate <90, .0, .0>
        translate <9, 0.5, -3>
        
    }
    box { <0.0, 0.0, 0.0>, <1, 1, 1> 
        texture { SHINY_YELLOW }
        rotate <.0, 345, .0>
        translate <8.80844, 0, -3.64595>
    }
    }
    //***********************************************************************
    // Purple crayon
    //***********************************************************************

    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 0.5, 0
        texture { SHINY_PURPLE }
        rotate <90, .0, .0>
        rotate <.0, 116.565, .0>
        translate <7.68541, 0.5, 5.12698>
        
    }

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5
        texture { IMAGE_SHINY_PURPLE }
        rotate <90, .0, .0>
        rotate <.0, 116.565, .0>
        translate <1.42229, 0.5, 8.28885>
        
    }
    torus { 0.375, 0.125 
        texture { SHINY_PURPLE }
        rotate <90, .0, .0>
        rotate <.0, 116.565, .0>
        translate <1.42229, 0.5, 8.28885>
        
    }
    difference {
        difference {
        cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45  
            texture { SHINY_PURPLE }
            rotate <90, .0, .0>
            rotate <.0, 116.565, .0>
            translate <0.527864, 0.5, 8.73607>
        
        }
        box { <0.0, 0.0, 0.0>, <1, 1, 1> 
            texture { SHINY_PURPLE }
            rotate <.0, 135, .0>
            translate <0.3617925, 0, 9.81095>
        }
        }
    box { <0.0, 0.0, 0.0>, <1, 1, 1> 
        texture { SHINY_PURPLE }
        rotate <.0, 135, .0>
        translate <0.3617925, 0, 9.81095>
    }
    }
    //***********************************************************************
    // Blue crayon
    //***********************************************************************

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5
        texture { IMAGE_SHINY_BLUE }
        rotate <90, .0, .0>
        rotate <.0, 63.4349, .0>
        translate <0.2111456, 0.5, -2.89443>
        
    }

    torus { 0.375, 0.125
        texture { SHINY_BLUE }
        rotate <90, .0, .0>
        rotate <.0, 63.4349, .0>
        translate <0.2111456, 0.5, -2.89443>
        
    }

    difference {
        difference {
        cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45
            texture { SHINY_BLUE }
            rotate <90, .0, .0>
            rotate <.0, 63.4349, .0>
            translate <-0.6832816, 0.5, -3.34164>
            
        }

        box { <0.0, 0.0, 0.0>, <1, 1, 1> 
            texture { SHINY_BLUE }
            rotate <.0, 5, .0>
            translate <-0.7597148, 0, -4.25132>
        }
        }
    box { <0.0, 0.0, 0.0>, <1, 1, 1> 
        texture { SHINY_BLUE }
        translate <-1.60729, 0, -3.59136>
    }
    }
    //***********************************************************************
    // Green crayon
    //***********************************************************************

    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5  
        texture { IMAGE_SHINY_GREEN }
        rotate <90, .0, .0>
        rotate <.0, 345.964, .0>
        translate <-0.2723931, 0.5, 5.08957>
        
    }
    torus { 0.375, 0.125 
        texture { SHINY_GREEN }
        rotate <90, .0, .0>
        rotate <.0, 345.964, .0>
        translate <-0.2723931, 0.5, 5.08957>
        
    }

    difference {
        difference {
        cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 1, 0.0>, 0.45  
            texture { SHINY_GREEN }
            rotate <90, .0, .0>
            rotate <.0, 345.964, .0>
            translate <-0.0298575, 0.5, 4.11943>
            
        }

        box { <0.0, 0.0, 0.0>, <1, 1, 1> 
            texture { SHINY_GREEN }
            rotate <.0, 15, .0>
            translate <-0.07319671, 0, 4.04895>
        }
        }
    box { <0.0, 0.0, 0.0>, <1, 1, 1>
        texture { SHINY_GREEN }
        translate <-0.56832, 0, 3.19991>
    }
    }
    //***********************************************************************
    // Main drawing on paper
    //***********************************************************************

    box { <0.0, 0.0, 0.0>, <17, 0.1, 23>
        texture { PAPER_IMAGE }
        translate <-6.5, -0.09615385, -11>
        
    }
}

/*---------------------------------------------------------------------------
Grade One -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/

