//**************************************************************************
// Lego object
//**************************************************************************

#declare LegoMain =
union {
#declare X = 2
#declare Z = 2

    #while (Z < 10)    
        #while(X < 14)
              superellipsoid { <1 .25> translate <X, Z, -8.5> scale <.25 .25 .125> rotate x*90 }
            #declare  X = X + 4
        #end
        #declare X = 2
     #declare Z = Z + 4
    #end
    difference {
        box { <0, 0, 0>, <3 1 2> }
        box { <0, 0, 0>, <2.6, 1, 1.6> translate <.2,-.2,.2> }
        }
    cylinder { <0 0 0>, <0 1 0>, .25 open translate <.5, 0, 1>  }
    cylinder { <0 0 0>, <0 1 0>, .25 open translate <1.5, 0, 1> }
    cylinder { <0 0 0>, <0 1 0>, .25 open translate <2.5, 0, 1> }
}

#declare Lego = object { LegoMain translate <1.5, 0, 1> }

//#declare LegoT = object { box { <0, 0, 0>, <1.5, 2, 2> translate <.75, 0, 1> } }

#declare LegoFinish =
finish { phong 1 phong_size 248 reflection .101 roughness .32 diffuse .11
         ambient .375 }

#declare RLegoTex =
texture { pigment { Red*1.25 } finish { LegoFinish } }

#declare GLegoTex =
texture { pigment { Green*1.25 } finish { LegoFinish } }

#declare BLegoTex =
texture { pigment { Blue*1.25 } finish { LegoFinish } }

#declare YLegoTex =
texture { pigment { Yellow*1.25 } finish { LegoFinish } }

#declare WLegoTex =
texture { pigment { White*1.25 } finish { LegoFinish } }

#declare KLegoTex =
texture { pigment { Black*1.25 } finish { LegoFinish } }

#declare AllLegos =
union {
object { Lego texture { RLegoTex } rotate x*90 translate <0,3,-2> }
object { Lego texture { BLegoTex } rotate <90,124,0> translate <11,3,-2> }
object { Lego texture { BLegoTex } translate <-1,0,6> rotate y*112 }
object { Lego texture { WLegoTex } translate <7,0,6> rotate y*12 }
object { Lego texture { YLegoTex } translate <-2, 0, -6> rotate y*43 }
object { Lego texture { KLegoTex } translate z*-8 rotate y*10}
object { Lego texture { RLegoTex } translate <-10,0,-8> rotate y*110}
object { Lego texture { YLegoTex } translate <-2,0,-9> rotate y*93}
object { Lego texture { WLegoTex } translate <-4,0,-4> rotate y*140}
object { Lego texture { GLegoTex } translate <0,0,5> rotate y*12}
object { Lego texture { GLegoTex } translate <4,0,-13> }
object { Lego texture { RLegoTex } translate <3,1,-13> }
}


/*---------------------------------------------------------------------------
Grade One -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/

