//**************************************************************************
// Train object
//**************************************************************************


#declare LDWood =
    pigment { granite
	color_map
	{
    [0.333 color rgbf<0.900 0.800 0.700 0.0>]
    [0.667 color rgbf<0.875 0.775 0.665 0.0>]
    [1.000 color rgbf<0.850 0.750 0.650 0.0>]
	}
    turbulence .88262
    scale .1355
	}


#declare LWood =
texture {
    pigment { LDWood }
    finish { phong 1 phong_size 31 roughness 0.88 }
}

#declare DWood =
texture {
    pigment { LDWood }
    finish { phong 1 phong_size 31 roughness 0.88 crand 0.098 }
}

#declare Wheel =
texture {
    pigment { color rgb<.8 .375 .375> }
    finish { phong .88 phong_size 21 }
}


#declare Train =
union {

difference { 
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 7.5, 0.0>, 4  
        rotate <.0, .0, -90>
        translate <-14.5, 4, 0>        
    }

    box { <0.0, 0.0, 0.0>, <8.5, 5, 9>
        translate <-15, -1, -4.5>        
    }
    texture { DWood }
}

union {  
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 10, 0.0>, 0.5  
        rotate <90, .0, .0>
        translate <-9.5, -3.5, -5>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 10, 0.0>, 0.5  
        rotate <90, .0, .0>
        translate <2.5, -3.5, -5>        
    }
    torus { 3.5, 1 
        rotate <90, .0, .0>
        translate <2.5, -3.5, 4>        
        texture { Wheel }
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 3.5, 0 
        rotate <90, .0, .0>
        translate <2.5, -3.5, 4>        
        texture { Wheel }
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 3.5, 0 
        rotate <90, .0, .0>
        translate <2.5, -3.5, -4>
        texture { Wheel }
    }
    torus { 3.5, 1 
        rotate <90, .0, .0>
        translate <2.5, -3.5, -4>
        texture { Wheel }
    }
    torus { 3.5, 1 
        rotate <90, .0, .0>
        translate <-9.5, -3.5, -4>        
        texture { Wheel }
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 3.5, 0 
        rotate <90, .0, .0>
        translate <-9.5, -3.5, -4>        
        texture { Wheel }
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 3.5, 0 
        rotate <90, .0, .0>
        translate <-9.5, -3.5, 4>
        texture { Wheel }
    }
    torus { 3.5, 1 
        rotate <90, .0, .0>
        translate <-9.5, -3.5, 4>
        texture { Wheel }
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 4, 0.0>, 0.5  
        translate <-3, 1, 0>        
    }
    cone { <0.0, 0.0, 0.0>, 1, <0.0, 5, 0.0>, 1  
        translate <3, 1, 0>        
    }
    box { <0.0, 0.0, 0.0>, <5, 5, 6> 
        translate <-12.5, -1, -3>        
    }
    box { <0.0, 0.0, 0.0>, <22, 5, 6> 
        rotate <.0, 180, .0>
        translate <7.5, -6, 3>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 15, 0.0>, 3  
        texture { DWood }
        rotate <.0, .0, -270>
        rotate <.0, 180, .0>
        translate <-7.5, 0, -1.809e-009>        
    }
 texture { LWood }
 }
}

/*---------------------------------------------------------------------------
Grade One -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.

NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
       contact me at my e-mail address to get my premission.
       Visit my website to find software/graphics/links, etc. at:
       http://www.interlog.com/~gautam
---------------------------------------------------------------------------*/


