// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una clase vista en una campana.
//--
// This file contains:
//  A class room seen in a bell.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  ## No flags used ##
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.

global_settings {
    assumed_gamma 2.4
    max_trace_level 12
}

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

// Final render with 2 'cos 1 need extensive (and slow) fine-tuning
#declare RoomLights = 2 // 0 off, 1 on, 2 fast
#include "room.inc"

object { Room }

#declare ArmHead =
    union {
        intersection {
            box { <0, -.01, -.01>, <.01, .01, .01> }
            sphere { 0, .01 }
            scale <.5, 1, 1>
            translate .0025*x
        }
        intersection {
            box { <0, -.01, -.01>, <.01, .01, .01> }
            sphere { 0, .01 }
            scale <.5, 1, 1>*.5
            translate -.0025*x
        }
        texture {
            T_Chrome_1A
            normal { wrinkles -.075 scale .004 }
        }
    }

#declare Arm =
    union {
        cylinder {
            <0, .01, 0>, <0, -.05, 0>, .00475
            scale <.5, 1, 1>
        }
        object { ArmHead }
        rotate 30*z
        translate <-.07, .14, -.025>
        texture {
            T_Brass_5E
            normal { bumps .001 scale .001 }
        }
    }

#declare Wires =
    union {
        cylinder { <0, -.00125, -.00125>, <8.5, -.00125, -.00125>, .00125 }
        cylinder { <0, .00125, -.00125>, <8.5, .00125, -.00125>, .00125 }
        torus { // Staple
            .005, .0025
            rotate 90*x    rotate 90*y
            translate <.175, 0, 0>
            texture {
                pigment { Gray60 }
                finish { phong .6 phong_size 5 }
                normal { bumps .05 scale .005 }
            }
        }
        translate <0, .05, 0>
        texture {
            pigment { Yellow }
            finish { phong .4 phong_size 10 }
            normal { bumps .05 scale .005 }
        }
    }

#declare Screw =
    intersection {
        sphere { 0, .005 scale <1, 1, .3> }
        box { <-.0051, -.00075, -.001>, <.0051, .00075, -.0051>    inverse }
        texture {
            T_Chrome_3A
            finish { ambient .1 }
            normal { bumps -.005 scale .001 }
        }
    }

#declare T_Serial =
    texture {
        pigment { Gray05 }
        finish {
            specular 1
            roughness .01
            reflection .025
        }
        normal { bumps .025 scale .005 }
    }

#declare Serial1 =
    text {
        ttf "arialbd.ttf",
        "4774A",
        .001, 0
        scale <.01, .01, 1>
        texture { T_Serial }
        translate <.05, .105, -.005>
    }

#declare Serial2 =
    text {
        ttf "arialbd.ttf",
        "Model",
        .001, 0
        scale <.01, .01, 1>
        texture { T_Serial }
        translate <-.0775, .105, -.005>
    }

#declare HalfBall =
    union { // inner to outter
        sphere {
            0, .25
            scale <1, .5, 1>
            translate <0, 2.25, 0>
            clipped_by {
                box { <-.26, 1.99, -.26>, <.26, 2.25, .26> }
            }
            scale <1, .5, 1>
        }
        torus {
            .5, .25
            translate 2.25*y    scale <1, .5, 1>
        }
        disc { <0, 1.25, 0>, y, 2, .5 }
        intersection {
            torus { 2, 1    scale <1, 1.25, 1> }
            cylinder { <0, 0, 0>, <0, 1.26, 0>, .5    inverse }
            box { <-3.01, 0, -3.01>, <3.01, 1.26, 3.01> }
        }
        scale .025
        rotate -90*x
        translate <0, .18, 0>
        texture {
            T_Chrome_5E
            normal {
                average
                normal_map {
                    [ .5 waves .0025 frequency 4 scale .001 ]
                    [ .5 waves -.0025 frequency 4 scale .001 translate .5 ]
                    [ .5 granite .01 ]
                    [ .5 bumps -.01 scale .001 ]
                }
            }
        }
    }

#declare Logo =
    height_field {
        gif "by-gsr.gif"
        translate <-.5, 0, -.5>
        rotate -90*x
        scale <.03, .01, .01>
        translate <-.05, .105, -.035>
        texture {
            pigment { red .5 }
            finish { ambient .2 }
        }
        translate <-3.5, 2.3, 3>
    }

object { Logo }

#declare Bell =
    union {
        object { Wires }
        object { Arm }
        object { Screw    rotate 124*z    translate <-.07, .24, -.0055> }
        object { Screw    rotate 214*z    translate <.07, .24, -.0055> }
        object { Serial1 }
        object { Serial2 }
        union {
            object { HalfBall }
            sphere { <0, .18, -.026>, .005 }
            translate <0, 0, -.0075>
        }
        superellipsoid { // Systems
            <.1, .1>
            scale <.08, .05, .05>    translate <0, .05, 0>
        }
        //box { <-.08, 0, -.05>, <.08, .1, 0> }
        superellipsoid { // Base
            <.1, .1>
            scale <.08, .125, .005>    translate <0, .125, 0>
        }
        //box { <-.08, 0, -.005>, <.08, .25, 0> }
        box { <-.07, .1, -.015>, <-.03, .11, -.02> }
        box { <-.07, .1, -.03>, <-.03, .11, -.035> }
        box { <-.07, .1, -.02>, <-.065, .11, -.03> }
        box { <-.035, .1, -.02>, <-.03, .11, -.03> }
        texture {
            pigment { Red }
            normal { bumps .025 scale .005 }
            //normal { dents .25 scale .001 }
            finish {
                specular 1
                roughness .01
                reflection .025
            }
        }
    }

object { Bell translate <-3.5, 2.3, 3> }

/*
// [ Needs more work,
// [ specially position and color (yellow isn't good, should be white).
// Sparkle
#declare cam_loc = <-3.6, 2.65, 2.6>
#declare light_loc = <.065, .18, -.0125> + <-3.5, 2.3, 3>
#declare lookat = <-3.5, 2.45, 3>
#declare sky_vect = <0, 1, 0>
#declare flare_type = "sparkle3"
#declare flare_scale_factor = 1
#include "lnsflare.inc"
*/

#declare Book =
    union {
        box { // Pages
            <-.097, .003, -.145>, <.097, .047, .145>
            texture {
                pigment { White }
                normal { gradient y    scale .001 }
            }
        }
        box { <-.1, .047, -.15>, <.1, .05, .15> } // Front cover
        box { <-.1, 0, -.15>, <-.097, .05, .15> } // Spine
        box { <-.1, 0, -.15>, <.1, .003, .15> } // Back cover
    }

#declare RedBook =
    object {
        Book
        texture { pigment { Red } }
    }

#declare BlueBook =
    object {
        Book
        texture { pigment { Blue } }
    }

// Easy visible books (reflected)
object {
    RedBook
    rotate -89*y    translate <-1.8, .751, -1.8>
}
object {
    BlueBook
    rotate -78*y translate <-1.8, .751+.05, -1.8>
}
object {
    RedBook
    rotate -95*y    translate <-1.85, .751, -1.1>
}
// Books to fill space
object {
    RedBook
    rotate -101*y translate <-1.75, .751, -1.5>
}
object {
    RedBook
    rotate -101*y translate <-.75, .751, -1.4>
}
object {
    RedBook
    rotate -96*y translate <.25, .751, 1.75>
}
object {
    RedBook
    rotate -75*y translate <1.25, .751, -1.9>
}
object {
    RedBook
    rotate -87*y translate <2.25, .751, -1.5>
}
object {
    BlueBook
    rotate -78*y translate <-1.75, .751, 1.5>
}
object {
    BlueBook
    rotate -95*y translate <-.75, .751, 1.3>
}
object {
    BlueBook
    rotate -110*y translate <.25, .751, -1.2>
}
object {
    BlueBook
    rotate -97*y translate <1.25, .751, 1.8>
}

camera {
    up <0, 1, 0>
    right <16/9, 0, 0>
    angle 45
//    location <2, 1.7, -2.9> // Good
//    look_at <0, 1.6, 0>     //
    location <-3.6, 2.65, 2.6> // Definitive 
    look_at <-3.5, 2.45, 3>    //
//    location <3, 1, 0>
//    look_at <-3.5, 1, 0>
}

// Fill lights
#if (RoomLights = 1)
    light_source {
        <0, 2.9, 0> Gray25
    }
    //light_source {
    //    <0, .8, 0> Gray25
    //}
#end
#if (RoomLights = 0)
    light_source {
        <0, 2.9, 0> White
    }
#end
// Sun
light_source {
    <0, 10000, -10000> rgb <.8, .8, 1>
}

#include "skies.inc"
sky_sphere { S_Cloud2 }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
