#version 3

#include "colors.inc"
#include "woods.inc"
#include "\povwin3\myfiles\tower.inc"
#include "\povwin3\myfiles\fence.inc"
#include "\povwin3\myfiles\flags.inc"

global_settings
{
  assumed_gamma 1.0
}


// A supporting bar under the planks

#declare bar =
cylinder
{
  0*y,  4*y,  .03
  pigment {Gray50}
  rotate -67.75*z
  translate <-.68,.0125,-2.4>
}



#declare LoopZ=-2.5
#declare struts= union
{
	#while (LoopZ<=2.5)
	object {
	bar
	translate <0,0,LoopZ>
	       }
	#declare LoopZ=LoopZ+.5
	#end
}

//***************************************

#declare plank =
box
{
  <-.1, -.02, -2.5>  // one corner position <X1 Y1 Z1>
  < .1,  .02,  2.5>  // other corner position <X2 Y2 Z2>
  texture { pigment { P_WoodGrain17A color_map { M_Wood10A }}}
  texture { pigment { P_WoodGrain17B color_map { M_Wood10B }}}
}

#declare LoopX=0
#declare LoopY=0
#declare Seats= union {
	#while (LoopX<=4)
	object {
	plank
	translate <LoopX,LoopY,0>
	}
	#declare LoopX=LoopX+.25
    #declare LoopY=LoopY+.1
	#end
}


// The poles
#declare pole =
union {
cylinder
{
  0*y,  2*y,  .01
  pigment {Gray50}

}


// create a sphere shape
sphere
{
  <0, 2, 0> // center of sphere <X Y Z>
  0.03       // radius of sphere
 pigment {Gold}
}
}




#declare bleachrs =
union {


object {struts
       translate <0,0,2.4>}



object {white_ribbons
       scale <.8,.5,.5>
       rotate 90*y
       translate <3,5.8,0>
       }

// The back fence of the bleachers
// Comment this part out to speed up render time

object {side_of_fence
       scale <.62,.3,.5>
       rotate 90*y
       translate <3,1.7,2.47>}


object {pole
       translate <3,1.5,-2.5>
       }

object {pole
       translate <3,1.5,2.5>
       }


object {Seats
       translate -1*x}

object {tower
       scale .1
       translate <3,-.1,-2>}

object {tower
       scale .1
       translate <1.5,-.7,-2>}

object {tower
       scale .1
       translate <3,-.1,0>}

object {tower
       scale .1
       translate <1.5,-.7,0>}


object {tower
       scale .1
       translate <3,-.1,2>}

object {tower
       scale .1
       translate <1.5,-.7,2>}

    }
