#version 3

#include "colors.inc"
#include "shapes.inc"
#include "\povwin3\myfiles\goal.inc"
#include "\povwin3\myfiles\column.inc"
#include "\povwin3\myfiles\banner.inc"
#include "\povwin3\myfiles\bleachrs.inc"
#include "\povwin3\myfiles\flags.inc"
#include "\povwin3\myfiles\wall.inc"
#include "\povwin3\myfiles\score.inc"
#include "skies.inc"

global_settings
{
  assumed_gamma 1.0
}


//********************************************
// The scoreboard


object {score
       scale 3.5
       translate <0,5,8.5>
       rotate 90*y}


//********************************************
// The walls on the outside

object {wall
       scale <1,4,6>
       translate <9.5,-.5,6.8>
       }

object {wall
       scale <1,4,7.5>
       rotate 90*y
       translate <5.85,-.5,9.75>
       }

object {wall
       scale <1,4,7.5>
       rotate 90*y
       translate <-3,-.5,9.75>
       }





//***********************************************

// The Flags Scattered About

object {red_ribbons
       scale <.9,.5,.5>
       rotate 25*y
       translate <5,4.3,5>}

object {white_ribbons
       scale <.9,.5,.5>
       rotate 25*y
       translate <5,4.5,5>}

object {blue_ribbons
       scale <.9,.5,.5>
       rotate 25*y
       translate <5,4.1,5>}
//------------------------
object {red_ribbons
       scale .7
       rotate 45*y
       translate <-4.5,5.6,7.2>}

object {blue_ribbons
       scale .7
       rotate 45*y
       translate <-4.5,5.2,7.2>}

object {white_ribbons
       scale .7
       rotate 45*y
       translate <-4.5,5.4,7.2>}

//***********************************************
// The Bleachers

object {bleachrs
       scale .8
       translate <4.5,-1,0>
       rotate 180*y}

object {bleachrs
       scale .8
       translate <4.4,-1,0>
       rotate 90*y}

object {bleachrs
       scale .8
       translate <4.5,-1,0>
       }


//***********************************************
// The banner

object {banner
       scale <3,2,1>
       translate <0,1,5.7>
       }

//***********************************************
// The building behind the pool
#declare building =
union {
// The building
box
{
  <-2, -1, -1>
  < 2,  1.5,  1>
  texture {
  pigment {Khaki}
  normal {bumps 2 scale .01}
         }
  translate <0,0,5>
 }
// The columns
object {column
       translate <-1.8,0,4>}
object {column
       translate <0,0,4>
       }
object {column
       translate <1.8,0,4>
       }
}

object {building
       scale 1.5}
object {building
       scale 2
       translate <0,0,0>
       rotate 90*y
       }
object {building
       scale 2
       translate <0,0,2>
       rotate -55*y
       }
//************************************************
// The goals

//The left goal
object {goal
rotate 90*y
       scale .3
       translate <3,-1.3,.2>
       }
//The right goal
object {goal
rotate -90*y
       scale .3
       translate <-3,-1.3,-.2>
       }


//************************************************
// The actual pool
#declare pool =
box
{
  <-2, -.5, -2>  // one corner position <X1 Y1 Z1>
  < 2,  1,  2>  // other corner position <X2 Y2 Z2>
  pigment {Gray70}
}

difference {
object {pool
       scale 1.75}
object {pool
       scale 1.7
       translate .1*y
       pigment {rgbf 1}
       }
translate -2.5*y
}

//**********************************************************************

// The cement around the pool
difference
{
box
{
  <-1, -1, -1>
  < 1,  1,  1>
  scale <10,.1,10>
  pigment {Gray80}
  normal {bumps 1 scale .01}
  translate -.11*y
}
object {pool
       scale 1.7001
       translate .05*y
       pigment {rgbf 1}
       }
translate -.8*y
}

//*********************************************************

// The Acid
plane {y, -1.0
     hollow
     texture {
     pigment {color rgbf <1, 1, 0.196, .8>}
     normal {bumps 2 turbulence 2}
     scale .1
     }
     translate 2*x
}

// ----------------------------------------
camera
{
  location  <0, 1, -10>
  look_at   <0, 1, 0>
  rotate 30*y
    }

sky_sphere {S_Cloud2
           rotate 180*y
           }

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 30, -10>
}
