
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:ivana
// Date:040797
// Auth:Anto Matkovic
// e-mail:anto.matkovic@zg.tel.hr

global_settings {assumed_gamma 2.2}

#include "colors.inc"
#include "textures.inc"

#include "nislova.inc"
#include "pleter.inc"
#include "ivanabody.inc"

sky_sphere {
    pigment {wrinkles turbulence 0.2 omega 0.4 octaves 5
        colour_map {
            [0.2 colour red 1.0 green 0.98 blue 0.96]
            [0.6 colour red 0.6 green 0.7 blue 0.99]
            [1.0 colour red 0.5 green 0.6 blue 0.88]}
        scale <0.5, 0.5, 0.5>
        rotate <45, 6, 0>}}

#declare ddrvo = texture{ pigment{ wood
turbulence 0.6
color_map{ [0 color rgb<0.6, 0.4, 0.25>]
           [1 color rgb<0.8, 0.5, 0.33>]}}
finish {ambient 0.25 diffuse 0.55 phong 0.6 phong_size 123}}


#declare drvotamno = texture{ pigment{ wood
turbulence 0.6
color_map{ [0 color rgb<0.5, 0.2, 0.1>]
           [1 color rgb<0.6, 0.3, 0.17>]}}
finish {ambient 0.25 diffuse 0.55 phong 0.6 phong_size 123}}

#declare parketdr = colour_map
    { [0 color rgb<0.6, 0.4, 0.25>]
      [1 color rgb<0.8, 0.5, 0.33>]}
#declare parfinish = finish{ambient 0.27 diffuse 0.55 phong 0.6 phong_size 73
reflection 0.12}


#declare podd = texture{
 material_map {
  tga "parket1"
  map_type 0
  texture { pigment { wood //smjer 1
    turbulence 1.7
    colour_map { parketdr}
  scale <0.1, 2.2, 1>}
  finish{parfinish}}

  texture { pigment {wood //smjer 2
    turbulence 0.9
    colour_map { parketdr}
  scale <0.4, 2.9, 1>}
  finish {parfinish }}

  texture { pigment {wood //smjer 1
    turbulence 0.5
    colour_map {parketdr}
  scale <0.4, 2.8, 1>}
  finish {parfinish}}

  texture { pigment {wood //smjer2
    turbulence 1.2
    colour_map { parketdr}
  scale <0.2, 3, 1>}
  finish {parfinish }}

  }
  scale     <6, 6, 0.1>
  rotate <0, 0, 90>}



#declare zid= texture {pigment {colour rgb <0.86, 0.83, 0.8>}
finish {ambient 0.18 diffuse 0.6 phong 0.3 phong_size 12}
normal {granite 0.03 scale 0.015}}

#declare zidpl= texture {pigment {colour rgb <0.86, 0.83, 0.8>}
finish {ambient 0.18 diffuse 0.6 phong 0.7 phong_size 78}}

#declare metal = texture {pigment {colour rgb <0.9, 0.6, 0>}
finish {specular 0.6  roughness 0.01 reflection 0.2 brilliance 6}}

#declare tl = texture {pigment {colour rgb <0.3, 0.3, 0.3>}
finish {specular 0.3 roughness 0.1}}//metal za klupicu

#declare staklo = texture {pigment {colour rgbf <0.95, 0.95, 0.96, 0.9>}
finish {phong 1 phong_size 230 ambient 0.1 diffuse 0.1
reflection 0.12 }}

#declare staklo1 = texture {pigment {colour rgbf <0.95, 0.95, 0.96, 0.9>}
finish {phong 1 phong_size 230 ambient 0.1 diffuse 0.1
reflection 0.12}}

#declare stropp= texture {pigment {colour rgb <0.5, 0.5, 0.5>} finish {phong 1 phong_size 23}}
// Set a color of the background (sky)


camera {  location  <38, -12, 6> direction <0.0, 2.010781, 0.0> sky <0.0, 0.0, 1.0> up <0.0, 0.0, 1.0>
right <1.3333, 0.0, 0.0> look_at   <-100, -34, 12.8> angle 28
aperture 0.27               // 0...N (bigger is narrower depth of field)
blur_samples 30             // # of rays per pixel
focal_point <-100, -34, 12.8>
 }





light_source{ 0*x color rgb 1.7
   area_light <16, 0, 16> <-16, 0, -16> 4, 4
  adaptive 0   jitter
  translate <6200, -5600, 2900>  }

//svijetla za backlight
light_source{ 0*x  colour rgb <0.6, 0.57, 0.55>  translate <0, 0, 3> shadowless fade_distance 44 fade_power 2
//atmosphere off
}

light_source{ 0*x  colour rgb <0.5, 0.43, 0.4>  translate <-84, -15, 2> shadowless fade_distance 30 fade_power 2
//atmosphere off
}


#declare pro_rupa =
union{
difference{
box{< 10,  -41.4,  -1><-10, -46, 43>  }
box {<6, -39, 8><-6, -48, 26>}
cylinder {<0, -39, 26>, <0, -48, 26>, 6}texture {zid}}

cylinder{<7.4, -41.4, 8>,<7.4, -41.4, 26.01>, 1.4 texture {zid}}
cylinder{<-7.4, -41.4, 8>,<-7.4, -41.4, 26.01>, 1.4 texture {zid}}

difference{
torus {7.4, 1.4  translate <0, -41.4, 26>}
box {<9, -39, 26><-9, -43, 11> }texture {zid}}

//sstok
superellipsoid
{<0.1, 0.4> scale< 7.5, 4, 0.2> translate <0, -43.5, 8> texture {ddrvo}}

//prozor okvir
cylinder{<0, -43, 8>,<0, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<8, -43, 26>,<-8, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<6, -43, 8>,<6, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<-6, -43, 8>,<-6, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<-6, -43, 8.2>,<6, -43, 8.2>, 0.3 texture{ddrvo}}
difference{
torus {6, 0.3  translate <0, -43, 26>}
box {<9, -42, 26><-9, -44, 11> }texture {ddrvo}}
//prozor letve
box {<0.35, -43.4, 26><-0.35, -43, 8> texture {ddrvo}}
box {<5.6, -43.4, 26><6, -43, 8>  texture {ddrvo}}
box {<-5.6, -43.4, 26><-6, -43, 8> texture {ddrvo}}
box {<-6, -43.4, 26.4><6, -43, 25.6> texture {ddrvo}}//vodoravna
difference{
cylinder{<0, -43.4, 26>,<0, -43, 26>, 6}
cylinder{<0, -43.5, 26>,<0, -42.8, 26>, 5.6}
box {<9, -42, 26><-9, -44, 11> }
texture {ddrvo}}
//staklo
box {<7, -43.2, 7> <-7, -43.25, 34> texture {staklo}}
}

#declare pro_rupaz =
union{
difference{
box{< 10,  -41.4,  -1><-10, -46, 43>  }
box {<6, -39, 8><-6, -48, 26>}
cylinder {<0, -39, 26>, <0, -48, 26>, 6}texture {zid}}

cylinder{<7.4, -41.4, 8>,<7.4, -41.4, 26.01>, 1.4 texture {zid}}
cylinder{<-7.4, -41.4, 8>,<-7.4, -41.4, 26.01>, 1.4 texture {zid}}

difference{
torus {7.4, 1.4  translate <0, -41.4, 26>}
box {<9, -39, 26><-9, -43, 11> }texture {zid}}

//sstok
superellipsoid
{<0.1, 0.4> scale< 7.5, 4, 0.2> translate <0, -43.5, 8> texture {ddrvo}}

//prozor okvir
cylinder{<0, -43, 8>,<0, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<8, -43, 26>,<-8, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<6, -43, 8>,<6, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<-6, -43, 8>,<-6, -43, 26.01>, 0.3 texture{ddrvo}}
cylinder{<-6, -43, 8.2>,<6, -43, 8.2>, 0.3 texture{ddrvo}}
difference{
torus {6, 0.3  translate <0, -43, 26>}
box {<9, -42, 26><-9, -44, 11> }texture {ddrvo}}
//prozor letve
box {<0.35, -43.4, 26><-0.35, -43, 8> texture {ddrvo}}
box {<5.6, -43.4, 26><6, -43, 8>  texture {ddrvo}}
box {<-5.6, -43.4, 26><-6, -43, 8> texture {ddrvo}}
box {<-6, -43.4, 26.4><6, -43, 25.6> texture {ddrvo}}//vodoravna
difference{
cylinder{<0, -43.4, 26>,<0, -43, 26>, 6}
cylinder{<0, -43.5, 26>,<0, -42.8, 26>, 5.6}
box {<9, -42, 26><-9, -44, 11> }
texture {ddrvo}}
//staklo
box {<0, -43.2, 7> <-7, -43.25, 26> texture {staklo1}}
//staklo gore
box {<7, -43.2, 26> <-7, -43.25, 34> texture {staklo}}
}

#declare otv_prozor =
union{
difference{                             //vanjski okvir
superellipsoid
{<0.03, 0.03> scale< 3, 0.3, 8.9> translate <-3, 0, 17.2 > }
superellipsoid
{<0.03, 0.03> scale< 2.6, 0.5, 8.5> translate <-3, 0, 17.2 > }
texture {ddrvo}}
difference{                             //vanjski okvir
superellipsoid
{<0.03, 0.03> scale< 3, 0.3, 8.9> translate <-3, 0, 17.2 > }
superellipsoid
{<0.03, 0.03> scale< 2.6, 0.5, 8.5> translate <-3, 0, 17.2 > }
texture {ddrvo} scale <0.97, 1, 0.99> translate <0.2, 0.3, 0>}


sphere {<-5.6, 1, 8.5> 0.15 texture {metal}} //kvaka
box {<-5.9, -0.05, 8.1><0, 0.05, 25.9> texture {staklo}} //staklo
}
object {otv_prozor rotate z*-135 translate <-90, -43.2, 0>}

#declare rupa =
union{
box {<7.4, -39, 8><-7.4, -48, 26>}
cylinder {<0, -39, 26>, <0, -48, 26>, 7.4}}

#declare rupa_nazad =
union{
box {<39, -7.4, 8><45, 7.4, 26>}
cylinder {<39, 0, 26>, <45, 0, 26>, 7.4}}

//rupa za pleter
#declare pletrupa =
box {<-2.5, -39.9, 6><2.5,-40.2 , 42> texture {zidpl}}




//pod
box{< 101,  41,  0><-111, -41, -1>   texture {podd}}
//strop
box{< 51,  41,  44><-111, -41, 48>   texture {zid}}
//desni zid
box{< 51,  40,  -1><-111, 41, 48>   texture {zid}}



// zid koji vidi, sa kojecim po sebi
difference{
box{<-100, 41, 47><-110, -41, -1> texture {zid}}
//rupa za pleter
box{<-99.9, -38.5, 6><-100.2, -33.5, 42> texture {zidpl}}
//rupa za natpis
box{<-99.9, -20, 32><-101.2, -4, 12> texture {zidpl}}
//rupa za mali pleter
box{<-99.9, -20, 33><-101.2, -4, 44> texture {zidpl}}
}
//zaobljeni dijelovi rupe za natpis
cylinder {<-101.01, -20, 32>,<-101.01, -4, 32>, 1  texture {zidpl}}//vodoravni gore
cylinder {<-101.01, -20, 12>,<-101.01, -4, 12>, 1  texture {zidpl}}//vodoravni dolje
cylinder {<-101.01, -20, 12>,<-101.01, -20, 32>, 1  texture {zidpl}}//uspravni lijevo
cylinder {<-101.01, -4, 12>,<-101.01, -4, 32>, 1  texture {zidpl}}//uspravni desno

//zaobljeni dio u kutu
difference{
box {<-100.2, -40.1, 0><-99, -39, 44> }
cylinder{<-99, -39, 0>,<-99, -39, 44>, 1} texture {zid}}



//zaobljeni dijelovi strop-zid
difference{
box {<101, -40, 42><-110, -38, 46> }
cylinder {<101, -38, 42>,<-111, -38, 42>, 2 } texture {zid}}
difference{
box {<-98, -40, 42><-110.01, 40, 46> }
cylinder {<-98, -40, 42>,<-98, 40, 42>, 2 } texture {zid}}

//lajsne
difference{
box {<101, -40, -0.01><-111, -39.5, 0.5>}
cylinder {<101, -39.5, 0.5>,<-111, -39.5, 0.5>, 0.3}
texture {ddrvo}}

difference{
box {<-99.5, -40, -0.01><-102, 40, 0.5>}
cylinder {<-99.5, -40, 0.5>,<-99.5, 40, 0.5>, 0.3}
texture {ddrvo}}

//lajsna u kutu
cylinder {<-99, -40, 0>,<-100, -39, 0>, 0.5 texture {ddrvo}}

//balet stanga
cylinder {<-98.5, 39, 8>,<-98.5, -33, 8>, 0.22 texture {drvotamno}}
#declare drzac =
union{
cylinder {<-98.5, -33, 8>,<-98.5, -32, 8>, 0.23 }
cylinder {<-98.5, -32.5, 8>,<-100.5, -32.5, 8>, 0.2 }
texture {metal}}
object {drzac}
object {drzac translate y*12}
object {drzac translate y*24}
object {drzac translate y*36}
object {drzac translate y*48}
object {drzac translate y*60}
object {drzac translate y*72}
object {drzac translate y*80}

// zid koji se ne vidi, iza ledja je
difference{
box{<40, 41, 48><44, -41, -1> }
object{rupa_nazad}
object{rupa_nazad translate y*-24}
object{rupa_nazad translate y*24}
texture {zid}}



//lijevi zid
difference{
box{< 51,  -40,  -1><-111, -46, 48>  }


object {rupa translate x*12}
object {rupa translate x*-12}
object {rupa translate x*-36}
object {rupa translate x*-60}
object {rupa translate x*-84}
object {pletrupa translate x*-24}
object {pletrupa translate x*-48}
object {pletrupa translate x*-72}
object {pletrupa translate x*-96}

texture {zid}}

object {pro_rupa translate x*12}
object {pro_rupa translate x*-12}
object {pro_rupa translate x*-36}
object {pro_rupa translate x*-60}
object {pro_rupaz translate x*-84}



//za klupicu
#declare nosac =
union{
intersection{
union{
torus {3, 0.1   rotate z*90 scale<1, 0.6, 1> translate <0, 2.2, 0>}
torus {3, 0.1   rotate z*90 scale<1, 0.6, 1> translate <0, -2.2, 0>}
torus {1.1, 0.1   rotate z*90 scale<1, 0.6, 1> translate <0, 0, 2>}
torus {1.1, 0.1   rotate z*90 scale<1, 0.6, 1> translate <0, 0, -2>}
torus {0.5, 0.1   rotate z*90 scale<1, 0.75, 0.9> translate <0, 0, 0.42>}
torus {0.5, 0.1   rotate z*90 scale<1, 0.75, 0.9> translate <0, 0, -0.42>}}
box{<-0.3, -2.5, -2.8><0.3, 2.5, 2.8>}}
cylinder{<0, -1.6, -2.8>,<0, 1.6, -2.8>, 0.1 }
cylinder{<0, -1.6, 2.8>,<0, 1.6, 2.8>, 0.1 }
scale <1, 0.8, 0.7>
translate <0, 0, 2>texture {tl}}

#declare klupica =
union{
object {nosac translate x*5.5}
object {nosac translate x*-5.5}
difference{
torus {5.5, 0.15    scale<1, 0.7, 0.35> translate <0, 0, 2>}
box{<5.7, 0.2, 2><-5.7, -0.2, -2.2>}
texture{tl}}
superellipsoid
{<0.1, 0.1> scale< 6, 0.2, 0.1> translate <0, 0, 4.05> texture {drvotamno}}
superellipsoid
{<0.1, 0.1> scale< 6, 0.2, 0.1> translate <0, 0.6, 4.05> texture {drvotamno}}
superellipsoid
{<0.1, 0.1> scale< 6, 0.2, 0.1> translate <0, 1.2, 4.05> texture {drvotamno}}
superellipsoid
{<0.1, 0.1> scale< 6, 0.2, 0.1> translate <0, -0.6, 4.05> texture {drvotamno}}
superellipsoid
{<0.1, 0.1> scale< 6, 0.2, 0.1> translate <0, -1.2, 4.05> texture {drvotamno}}
}


object{klupica translate <-36, -37, 0>}
object{klupica translate <-48, -37, 0>}
object{klupica translate <-60, -37, 0>}
object{klupica translate <-72, -37, 0>}

//torus {2.2, 0.1   rotate <15, 0, 0>  translate <-38,-38.7, 2.25>texture {ddrvo}}






