#include "map.inc"

#declare Clear =
pigment { rgbt<1,1,1,1> }

#declare PintGlass =
merge {
  lathe {
    cubic_spline 8
    <3.4,6.24>, <3.9,4.32>, <4.1,2.1>, <2.9,-3.36>, <3.2,-5.84>, <2.7,-6.24>, <2,-6.34>, <0,-6.35>
    sturm
  }
  disc { <0,-6.34,0>, <0,1,0>, 2 }
  difference {
    torus { 3.75, 0.15 translate 4.32*y }
    box { <-5,0,-5>, <5,4.32,5> }
  }
  pigment {
    gradient z pigment_map {
      [ 0 PintMap ]
      [ 0.5 PintMap ]
      [ 0.5 Clear ]
    }
    translate <-0.5,-0.5,-0.5>
    scale <6,2.2,8.3>
    translate 2*y
  }
  finish { reflection 0.1 refraction 1 ior 1.2 phong 1 }
}

#declare Foam =
cone { <0,4.32,0>, 3.6, <0,3.5,0>, 3.8
  pigment {
    bozo color_map {
      [ 0 color rgb<1,0.84,0.72> ]
      [ 1 color rgb<0.9,0.8,0.7> ]
    }
    turbulence 1
    scale 0.5
  }
  normal { bumps 0.2 scale 1.5 }
}

#declare Beer =
union {
  lathe {
    cubic_spline 8
    <3,6.78>, <3.8,3.5>, <3.8,2.1>, <2.6,-3.36>, <2.6,-5.1>, <2.25,-5.3>, <1,-5.5>, <0,-5.55>
    sturm
  }
  disc { <0,-5.5,0>, <0,1,0>, 1 }
  pigment { rgbf<0.1,0.02,0,1> }
  finish { ior 1.33 refraction 1 reflection 0.05 phong 0.2 phong_size 20 }
}

#declare Pint =
union {
  object { PintGlass }
  object { Beer }
  object { Foam }
  translate 6.35*y
  scale 1/12.59
}
