#declare Mouse_ =
union {
  difference {
    intersection {
      sphere { <0,-7.5,0>, 10 }
      box { <2.7,3,5.283>, <-2.7,0,-5.283> }
    }
    sphere { <0,-7.5,0>, 9.7 }
    box { <3,3,2>, <-3,0,1.8> }
    box { <-0.1,3,6>, <0.1,0,1.9> }
  }
  intersection {
    sphere { <0,-7.5,0>, 9.55 }
    box { <2.7,3,4.8>, <-2.7,0,-4.8> }
  }
  pigment { rgb <0.914, 0.882, 0.780> }
  finish {
    ambient 0.10
    diffuse 0.90
    phong 0.03
    phong_size 1.0
  }
}

#declare MouseCord =
intersection { 
  torus { 20, 0.35 translate <0,0.4,5> }
  box { <0,0,5>, <21,1,21> }
  translate -20*x
  finish {
    ambient 0.10
    diffuse 0.90
    phong 0.03
    phong_size 1.0
    metallic
  }
  pigment { rgb <0.478, 0.459, 0.412> }
}

#declare Mouse =
union {
  object { Mouse_ }
  object { MouseCord }
  translate 0.8*y
}

#declare Black =
pigment { rgb<0,0,0> }

#declare PadTexture =
pigment {
  image_map {
    tga "buzz.tga"
    interpolate 2
    once
  }
  translate <-0.5,-0.5,0>
  rotate 90*x
  rotate 90*y
  scale <20,1,30>
}

#declare MousePad =
union {
  box { <-7,0,-15>, <7,0.8,15> }
  box { <-10,0,-12>, <10,0.8,12> }
  cylinder { <-7,0,-12>, <-7,0.8,-12>, 3 }
  cylinder { <-7,0,12>, <-7,0.8,12>, 3 }
  cylinder { <7,0,-12>, <7,0.8,-12>, 3 }
  cylinder { <7,0,12>, <7,0.8,12>, 3 }
  pigment {
    gradient y pigment_map {
      [0 Black]
      [0.7 Black]
      [0.7 PadTexture]
    }
  }
}
