#declare Emblem =
intersection {
  difference {
    cylinder { <0,-6,0>, <0,0,0>, 3.5 }
    cylinder { <0,-6,0>, <0,0,0>, 3.3 }
    box { <-10,-10,0>, <10,10,10> }
  }
  cylinder { <0,-5,-8>, <0,-5,8>, 1.8 scale <1,0.5,1> }
  translate 1.5*z
  texture {
    pigment { rgb<0,0,0> }
  }
  texture {
    pigment {
      image_map {
        gif "logo.gif"
        interpolate 2
        once
      }
      translate <-0.5,-0.5,0>
      scale <3.6,1.8,1>
      scale 0.973
      translate -2.5*y
    }
    finish { phong 0.8 phong_size 120 reflection 0.1 }
  }
}

#declare BlackPlastic =
union {
  sphere { <0,0,0>, 1 scale <1,1.25,1> }
  lathe { cubic_spline 7, <1,3>, <1,0>, <1,-1>, <0.9,-2.5>, <0.7,-5>, <0.8,-6>, <0.9,-7.5> sturm }
  intersection {
    cylinder { <0,-2.5,0>, <0,-2.5,-3.5>, 0.4 }
    cylinder { <0,-6,0>, <0,0,0>, 3.3 translate 1.5*z }
  }
  cylinder { <-0.05,0,0>, <0.05,0,0>, 1 scale <1,0.4,0.9> translate -7.2*y }
  box { <-0.05,-8.3,-0.9>, <0.05,-7.2,0.9> }
  lathe { cubic_spline 5, <0.6,-9>, <0.6,-10.5>, <0.5,-12>, <0.25,-14>, <0.2,-14.2> sturm translate -1.25*y }
  pigment { rgb<0,0,0> }
  finish { phong 0.8 phong_size 120 reflection 0.1 }
}

#declare GoldMetal =
union {
  torus { 0.6, 0.18 translate 0.99*y }
  intersection {
    sphere { <0,0,0>, 1 scale <1,1.25,1> }
    cylinder { <0,0,0>, <0,2,0>, 0.5 }
    translate 0.1*y
  }
  cylinder { <0,0,0>, <0,1.5,0>, 0.4 }
  sphere { <0,1.5,0>, 0.5 }
  torus { 0.8, 0.2 scale <1,2,1> translate -6.3*y }
  difference {
    union {
      cylinder { <0,-6.3,0>, <0,-8,0>, 1 }
      torus { 0.7, 0.3 translate -8*y }
    }
    cylinder { <-1,-8,0>, <1,-8,0>, 2 scale <1,1,0.45> translate 1.6*z }
    cylinder { <-1,-8,0>, <1,-8,0>, 2 scale <1,1,0.45> translate -1.6*z }
    box { <-0.05,-10,-10>, <0.05,-6.8,10> }
  }
  cylinder { <-1.1,-7.5,0>, <1.1,-7.5,0>, 0.2 }
  difference {
    union {
      torus { 1, 0.1 scale <1,2,1> translate -8.5*y }
      cylinder { <0,-8.5,0>, <0,-10.3,0>, 1.1 }
      torus { 1, 0.1 scale <1,2,1> translate -10.3*y }
    }
    #declare Count = 0
    #while (Count < 24)
      cylinder { <0,-8.3,1.1>, <0,-10.5,1.1>, 0.1 rotate Count*15*y }
      #declare Count = Count + 1
    #end
  }
  torus { 0.7, 0.3 translate -10.5*y }
  torus { 0.5, 0.2 translate -10.8*y }
  cylinder { <0,-10.8,0>, <0,-11.5,0>, 0.5 }
  torus { 0.5, 0.2 translate -11.5*y }
  torus { 0.6, 0.25 translate -11.75*y }
  cylinder { <0,-9.6,0>, <0,-9.6,7>, 0.6 }
  cylinder { <0,-8.8,0>, <0,-8.8,7>, 0.2 }
  pigment { rgb<1,0.85,0.1> }
  finish { phong 1 phong_size 80 metallic reflection 0.25 brilliance 100 }
}

#declare preTap = 
union {
  object { BlackPlastic }
  object { GoldMetal }
  object { Emblem }
}

#declare Tap = 
union {
  union {
    torus { 9.25, 3 rotate 90*x translate 108*z }
    cylinder { <0,0,108>, <0,0,116>, 12.25 }
    torus { 6, 6.25 rotate 90*x translate 116*z }
    cylinder { <0,0,119>, <0,0,122.25>, 6 }
    cylinder { <0,-1,122.25>, <0,-1,124>, 5 }
    torus { 3, 2 scale <1,0.7,1> rotate 90*x translate <0,-1,124> }
    cylinder { <0,3,122.25>, <0,3,124>, 3 }
    torus { 1, 2 scale <1,0.7,1> rotate 90*x translate <0,3,124> }
    pigment { rgb<0,0,0> }
    finish { phong 0.8 phong_size 120 reflection 0.1 }
  }
  object { preTap
    translate <0,9.4,-7>
    scale 5
    translate -122*z
    scale <1,1,-1>
  }
  translate 93.05*z
  scale 1/250
}
