#include <math.h>
#include <stdio.h>

int main (void) {
  double x, theta1, theta2, theta3, top, bottom, side;
  int i;

  printf ("#include \"scales.inc\"\n#declare Body =\ndifference {\n  union {\n");
  for (i = 0, x = -3.25, theta3 = -M_PI/3.0, theta2 = theta1 = -M_PI/2.5; i < 100; i++) {
    if (i < 32) {
      side = 0.9*cos(theta3) + 0.25;
      theta3 += M_PI/93.0;
    }
    else {
      side = 0.4*cos(theta3) + 0.75;
      theta3 += M_PI/69.0;
    }
    if (i < 38) {
      top = cos(theta1) + 0.1;
      theta1 += M_PI/92.5;
    }
    else {
      top = 0.75*cos(theta1) + 0.35;
      theta1 += M_PI/126.0;
    }
    if (i < 36) {
      bottom = cos(theta2) + 0.1;
      theta2 += M_PI/87.5;
    }
    else {
      bottom = 0.4*cos(theta2) + 0.7;
      theta2 += M_PI/65.0;
    }
    printf ("    sphere { <%f,%f,0>, %f scale <1,1,%f> }\n", x, (top-bottom)/2.0, (top+bottom)/2.0, side/(top+bottom));
    x += 0.065;
  }
  printf ("  }\n  union {\n    difference {\n");
  printf ("      box { <-1,-1,-1>, <0,0,1> }\n");
  printf ("      box { <-0.25,-0.25,-1>, <1,1,1> }\n    }\n");
  printf ("    cylinder { <-0.25,-0.25,-1>, <-0.25,-0.25,1>, 0.25 }\n");
  printf ("    rotate -42*z\n");
  printf ("    translate <-3,-0.04,0>\n  }\n");
  printf ("  texture { ScaleTexture }\n}");
  return 0;
}
