#include <stdio.h>

int main (void) {
  double y1, y2, x, oldy1, oldy2, oldx;
  int i;

  printf ("#declare TailFinSpikes =\nunion {\n");
  fprintf (stderr, "#declare TailFinMembrane =\nunion {\n");
  for (i = 0, y1 = 0.367, y2 = 0.38, x = 4.8; i < 9; i++) {
    printf ("  cone { <3,%f,0>, 0.05, <%f,%f,0>, 0.01 scale <1,1,1.5> }\n", y1, x, y2);
    if (i < 8)
      fprintf (stderr, "  difference {\n    prism { linear_sweep linear_spline 0.005, -0.005, 5\n      <3,%f>, <%f,%f>,\n", y1, x, y2);
    oldy1 = y1; oldy2 = y2; oldx = x;
    y1 -= 0.08; y2 -= 0.15;
    if (i < 3)
      x -= 0.12;
    else
      x += 0.044;
    if (i < 8) {
      fprintf (stderr, "      <%f,%f>, <3,%f>,\n      <3,%f>\n      rotate -90*x\n    }\n", x, y2, y1, oldy1);
      fprintf (stderr, "    cylinder { <0,%f,-1>, <0,%f,1>, 0.07\n      scale <1.75,1,1> translate %f*x\n    }\n  }\n", (oldy2+y2)/2.0, (oldy2+y2)/2.0, (oldx+x)/2.0);
    }
  }
  printf ("}\n");
  fprintf (stderr, "}\n");
  return 0;
}
