#include <stdio.h>
#include <math.h>

int main (void) {
  double y, x1, x2, oldx1, oldx2, oldy, bx1, bx2, by;
  int i;

  printf ("\n#declare FrontDorsalFinSpikes =\nunion {\n");
  fprintf (stderr, "\n#declare FrontDorsalFinMembrane =\nunion {\n");
  for (i = x1 = x2 = 0, y = 0.08; i < 10;) {
    printf ("  cone { <%f,0,0>, 0.03, <%f,%f,0>, 0.005 scale <1,1,1.2> }\n", x1, x2, y);
    oldx1 = x1; oldx2 = x2; oldy = y;
    i++;
    x1 += 0.0888;
    x2 = 0.16 + 0.5*(1 - cos(i*M_PI/9.0));
    y = 0.4*sin(i*M_PI/9.0) + 0.2;
    if (i > 0) {
      bx1 = (oldx1 + x1) / 2.0;
      bx2 = (oldx2 + x2) / 2.0;
      by = (oldy + y) / 2.0;
      fprintf (stderr, "  difference {\n    prism { linear_sweep linear_spline 0.001, -0.001, 5\n");
      fprintf (stderr, "      <%f,0>, <%f,%f>, <%f,%f>, <%f,0>, <%f,0>\n      rotate -90*x\n    }\n", oldx1, oldx2, oldy, x2, y, x1, oldx1);
      fprintf (stderr, "    cylinder { <0,0,1>, <0,0,-1>, %f scale <1.2,1,1> rotate %f*z translate <%f,%f,0> }\n  }\n", sqrt((bx2-x2)*(bx2-x2) + (by-y)*(by-y)), 180*atan2(by,bx2-bx1)/M_PI, bx2, by);
    }
  }
  printf ("}\n");
  fprintf (stderr, "}\n");
  return 0;
}
