#include "metals.inc"

//P_Chrome2 - color for metalwork
//F_MetalE is pre-defined v shiny metallic finish

#declare My_Metal_Tex =
texture {
   pigment { P_Chrome2 }
   finish { F_MetalE }
}

#declare Vert_Bar =
cylinder { <0, 0, 160> <0, 30, 160>, 0.5
   texture {
      pigment { P_Chrome2 }
      finish { F_MetalE }
   }
}

#declare Horizontal_Ring_Outer =
cylinder {
   <0, 4.9, 0> <0, 5.1, 0>, 160.5
   texture {
      pigment { P_Chrome2 }
      finish { F_MetalE }
   }
}

#declare Horizontal_Ring_Inner =
cylinder {
   <0, 4.85, 0> <0, 5.15, 0>, 159.5
   texture {
      pigment { P_Chrome2 }
      finish { F_MetalE }
   }
}

#declare Horizontal_Ring =
difference {
   object { Horizontal_Ring_Outer }
   object { Horizontal_Ring_Inner }
}   


#declare The_Bars =
union { // The_Bars union statement
   union { //Vert_Bar union statement
#declare Orbit_by = 0
#while (Orbit_by <360)
   object { Vert_Bar rotate <0, Orbit_by, 0> }
   #declare Orbit_by = Orbit_by + 5
#end
   } //End of Vert_Bar union statement

#declare Trans_up_by = 0
   union { // Horizontal_Ring union statement
#while (Trans_up_by <4)
   object { Horizontal_Ring translate <0, Trans_up_by*5, 0> }
   #declare Trans_up_by = Trans_up_by + 1
#end
   } // End of Horizontal_Ring union statement

} //End of The_Bars union statement












