global_settings
 {radiosity
   {//distance_maximum 5.5  //??
    //nearest_count 2
    count 200
    error_bound 0.33
   }
 }


#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "school2.inc"

#declare R1=seed(123)
#declare R2=seed(321)

camera {  //  Camera Camera01
  location  <05,-10,-2>//<-20,-55,185>//<-10, -47, 15>//<-45,-20,15>//
  location  <-110,-75,-8> //BRA
  direction <0.0,     0.0,  2.6329>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  //angle 14//43.458
  look_at   <5,0,4>//<27,1,25>//<-40,-25,-10>//<15,40,15>//<20,3.1,30>//<30,0,16>//
  look_at   <-40,-25,4> //BRA
}

// create a regular point light source
/*light_source
{
  0*x // light's position (translated below)
  //color White*.9  // light's color
  //color (White/2+Gold/2)*1
  color (White*2/3+Gold/3)*.9
  translate <-90*3, -80*3, 40*3>         //<-20, -27, 2>//<30, -10, 20>
}*/

light_source
 {<-80,-3,38>
  //color (White/3+Gold*2/3) * .6
  color rgb<1,.86,.6>*.5
  fade_distance 55
  fade_power 2
  }


// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{ 0*x // light's position (translated below)
  color (White*2/3+Gold/3)*.9  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  //<8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  <8,0,0>,<0,0,8>
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  translate <-90*3, -80*3, 40*3>//<-70, -100, 45>//translate <40, 80, -40>   // <x y z> position of light
}



#declare StenTex=
texture
{pigment
       {dents
        turbulence 0.3
        color_map
         {[ 0.0 color Clear]
          //[ 0.5 color rgbf<.8,.5,.5,.0>]
          //[ 1.0 color rgbf<.8,.5,.5,.0>]
          [ 0.5 color rgbf<.8,.7,.7,.2>]
          [ 1.0 color rgbf<.8,.7,.7,.0>]
          [ 1.0 color Clear]
         }
        translate<50*rand(R1),100*rand(R1), 140*rand(R2)>
        scale 1
       }
      //normal{granite scale 4}
      }


box
 {<-50,0,-10>,<-48,-20,-7.85>
  //pigment{color Gray50}
  texture{T_Grnt9}
  texture{StenTex}
  normal{bumps scale 0.5}
 }
superellipsoid
 {<0.2,.1>
  scale<1,1,3>
  rotate x*90
  rotate -y*4
  translate<-49,-23.1,-9>
  //texture {T_Grnt27}
  texture {T_Grnt9}
  texture{StenTex}
  normal{dents scale .3}
 }
superellipsoid
 {<0.2,.06>
  scale<1,1,3>
  rotate x*90
  rotate y*4
  rotate z*90
  translate<-47,-27,-9>
  //pigment{color Red}
  texture{T_Grnt9}
  texture{StenTex}
  normal{dents 2 scale .5}
 }
superellipsoid
 {<0.2,.06>
  scale<1,1,3>
  rotate x*90
  rotate y*0
  rotate z*90
  translate<-40.9,-27,-9>
  //pigment{color Red}
  texture{T_Grnt9}
  texture{StenTex}
  normal{dents scale .5}
 }
superellipsoid
 {<0.2,.06>
  scale<1,1,3>
  rotate x*90
  rotate -y*2
  rotate z*90
  translate<-34.7,-27,-9>
  //pigment{color Yellow}
  texture{T_Grnt9}
  texture{StenTex}
  normal{dents scale .5}
 }
#declare loop=1
#while (loop<=10)
 superellipsoid
 {<0.2,.06>
  scale<1,1,3>
  rotate x*90
  rotate y*(rand(R2)*6-3)
  rotate z*90
  translate<-34.7+loop*6.2,-27,-8.5>
  //pigment{color Yellow}
  texture{T_Grnt9}
  texture{StenTex}
  normal{dents scale .5}
 }
 #declare loop=loop+1
#end


blob
{threshold 0.1
 #declare loop=0                 // JORDEN
 #while (loop<1500)   //3000)
  #declare Slump=rand(R2)*12.5-25  //25-25
  #declare Slamp=rand(R1)*1+.5
  sphere{<rand(R1)*100-46,Slump,0>,Slamp,1 scale <1,1,.7/Slamp> translate<0,0,-4.7-abs(-12.5+Slump)/10>}
  #declare loop=loop+1
 #end
 pigment{color DarkBrown+.1}
 normal{bumps .5 scale 0.2}
 finish{crand 0.5}
}

blob
{threshold 0.1
 #declare loop=0                 // Snn p JORDEN
 #while (loop<500)  //1000)
  #declare Slump=rand(R1)*12.5-25  //25-25
  #declare Slamp=rand(R2)*1+.5
  sphere{<rand(R1)*100-46,Slump,0>,Slamp,1 scale<1,1,.7/Slamp> translate <0,0,-4.5-abs(-12.5+Slump)/10>}
  #declare loop=loop+1
 #end
 pigment{color White}
 normal {bumps .5 scale 0.5}
 finish{ambient .35 diffuse .5}
}


#include "sko.pov"
                                        //SNN p marken
intersection
{
blob
 {threshold 0.1
  #declare loop=0
  #while (loop<2800)
   #declare Slump=rand(R1)*2.5+.5
   sphere{<rand(R1)*120-59,-rand(R2)*70,0>,Slump,1 scale<1,1,1/Slump> translate -z*10.2}
   #declare loop=loop+1
  #end
  #declare loop=0
  #while (loop<1800)
   #declare Slump=rand(R1)*2.5+.5
   #declare Slamp=rand(R1)*30-90
   sphere{<Slamp,-rand(R2)*70,0>,Slump,1 scale<1,1,((Slamp+140)/(100))/Slump> translate -z*10.2 }//pigment{color Green}}
   #declare loop=loop+1
  #end
  pigment{color White}
  finish{diffuse 0.35 ambient .5}
 }
/*union
{
#declare loop=0
#while (loop<75)
 object
  {Sko
   scale <.3,.3,1>
   rotate z*360*rand(R2)
   translate <rand(R1)*30-90,-rand(R2)*40-15,-10.5>//<-65,-40,-12>
   //pigment{rgb<1,1,.93>}
   pigment{color Blue}
   finish{diffuse 0.5 ambient .5}
   inverse
  }
 #declare loop=loop+1
#end
}*/
normal {bumps .8 scale 0.3}
}


/*box      //Rummet innanfr
 {<-15,-5,0>,<65,35,50>
  /*pigment
   {gradient x
    color_map
     {[0 color White]
      [.5 color White]
      [.5 color Brown]
      [.75 color White]
      [1 color Brown]
     }
    scale 1
   }*/
   pigment{color White}
  clipped_by
   {plane
     {y,0.5
      inverse
     }
   }
  }*/
plane
 {y,35
  pigment{color Gray70}
  finish{ambient 1 diffuse 0}}
box
 {<-100,.5,50>,<2*(21.4+8.25)+7,50,51>   //<500,50,51>
  pigment{color Gray60}
  finish{ambient 1 diffuse 0}}

box
  {<9.1,7,3.1+1.2*7>,<47.7,6.3,57.7+1.2*9>
   translate 2*x*(21.4+8.25)
   pigment{color Gray10}
   finish{ambient 1 diffuse 0}}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
intersection
{
box
 {<-55,0,-0.1>,<105,3,85>}
box
  {<9.1-.25,3.1,3.1+1.2*7>,<30.7,-4,27.7+1.2*9> inverse
   translate <-(21.4+8.25)-.75,0,0>}
box
  //{<9,4,3.7>,<21,-4,13>}
  //{<9,4,3.4>,<20.2,-4,16.8>}
  {<9.1-.25,3.1,3.1+1.2*7>,<30.7,-4,27.7+1.2*9> inverse
   translate <-.75,0,0>}
box
  {<9.1-.25,3.1,3.1+1.2*7>,<30.7,-4,27.7+1.2*9> inverse
   translate <(21.4+8.25)-.75,0,0>}
box
  {<9.1-.25,3.1,3.1+1.2*7>,<30.7,-4,27.7+1.2*9> inverse
   translate <2*(21.4+8.25)-.75,0,0>}
pigment {color rgb<.9,.92,.87>}//Gray85}
finish {crand 0.12 ambient 0.5 diffuse 0.2}

 /*texture
 {
 pigment{
  bozo
  turbulence 0.4
  color_map{
   [0.0 color Clear]
   [0.3 color DarkTan/2 filter 0.5]
   [1.0 color Clear]
  }
  rotate 90*z
  scale 8/20
 }
 }
 */
}

//Grunden brjar hr

box
 {<-55,0,-0.14>,<105,1,-10>
  texture
{
pigment{
  marble
  turbulence 0.4
  color_map{
   [0.0 color Gray80 filter 0.]
   [0.2 color Gray80 filter 0.]
   [0.2 color  Gray70 filter 0.]
   [1.0 color Gray80 filter 0.]
  }
  rotate 90*z
  scale <1,180/13,1>
  scale 5 //min
  translate 9*y
 }
}
//finish{crand 0.1}
finish {ambient 0.4 diffuse 0.3}
 }

/*box     //Skit
 {<-15,-0.01,-4.1>,<45,1,-8>
    texture
{
pigment{
  marble
  //turbulence 0.4
  turbulence 0.4
  color_map{
   [0.0 color Gray90 filter 1]
   [0.2 color Gray90 filter 1]
   [0.2 color Gray90 filter 1]
   [1.0 color White filter 1]
  }
  rotate 90*y
  scale <1,180/13,1>
  scale 2 //min
  translate 9*y
  //translate z*.4
 }
}
finish{crand 0.1}
}*/

//Grunden slutar hr

intersection
  {
union
{
#declare varv=-12
#declare vurv=0
 #while (vurv<=50)
  #while (varv<=20)
   #if (mod(vurv,2)=0)
    #declare P=0
   #else
    #declare P=2
   #end
   box
    {<varv*4.25+P,1,vurv*1.2>,<varv*4.25+P+4,-.1,vurv*1.2+1>
     //rotate<rand(R2)*0,rand(R2)*0.5,-rand(R1)*1>

     texture{
     pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
            }

     texture
      {pigment
       {dents
        turbulence 0.3
        color_map
         {[ 0.0 color Clear]
          [ 0.5 color Brown filter 0.5]
          [ 1.0 color Firebrick filter 0.6]
          [ 1.0 color Clear]
         }
        translate<50*rand(R1),100*rand(R1), 140*rand(R2)>
        scale 3
       }
      normal{granite scale 4}
      }

     finish{crand 0.15 ambient .29}//.35}
    }
   /*superellipsoid
    {<rand(R1)*.1,rand(R2)*.15>
     pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
     finish{crand.15}
     scale<2,1,.5>
     translate<varv*4.15+P,.9,vurv*1.05>
    }*/
   #declare varv=varv+1
  #end
  #if (vurv>=21)
   #declare varv=-12+vurv*1-21
  #else
   #declare varv=-12
  #end
  #declare vurv=vurv+1
 #end
 }
 union
{
 box
  {<9.2-.25,1.1,3.3+1.2*7>,<30.6,-4,27.6+1.2*9>
   pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
   finish{/*ambient 0.4*/ crand.15}
   //inverse
   translate -x*(21.4+8.25)
  }
 box
  {<9.2-.25,1.1,3.3+1.2*7>,<30.6,-4,27.6+1.2*9>
   pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
   finish{/*ambient 0.4*/ crand.15}   // !OBS! AMBIENT !SBO!
   //inverse
  }
 box
  {<9.2-.25,1.1,3.3+1.2*7>,<30.6,-4,27.6+1.2*9>
   pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
   finish{/*ambient 0.4*/ crand.15}
   //inverse
   translate x*(21.4+8.25)
  }
 box
  {<9.2-.25,1.1,3.3+1.2*7>,<30.6,-4,27.6+1.2*9>
   pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
   finish{/*ambient 0.4*/ crand.15}
   //inverse
   translate 2*x*(21.4+8.25)
  }
 inverse
 translate <-.75,0,0>
}
 #declare varv2=0
 #while (varv2<1000)
  /*box
   {<0,0,0>,<rand(R1)*rand(R2)*.5,rand(R1)*.2,rand(R2)*.2>
    rotate<rand(R2)*360,rand(R1)*360,rand(R2)*360>
    translate<rand(R1)*30,-0.19,rand(R2)*10>
    pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
    finish{crand.15}
   }*/
  /*#declare slump=rand(R1)*.12
  sphere
   {<0,0,0>,slump
    scale <1,.1/slump,rand(R2)*5.5>
    translate<rand(R1)*30,-0.1,rand(R2)*10>
    pigment{color rgb<rand(R1)*.1+.9,rand(R2)*.12+.4,/*rand(R2)*.2+*/0.3>}//Firebrick}
    finish{crand 0.15}
   }*/
  #declare varv2=varv2+1
 #end
   }

#include "snowball.pov"
object
 {SnowBall
  pigment{color White}
  finish{ambient 0.5 diffuse 0.5}
  rotate z*90
  rotate y*90
  scale <1.4,0.85,2>
  translate <5,0,4>
  normal{bumps scale 0.3}
 }

#declare Window=
union{
/*box                   //Fnsterglaset Check it out
 {//<9.1,1.1,3.4+1.2*7>,<30.7,1.3,27.7+1.2*9>
  <10.4,1.1,3.4+1.2*7>,<29,1.3,27.7+1.2*9>
  pigment{color rgbf<.96,.98,1,1>}
  finish{specular 0.3 roughness 0.005 reflection 0.1}
 }*/
union{
box                 //Fnsterblecket...
 {<0,-1,0>, <30.6-9.2, 1, .05>
  //<9.2,1,3.3+1.2*7>,<30.6,-.7,3.4+1.2*7>
  rotate x*20
  translate<9.2,0,3.3+1.2*7>
 }
box
 {<9.2,0,3.3+1.2*7>,<9.25,1,4.2+1.2*7>
  //pigment{color White}
 }
box
 {<30.5,0,3.3+1.2*7>,<30.6,1,4.2+1.2*7>
  //pigment{color White}
 }
box
 {<9.2, -1, 3.05+1.2*7>, <30.6, -.95, 2.7+1.2*7>
  //pigment{color White}
 }
 pigment{color White}
 finish{ambient 0.23}
 texture
   {pigment
    {marble
     turbulence 0.4
     color_map
      {[0.0 color White filter 0.7]
       //[0.2 color White filter 0.7]
       [0.2 color rgb<.6,.7,.6> filter 0.7]
       [1.0 color White filter 0.7]
      }
     rotate 90*z
     //scale <1,180/13,1>
     scale <.2,300000000,.4> //min
     translate 9*y
    }
    finish{ambient 0.23}
   }
  texture
   {pigment
     {//gradient z
      onion
      color_map
       {[0 color White filter 0]
        [0.4 color White filter 0]
        [0.6 color White filter 1]
        [1 color White filter 1]
       }
      scale 31
      //translate z*3.4
      scale <0.7,0.2,2.3>
      translate <20,-1,0>
     }
     finish{ambient 0.23}
    }//slut p texturen

   }

difference
 {box            //Fnsterkarmen...
   {<9.1,2,3.1+1.2*7>,<30.7,1.1,27.7+1.2*9>}
  box                                               // "grund"...
   {<10.2, -3, 4.1+1.2*7>,<29.7,4,26.7+1.2*9>}
  pigment{color White}
  finish{ambient 0.23}
 }
difference
 {box
   {<9.8, 0.9, 4.1+1.2*7>,<30, 2.2, 27.6+1.2*9-.3>} //3.1+28.5>} //27.2+1.2*9>}
  box                                               //"ram" under...
   {<10.9, -3, 5.0+1.2*7>,<29, 4, 3.1+27.6+1.3>} //26.3+1.2*9>}
  box                                               //"ram" VER...
   {<10.9, -3, 4.1+28.5>,<29, 4, 26.3+1.2*9>}
  /*box
   {<9.1,-3,3.1+1.2*23.5>,<30.7,1.1,3.1+1.2*23.7>}*/
  pigment{color White}
  finish{ambient 0.23}
  texture
   {pigment
    {marble
     turbulence 0.4
     color_map
      {[0.0 color White filter 0.4]   //.7
       //[0.2 color White filter 0.4]
       [0.2 color rgb<.6,.7,.6> filter 0.4]
       [1.0 color White filter 0.4]
      }
     rotate 90*z
     //scale <1,180/13,1>
     scale <.2,300000000,300> //min
     translate 9*y
    }
    finish{ambient 0.23}
   }//slut p texturen
  texture
   {pigment
     {//gradient z
      onion
      color_map
       {[0 color White filter 0]
        [0.4 color White filter 0]
        [0.75 color White filter 1]
        [1 color White filter 1]
       }
      scale 31
      //translate z*3.4
      scale <0.7,0,2.3>
      translate <20,0,0>
     }
     finish{ambient 0.23}
    }//slut p texturen
 }

intersection                            //Sjlva fnstret
 {box
   {<11, 0.75, 5.1+1.2*7>,<28.9, 2.2, 4.3+27.6>}
  box
   {<11.9,-1, 6+1.2*7>,<28, 3, 3.4+27.6> inverse}
  cylinder
   {<11,.75,4.3+27.6>,<12,.75,3.3+27.6>,.06 inverse texture{Rusty_Iron1}}
  cylinder
   {<11,.75,5.1+1.2*7>,<12,.75,6.1+1.2*7>,.06 inverse texture{Rusty_Iron1}}
  cylinder
   {<28.9,.75,5.1+1.2*7>,<27.9,.75,6.1+1.2*7>,.06 inverse texture{Rusty_Iron1}}
  cylinder
   {<28.9,.75,4.3+27.6>,<27.9,.75,3.3+27.6>,.06 inverse texture{Rusty_Iron1}}
  box
   {<11.6,1.2,5.7+1.2*7>,<28.3,1.28,3.7+27.6> inverse}
  pigment{color White}
  finish{ambient .23}
 }
} //Slut p "Window"

object
 {Window
  translate <-.75,0,0>}

#include "gardin.pov"
#declare GardiN=
object
 {Gardinen
  scale <1.5,0.65,0.8>
  rotate x*90
  rotate y*90
  translate<30,6,24>
  pigment{color NewTan}
  finish{ ambient .5 diffuse .2 phong 0 specular 0 }//diffuse 0.5}
 }
light_source
 {<0,3,34> color Gray40}// looks_like{sphere{<0,3,34>,40 pigment{color Red}}}} //REMEMBER!!!!!
/*light_source
 {<50,25,40> color White }//looks_like{sphere{<60,30,45>,4 pigment{color Red}}}}
*/

object
 {Window translate <-(21.4+8.25)-.75,0,0>}
object
 {Window translate <(21.4+8.25)-.75,0,0>}
object
 {Window translate <2*(21.4+8.25)-.75,0,0>}

object
 {GardiN}
object
 {GardiN
  translate<-30,-6,-24>
  scale <1.5,1,1>
  translate  <-(21.4+8.25)+30,6,12>}
object
 {GardiN translate  <(21.4+8.25)-6,0,0>}
object
 {GardiN translate  <2*(21.4+8.25)-8,0,0>
  finish{ ambient .1 diffuse .5 phong 0 specular 0 }}//diffuse 0.5}



union
{
difference                //TRAPPAN
 {superellipsoid
   {<.3,.05>
    scale<9,14,1.25>
    translate<-5.5,0,-5>
   }
  plane
   {x,-12}
  //pigment{color Green}
 }
superellipsoid
 {<.05,.05>
  scale<8,14,1.25>
  translate<-20.1,0,-5>
  //pigment{color Red}
 }
intersection
 {superellipsoid
   {<.3,.05>
    scale<9,14,1.25>
    translate<-34,0,-5>
   }
  plane
   {x,-28.1}
  //pigment{color Blue}
 }

difference
{
superellipsoid //Trappan ver
 {<.3,.05>
  scale<14,11,1.25>
  translate<-12,0,-2.5>
 }
plane
 {x,-18.95}
//pigment{color Yellow}
}
intersection
{
superellipsoid //Trappan ver, vnster
 {<.3,.05>
  scale<14,11,1.25>
  translate<-27.2,0,-2.5>
 }
plane
 {x,-19.05}
//pigment{color Salmon}
}

union{
difference                //Trappan underst
 {superellipsoid
   {<.3,.05>
    scale<9,14,1.25>
    translate<-5.5,0,-5>
   }
  plane
   {x,-12}
  //pigment{color Green}
 }
superellipsoid
 {<.05,.05>
  scale<8,14,1.25>
  translate<-20.1,0,-5>
  //pigment{color Red}
 }
intersection
 {superellipsoid
   {<.3,.05>
    scale<9,14,1.25>
    translate<-34,0,-5>
   }
  plane
   {x,-28.1}
  //pigment{color Blue}
 }
scale y*1.25
translate z*-2.45
}

//texture{T_Stone28}
//texture{T_Stone32}
//texture{T_Stone34}
//texture{T_Stone20}
//texture{T_Stone23}
//texture{T_Stone3}
//texture{T_Stone7}
//texture{T_Stone9}
texture{T_Stone14} //bst i test
finish{phong 0 phong_size 0}
normal{granite 3 turbulence 0.6}
scale<1.2,1.5,1.2>
translate<-59,0,0.4>//1.4>
}                 //SLUT p da' big big union








// ********  REFERENCED OBJECTS  *******

#declare EkerTurn1 = intersection {
  torus { // EkerT1
    1.5, 0.35  rotate -x*90
    scale <0.132588, 0.143414, 0.120698>
    rotate <-131.676285, -8.497362, -79.411232>
    translate  <-1.23072, -0.890218, 0.560719>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale 0.317683
    rotate <0.0, 41.323494, 0.0>
    translate  <-1.317002, -1.191502, 0.306726>
  }
}
#declare Ekern1 = union {
  cylinder { // Eker1
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.04, 0.04, 13.0>
    rotate <173.507462, 40.0, -3.674118>
    translate  <7.161296, -0.149333, 10.464114>
  }
  object { EkerTurn1 }
  cone { // EkerSlut1
    <0,0,0>, 0.8, <0,0,1>, 1.0
    texture {
      EkerTex
    }
    scale <0.11278, 0.08836, 0.842267>
    rotate <2.638989, -40.386093, -175.911911>
    translate  <6.772349, -0.209128, 9.990509>
  }
  texture {
    EkerTex
  }
  rotate <0.0, 12.0, 0.904241>
  translate  <0.861736, -0.005223, -0.040428>
}
#declare EkerTurn2 = intersection {
  torus { // EkerT2
    1.5, 0.35  rotate -x*90
    scale <0.132588, 0.143414, 0.120698>
    rotate <-131.676285, -8.497362, -79.411232>
    translate  <-1.201364, -0.881613, 0.546335>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.317683
    rotate <0.0, 41.323494, 0.0>
    translate  <-1.317002, -1.191502, 0.306726>
  }
}
#declare EkernMots1 = union {
  cylinder { // Eker2
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.04, 0.04, 13.0>
    rotate <173.507462, 40.0, -3.674118>
    translate  <7.176597, -0.140565, 10.418162>
  }
  object { EkerTurn2 }
  cone { // EkerSlut2
    <0,0,0>, 0.8, <0,0,1>, 1.0
    texture {
      EkerTex
    }
    scale <0.129625, 0.110592, 0.847952>
    rotate <-2.879493, -40.640392, -168.520279>
    translate  <6.644825, -0.215049, 9.772206>
  }
  texture {
    EkerTex
  }
  rotate <-6.582714, 12.0, 164.330536>
  translate  <-1.438143, -1.570037, -0.044888>
}
#declare EkerTurn3 = intersection {
  torus { // EkerT3
    1.5, 0.35  rotate -x*90
    scale <0.132588, 0.143414, 0.120698>
    rotate <-131.676285, -8.497362, -79.411232>
    translate  <-1.23569, -0.891036, 0.565016>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.317683
    rotate <0.0, 41.323494, 0.0>
    translate  <-1.317002, -1.191502, 0.306726>
  }
}
#declare EkernHogerMots1 = union {
  cylinder { // Eker3
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.04, 0.04, 13.0>
    rotate <173.507462, 40.0, -3.674118>
    translate  <7.161296, -0.149333, 10.464114>
  }
  object { EkerTurn3 }
  cone { // EkerSlut3
    <0,0,0>, 0.8, <0,0,1>, 1.0
    texture {
      EkerTex
    }
    scale <0.118933, 0.08142, 0.829673>
    rotate <3.290616, 39.801334, 10.947863>
    translate  <6.946596, -0.142385, 10.222539>
  }
  texture {
    EkerTex
  }
  rotate <-1.496688, 12.0, -10.712959>
  translate  <0.88879, 1.649012, -0.119856>
}
#declare EkerTurn4 = intersection {
  torus { // EkerT4
    1.5, 0.35  rotate -x*90
    scale <0.132588, 0.143414, 0.120698>
    rotate <-131.676285, -8.497362, -79.411232>
    translate  <-1.209083, -0.887762, 0.554979>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale 0.317683
    rotate <0.0, 41.323494, 0.0>
    translate  <-1.317002, -1.191502, 0.306726>
  }
}
#declare EkernHoger1 = union {
  cylinder { // Eker4
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.04, 0.04, 13.0>
    rotate <173.507462, 40.0, -3.674118>
    translate  <7.176597, -0.140565, 10.418162>
  }
  object { EkerTurn4 }
  cone { // EkerSlut4
    <0,0,0>, 0.8, <0,0,1>, 1.0
    texture {
      EkerTex
    }
    scale <0.129625, 0.110592, 0.847952>
    rotate <5.188569, -40.428143, 178.403976>
    translate  <6.637771, -0.194666, 9.776541>
  }
  texture {
    EkerTex
  }
  rotate <-7.659696, 23.0, 174.398529>
  translate  <-1.254541, 0.216144, -0.301432>
}
#declare MkubM0 = object {
  box { // MkubM0
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TireTex
    }
    scale <0.317391, 0.117142, 0.167069>
    translate  <0.008383, -0.009697, 15.905407>
  }
}
#declare MkubV0 = object {
  box { // MkubV0
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TireTex
    }
    scale <0.198245, 0.113125, 0.169621>
    rotate 16.873398*x
    translate  <-0.004802, -0.296672, 15.876575>
  }
}
#declare MkubVV0 = object {
  box { // MkubVV0
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TireTex
    }
    scale <0.189456, 0.130987, 0.163667>
    rotate 37.860645*x
    translate  <0.008383, -0.560686, 15.752155>
  }
}
#declare MkubH0 = object {
  box { // MkubH0
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TireTex
    }
    scale <0.198531, 0.103724, 0.098208>
    rotate -16.870001*x
    translate  <0.0, 0.294472, 15.926718>
  }
}
#declare MkubHH0 = object {
  box { // MkubHH0
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TireTex
    }
    scale <0.220947, 0.117508, 0.166147>
    rotate -25.706421*x
    translate  <0.0, 0.516696, 15.754844>
  }
}
#declare HTcutTvars1 = object {
  torus { // HTcutTvars1
    1.5, 0.05  rotate -x*90
    scale <4.219863, 0.545522, 1.0>
    translate  <-43.022706, 0.002758, -0.001052>
  }
}
#declare SnoffsCut1 = object {
  torus { // SnoffsCut1
    1.5, 0.2  rotate -x*90
    scale <0.835527, 0.632396, 1.0>
    rotate -90.0*x
    translate  <0.123488, -0.017426, 0.019599>
  }
}


#declare CSb1 = intersection {
  box { // CSb1Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <12.410411, -3.266372, -8.363884>
  }
  torus { // CSt1
    1.5, 0.32  rotate -x*90
    rotate -90.0*x
    translate  <11.409643, -4.509227, -9.360726>
  }
}
#declare CSb2 = intersection {
  box { // CSb2Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 1.0>
    translate  <-13.737099, -3.175355, 7.992035>
  }
  torus { // CSt2
    1.5, 0.24  rotate -x*90
    scale <1.31828, 0.905273, 1.312332>
    rotate -90.0*x
    translate  <-15.236365, -4.505017, 6.998485>
  }
}
#declare CSb3 = intersection {
  torus { // CSt3
    1.5, 0.38  rotate -x*90
    scale <0.971027, 0.833696, 0.575821>
    translate  <-15.236061, -3.255926, 8.355041>
  }
  box { // CSt3Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <-16.235822, -3.073343, 8.479939>
  }
}
#declare CSb4 = intersection {
  torus { // CSt5
    1.5, 0.32  rotate -x*90
    rotate -90.0*x
    translate  <11.406404, -2.004173, -9.360726>
  }
  box { // CSb3Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <12.410411, -1.72317, -8.363884>
  }
  translate  0.00115*y
}
#declare CSb5 = intersection {
  torus { // CSt4
    1.5, 0.24  rotate -x*90
    scale <1.31828, 0.905273, 1.312332>
    rotate -90.0*x
    translate  <-15.236365, 1.24325, 6.99781>
  }
  box { // CSb4Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 1.0>
    translate  <-13.737099, 0.429217, 7.992035>
  }
  translate  -3.253771*y
}
#declare Cube004 = object {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.105342, 2.021914, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <-13.651227, -2.878349, -15.345369>
  }
}
#declare Cube005 = object {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.613656, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <13.350592, -3.078186, -15.341868>
  }
}
#declare CS1 = union {
  cylinder { // CSc1
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 6.816213>
    translate  <12.913469, -4.516534, -16.173784>
  }
  cylinder { // CSc2
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 24.700001>
    rotate <0.0, -90.0, 0.0>
    translate  <11.414492, -4.509765, -7.857787>
  }
  cylinder { // CSc3
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 23.0>
    translate  <-13.260312, -4.507048, -16.00361>
  }
  cylinder { // CSc4
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 23.0>
    translate  <-13.263095, -2.003525, -16.00361>
  }
  cylinder { // CSc5
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 24.700001>
    rotate <0.0, -90.0, 0.0>
    translate  <11.409796, -2.002701, -7.857787>
  }
  cylinder { // CSc6
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 6.816213>
    translate  <12.913469, -2.003517, -16.178883>
  }
  object { CSb1 }
  object { CSb2 }
  object { CSb3 }
  object { CSb4 }
  object { CSb5 }
  cylinder { // CSc7
    <0,0,1>, <0,0,0>, 1
    scale <0.337095, 0.32, 2.506283>
    rotate <-90.0, 0.0, 0.0>
    translate  <12.920807, -4.500811, -10.45678>
  }
  cylinder { // CSc8
    <0,0,1>, <0,0,0>, 1
    scale <0.337095, 0.32, 2.506283>
    rotate <-90.0, 0.0, 0.0>
    translate  <-13.25261, -4.500811, -6.982799>
  }
  object { Cube004 }
  object { Cube005 }
  scale <0.949288, 1.0, 1.0>
  translate  <-1.320635, 3.253771, -1.529807>
}


union{
union{//hr brjar cykeln


// ********  OBJECTS  *******

blob {   // Blob002
  threshold 0.6
  component 1.0, 0.556435, <-0.025316, -0.008439, 0.0>

  component 1.0, 0.35012, <0.177215, -0.075949, 0.0>

  component 1.0, 0.258803, <-0.447257, -0.126582, 0.0>

  component 1.0, 0.301646, <-0.295359, -0.075949, 0.0>

  component 1.0, 0.303734, <0.447257, -0.109705, 0.0>

  component 1.0, 0.377895, <-0.194093, 0.0, 0.261603>

  component 1.0, 0.377895, <-0.025316, 0.0, 0.261603>

  component 1.0, 0.429544, <-0.160338, 0.0, -0.14346>

  component 1.0, 0.238472, <-0.092827, 0.0, -0.43038>

  component 1.0, 0.35192, <0.059072, 0.0, -0.43038>

  component 1.0, 0.238472, <0.565401, 0.0, -0.177215>

  component 1.0, 0.227627, <0.632911, 0.0, -0.312236>

  /*texture {
    CykelTex
  }*/
  pigment{color White}
  finish{ambient .5 diffuse .35}
  normal {bumps .8 scale 0.3}
  scale <8.131606, 6.753699, 5.0>
  rotate 90.0*x
  translate  <-9.019026, 0.0, -16.534881>
}



difference { // CSG003
  box { // GaffelToppHattM
    <-1, -1, -1>, <1, 1, 1>
    scale <0.932011, 2.262116, 1.596624>
    rotate <6.61768, 1.988145, 19.337875>
    translate  <35.065349, -1.719999, 14.720465>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale 16.5
    rotate <-83.460739, 0.0, 19.01037>
    translate  <32.00209, -9.632456, -1.565457>
  }
  texture {
    EkerTex
  }
  scale <1.0, 0.902167, 1.0>
  translate  <0.122291, -0.097833, 0.02112>
}


#declare VridTorusNeder = difference {
  torus { // vridtorusneder
    1.5, 0.5  rotate -x*90
    scale <0.535862, 0.560161, 0.58942>
    rotate 4.808383*y
    translate  <6.477728, 0.0, 16.882198>
  }
  plane { // vridtncut
    z,0
    rotate 4.681248*y
    translate  <6.516764, 0.0, 16.767536>
  }
  texture {
    EkerTex
  }
  translate  <-0.064278, 0.0, 0.559602>
}
#declare VridTorusUppe = difference {
  torus { // vridtorusnede1
    1.5, 0.5  rotate -x*90
    scale <0.535862, 0.560161, 0.58942>
    rotate 4.808383*y
    translate  <6.477728, 0.0, 16.882198>
  }
  plane { // vridtncut1
    z,0
    rotate 4.681248*y
    translate  <6.516764, 0.0, 16.767536>
  }
  texture {
    EkerTex
  }
  translate  <0.601826, 0.0, 7.365872>
}
#declare VridMuttern = intersection {
  box { // NavMutterBas1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale <2.0, 1.0, 2.0>
  rotate <-90.0, 5.688545, 0.0>
  translate  <6.989196, 0.015304, 22.800918>
}
#declare CykelFast = union {
  cylinder { // Stang
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.79204, 0.893776, 6.5>
    rotate 4.840664*y
    translate  <6.482515, 0.0, 17.624844>
  }
  cylinder { // RamTop
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.7, 0.7, 31.75271>
    rotate <0.0, -90.0, 0.0>
    translate  <38.737927, 0.0, 22.791467>
  }
  cylinder { // RamUnder
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.75, 0.75, 33.782791>
    rotate <-180.0, 48.370117, -180.0>
    translate  <6.681444, 0.0, 19.926532>
  }
  object { VridTorusNeder }
  cylinder { // Extra
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.683064, 0.660677, 1.047748>
    rotate 6.14719*y
    translate  <6.425893, 0.0, 17.042061>
  }
  object { VridTorusUppe }
  object { VridMuttern }
  torus { // SladdKlammaT
    1.5, 0.5  rotate -x*90
    texture {
      Svart
    }
    scale 0.5
    rotate -45.282478*y
    translate  <11.158479, 0.007387, 15.962231>
  }
/*  rotate <-1.757388, -0.127295, -13.975985>
  translate  <0.0, 0.986065, 0.091647>*/                //AHHHAA!
}
#declare Hjul1 = intersection {
  torus { // HjulTorus1
    1.5, 0.08  rotate -x*90
    scale 9.5
    rotate -90.0*x
  }
  cylinder { // HjulCut1
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 1.2>
    rotate -90.0*x
    translate  -0.6*y
  }
  texture {
    EkerTex
  }
}
//
// Include file contains 'Nav1'
//
#include "school2.in1"
#declare Nav1 = object {
  Nav1_Raw
  texture {
    EkerTex
  }
  rotate -90.0*x
  translate  0.027508*z
}
// Include contains 'GeneratorSkruv'
#include "school2.in2"

#declare GeneratorSkruv = object {
  GeneratorSkruv_Raw
  texture {
    EkerTex
  }
  scale <0.44659, 0.482414, 0.394344>
  rotate <4.137633, -15.384845, 164.774475>
  translate  <6.255559, -1.459577, 12.805621>
}
#declare GeneratorCuttt = difference {
  cylinder { // GeneratorCut
    <0,0,1>, <0,0,0>, 1
    scale <0.85, 0.85, 1.0>
    rotate 15.017045*y
    translate  <5.959663, -1.436908, 11.623133>
  }
  torus { // GeneratorMitt
    1.1, 0.7  rotate -x*90
    scale <0.768885, 0.768885, 0.65>
    rotate 14.84789*y
    translate  <6.226827, -1.443547, 12.588612>
  }
  texture {
    EkerTex
  }
  translate  <-0.149864, 0.0, -0.565699>
}
#declare Generator = union {
  object { GeneratorSkruv }
  cylinder { // GenratorUppe
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.309034, 0.38, 3.482483>
    rotate 15.072155*y
    translate  <5.518032, -1.445402, 10.012745>
  }
  cylinder { // GeneratorUnder
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.852132, 0.85, 1.386836>
    rotate 14.867228*y
    translate  <5.582558, -1.436152, 10.223016>
  }
  torus { // GeneratorBotten
    1.5, 0.5  rotate -x*90
    texture {
      EkerTex
    }
    scale <0.42, 0.42, 0.454348>
    rotate 14.964967*y
    translate  <5.57873, -1.436923, 10.228649>
  }
  object { GeneratorCuttt }
  cylinder { // SladdFaste1
    <0,0,1>, <0,0,0>, 1
    texture {
      Vit
    }
    scale <0.1, 0.1, 0.5>
    rotate <0.0, 13.360041, 0.0>
    translate  <5.321874, -1.614266, 9.815136>
  }
  cylinder { // SladdFaste2
    <0,0,1>, <0,0,0>, 1
    texture {
      Vit
    }
    scale <0.1, 0.1, 0.5>
    rotate <0.0, 13.360041, 0.0>
    translate  <5.797777, -1.420674, 9.680574>
  }
  rotate -8.319364*y
  translate  <-3.018186, 3.347652, 0.545918>
}
#declare GaffelV = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.314068, 0.000000, 0.327947>, <-4.314068, -0.193745, 0.327947>, <-4.308129, -0.193745, 0.023734>, <-4.308129, 0.000000, 0.023734>,
      <-0.840761, -0.112876, 2.382203>, <-0.840761, -0.509033, 2.382203>, <0.076355, -0.509033, 2.382203>, <0.076355, -0.112876, 2.382203>,
      <-0.892673, -0.395066, 4.438641>, <-0.892673, -0.835199, 4.438641>, <0.128268, -0.835199, 4.438641>, <0.128268, -0.395066, 4.438641>,
      <-0.713888, -0.395066, 6.194682>, <-0.713888, -0.916875, 6.194682>, <0.331686, -0.916875, 6.194682>, <0.331686, -0.395066, 6.194682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.308129, 0.000000, 0.023734>, <-4.308129, 0.193745, 0.023734>, <-4.314068, 0.193745, 0.327947>, <-4.314068, 0.000000, 0.327947>,
      <0.076355, -0.112876, 2.382203>, <0.076355, 0.283281, 2.382203>, <-0.840761, 0.283281, 2.382203>, <-0.840761, -0.112876, 2.382203>,
      <0.128268, -0.395066, 4.438641>, <0.128268, 0.045067, 4.438641>, <-0.892673, 0.045067, 4.438641>, <-0.892673, -0.395066, 4.438641>,
      <0.331686, -0.395066, 6.194682>, <0.331686, 0.070304, 6.194682>, <-0.713888, 0.070304, 6.194682>, <-0.713888, -0.395066, 6.194682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.713888, -0.395066, 6.194682>, <-0.713888, -0.916875, 6.194682>, <0.331686, -0.916875, 6.194682>, <0.331686, -0.395066, 6.194682>,
      <-0.535104, -0.451504, 7.950723>, <-0.535104, -0.998550, 7.950723>, <0.535104, -0.998550, 7.950723>, <0.535104, -0.451504, 7.950723>,
      <-0.589521, -0.564380, 10.107718>, <-0.589521, -1.140409, 10.107718>, <0.589521, -1.140409, 10.107718>, <0.589521, -0.564380, 10.107718>,
      <-0.561288, -0.560053, 10.854235>, <-0.561288, -1.136081, 10.854235>, <0.617755, -1.136081, 10.854235>, <0.617755, -0.560053, 10.854235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.331686, -0.395066, 6.194682>, <0.331686, 0.070304, 6.194682>, <-0.713888, 0.070304, 6.194682>, <-0.713888, -0.395066, 6.194682>,
      <0.535104, -0.451504, 7.950723>, <0.535104, 0.095542, 7.950723>, <-0.535104, 0.095542, 7.950723>, <-0.535104, -0.451504, 7.950723>,
      <0.589521, -0.564380, 10.107718>, <0.589521, 0.011648, 10.107718>, <-0.589521, 0.011648, 10.107718>, <-0.589521, -0.564380, 10.107718>,
      <0.617755, -0.560053, 10.854235>, <0.617755, 0.015976, 10.854235>, <-0.561288, 0.015976, 10.854235>, <-0.561288, -0.560053, 10.854235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.561288, -0.560053, 10.854235>, <-0.561288, -1.136081, 10.854235>, <0.617755, -1.136081, 10.854235>, <0.617755, -0.560053, 10.854235>,
      <-0.533055, -0.555725, 11.600752>, <-0.533055, -1.131754, 11.600752>, <0.645988, -1.131754, 11.600752>, <0.645988, -0.555725, 11.600752>,
      <-0.577220, -0.542067, 15.577114>, <-0.577220, -1.155090, 15.580044>, <0.699511, -1.155090, 15.580044>, <0.699511, -0.542067, 15.577114>,
      <-0.577220, -0.552462, 17.191303>, <-0.577220, -1.164099, 17.194298>, <0.699511, -1.164099, 17.194298>, <0.699511, -0.552462, 17.191303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.617755, -0.560053, 10.854235>, <0.617755, 0.015976, 10.854235>, <-0.561288, 0.015976, 10.854235>, <-0.561288, -0.560053, 10.854235>,
      <0.645988, -0.555725, 11.600752>, <0.645988, 0.020304, 11.600752>, <-0.533055, 0.020304, 11.600752>, <-0.533055, -0.555725, 11.600752>,
      <0.699511, -0.542067, 15.577114>, <0.699511, 0.070955, 15.574183>, <-0.577220, 0.070955, 15.574183>, <-0.577220, -0.542067, 15.577114>,
      <0.699511, -0.552462, 17.191303>, <0.699511, 0.059175, 17.188307>, <-0.577220, 0.059175, 17.188307>, <-0.577220, -0.552462, 17.191303>
    }
  }
  texture {
    CykelTex
  }
  rotate <-0.153998, 12.761926, 0.752808>
  translate  <4.86502, -1.696549, -1.06179>
}
#declare CSG001 = difference {
  cylinder { // GaffelCyl1
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.696422, 0.6, 0.15>
    rotate <90.0, -18.466198, 0.0>
    translate  <0.009943, -1.53773, -0.057975>
  }
  box { // Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.066163, 0.249333, 0.136162>
    rotate <0.0, -24.55344, 0.0>
    translate  <-0.951389, -1.603344, -0.469018>
  }
  texture {
    CykelTex
  }
  rotate 8.137008*y
  translate  <-0.014257, -0.172822, 0.002038>
}
#declare GaffelnV = union {
  object { GaffelV }
  sphere { // GaffelSlut1
    <0,0,0>,1
    texture {
      CykelTex
    }
    scale <0.312602, 0.149756, 0.139299>
    rotate <-0.087452, -16.316586, 0.136579>
    translate  <0.697414, -1.772089, 0.057242>
  }
  cylinder { // GaffelCyl2
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.622632, 0.426045, 0.15>
    rotate <-90.0, 38.879524, 0.0>
    translate  <0.542435, -1.86043, -0.364458>
  }
  object { CSG001 }
  rotate -8.137008*y
  translate  <0.014402, 0.172822, 0.0>
}
#declare EkrarnaTillVstr = union {
  object { Ekern1 }
  object { // Ekern2->Ekern1
    Ekern1
    rotate <0.0, -40.0, 0.0>
    translate  0.0*x
  }
  object { // Ekern3->Ekern1
    Ekern1
    rotate <0.0, -80.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Ekern4->Ekern1
    Ekern1
    rotate <-180.0, -60.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Ekern5->Ekern1
    Ekern1
    rotate <-180.0, -20.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Ekern6->Ekern1
    Ekern1
    rotate <-180.0, 20.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Ekern7->Ekern1
    Ekern1
    rotate <-180.0, 60.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Ekern8->Ekern1
    Ekern1
    rotate <0.0, 80.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Ekern9->Ekern1
    Ekern1
    rotate <0.0, 40.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { EkernMots1 }
  object { // EkernMots2->EkernMots1
    EkernMots1
    rotate <0.0, 40.0, 0.0>
  }
  object { // EkernMots3->EkernMots1
    EkernMots1
    rotate <0.0, 80.0, 0.0>
  }
  object { // EkernMots4->EkernMots1
    EkernMots1
    rotate <-180.0, 60.0, -180.0>
  }
  object { // EkernMots5->EkernMots1
    EkernMots1
    rotate <-180.0, 20.0, -180.0>
  }
  object { // EkernMots6->EkernMots1
    EkernMots1
    rotate <-180.0, -20.0, 180.0>
  }
  object { // EkernMots7->EkernMots1
    EkernMots1
    rotate <-180.0, -60.0, -180.0>
  }
  object { // EkernMots8->EkernMots1
    EkernMots1
    rotate <0.0, -80.0, 0.0>
  }
  object { // EkernMots9->EkernMots1
    EkernMots1
    rotate <0.0, -40.0, 0.0>
  }
}
// Include contains 'VentilSkruvddd'
#include "school2.in3"

#declare VentilSkruvddd = object {
  VentilSkruvddd_Raw
  texture {
    EkerTex
  }
  scale <0.38431, 0.384, 0.327902>
  rotate <43.858906, -69.297264, 134.229218>
  translate  <-12.292203, 0.005357, -3.491917>
}
#declare VentilHatten = intersection {
  sphere { // VentilHatt
    <0,0,0>,1
    texture {
      Svart
    }
    scale <0.33083, 0.33, 0.735877>
    rotate 73.342148*y
    translate  <-11.959205, -0.002012, -3.386322>
  }
  box { // VentilHattCut
    <-1, -1, -1>, <1, 1, 1>
    scale 0.646535
    rotate 74.521172*y
    translate  <-11.339516, -0.074054, -3.265693>
  }
  texture {
    Svart
  }
}
#declare Ventilen = union {
  cylinder { // VentilBas
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.26, 0.26, 1.107476>
    rotate 73.693214*y
    translate  <-13.165147, 0.0, -3.751834>
  }
  object { VentilSkruvddd }
  object { VentilHatten }
  cylinder { // VentilHattCyl
    <0,0,1>, <0,0,0>, 1
    texture {
      Svart
    }
    scale <0.36, 0.36, 0.177025>
    rotate 74.347107*y
    translate  <-11.98972, -0.001011, -3.38914>
  }
  scale <0.501883, 0.499805, 0.55864>
  rotate -11.096824*y
  translate  <-6.206515, 0.0, -2.488979>
}
#declare NavMuttern = intersection {
  box { // NavMutterBas
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale <0.7, 1.0, 0.7>
  translate  0.030825*x
}
#declare EkrarnaMotsHoge = union {
  object { EkernHogerMots1 }
  object { // EkernHogerMot2->EkernHogerMots1
    EkernHogerMots1
    rotate <0.0, -40.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot3->EkernHogerMots1
    EkernHogerMots1
    rotate <0.0, -80.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot4->EkernHogerMots1
    EkernHogerMots1
    rotate <180.0, -60.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot5->EkernHogerMots1
    EkernHogerMots1
    rotate <180.0, -20.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot6->EkernHogerMots1
    EkernHogerMots1
    rotate <180.0, 20.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot7->EkernHogerMots1
    EkernHogerMots1
    rotate <0.0, -240.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot8->EkernHogerMots1
    EkernHogerMots1
    rotate <0.0, -280.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHogerMot9->EkernHogerMots1
    EkernHogerMots1
    rotate <0.0, -320.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  rotate -10.0*y
}
#declare EkrarnaTillHgr = union {
  object { EkrarnaMotsHoge }
  object { EkernHoger1 }
  object { // EkernHoger2->EkernHoger1
    EkernHoger1
    rotate <0.0, -40.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger3->EkernHoger1
    EkernHoger1
    rotate <0.0, -80.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger4->EkernHoger1
    EkernHoger1
    rotate <180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger5->EkernHoger1
    EkernHoger1
    rotate <180.0, -20.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger6->EkernHoger1
    EkernHoger1
    rotate <180.0, 20.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger7->EkernHoger1
    EkernHoger1
    rotate <180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger8->EkernHoger1
    EkernHoger1
    rotate <0.0, 80.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // EkernHoger9->EkernHoger1
    EkernHoger1
    rotate <0.0, 40.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
}
#declare StangSkruvB = difference {
  cylinder { // StangSkruvCyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.749816, -0.392919>
  }
  box { // StangSkruvCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.907007, -0.404223>
  }
  texture {
    EkerTex
  }
  rotate <6.935403, 0.0, 90.0>
  translate  <15.195907, -0.724794, -1.224817>
}
#declare GaffelH = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.314068, 0.000000, 0.327947>, <-4.314068, 0.193745, 0.327947>, <-4.308129, 0.193745, 0.023734>, <-4.308129, 0.000000, 0.023734>,
      <-0.840761, 0.112876, 2.382203>, <-0.840761, 0.509033, 2.382203>, <0.076355, 0.509033, 2.382203>, <0.076355, 0.112876, 2.382203>,
      <-0.892673, 0.395066, 4.438641>, <-0.892673, 0.835199, 4.438641>, <0.128268, 0.835199, 4.438641>, <0.128268, 0.395066, 4.438641>,
      <-0.713888, 0.423285, 6.194682>, <-0.713888, 0.916875, 6.194682>, <0.331686, 0.916875, 6.194682>, <0.331686, 0.423285, 6.194682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.308129, 0.000000, 0.023734>, <-4.308129, -0.193745, 0.023734>, <-4.314068, -0.193745, 0.327947>, <-4.314068, 0.000000, 0.327947>,
      <0.076355, 0.112876, 2.382203>, <0.076355, -0.283281, 2.382203>, <-0.840761, -0.283281, 2.382203>, <-0.840761, 0.112876, 2.382203>,
      <0.128268, 0.395066, 4.438641>, <0.128268, -0.045067, 4.438641>, <-0.892673, -0.045067, 4.438641>, <-0.892673, 0.395066, 4.438641>,
      <0.331686, 0.423285, 6.194682>, <0.331686, -0.070304, 6.194682>, <-0.713888, -0.070304, 6.194682>, <-0.713888, 0.423285, 6.194682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.713888, 0.423285, 6.194682>, <-0.713888, 0.916875, 6.194682>, <0.331686, 0.916875, 6.194682>, <0.331686, 0.423285, 6.194682>,
      <-0.535104, 0.451504, 7.950723>, <-0.535104, 0.998550, 7.950723>, <0.535104, 0.998550, 7.950723>, <0.535104, 0.451504, 7.950723>,
      <-0.589521, 0.564380, 10.107718>, <-0.589521, 1.140409, 10.107718>, <0.589521, 1.140409, 10.107718>, <0.589521, 0.564380, 10.107718>,
      <-0.561288, 0.560053, 10.854235>, <-0.561288, 1.136081, 10.854235>, <0.617755, 1.136081, 10.854235>, <0.617755, 0.560053, 10.854235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.331686, 0.423285, 6.194682>, <0.331686, -0.070304, 6.194682>, <-0.713888, -0.070304, 6.194682>, <-0.713888, 0.423285, 6.194682>,
      <0.535104, 0.451504, 7.950723>, <0.535104, -0.095542, 7.950723>, <-0.535104, -0.095542, 7.950723>, <-0.535104, 0.451504, 7.950723>,
      <0.589521, 0.564380, 10.107718>, <0.589521, -0.011648, 10.107718>, <-0.589521, -0.011648, 10.107718>, <-0.589521, 0.564380, 10.107718>,
      <0.617755, 0.560053, 10.854235>, <0.617755, -0.015976, 10.854235>, <-0.561288, -0.015976, 10.854235>, <-0.561288, 0.560053, 10.854235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.561288, 0.560053, 10.854235>, <-0.561288, 1.136081, 10.854235>, <0.617755, 1.136081, 10.854235>, <0.617755, 0.560053, 10.854235>,
      <-0.533055, 0.555725, 11.600752>, <-0.533055, 1.131754, 11.600752>, <0.645988, 1.131754, 11.600752>, <0.645988, 0.555725, 11.600752>,
      <-0.577220, 0.542067, 15.577114>, <-0.577220, 1.155090, 15.580044>, <0.699511, 1.155090, 15.580044>, <0.699511, 0.542067, 15.577114>,
      <-0.577220, 0.552462, 17.191303>, <-0.577220, 1.164099, 17.194298>, <0.699511, 1.164099, 17.194298>, <0.699511, 0.552462, 17.191303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.617755, 0.560053, 10.854235>, <0.617755, -0.015976, 10.854235>, <-0.561288, -0.015976, 10.854235>, <-0.561288, 0.560053, 10.854235>,
      <0.645988, 0.555725, 11.600752>, <0.645988, -0.020304, 11.600752>, <-0.533055, -0.020304, 11.600752>, <-0.533055, 0.555725, 11.600752>,
      <0.699511, 0.542067, 15.577114>, <0.699511, -0.070955, 15.574183>, <-0.577220, -0.070955, 15.574183>, <-0.577220, 0.542067, 15.577114>,
      <0.699511, 0.552462, 17.191303>, <0.699511, -0.059175, 17.188307>, <-0.577220, -0.059175, 17.188307>, <-0.577220, 0.552462, 17.191303>
    }
  }
  texture {
    CykelTex
  }
  rotate <0.608057, 4.768898, 0.368294>
  translate  <4.95672, 1.599608, -0.393708>
}
#declare SkarmStang2 = intersection {
  torus { // StangTorus2
    1.5, 0.09  rotate -x*90
    scale <11.3652, 0.959804, 1.035426>
    rotate <-0.25165, 6.184146, 2.32242>
    translate  <0.345535, 0.001395, -0.116725>
  }
  box { // StangCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <8.149147, 2.280695, 1.172785>
    rotate <2.571379, 5.804821, 5.601637>
    translate  <8.637648, 2.844804, -0.641925>
  }
  texture {
    EkerTex
  }
}
#declare SkarmSkruv1 = difference {
  cylinder { // StangSkruvCyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.749816, -0.392919>
  }
  box { // StangSkruvCut4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.907007, -0.404223>
  }
  texture {
    EkerTex
  }
  rotate <177.877716, 0.0, -90.0>
  translate  <5.487196, 0.709454, 16.021626>
}
#declare SkarmSkruv2 = difference {
  cylinder { // StangSkruvCyl5
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.71893, -0.398801>
  }
  box { // StangSkruvCut5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.898975, -0.400829>
  }
  texture {
    EkerTex
  }
  rotate <-112.906303, -13.211476, -90.0>
  translate  <7.344953, 0.709454, 13.220949>
}
#declare SkarmHallarNere = intersection {
  torus { // SkarmHTorus
    1.5, 0.2  rotate -x*90
    scale 10.0
    rotate -90.0*x
    translate  <0.023707, 0.0, 0.055316>
  }
  box { // SkarmHallarCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.354472, 0.774282, 0.380053>
    rotate 20.725758*y
    translate  <7.492151, 0.0, 15.078601>
  }
  cylinder { // SkarmHCut2
    <0,0,1>, <0,0,0>, 1
    translate  <8.14769, 0.0, 14.401433>
  }
  texture {
    EkerTex
  }
}
#declare SkarmSkruv3 = difference {
  cylinder { // StangSkruvCyl6
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.71893, -0.398801>
  }
  box { // StangSkruvCut6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.898975, -0.400829>
  }
  texture {
    EkerTex
  }
  rotate <-114.168648, 14.27054, -90.311218>
  translate  <7.303275, 0.709454, 13.583713>
}
#declare Lampaddd = difference {
  sphere { // Lampa
    <0,0,0>,1
    scale <3.380641, 1.802746, 1.795746>
    translate  <1.965473, -0.007076, 22.625498>
  }
  plane { // LampaCut
    z,0
    rotate <-180.0, 90.0, -180.0>
    translate  <2.279052, 0.0, 22.905063>
  }
  texture {
    CykelTex
  }
  translate  <-0.956294, 0.0, -2.223932>
}
#declare LampHallare = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <1.512161, 1.960929, 0.5>
    rotate <-90.0, -27.545542, 0.0>
    translate  <3.586599, -0.25, 17.80082>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.184959, 1.591985, 1.563333>
    rotate <-90.0, -40.004662, 0.0>
    translate  <3.59516, -0.719074, 17.563917>
  }
  plane { // Plane001
    z,0
    rotate <0.0, 88.056602, 0.0>
    translate  <3.189862, 0.0, 19.204943>
  }
  plane { // Plane002
    z,0
    rotate 5.354949*y
    translate  <4.834121, 0.0, 16.968751>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.647957, 0.178718, 1.154881>
    rotate 25.054405*y
    translate  <4.207286, 0.0, 18.669046>
  }
  texture {
    EkerTex
  }
  translate  <0.129881, 0.0, 0.510245>
}
#declare LampGlas = difference {
  sphere { // Lampa1
    <0,0,0>,1
    scale <3.244222, 1.73, 1.723282>
    translate  <0.999126, -0.007076, 20.399615>
  }
  plane { // LampGlasCut
    z,0
    texture {
      LampTex
      scale <0.927433, 3.207582, 1.009156>
    }
    rotate 77.392044*y
    translate  <0.869082, 0.0, 19.668359>
  }
  texture {
    LampTex
  }
  rotate -0.011559*x
}
#declare LampMuttern1 = intersection {
  box { // NavMutterBas2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  translate  <4.418282, 0.442704, 19.408464>
}
#declare LampMuttern2 = intersection {
  box { // NavMutterBas3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  translate  <4.418526, 1.062022, 19.401231>
}
#declare Lyktan = union {
  object { Lampaddd }
  object { LampHallare }
  box { // LampHallarLada
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.188322, 0.254704, 0.357177>
    rotate 5.510356*y
    translate  <5.233227, 0.0, 17.184945>
  }
  object { LampGlas }
  sphere { // LampPryl
    <0,0,0>,1
    texture {
      LampTex
    }
    scale <0.240989, 0.306491, 0.128541>
    translate  <1.845445, -0.003109, 22.062186>
  }
  cylinder { // FuskCyl2
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.289198, 0.289198, 0.085788>
    rotate <-90.0, 0.0, 5.959169>
    translate  <4.394674, -0.276065, 19.416607>
  }
  cylinder { // FuskCyl3
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.289198, 0.289198, 0.085788>
    rotate <-90.0, 0.0, -4.210643>
    translate  <4.398927, 0.181837, 19.416607>
  }
  object { LampMuttern1 }
  object { LampMuttern2 }
  cylinder { // LampGangor
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.06, 0.06, 0.777772>
    rotate <-90.0, 0.0, 0.0>
    translate  <4.402089, -0.39176, 19.408751>
  }
  translate  <-0.073489, 0.0, -0.432056>
}
#declare FramSkarmen = difference {
  torus { // FramSkarm
    1.5, 0.2  rotate -x*90
    scale 10.0
    rotate -90.0*x
  }
  cylinder { // FramSkarmCut1
    <0,0,1>, <0,0,0>, 1
    scale <15.0, 15.0, 5.0>
    rotate -90.0*x
    translate  -2.5*y
  }
  plane { // FramSkarmCut2
    z,0
    scale <3.376432, 3.376432, 1.0>
    rotate 67.116257*y
    translate  <-1.762291, 0.107171, 14.196253>
  }
  plane { // FramSkarmCut3
    z,0
    scale <3.376432, 3.448445, 1.0>
    rotate 44.414051*y
    translate  <12.884782, 0.0, -7.785183>
  }
  torus { // SkarmCut
    1.5, 0.2  rotate -x*90
    scale 9.9
    rotate -90.0*x
  }
}
#declare SkurenSkarm = intersection {
  object { FramSkarmen }
  cylinder { // SkarmCut1
    <0,0,1>, <0,0,0>, 1
    scale <18.517759, 18.517759, 3.0>
    rotate -90.0*x
    translate  -1.5*y
  }
  texture {
    CykelTex
  }
}
#declare SkarmVanster = difference {
  cone { // SkarmVansterKon
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale <16.33, 16.33, 1.010175>
    rotate -90.0*x
    translate  -2.517657*y
  }
  cylinder { // SkarmVansterCut
    <0,0,1>, <0,0,0>, 1
    scale <15.35, 15.35, 5.0>
    rotate -90.0*x
    translate  -2.5*y
  }
  plane { // SkarmVCut2
    z,0
    scale <3.376432, 3.376432, 1.0>
    rotate 67.116257*y
    translate  <-1.762291, 0.107171, 14.196253>
  }
  plane { // SkarmVCut3
    z,0
    scale <3.376432, 3.448445, 1.0>
    rotate 44.414051*y
    translate  <12.884799, 0.0, -7.785128>
  }
  texture {
    CykelTex
  }
}
#declare SkarmHoger = difference {
  cone { // SkarmHogerKon
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale <16.33, 16.33, 1.000746>
    rotate 90.0*x
    translate  2.500257*y
  }
  cylinder { // SkarmHogerCut
    <0,0,1>, <0,0,0>, 1
    scale <15.35, 15.35, 5.0>
    rotate -90.0*x
    translate  -2.5*y
  }
  plane { // SkarmHCut3
    z,0
    scale <3.376432, 3.376432, 1.0>
    rotate 67.116257*y
    translate  <-1.762291, 0.107171, 14.196253>
  }
  plane { // SkarmHCut4
    z,0
    scale <3.376432, 3.448445, 1.0>
    rotate 44.414051*y
    translate  <12.884111, 0.0, -7.784588>
  }
  texture {
    CykelTex
  }
}
#declare LampSkruv = difference {
  cylinder { // StangSkruvCyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.749816, -0.392919>
  }
  box { // StangSkruvCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.907007, -0.404223>
  }
  texture {
    EkerTex
  }
  rotate <-176.591553, 0.0, 90.0>
  translate  <6.699545, -0.724794, 16.29725>
}
#declare GenMutter5 = intersection {
  box { // NavMutterBas8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.76
  rotate <-90.0, 5.70357, 0.0>
  translate  <7.678546, 0.051633, 29.07638>
}
#declare StyrHCyl2 = difference {
  cylinder { // StyrHallarCyl2
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <1.468405, 0.704373, 1.507099>
    rotate 6.233162*y
    translate  <4.56696, 0.0, 29.700825>
  }
  box { // StyrHCyl2Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.036011, 1.0, 0.135452>
    rotate 5.753755*y
    translate  <4.000543, 0.0, 30.534808>
  }
}
#declare StyrCSG2 = intersection {
  object { StyrHCyl2 }
  box { // Cut
    <-1, -1, -1>, <1, 1, 1>
    rotate 6.048585*y
    translate  <3.675031, 0.0, 30.706135>
  }
  texture {
    EkerTex
  }
  rotate -9.068233*y
  translate  <5.713095, 0.0, -0.444325>
}
#declare StyrCSG1 = difference {
  cylinder { // StyrHallarCyl1
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.75, 0.75, 1.4>
    rotate <-90.0, 6.243567, 0.0>
    translate  <5.501083, -0.7, 30.350595>
  }
  box { // Cut1
    <-1, -1, -1>, <1, 1, 1>
    rotate -3.115142*y
    translate  <4.502642, 0.0, 30.445501>
  }
  texture {
    EkerTex
  }
}
#declare GenMutter6 = intersection {
  box { // NavMutterBas9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.76
  rotate <-90.0, -2.636473, 0.0>
  translate  <4.55203, 0.001084, 28.123127>
}
#declare StyrSkruv = difference {
  sphere { // StyrSkruvS
    <0,0,0>,1
    scale <0.33, 0.33, 0.2>
    rotate 5.203493*y
    translate  <4.575688, 0.0, 31.20977>
  }
  box { // StyrSkruvCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.039549, 0.349414, 0.171362>
    rotate 5.558967*y
    translate  <4.593414, 0.0, 31.429699>
  }
  texture {
    EkerTex
  }
  rotate -7.700823*y
  translate  <4.040873, 0.0, -0.481973>
}
#declare Styre = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.607831, 5.426656, 2.709440>, <2.607831, 5.373746, 2.156966>, <3.450619, 5.373746, 2.156966>, <3.450619, 5.426656, 2.709440>,
      <2.607814, 3.448808, 3.229094>, <2.607798, 3.244252, 2.546141>, <3.450571, 3.244252, 2.546141>, <3.450595, 3.448808, 3.229094>,
      <2.357672, 0.040258, 4.056098>, <2.357672, -0.753085, 3.373618>, <3.450571, -0.753085, 3.373618>, <3.450571, 0.040258, 4.056098>,
      <0.905611, 0.020129, 6.028049>, <0.905611, -0.730792, 5.686809>, <2.031950, -0.741938, 5.686809>, <2.031950, 0.008983, 6.028049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.450619, 5.426656, 2.709440>, <3.450619, 5.479566, 3.261913>, <2.607831, 5.479566, 3.261913>, <2.607831, 5.426656, 2.709440>,
      <3.450595, 3.448808, 3.229094>, <3.450619, 3.653364, 3.912047>, <2.607831, 3.653364, 3.912047>, <2.607814, 3.448808, 3.229094>,
      <3.450571, 0.040258, 4.056098>, <3.450571, 0.833601, 4.738578>, <2.357672, 0.833601, 4.738578>, <2.357672, 0.040258, 4.056098>,
      <2.031950, 0.008983, 6.028049>, <2.031950, 0.759904, 6.369289>, <0.905611, 0.771050, 6.369289>, <0.905611, 0.020129, 6.028049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.905611, 0.020129, 6.028049>, <0.905611, -0.730792, 5.686809>, <2.031950, -0.741938, 5.686809>, <2.031950, 0.008983, 6.028049>,
      <-0.546450, 0.000000, 8.000000>, <-0.546450, -0.708500, 8.000000>, <0.613328, -0.730792, 8.000000>, <0.613328, -0.022293, 8.000000>,
      <-0.546450, 0.000000, 10.000000>, <-0.546450, -0.708500, 10.000000>, <0.613328, -0.730792, 10.000000>, <0.613328, -0.022293, 10.000000>,
      <-0.546450, 0.000000, 12.000000>, <-0.546450, -0.708500, 12.000000>, <0.613328, -0.730792, 12.000000>, <0.613328, -0.022293, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.031950, 0.008983, 6.028049>, <2.031950, 0.759904, 6.369289>, <0.905611, 0.771050, 6.369289>, <0.905611, 0.020129, 6.028049>,
      <0.613328, -0.022293, 8.000000>, <0.613328, 0.686207, 8.000000>, <-0.546450, 0.708500, 8.000000>, <-0.546450, 0.000000, 8.000000>,
      <0.613328, -0.022293, 10.000000>, <0.613328, 0.686207, 10.000000>, <-0.546450, 0.708500, 10.000000>, <-0.546450, 0.000000, 10.000000>,
      <0.613328, -0.022293, 12.000000>, <0.613328, 0.686207, 12.000000>, <-0.546450, 0.708500, 12.000000>, <-0.546450, 0.000000, 12.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.546450, 0.000000, 12.000000>, <-0.546450, -0.708500, 12.000000>, <0.613328, -0.730792, 12.000000>, <0.613328, -0.022293, 12.000000>,
      <-0.546450, 0.000000, 14.000000>, <-0.546450, -0.708500, 14.000000>, <0.613328, -0.730792, 14.000000>, <0.613328, -0.022293, 14.000000>,
      <-0.546450, 0.000000, 16.000000>, <-0.546450, -0.708500, 16.000000>, <0.613328, -0.730792, 16.000000>, <0.613328, -0.022293, 16.000000>,
      <0.903024, 0.016762, 18.238865>, <0.900437, -0.734613, 18.672304>, <2.026776, -0.745759, 18.672304>, <2.029363, 0.005616, 18.238865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.613328, -0.022293, 12.000000>, <0.613328, 0.686207, 12.000000>, <-0.546450, 0.708500, 12.000000>, <-0.546450, 0.000000, 12.000000>,
      <0.613328, -0.022293, 14.000000>, <0.613328, 0.686207, 14.000000>, <-0.546450, 0.708500, 14.000000>, <-0.546450, 0.000000, 14.000000>,
      <0.613328, -0.022293, 16.000000>, <0.613328, 0.686207, 16.000000>, <-0.546450, 0.708500, 16.000000>, <-0.546450, 0.000000, 16.000000>,
      <2.029363, 0.005616, 18.238865>, <2.031950, 0.756991, 17.805425>, <0.905611, 0.768137, 17.805425>, <0.903024, 0.016762, 18.238865>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.903024, 0.016762, 18.238865>, <0.900437, -0.734613, 18.672304>, <2.026776, -0.745759, 18.672304>, <2.029363, 0.005616, 18.238865>,
      <2.352498, 0.033525, 20.477729>, <2.347324, -0.760725, 21.344608>, <3.440224, -0.760725, 21.344608>, <3.445398, 0.033525, 20.477729>,
      <2.641449, 3.221052, 21.491125>, <2.632138, 3.234508, 22.293078>, <3.450571, 3.234508, 22.293078>, <3.459890, 3.221052, 21.491125>,
      <2.639690, 5.424703, 21.854720>, <2.632171, 5.382209, 22.443039>, <3.450619, 5.382209, 22.443039>, <3.458138, 5.424703, 21.854720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.029363, 0.005616, 18.238865>, <2.031950, 0.756991, 17.805425>, <0.905611, 0.768137, 17.805425>, <0.903024, 0.016762, 18.238865>,
      <3.445398, 0.033525, 20.477729>, <3.450571, 0.827775, 19.610850>, <2.357672, 0.827775, 19.610850>, <2.352498, 0.033525, 20.477729>,
      <3.459890, 3.221052, 21.491125>, <3.469209, 3.207596, 20.689171>, <2.650760, 3.207596, 20.689171>, <2.641449, 3.221052, 21.491125>,
      <3.458138, 5.424703, 21.854720>, <3.465657, 5.467198, 21.266402>, <2.647208, 5.467198, 21.266402>, <2.639690, 5.424703, 21.854720>
    }
  }
  texture {
    EkerTex
  }
  rotate <90.0, -90.0, -180.0>
  translate  <5.493207, -12.380544, 30.454516>
}
#declare TireMonster = union {
  torus { // TireStringVN
    1.5, 0.01  rotate -x*90
    texture {
      TireTex
    }
    scale <9.95, 9.95, 10.526612>
    rotate -90.0*x
    translate  -0.923297*y
  }
  object { // MkubHH119->MkubHH0
    MkubHH0
    rotate <0.0, 3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH118->MkubHH0
    MkubHH0
    rotate <0.0, 6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { MkubM0 }
  object { // MkubM1->MkubM0
    MkubM0
    rotate -3.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM2->MkubM0
    MkubM0
    rotate -6.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM3->MkubM0
    MkubM0
    rotate -9.0*y
    translate  0.0*z
  }
  object { // MkubM4->MkubM0
    MkubM0
    rotate -12.0*y
    translate  0.0*x
  }
  object { // MkubM5->MkubM0
    MkubM0
    rotate -15.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM6->MkubM0
    MkubM0
    rotate -18.0*y
    translate  0.0*z
  }
  object { // MkubM7->MkubM0
    MkubM0
    rotate -21.0*y
    translate  0.0*x
  }
  object { // MkubM8->MkubM0
    MkubM0
    rotate -24.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM9->MkubM0
    MkubM0
    rotate -27.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM10->MkubM0
    MkubM0
    rotate -30.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM11->MkubM0
    MkubM0
    rotate -33.0*y
    translate  0.0*x
  }
  object { // MkubM12->MkubM0
    MkubM0
    rotate -36.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM13->MkubM0
    MkubM0
    rotate -39.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM14->MkubM0
    MkubM0
    rotate -42.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM15->MkubM0
    MkubM0
    rotate -45.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM16->MkubM0
    MkubM0
    rotate -48.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM17->MkubM0
    MkubM0
    rotate -51.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM18->MkubM0
    MkubM0
    rotate -54.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM19->MkubM0
    MkubM0
    rotate -57.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM20->MkubM0
    MkubM0
    rotate -60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM21->MkubM0
    MkubM0
    rotate -63.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM22->MkubM0
    MkubM0
    rotate -66.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM23->MkubM0
    MkubM0
    rotate -69.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM24->MkubM0
    MkubM0
    rotate -72.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM25->MkubM0
    MkubM0
    rotate -75.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM26->MkubM0
    MkubM0
    rotate -78.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM27->MkubM0
    MkubM0
    rotate -81.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM28->MkubM0
    MkubM0
    rotate -84.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM29->MkubM0
    MkubM0
    rotate -87.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM30->MkubM0
    MkubM0
    rotate -90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM31->MkubM0
    MkubM0
    rotate <-180.0, -87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM32->MkubM0
    MkubM0
    rotate <-180.0, -84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM33->MkubM0
    MkubM0
    rotate <-180.0, -81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM34->MkubM0
    MkubM0
    rotate <-180.0, -78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM35->MkubM0
    MkubM0
    rotate <-180.0, -75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM36->MkubM0
    MkubM0
    rotate <-180.0, -72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM37->MkubM0
    MkubM0
    rotate <-180.0, -69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM38->MkubM0
    MkubM0
    rotate <-180.0, -66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM39->MkubM0
    MkubM0
    rotate <-180.0, -63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM40->MkubM0
    MkubM0
    rotate <-180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM41->MkubM0
    MkubM0
    rotate <-180.0, -57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM42->MkubM0
    MkubM0
    rotate <-180.0, -54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM43->MkubM0
    MkubM0
    rotate <-180.0, -51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM44->MkubM0
    MkubM0
    rotate <-180.0, -48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM45->MkubM0
    MkubM0
    rotate <-180.0, -45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM46->MkubM0
    MkubM0
    rotate <-180.0, -42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM47->MkubM0
    MkubM0
    rotate <-180.0, -39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM48->MkubM0
    MkubM0
    rotate <-180.0, -36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM49->MkubM0
    MkubM0
    rotate <-180.0, -33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM50->MkubM0
    MkubM0
    rotate <-180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM51->MkubM0
    MkubM0
    rotate <-180.0, -27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM52->MkubM0
    MkubM0
    rotate <-180.0, -24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM53->MkubM0
    MkubM0
    rotate <-180.0, -21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM54->MkubM0
    MkubM0
    rotate <-180.0, -18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM55->MkubM0
    MkubM0
    rotate <-180.0, -15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM56->MkubM0
    MkubM0
    rotate <-180.0, -12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM57->MkubM0
    MkubM0
    rotate <-180.0, -9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM58->MkubM0
    MkubM0
    rotate <-180.0, -6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM59->MkubM0
    MkubM0
    rotate <-180.0, -3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM60->MkubM0
    MkubM0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM61->MkubM0
    MkubM0
    rotate <-180.0, 3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM62->MkubM0
    MkubM0
    rotate <-180.0, 6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM63->MkubM0
    MkubM0
    rotate <-180.0, 9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM64->MkubM0
    MkubM0
    rotate <-180.0, 12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM65->MkubM0
    MkubM0
    rotate <-180.0, 15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM66->MkubM0
    MkubM0
    rotate <-180.0, 18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM67->MkubM0
    MkubM0
    rotate <-180.0, 21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM68->MkubM0
    MkubM0
    rotate <-180.0, 24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM69->MkubM0
    MkubM0
    rotate <-180.0, 27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM70->MkubM0
    MkubM0
    rotate <-180.0, 30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM71->MkubM0
    MkubM0
    rotate <-180.0, 33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM72->MkubM0
    MkubM0
    rotate <-180.0, 36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM73->MkubM0
    MkubM0
    rotate <-180.0, 39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM74->MkubM0
    MkubM0
    rotate <-180.0, 42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM75->MkubM0
    MkubM0
    rotate <-180.0, 45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM76->MkubM0
    MkubM0
    rotate <-180.0, 48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM77->MkubM0
    MkubM0
    rotate <-180.0, 51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM78->MkubM0
    MkubM0
    rotate <-180.0, 54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM79->MkubM0
    MkubM0
    rotate <-180.0, 57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM80->MkubM0
    MkubM0
    rotate <-180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM81->MkubM0
    MkubM0
    rotate <-180.0, 63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM82->MkubM0
    MkubM0
    rotate <-180.0, 66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM83->MkubM0
    MkubM0
    rotate <-180.0, 69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM84->MkubM0
    MkubM0
    rotate <-180.0, 72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM85->MkubM0
    MkubM0
    rotate <-180.0, 75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM86->MkubM0
    MkubM0
    rotate <-180.0, 78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM87->MkubM0
    MkubM0
    rotate <-180.0, 81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM88->MkubM0
    MkubM0
    rotate <-180.0, 84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM89->MkubM0
    MkubM0
    rotate <-180.0, 87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM90->MkubM0
    MkubM0
    rotate 90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM91->MkubM0
    MkubM0
    rotate 87.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM92->MkubM0
    MkubM0
    rotate 84.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM93->MkubM0
    MkubM0
    rotate 81.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM94->MkubM0
    MkubM0
    rotate 78.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM95->MkubM0
    MkubM0
    rotate 75.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM96->MkubM0
    MkubM0
    rotate 72.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM97->MkubM0
    MkubM0
    rotate 69.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM98->MkubM0
    MkubM0
    rotate 66.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM99->MkubM0
    MkubM0
    rotate 63.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM100->MkubM0
    MkubM0
    rotate 60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM101->MkubM0
    MkubM0
    rotate 57.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM102->MkubM0
    MkubM0
    rotate 54.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM103->MkubM0
    MkubM0
    rotate 51.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM104->MkubM0
    MkubM0
    rotate 48.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM105->MkubM0
    MkubM0
    rotate 45.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM106->MkubM0
    MkubM0
    rotate 42.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM107->MkubM0
    MkubM0
    rotate 39.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM108->MkubM0
    MkubM0
    rotate 36.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM109->MkubM0
    MkubM0
    rotate 33.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM110->MkubM0
    MkubM0
    rotate 30.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM111->MkubM0
    MkubM0
    rotate 27.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM112->MkubM0
    MkubM0
    rotate 24.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM113->MkubM0
    MkubM0
    rotate 21.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM114->MkubM0
    MkubM0
    rotate 18.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM115->MkubM0
    MkubM0
    rotate 15.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM116->MkubM0
    MkubM0
    rotate 12.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM117->MkubM0
    MkubM0
    rotate 9.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM118->MkubM0
    MkubM0
    rotate 6.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubM119->MkubM0
    MkubM0
    rotate 3.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { MkubV0 }
  object { // MkubV1->MkubV0
    MkubV0
    rotate <0.0, -3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV2->MkubV0
    MkubV0
    rotate <0.0, -6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV3->MkubV0
    MkubV0
    rotate <0.0, -9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV4->MkubV0
    MkubV0
    rotate <0.0, -12.0, 0.0>
    translate  0.0*y
  }
  object { // MkubV5->MkubV0
    MkubV0
    rotate <0.0, -15.0, 0.0>
    translate  0.0*y
  }
  object { // MkubV6->MkubV0
    MkubV0
    rotate <0.0, -18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV7->MkubV0
    MkubV0
    rotate <0.0, -21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV8->MkubV0
    MkubV0
    rotate <0.0, -24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV9->MkubV0
    MkubV0
    rotate <0.0, -27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV10->MkubV0
    MkubV0
    rotate <0.0, -30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV11->MkubV0
    MkubV0
    rotate <0.0, -33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV12->MkubV0
    MkubV0
    rotate <0.0, -36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV13->MkubV0
    MkubV0
    rotate <0.0, -39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV14->MkubV0
    MkubV0
    rotate <0.0, -42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV15->MkubV0
    MkubV0
    rotate <0.0, -45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV16->MkubV0
    MkubV0
    rotate <0.0, -48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV17->MkubV0
    MkubV0
    rotate <0.0, -51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV18->MkubV0
    MkubV0
    rotate <0.0, -54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV19->MkubV0
    MkubV0
    rotate <0.0, -57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV20->MkubV0
    MkubV0
    rotate <0.0, -60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV21->MkubV0
    MkubV0
    rotate <0.0, -63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV22->MkubV0
    MkubV0
    rotate <0.0, -66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV23->MkubV0
    MkubV0
    rotate <0.0, -69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV24->MkubV0
    MkubV0
    rotate <0.0, -72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV25->MkubV0
    MkubV0
    rotate <0.0, -75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV26->MkubV0
    MkubV0
    rotate <0.0, -78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV27->MkubV0
    MkubV0
    rotate <0.0, -81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV28->MkubV0
    MkubV0
    rotate <0.0, -84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV29->MkubV0
    MkubV0
    rotate <0.0, -87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV30->MkubV0
    MkubV0
    rotate <0.0, -90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV31->MkubV0
    MkubV0
    rotate <-180.0, -87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV32->MkubV0
    MkubV0
    rotate <-180.0, -84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV33->MkubV0
    MkubV0
    rotate <-180.0, -81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV34->MkubV0
    MkubV0
    rotate <-180.0, -78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV35->MkubV0
    MkubV0
    rotate <-180.0, -75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV36->MkubV0
    MkubV0
    rotate <-180.0, -72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV37->MkubV0
    MkubV0
    rotate <-180.0, -69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV38->MkubV0
    MkubV0
    rotate <-180.0, -66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV39->MkubV0
    MkubV0
    rotate <-180.0, -63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV40->MkubV0
    MkubV0
    rotate <-180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV41->MkubV0
    MkubV0
    rotate <-180.0, -57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV42->MkubV0
    MkubV0
    rotate <-180.0, -54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV43->MkubV0
    MkubV0
    rotate <-180.0, -51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV44->MkubV0
    MkubV0
    rotate <-180.0, -48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV45->MkubV0
    MkubV0
    rotate <-180.0, -45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV46->MkubV0
    MkubV0
    rotate <-180.0, -42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV47->MkubV0
    MkubV0
    rotate <-180.0, -39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV48->MkubV0
    MkubV0
    rotate <-180.0, -36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV49->MkubV0
    MkubV0
    rotate <-180.0, -33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV50->MkubV0
    MkubV0
    rotate <-180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV51->MkubV0
    MkubV0
    rotate <-180.0, -27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV52->MkubV0
    MkubV0
    rotate <-180.0, -24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV53->MkubV0
    MkubV0
    rotate <-180.0, -21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV54->MkubV0
    MkubV0
    rotate <-180.0, -18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV55->MkubV0
    MkubV0
    rotate <-180.0, -15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV56->MkubV0
    MkubV0
    rotate <-180.0, -12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV57->MkubV0
    MkubV0
    rotate <-180.0, -9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV58->MkubV0
    MkubV0
    rotate <-180.0, -6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV59->MkubV0
    MkubV0
    rotate <-180.0, -3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV60->MkubV0
    MkubV0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV61->MkubV0
    MkubV0
    rotate <-180.0, 3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV62->MkubV0
    MkubV0
    rotate <-180.0, 6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV63->MkubV0
    MkubV0
    rotate <-180.0, 9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV64->MkubV0
    MkubV0
    rotate <-180.0, 12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV65->MkubV0
    MkubV0
    rotate <-180.0, 15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV66->MkubV0
    MkubV0
    rotate <-180.0, 18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV67->MkubV0
    MkubV0
    rotate <-180.0, 21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV68->MkubV0
    MkubV0
    rotate <-180.0, 24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV69->MkubV0
    MkubV0
    rotate <-180.0, 27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV70->MkubV0
    MkubV0
    rotate <-180.0, 30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV71->MkubV0
    MkubV0
    rotate <-180.0, 33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV72->MkubV0
    MkubV0
    rotate <-180.0, 36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV73->MkubV0
    MkubV0
    rotate <-180.0, 39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV74->MkubV0
    MkubV0
    rotate <-180.0, 42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV75->MkubV0
    MkubV0
    rotate <-180.0, 45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV76->MkubV0
    MkubV0
    rotate <-180.0, 48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV77->MkubV0
    MkubV0
    rotate <-180.0, 51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV78->MkubV0
    MkubV0
    rotate <-180.0, 54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV79->MkubV0
    MkubV0
    rotate <-180.0, 57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV80->MkubV0
    MkubV0
    rotate <-180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV81->MkubV0
    MkubV0
    rotate <-180.0, 63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV82->MkubV0
    MkubV0
    rotate <-180.0, 66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV83->MkubV0
    MkubV0
    rotate <-180.0, 69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV84->MkubV0
    MkubV0
    rotate <-180.0, 72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV85->MkubV0
    MkubV0
    rotate <-180.0, 75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV86->MkubV0
    MkubV0
    rotate <-180.0, 78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV87->MkubV0
    MkubV0
    rotate <-180.0, 81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV88->MkubV0
    MkubV0
    rotate <-180.0, 84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV89->MkubV0
    MkubV0
    rotate <-180.0, 87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV90->MkubV0
    MkubV0
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV91->MkubV0
    MkubV0
    rotate <0.0, 87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV92->MkubV0
    MkubV0
    rotate <0.0, 84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV93->MkubV0
    MkubV0
    rotate <0.0, 81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV94->MkubV0
    MkubV0
    rotate <0.0, 78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV95->MkubV0
    MkubV0
    rotate <0.0, 75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV96->MkubV0
    MkubV0
    rotate <0.0, 72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV97->MkubV0
    MkubV0
    rotate <0.0, 69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV98->MkubV0
    MkubV0
    rotate <0.0, 66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV99->MkubV0
    MkubV0
    rotate <0.0, 63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV100->MkubV0
    MkubV0
    rotate <0.0, 60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV101->MkubV0
    MkubV0
    rotate <0.0, 57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV102->MkubV0
    MkubV0
    rotate <0.0, 54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV103->MkubV0
    MkubV0
    rotate <0.0, 51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV104->MkubV0
    MkubV0
    rotate <0.0, 48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV105->MkubV0
    MkubV0
    rotate <0.0, 45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV106->MkubV0
    MkubV0
    rotate <0.0, 42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV107->MkubV0
    MkubV0
    rotate <0.0, 39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV108->MkubV0
    MkubV0
    rotate <0.0, 36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV109->MkubV0
    MkubV0
    rotate <0.0, 33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV110->MkubV0
    MkubV0
    rotate <0.0, 30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV111->MkubV0
    MkubV0
    rotate <0.0, 27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV112->MkubV0
    MkubV0
    rotate <0.0, 24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV113->MkubV0
    MkubV0
    rotate <0.0, 21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV114->MkubV0
    MkubV0
    rotate <0.0, 18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV115->MkubV0
    MkubV0
    rotate <0.0, 15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV116->MkubV0
    MkubV0
    rotate <0.0, 12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV117->MkubV0
    MkubV0
    rotate <0.0, 9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV118->MkubV0
    MkubV0
    rotate <0.0, 6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubV119->MkubV0
    MkubV0
    rotate <0.0, 3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { MkubVV0 }
  object { // MkubVV1->MkubVV0
    MkubVV0
    rotate <0.0, -3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV2->MkubVV0
    MkubVV0
    rotate <0.0, -6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV3->MkubVV0
    MkubVV0
    rotate <0.0, -9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV4->MkubVV0
    MkubVV0
    rotate <0.0, -12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV5->MkubVV0
    MkubVV0
    rotate <0.0, -15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV6->MkubVV0
    MkubVV0
    rotate <0.0, -18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV7->MkubVV0
    MkubVV0
    rotate <0.0, -21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV8->MkubVV0
    MkubVV0
    rotate <0.0, -24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV9->MkubVV0
    MkubVV0
    rotate <0.0, -27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV10->MkubVV0
    MkubVV0
    rotate <0.0, -30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV11->MkubVV0
    MkubVV0
    rotate <0.0, -33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV12->MkubVV0
    MkubVV0
    rotate <0.0, -36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV13->MkubVV0
    MkubVV0
    rotate <0.0, -39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV14->MkubVV0
    MkubVV0
    rotate <0.0, -42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV15->MkubVV0
    MkubVV0
    rotate <0.0, -45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV16->MkubVV0
    MkubVV0
    rotate <0.0, -48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV17->MkubVV0
    MkubVV0
    rotate <0.0, -51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV18->MkubVV0
    MkubVV0
    rotate <0.0, -54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV19->MkubVV0
    MkubVV0
    rotate <0.0, -57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV20->MkubVV0
    MkubVV0
    rotate <0.0, -60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV21->MkubVV0
    MkubVV0
    rotate <0.0, -63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV22->MkubVV0
    MkubVV0
    rotate <0.0, -66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV23->MkubVV0
    MkubVV0
    rotate <0.0, -69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV24->MkubVV0
    MkubVV0
    rotate <0.0, -72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV25->MkubVV0
    MkubVV0
    rotate <0.0, -75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV26->MkubVV0
    MkubVV0
    rotate <0.0, -78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV27->MkubVV0
    MkubVV0
    rotate <0.0, -81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV28->MkubVV0
    MkubVV0
    rotate <0.0, -84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV29->MkubVV0
    MkubVV0
    rotate <0.0, -87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV30->MkubVV0
    MkubVV0
    rotate <0.0, -90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV31->MkubVV0
    MkubVV0
    rotate <180.0, -87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV32->MkubVV0
    MkubVV0
    rotate <180.0, -84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV33->MkubVV0
    MkubVV0
    rotate <180.0, -81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV34->MkubVV0
    MkubVV0
    rotate <180.0, -78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV35->MkubVV0
    MkubVV0
    rotate <180.0, -75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV36->MkubVV0
    MkubVV0
    rotate <180.0, -72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV37->MkubVV0
    MkubVV0
    rotate <180.0, -69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV38->MkubVV0
    MkubVV0
    rotate <180.0, -66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV39->MkubVV0
    MkubVV0
    rotate <180.0, -63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV40->MkubVV0
    MkubVV0
    rotate <180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV41->MkubVV0
    MkubVV0
    rotate <180.0, -57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV42->MkubVV0
    MkubVV0
    rotate <180.0, -54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV43->MkubVV0
    MkubVV0
    rotate <180.0, -51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV44->MkubVV0
    MkubVV0
    rotate <180.0, -48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV45->MkubVV0
    MkubVV0
    rotate <180.0, -45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV46->MkubVV0
    MkubVV0
    rotate <180.0, -42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV47->MkubVV0
    MkubVV0
    rotate <180.0, -39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV48->MkubVV0
    MkubVV0
    rotate <180.0, -36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV49->MkubVV0
    MkubVV0
    rotate <180.0, -33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV50->MkubVV0
    MkubVV0
    rotate <180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV51->MkubVV0
    MkubVV0
    rotate <180.0, -27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV52->MkubVV0
    MkubVV0
    rotate <180.0, -24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV53->MkubVV0
    MkubVV0
    rotate <180.0, -21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV54->MkubVV0
    MkubVV0
    rotate <180.0, -18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV55->MkubVV0
    MkubVV0
    rotate <180.0, -15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV56->MkubVV0
    MkubVV0
    rotate <180.0, -12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV57->MkubVV0
    MkubVV0
    rotate <180.0, -9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV58->MkubVV0
    MkubVV0
    rotate <180.0, -6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV59->MkubVV0
    MkubVV0
    rotate <180.0, -3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV60->MkubVV0
    MkubVV0
    rotate <180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV61->MkubVV0
    MkubVV0
    rotate <180.0, 3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV62->MkubVV0
    MkubVV0
    rotate <180.0, 6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV63->MkubVV0
    MkubVV0
    rotate <180.0, 9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV64->MkubVV0
    MkubVV0
    rotate <180.0, 12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV65->MkubVV0
    MkubVV0
    rotate <180.0, 15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV66->MkubVV0
    MkubVV0
    rotate <180.0, 18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV67->MkubVV0
    MkubVV0
    rotate <180.0, 21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV68->MkubVV0
    MkubVV0
    rotate <180.0, 24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV69->MkubVV0
    MkubVV0
    rotate <180.0, 27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV70->MkubVV0
    MkubVV0
    rotate <180.0, 30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV71->MkubVV0
    MkubVV0
    rotate <180.0, 33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV72->MkubVV0
    MkubVV0
    rotate <180.0, 36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV73->MkubVV0
    MkubVV0
    rotate <180.0, 39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV74->MkubVV0
    MkubVV0
    rotate <180.0, 42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV75->MkubVV0
    MkubVV0
    rotate <180.0, 45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV76->MkubVV0
    MkubVV0
    rotate <180.0, 48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV77->MkubVV0
    MkubVV0
    rotate <180.0, 51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV78->MkubVV0
    MkubVV0
    rotate <180.0, 54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV79->MkubVV0
    MkubVV0
    rotate <180.0, 57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV80->MkubVV0
    MkubVV0
    rotate <180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV81->MkubVV0
    MkubVV0
    rotate <180.0, 63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV82->MkubVV0
    MkubVV0
    rotate <180.0, 66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV83->MkubVV0
    MkubVV0
    rotate <180.0, 69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV84->MkubVV0
    MkubVV0
    rotate <180.0, 72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV85->MkubVV0
    MkubVV0
    rotate <180.0, 75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV86->MkubVV0
    MkubVV0
    rotate <180.0, 78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV87->MkubVV0
    MkubVV0
    rotate <180.0, 81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV88->MkubVV0
    MkubVV0
    rotate <180.0, 84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV89->MkubVV0
    MkubVV0
    rotate <180.0, 87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV90->MkubVV0
    MkubVV0
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV91->MkubVV0
    MkubVV0
    rotate <0.0, 87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV92->MkubVV0
    MkubVV0
    rotate <0.0, 84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV93->MkubVV0
    MkubVV0
    rotate <0.0, 81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV94->MkubVV0
    MkubVV0
    rotate <0.0, 78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV95->MkubVV0
    MkubVV0
    rotate <0.0, 75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV96->MkubVV0
    MkubVV0
    rotate <0.0, 72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV97->MkubVV0
    MkubVV0
    rotate <0.0, 69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV98->MkubVV0
    MkubVV0
    rotate <0.0, 66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV99->MkubVV0
    MkubVV0
    rotate <0.0, 63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV100->MkubVV0
    MkubVV0
    rotate <0.0, 60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV101->MkubVV0
    MkubVV0
    rotate <0.0, 57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV102->MkubVV0
    MkubVV0
    rotate <0.0, 54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV103->MkubVV0
    MkubVV0
    rotate <0.0, 51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV104->MkubVV0
    MkubVV0
    rotate <0.0, 48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV105->MkubVV0
    MkubVV0
    rotate <0.0, 45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV106->MkubVV0
    MkubVV0
    rotate <0.0, 42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV107->MkubVV0
    MkubVV0
    rotate <0.0, 39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV108->MkubVV0
    MkubVV0
    rotate <0.0, 36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV109->MkubVV0
    MkubVV0
    rotate <0.0, 33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV110->MkubVV0
    MkubVV0
    rotate <0.0, 30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV111->MkubVV0
    MkubVV0
    rotate <0.0, 27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV112->MkubVV0
    MkubVV0
    rotate <0.0, 24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV113->MkubVV0
    MkubVV0
    rotate <0.0, 21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV114->MkubVV0
    MkubVV0
    rotate <0.0, 18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV115->MkubVV0
    MkubVV0
    rotate <0.0, 15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV116->MkubVV0
    MkubVV0
    rotate <0.0, 12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV117->MkubVV0
    MkubVV0
    rotate <0.0, 9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV118->MkubVV0
    MkubVV0
    rotate <0.0, 6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubVV119->MkubVV0
    MkubVV0
    rotate <0.0, 3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { MkubH0 }
  object { // MkubH119->MkubH0
    MkubH0
    rotate <0.0, 3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH118->MkubH0
    MkubH0
    rotate <0.0, 6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH117->MkubH0
    MkubH0
    rotate <0.0, 9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH116->MkubH0
    MkubH0
    rotate <0.0, 12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH115->MkubH0
    MkubH0
    rotate <0.0, 15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH114->MkubH0
    MkubH0
    rotate <0.0, 18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH113->MkubH0
    MkubH0
    rotate <0.0, 21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH112->MkubH0
    MkubH0
    rotate <0.0, 24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH111->MkubH0
    MkubH0
    rotate <0.0, 27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH110->MkubH0
    MkubH0
    rotate <0.0, 30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH109->MkubH0
    MkubH0
    rotate <0.0, 33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH108->MkubH0
    MkubH0
    rotate <0.0, 36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH107->MkubH0
    MkubH0
    rotate <0.0, 39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH106->MkubH0
    MkubH0
    rotate <0.0, 42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH105->MkubH0
    MkubH0
    rotate <0.0, 45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH104->MkubH0
    MkubH0
    rotate <0.0, 48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH103->MkubH0
    MkubH0
    rotate <0.0, 51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH102->MkubH0
    MkubH0
    rotate <0.0, 54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH101->MkubH0
    MkubH0
    rotate <0.0, 57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH100->MkubH0
    MkubH0
    rotate <0.0, 60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH99->MkubH0
    MkubH0
    rotate <0.0, 63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH98->MkubH0
    MkubH0
    rotate <0.0, 66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH97->MkubH0
    MkubH0
    rotate <0.0, 69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH96->MkubH0
    MkubH0
    rotate <0.0, 72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH95->MkubH0
    MkubH0
    rotate <0.0, 75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH94->MkubH0
    MkubH0
    rotate <0.0, 78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH93->MkubH0
    MkubH0
    rotate <0.0, 81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH92->MkubH0
    MkubH0
    rotate <0.0, 84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH91->MkubH0
    MkubH0
    rotate <0.0, 87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH90->MkubH0
    MkubH0
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH89->MkubH0
    MkubH0
    rotate <-180.0, 87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH88->MkubH0
    MkubH0
    rotate <-180.0, 84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH87->MkubH0
    MkubH0
    rotate <-180.0, 81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH86->MkubH0
    MkubH0
    rotate <-180.0, 78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH85->MkubH0
    MkubH0
    rotate <-180.0, 75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH84->MkubH0
    MkubH0
    rotate <-180.0, 72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH83->MkubH0
    MkubH0
    rotate <-180.0, 69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH82->MkubH0
    MkubH0
    rotate <-180.0, 66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH81->MkubH0
    MkubH0
    rotate <-180.0, 63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH80->MkubH0
    MkubH0
    rotate <-180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH79->MkubH0
    MkubH0
    rotate <-180.0, 57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH78->MkubH0
    MkubH0
    rotate <-180.0, 54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH77->MkubH0
    MkubH0
    rotate <-180.0, 51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH76->MkubH0
    MkubH0
    rotate <-180.0, 48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH75->MkubH0
    MkubH0
    rotate <-180.0, 45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH74->MkubH0
    MkubH0
    rotate <-180.0, 42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH73->MkubH0
    MkubH0
    rotate <-180.0, 39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH72->MkubH0
    MkubH0
    rotate <-180.0, 36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH71->MkubH0
    MkubH0
    rotate <-180.0, 33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH70->MkubH0
    MkubH0
    rotate <-180.0, 30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH69->MkubH0
    MkubH0
    rotate <-180.0, 27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH68->MkubH0
    MkubH0
    rotate <-180.0, 24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH67->MkubH0
    MkubH0
    rotate <-180.0, 21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH66->MkubH0
    MkubH0
    rotate <-180.0, 18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH65->MkubH0
    MkubH0
    rotate <-180.0, 15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH64->MkubH0
    MkubH0
    rotate <-180.0, 12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH63->MkubH0
    MkubH0
    rotate <-180.0, 9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH62->MkubH0
    MkubH0
    rotate <-180.0, 6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH61->MkubH0
    MkubH0
    rotate <-180.0, 3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH60->MkubH0
    MkubH0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH59->MkubH0
    MkubH0
    rotate <-180.0, -3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH58->MkubH0
    MkubH0
    rotate <-180.0, -6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH57->MkubH0
    MkubH0
    rotate <-180.0, -9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH56->MkubH0
    MkubH0
    rotate <-180.0, -12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH55->MkubH0
    MkubH0
    rotate <-180.0, -15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH54->MkubH0
    MkubH0
    rotate <-180.0, -18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH53->MkubH0
    MkubH0
    rotate <-180.0, -21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH52->MkubH0
    MkubH0
    rotate <-180.0, -24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH51->MkubH0
    MkubH0
    rotate <-180.0, -27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH50->MkubH0
    MkubH0
    rotate <-180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH49->MkubH0
    MkubH0
    rotate <-180.0, -33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH48->MkubH0
    MkubH0
    rotate <-180.0, -36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH47->MkubH0
    MkubH0
    rotate <-180.0, -39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH46->MkubH0
    MkubH0
    rotate <-180.0, -42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH45->MkubH0
    MkubH0
    rotate <-180.0, -45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH44->MkubH0
    MkubH0
    rotate <-180.0, -48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH43->MkubH0
    MkubH0
    rotate <-180.0, -51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH42->MkubH0
    MkubH0
    rotate <-180.0, -54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH41->MkubH0
    MkubH0
    rotate <-180.0, -57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH40->MkubH0
    MkubH0
    rotate <-180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH39->MkubH0
    MkubH0
    rotate <-180.0, -63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH38->MkubH0
    MkubH0
    rotate <-180.0, -66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH37->MkubH0
    MkubH0
    rotate <-180.0, -69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH36->MkubH0
    MkubH0
    rotate <-180.0, -72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH35->MkubH0
    MkubH0
    rotate <-180.0, -75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH34->MkubH0
    MkubH0
    rotate <-180.0, -78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH33->MkubH0
    MkubH0
    rotate <-180.0, -81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH32->MkubH0
    MkubH0
    rotate <-180.0, -84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH31->MkubH0
    MkubH0
    rotate <-180.0, -87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH30->MkubH0
    MkubH0
    rotate <0.0, -90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH29->MkubH0
    MkubH0
    rotate <0.0, -87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH28->MkubH0
    MkubH0
    rotate <0.0, -84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH27->MkubH0
    MkubH0
    rotate <0.0, -81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH26->MkubH0
    MkubH0
    rotate <0.0, -78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH25->MkubH0
    MkubH0
    rotate <0.0, -75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH24->MkubH0
    MkubH0
    rotate <0.0, -72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH23->MkubH0
    MkubH0
    rotate <0.0, -69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH22->MkubH0
    MkubH0
    rotate <0.0, -66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH21->MkubH0
    MkubH0
    rotate <0.0, -63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH20->MkubH0
    MkubH0
    rotate <0.0, -60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH19->MkubH0
    MkubH0
    rotate <0.0, -57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH18->MkubH0
    MkubH0
    rotate <0.0, -54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH17->MkubH0
    MkubH0
    rotate <0.0, -51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH16->MkubH0
    MkubH0
    rotate <0.0, -48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH15->MkubH0
    MkubH0
    rotate <0.0, -45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH14->MkubH0
    MkubH0
    rotate <0.0, -42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH13->MkubH0
    MkubH0
    rotate <0.0, -39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH12->MkubH0
    MkubH0
    rotate <0.0, -36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH11->MkubH0
    MkubH0
    rotate <0.0, -33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH10->MkubH0
    MkubH0
    rotate <0.0, -30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH9->MkubH0
    MkubH0
    rotate <0.0, -27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH8->MkubH0
    MkubH0
    rotate <0.0, -24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH7->MkubH0
    MkubH0
    rotate <0.0, -21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH6->MkubH0
    MkubH0
    rotate <0.0, -18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH5->MkubH0
    MkubH0
    rotate <0.0, -15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH4->MkubH0
    MkubH0
    rotate <0.0, -12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH3->MkubH0
    MkubH0
    rotate <0.0, -9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH2->MkubH0
    MkubH0
    rotate <0.0, -6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubH1->MkubH0
    MkubH0
    rotate <0.0, -3.0, 0.0>
    translate  0.0*y
  }
  object { MkubHH0 }
  torus { // TireStringVU
    1.5, 0.01  rotate -x*90
    texture {
      TireTex
    }
    scale 10.22
    rotate -90.0*x
    translate  -0.912553*y
  }
  object { // MkubHH117->MkubHH0
    MkubHH0
    rotate <0.0, 9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH116->MkubHH0
    MkubHH0
    rotate <0.0, 12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH115->MkubHH0
    MkubHH0
    rotate <0.0, 15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH114->MkubHH0
    MkubHH0
    rotate <0.0, 18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH113->MkubHH0
    MkubHH0
    rotate <0.0, 21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH112->MkubHH0
    MkubHH0
    rotate <0.0, 24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH111->MkubHH0
    MkubHH0
    rotate <0.0, 27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH110->MkubHH0
    MkubHH0
    rotate <0.0, 30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH109->MkubHH0
    MkubHH0
    rotate <0.0, 33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH108->MkubHH0
    MkubHH0
    rotate <0.0, 36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH107->MkubHH0
    MkubHH0
    rotate <0.0, 39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH106->MkubHH0
    MkubHH0
    rotate <0.0, 42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH105->MkubHH0
    MkubHH0
    rotate <0.0, 45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH104->MkubHH0
    MkubHH0
    rotate <0.0, 48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH103->MkubHH0
    MkubHH0
    rotate <0.0, 51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH102->MkubHH0
    MkubHH0
    rotate <0.0, 54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH101->MkubHH0
    MkubHH0
    rotate <0.0, 57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH100->MkubHH0
    MkubHH0
    rotate <0.0, 60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH99->MkubHH0
    MkubHH0
    rotate <0.0, 63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH98->MkubHH0
    MkubHH0
    rotate <0.0, 66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH97->MkubHH0
    MkubHH0
    rotate <0.0, 69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH96->MkubHH0
    MkubHH0
    rotate <0.0, 72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH95->MkubHH0
    MkubHH0
    rotate <0.0, 75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH94->MkubHH0
    MkubHH0
    rotate <0.0, 78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH93->MkubHH0
    MkubHH0
    rotate <0.0, 81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH92->MkubHH0
    MkubHH0
    rotate <0.0, 84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH91->MkubHH0
    MkubHH0
    rotate <0.0, 87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH90->MkubHH0
    MkubHH0
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH89->MkubHH0
    MkubHH0
    rotate <-180.0, 87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH88->MkubHH0
    MkubHH0
    rotate <-180.0, 84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH87->MkubHH0
    MkubHH0
    rotate <-180.0, 81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH86->MkubHH0
    MkubHH0
    rotate <-180.0, 78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH85->MkubHH0
    MkubHH0
    rotate <-180.0, 75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH84->MkubHH0
    MkubHH0
    rotate <-180.0, 72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH83->MkubHH0
    MkubHH0
    rotate <-180.0, 69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH82->MkubHH0
    MkubHH0
    rotate <-180.0, 66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH81->MkubHH0
    MkubHH0
    rotate <-180.0, 63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH80->MkubHH0
    MkubHH0
    rotate <-180.0, 60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH79->MkubHH0
    MkubHH0
    rotate <-180.0, 57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH78->MkubHH0
    MkubHH0
    rotate <-180.0, 54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH77->MkubHH0
    MkubHH0
    rotate <-180.0, 51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH76->MkubHH0
    MkubHH0
    rotate <-180.0, 48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH75->MkubHH0
    MkubHH0
    rotate <-180.0, 45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH74->MkubHH0
    MkubHH0
    rotate <-180.0, 42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH73->MkubHH0
    MkubHH0
    rotate <-180.0, 39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH72->MkubHH0
    MkubHH0
    rotate <-180.0, 36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH71->MkubHH0
    MkubHH0
    rotate <-180.0, 33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH70->MkubHH0
    MkubHH0
    rotate <-180.0, 30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH69->MkubHH0
    MkubHH0
    rotate <-180.0, 27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH68->MkubHH0
    MkubHH0
    rotate <-180.0, 24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH67->MkubHH0
    MkubHH0
    rotate <-180.0, 21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH66->MkubHH0
    MkubHH0
    rotate <-180.0, 18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH65->MkubHH0
    MkubHH0
    rotate <-180.0, 15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH64->MkubHH0
    MkubHH0
    rotate <-180.0, 12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH63->MkubHH0
    MkubHH0
    rotate <-180.0, 9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH62->MkubHH0
    MkubHH0
    rotate <-180.0, 6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH61->MkubHH0
    MkubHH0
    rotate <-180.0, 3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH60->MkubHH0
    MkubHH0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH59->MkubHH0
    MkubHH0
    rotate <-180.0, -3.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH58->MkubHH0
    MkubHH0
    rotate <-180.0, -6.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH57->MkubHH0
    MkubHH0
    rotate <-180.0, -9.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH56->MkubHH0
    MkubHH0
    rotate <-180.0, -12.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH55->MkubHH0
    MkubHH0
    rotate <-180.0, -15.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH54->MkubHH0
    MkubHH0
    rotate <-180.0, -18.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH53->MkubHH0
    MkubHH0
    rotate <-180.0, -21.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH52->MkubHH0
    MkubHH0
    rotate <-180.0, -24.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH51->MkubHH0
    MkubHH0
    rotate <-180.0, -27.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH50->MkubHH0
    MkubHH0
    rotate <-180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH49->MkubHH0
    MkubHH0
    rotate <-180.0, -33.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH48->MkubHH0
    MkubHH0
    rotate <-180.0, -36.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH47->MkubHH0
    MkubHH0
    rotate <-180.0, -39.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH46->MkubHH0
    MkubHH0
    rotate <-180.0, -42.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH45->MkubHH0
    MkubHH0
    rotate <-180.0, -45.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH44->MkubHH0
    MkubHH0
    rotate <-180.0, -48.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH43->MkubHH0
    MkubHH0
    rotate <-180.0, -51.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH42->MkubHH0
    MkubHH0
    rotate <-180.0, -54.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH41->MkubHH0
    MkubHH0
    rotate <-180.0, -57.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH40->MkubHH0
    MkubHH0
    rotate <-180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH39->MkubHH0
    MkubHH0
    rotate <-180.0, -63.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH38->MkubHH0
    MkubHH0
    rotate <-180.0, -66.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH37->MkubHH0
    MkubHH0
    rotate <-180.0, -69.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH36->MkubHH0
    MkubHH0
    rotate <-180.0, -72.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH35->MkubHH0
    MkubHH0
    rotate <-180.0, -75.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH34->MkubHH0
    MkubHH0
    rotate <-180.0, -78.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH33->MkubHH0
    MkubHH0
    rotate <-180.0, -81.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH32->MkubHH0
    MkubHH0
    rotate <-180.0, -84.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH31->MkubHH0
    MkubHH0
    rotate <-180.0, -87.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH30->MkubHH0
    MkubHH0
    rotate <0.0, -90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH29->MkubHH0
    MkubHH0
    rotate <0.0, -87.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH28->MkubHH0
    MkubHH0
    rotate <0.0, -84.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH27->MkubHH0
    MkubHH0
    rotate <0.0, -81.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH26->MkubHH0
    MkubHH0
    rotate <0.0, -78.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH25->MkubHH0
    MkubHH0
    rotate <0.0, -75.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH24->MkubHH0
    MkubHH0
    rotate <0.0, -72.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH23->MkubHH0
    MkubHH0
    rotate <0.0, -69.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH22->MkubHH0
    MkubHH0
    rotate <0.0, -66.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH21->MkubHH0
    MkubHH0
    rotate <0.0, -63.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH20->MkubHH0
    MkubHH0
    rotate <0.0, -60.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH19->MkubHH0
    MkubHH0
    rotate <0.0, -57.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH18->MkubHH0
    MkubHH0
    rotate <0.0, -54.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH17->MkubHH0
    MkubHH0
    rotate <0.0, -51.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH16->MkubHH0
    MkubHH0
    rotate <0.0, -48.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH15->MkubHH0
    MkubHH0
    rotate <0.0, -45.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH14->MkubHH0
    MkubHH0
    rotate <0.0, -42.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH13->MkubHH0
    MkubHH0
    rotate <0.0, -39.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH12->MkubHH0
    MkubHH0
    rotate <0.0, -36.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH11->MkubHH0
    MkubHH0
    rotate <0.0, -33.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH10->MkubHH0
    MkubHH0
    rotate <0.0, -30.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH9->MkubHH0
    MkubHH0
    rotate <0.0, -27.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH8->MkubHH0
    MkubHH0
    rotate <0.0, -24.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH7->MkubHH0
    MkubHH0
    rotate <0.0, -21.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH6->MkubHH0
    MkubHH0
    rotate <0.0, -18.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH5->MkubHH0
    MkubHH0
    rotate <0.0, -15.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH4->MkubHH0
    MkubHH0
    rotate <0.0, -12.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH3->MkubHH0
    MkubHH0
    rotate <0.0, -9.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH2->MkubHH0
    MkubHH0
    rotate <0.0, -6.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // MkubHH1->MkubHH0
    MkubHH0
    rotate <0.0, -3.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
}
#declare HandtagGrund = intersection {
  sphere { // HandtagGrundS
    <0,0,0>,1
    scale <6.669631, 0.829588, 0.822423>
    translate  <10.79016, -9.344002, 33.38134>
  }
  box { // HandtagCut
    <-1, -1, -1>, <1, 1, 1>
    scale <3.693031, 1.528158, 1.055045>
    translate  <10.777753, -9.287123, 33.327087>
  }
  translate  <-53.802368, 9.343511, -33.382015>
}
#declare Handtaget = difference {
  object { HandtagGrund }
  torus { // HTcutT1
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-46.43903, 0.0, -0.0006>
  }
  torus { // HTcutT2
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-46.349842, 0.000716, -0.0006>
  }
  torus { // HTcutT3
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-46.2598, 0.000716, -0.0006>
  }
  torus { // HTcutT4
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-46.16092, 0.000716, -0.0006>
  }
  torus { // HTcutT5
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-46.058343, 0.000716, -0.0006>
  }
  torus { // HTcutT6
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-43.229954, 0.000716, -0.0006>
  }
  torus { // HTcutT7
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-43.117736, 0.000716, -0.0006>
  }
  torus { // HTcutT8
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-43.006539, 0.000716, -0.0006>
  }
  torus { // HTcutT9
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-42.8993, 0.000716, -0.0006>
  }
  torus { // HTcutT10
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-42.792061, 0.000716, -0.0006>
  }
  torus { // HTcutT11
    1.5, 0.05  rotate -x*90
    scale <0.46, 0.46, 0.618257>
    rotate -90.0*y
    translate  <-39.514434, 0.0, -0.0006>
  }
  torus { // HTcutT12
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-39.601606, 0.000716, -0.0006>
  }
  torus { // HTcutT13
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-39.69815, 0.000716, -0.0006>
  }
  torus { // HTcutT14
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-39.789665, 0.000716, -0.0006>
  }
  torus { // HTcutT15
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-39.872846, 0.000716, -0.0006>
  }
  object { HTcutTvars1 }
  object { // HTcutTvars2->HTcutTvars1
    HTcutTvars1
    rotate -10.0*x
  }
  object { // HTcutTvars3->HTcutTvars1
    HTcutTvars1
    rotate -20.0*x
    translate  0.0*z
  }
  object { // HTcutTvars4->HTcutTvars1
    HTcutTvars1
    rotate -30.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars5->HTcutTvars1
    HTcutTvars1
    rotate -40.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars6->HTcutTvars1
    HTcutTvars1
    rotate -50.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars7->HTcutTvars1
    HTcutTvars1
    rotate -60.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars8->HTcutTvars1
    HTcutTvars1
    rotate -70.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars9->HTcutTvars1
    HTcutTvars1
    rotate -80.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars10->HTcutTvars1
    HTcutTvars1
    rotate -90.0*x
    translate  0.0*z
  }
  object { // HTcutTvars11->HTcutTvars1
    HTcutTvars1
    rotate -100.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars12->HTcutTvars1
    HTcutTvars1
    rotate -110.0*x
    translate  0.0*y
  }
  object { // HTcutTvars13->HTcutTvars1
    HTcutTvars1
    rotate -120.0*x
    translate  0.0*z
  }
  object { // HTcutTvars14->HTcutTvars1
    HTcutTvars1
    rotate -130.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars15->HTcutTvars1
    HTcutTvars1
    rotate -140.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars16->HTcutTvars1
    HTcutTvars1
    rotate -150.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars17->HTcutTvars1
    HTcutTvars1
    rotate -160.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars18->HTcutTvars1
    HTcutTvars1
    rotate -170.0*x
    translate  0.0*y
  }
  object { // HTcutTvars19->HTcutTvars1
    HTcutTvars1
    rotate 180.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars20->HTcutTvars1
    HTcutTvars1
    rotate 170.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars21->HTcutTvars1
    HTcutTvars1
    rotate 160.0*x
    translate  0.0*z
  }
  object { // HTcutTvars22->HTcutTvars1
    HTcutTvars1
    rotate 150.0*x
    translate  0.0*z
  }
  object { // HTcutTvars23->HTcutTvars1
    HTcutTvars1
    rotate 140.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars24->HTcutTvars1
    HTcutTvars1
    rotate 130.0*x
    translate  0.0*y
  }
  object { // HTcutTvars25->HTcutTvars1
    HTcutTvars1
    rotate 120.0*x
    translate  0.0*y
  }
  object { // HTcutTvars26->HTcutTvars1
    HTcutTvars1
    rotate 110.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars27->HTcutTvars1
    HTcutTvars1
    rotate 100.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars28->HTcutTvars1
    HTcutTvars1
    rotate 90.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars29->HTcutTvars1
    HTcutTvars1
    rotate 80.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars30->HTcutTvars1
    HTcutTvars1
    rotate 70.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars31->HTcutTvars1
    HTcutTvars1
    rotate 60.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars32->HTcutTvars1
    HTcutTvars1
    rotate 50.0*x
  }
  object { // HTcutTvars33->HTcutTvars1
    HTcutTvars1
    rotate 40.0*x
    translate  0.0*z
  }
  object { // HTcutTvars34->HTcutTvars1
    HTcutTvars1
    rotate 30.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars35->HTcutTvars1
    HTcutTvars1
    rotate 20.0*x
    translate  0.0*z
  }
  object { // HTcutTvars36->HTcutTvars1
    HTcutTvars1
    rotate 10.0*x
    translate  0.0*z
  }
  texture {
    Vit
  }
  scale <0.75, 0.8, 0.8>
  rotate <-0.008574, -0.071598, -15.750146>
  translate  <42.591782, -18.598817, 33.505246>
}
#declare HandtagGrund1 = intersection {
  sphere { // HandtagGrundS1
    <0,0,0>,1
    scale <6.669631, 0.829588, 0.822423>
    translate  <10.79016, -9.344002, 33.38134>
  }
  box { // HandtagCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.693031, 1.528158, 1.055045>
    translate  <10.777753, -9.287123, 33.327087>
  }
  translate  <-53.802368, 9.343511, -33.382015>
}
#declare Handtaget1 = difference {
  object { HandtagGrund1 }
  torus { // HTcutT16
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-46.43903, 0.0, -0.0006>
  }
  torus { // HTcutT17
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-46.349842, 0.000716, -0.0006>
  }
  torus { // HTcutT18
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-46.2598, 0.000716, -0.0006>
  }
  torus { // HTcutT19
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-46.16092, 0.000716, -0.0006>
  }
  torus { // HTcutT20
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-46.058343, 0.000716, -0.0006>
  }
  torus { // HTcutT21
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-43.229954, 0.000716, -0.0006>
  }
  torus { // HTcutT22
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-43.117736, 0.000716, -0.0006>
  }
  torus { // HTcutT23
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-43.006539, 0.000716, -0.0006>
  }
  torus { // HTcutT24
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-42.8993, 0.000716, -0.0006>
  }
  torus { // HTcutT25
    1.5, 0.05  rotate -x*90
    scale <0.54, 0.54, 0.618257>
    rotate -90.0*y
    translate  <-42.792061, 0.000716, -0.0006>
  }
  torus { // HTcutT26
    1.5, 0.05  rotate -x*90
    scale <0.46, 0.46, 0.618257>
    rotate -90.0*y
    translate  <-39.514434, 0.0, -0.0006>
  }
  torus { // HTcutT27
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-39.601606, 0.000716, -0.0006>
  }
  torus { // HTcutT28
    1.5, 0.05  rotate -x*90
    scale <0.47, 0.47, 0.618257>
    rotate -90.0*y
    translate  <-39.69815, 0.000716, -0.0006>
  }
  torus { // HTcutT29
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-39.789665, 0.000716, -0.0006>
  }
  torus { // HTcutT30
    1.5, 0.05  rotate -x*90
    scale <0.48, 0.48, 0.618257>
    rotate -90.0*y
    translate  <-39.872846, 0.000716, -0.0006>
  }
  torus { // HTcutTvars37
    1.5, 0.05  rotate -x*90
    scale <4.219863, 0.545522, 1.0>
    translate  <-43.022706, 0.002758, -0.001052>
  }
  object { // HTcutTvars38->HTcutTvars1
    HTcutTvars1
    rotate -10.0*x
  }
  object { // HTcutTvars39->HTcutTvars1
    HTcutTvars1
    rotate -20.0*x
    translate  0.0*z
  }
  object { // HTcutTvars40->HTcutTvars1
    HTcutTvars1
    rotate -30.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars41->HTcutTvars1
    HTcutTvars1
    rotate -40.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars42->HTcutTvars1
    HTcutTvars1
    rotate -50.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars43->HTcutTvars1
    HTcutTvars1
    rotate -60.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars44->HTcutTvars1
    HTcutTvars1
    rotate -70.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars45->HTcutTvars1
    HTcutTvars1
    rotate -80.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars46->HTcutTvars1
    HTcutTvars1
    rotate -90.0*x
    translate  0.0*z
  }
  object { // HTcutTvars47->HTcutTvars1
    HTcutTvars1
    rotate -100.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars48->HTcutTvars1
    HTcutTvars1
    rotate -110.0*x
    translate  0.0*y
  }
  object { // HTcutTvars49->HTcutTvars1
    HTcutTvars1
    rotate -120.0*x
    translate  0.0*z
  }
  object { // HTcutTvars50->HTcutTvars1
    HTcutTvars1
    rotate -130.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars51->HTcutTvars1
    HTcutTvars1
    rotate -140.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars52->HTcutTvars1
    HTcutTvars1
    rotate -150.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars53->HTcutTvars1
    HTcutTvars1
    rotate -160.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars54->HTcutTvars1
    HTcutTvars1
    rotate -170.0*x
    translate  0.0*y
  }
  object { // HTcutTvars55->HTcutTvars1
    HTcutTvars1
    rotate 180.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars56->HTcutTvars1
    HTcutTvars1
    rotate 170.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars57->HTcutTvars1
    HTcutTvars1
    rotate 160.0*x
    translate  0.0*z
  }
  object { // HTcutTvars58->HTcutTvars1
    HTcutTvars1
    rotate 150.0*x
    translate  0.0*z
  }
  object { // HTcutTvars59->HTcutTvars1
    HTcutTvars1
    rotate 140.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars60->HTcutTvars1
    HTcutTvars1
    rotate 130.0*x
    translate  0.0*y
  }
  object { // HTcutTvars61->HTcutTvars1
    HTcutTvars1
    rotate 120.0*x
    translate  0.0*y
  }
  object { // HTcutTvars62->HTcutTvars1
    HTcutTvars1
    rotate 110.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars63->HTcutTvars1
    HTcutTvars1
    rotate 100.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars64->HTcutTvars1
    HTcutTvars1
    rotate 90.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars65->HTcutTvars1
    HTcutTvars1
    rotate 80.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars66->HTcutTvars1
    HTcutTvars1
    rotate 70.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars67->HTcutTvars1
    HTcutTvars1
    rotate 60.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars68->HTcutTvars1
    HTcutTvars1
    rotate 50.0*x
  }
  object { // HTcutTvars69->HTcutTvars1
    HTcutTvars1
    rotate 40.0*x
    translate  0.0*z
  }
  object { // HTcutTvars70->HTcutTvars1
    HTcutTvars1
    rotate 30.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // HTcutTvars71->HTcutTvars1
    HTcutTvars1
    rotate 20.0*x
    translate  0.0*z
  }
  object { // HTcutTvars72->HTcutTvars1
    HTcutTvars1
    rotate 10.0*x
    translate  0.0*z
  }
  texture {
    Vit
  }
  scale <0.75, 0.8, 0.8>
  rotate <-1.395376, -2.266533, 14.170719>
  translate  <43.544925, 17.772549, 34.914192>
}
#declare CSG002 = difference {
  cylinder { // GaffelCyl3
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.696422, 0.6, 0.15>
    rotate <90.0, -10.329189, 0.0>
    translate  <-0.01262, 1.56413, -0.045545>
  }
  box { // Cut3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.066163, 0.249333, 0.136162>
    rotate <0.0, -24.55344, 0.0>
    translate  <-0.951389, 1.561698, -0.469018>
  }
  texture {
    CykelTex
  }
}
#declare KlockaTopp = difference {
  sphere { // KlockaTopp1
    <0,0,0>,1
    scale <1.2, 1.2, 0.8>
  }
  box { // KlockaToppCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.65535, 1.369676, 1.031251>
    rotate <-3.095533, -5.52213, 8.305959>
    translate  <-0.140443, 0.094536, -1.211301>
  }
  object { SnoffsCut1 }
  object { // SnoffsCut2->SnoffsCut1
    SnoffsCut1
    rotate -60.0*z
  }
  object { // SnoffsCut3->SnoffsCut1
    SnoffsCut1
    rotate -120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // SnoffsCut4->SnoffsCut1
    SnoffsCut1
    rotate 180.0*z
    translate  0.0*y
  }
  object { // SnoffsCut5->SnoffsCut1
    SnoffsCut1
    rotate 120.0*z
  }
  object { // SnoffsCut6->SnoffsCut1
    SnoffsCut1
    rotate 60.0*z
    translate  0.0*x
  }
  texture {
    EkerTex
  }
  rotate <-26.545639, 14.391707, 0.0>
  translate  <5.884131, -6.21393, 32.962515>
}
#declare KlockaUnder = intersection {
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    scale 0.594782
    rotate <-26.505415, 14.287029, 0.0>
    translate  <5.876259, -6.294998, 32.755216>
  }
  box { // CutUnder
    <-1, -1, -1>, <1, 1, 1>
    scale <1.9, 1.816397, 1.351532>
    rotate <-28.270948, 14.72948, 2.024145>
    translate  <5.907724, -6.769087, 31.475567>
  }
  texture {
    EkerTex
  }
  translate  <0.0, -0.11296, -0.163165>
}
#declare Ringklockan = union {
  object { KlockaTopp }
  sphere { // Skruvas
    <0,0,0>,1
    texture {
      EkerTex
    }
    scale 0.2
    translate  <6.104707, -5.800735, 33.627166>
  }
  object { KlockaUnder }
  cylinder { // Cylindras
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <1.0, 0.737414, 0.220712>
    rotate <-27.397936, 14.404218, 9.46657>
    translate  <5.837233, -6.563534, 32.384338>
  }
  cylinder { // Skruvas2
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.124824, 0.127971, 1.04015>
    rotate <-29.366678, 15.712582, -7.38284>
    translate  <5.701122, -6.479772, 32.441291>
  }
  rotate -1.878973*x
  translate  <0.239178, -0.548747, 0.240517>
}
#declare KlockKddd = difference {
  cylinder { // KlockKGrund
    <0,0,1>, <0,0,0>, 1
    scale <0.700452, 0.691713, 0.804091>
    rotate <58.566101, 20.731867, 0.0>
    translate  <5.445976, -6.24188, 31.90887>
  }
  cylinder { // KlockKCut1
    <0,0,1>, <0,0,0>, 1
    scale <0.676167, 0.602859, 1.007634>
    rotate <58.647823, 20.34536, -2.071319>
    translate  <5.501519, -6.163284, 31.915333>
  }
  box { // KlockKCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.904042, 0.112389>
    rotate <-27.455458, 15.925435, 18.358088>
    translate  <5.575183, -6.711748, 32.246598>
  }
  texture {
    EkerTex
  }
  rotate -0.141925*x
}
#declare KlockMutter1 = intersection {
  box { // NavMutterBas10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  rotate <-118.535027, 5.474665, 0.0>
  translate  <4.653085, -7.08437, 31.428344>
}
#declare KlockaSkruv1 = difference {
  cylinder { // StangSkruvCyl7
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.749816, -0.392919>
  }
  box { // StangSkruvCut7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.907007, -0.404223>
  }
  texture {
    EkerTex
  }
  rotate <-113.623329, -29.338047, -79.088127>
  translate  <4.461516, -6.902985, 30.380652>
}
#declare KlockMutter2 = intersection {
  box { // NavMutterBas11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  rotate <-118.535027, 5.474665, 0.0>
  translate  <6.360216, -6.733927, 31.231678>
}
#declare KlockaSkruv2 = difference {
  cylinder { // StangSkruvCyl8
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.749816, -0.392919>
  }
  box { // StangSkruvCut8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.907007, -0.404223>
  }
  texture {
    EkerTex
  }
  rotate <-113.623329, -29.338047, -79.088127>
  translate  <6.157462, -6.525452, 30.231033>
}
#declare GenMutter4 = intersection {
  box { // NavMutterBas7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  translate  <6.934858, 3.152186, 11.741195>
}
#declare GenMutter3 = intersection {
  box { // NavMutterBas6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  translate  <6.937438, 3.590067, 11.738817>
}
#declare GenMutter2 = intersection {
  box { // NavMutterBas5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  translate  <5.059521, 3.14795, 11.86625>
}
#declare GenMutter1 = intersection {
  box { // NavMutterBas4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale 0.4
  translate  <5.059521, 3.583249, 11.855047>
}
#declare GenKlammaCent = difference {
  cylinder { // GenKlammaCyl
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.656749, 0.475662, 1.034025>
    rotate <-2.287865, 5.067429, -0.109219>
    translate  <5.974298, 2.616838, 11.288769>
  }
  box { // GenKlammaCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.066603, 0.199829, 0.923299>
    rotate <-1.886416, 3.686585, -0.102896>
    translate  <5.841858, 2.636466, 11.802328>
  }
  texture {
    EkerTex
  }
}
#declare GeneratorKlamma = union {
  cylinder { // GenGangor2
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.06, 0.06, 0.662657>
    rotate <-90.000809, 0.0, 0.0>
    translate  <6.919824, 2.276961, 11.741477>
  }
  object { GenMutter4 }
  object { GenMutter3 }
  box { // GenKlammBV
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.559416, 0.013236, 0.481574>
    rotate <-2.532214, 3.832071, 0.211377>
    translate  <6.663632, 2.830601, 11.741125>
  }
  box { // GenKlammBH
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.559416, 0.013236, 0.481574>
    rotate <-2.532214, 3.832071, 0.211377>
    translate  <6.655752, 2.427048, 11.741787>
  }
  cylinder { // GenGangor1
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.06, 0.06, 0.662657>
    rotate <-90.000809, 0.0, 0.0>
    translate  <5.045292, 2.266733, 11.863101>
  }
  object { GenMutter2 }
  object { GenMutter1 }
  box { // GenKlammFV
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.559416, 0.013236, 0.481574>
    rotate <-2.532214, 3.832071, 0.211377>
    translate  <5.149431, 2.830601, 11.86303>
  }
  box { // GenKlammFH
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.559416, 0.013236, 0.481574>
    rotate <-3.220552, 4.962573, 0.314798>
    translate  <5.19276, 2.423598, 11.879354>
  }
  object { GenKlammaCent }
  translate  <-0.212192, -0.590737, -2.267643>
}
#declare GenTurnddd1 = difference {
  cylinder { // GenTurnB1
    <0,0,1>, <0,0,0>, 1
    scale <1.496868, 1.824603, 0.1>
    rotate <-92.0439, 0.0, 0.0>
    translate  <4.350309, 2.706511, 11.005536>
  }
  cylinder { // GenTurnCutC1
    <0,0,1>, <0,0,0>, 1
    scale <0.720291, 1.170241, 0.353202>
    rotate <-93.250099, 0.0, 0.0>
    translate  <4.358335, 2.606525, 11.155115>
  }
  translate  <0.102588, 0.0, 0.042218>
}
#declare GenTurnddd = difference {
  cylinder { // GenTurnB
    <0,0,1>, <0,0,0>, 1
    scale <1.496868, 1.824603, 0.1>
    rotate <-92.0439, 0.0, 0.0>
    translate  <4.350309, 2.706511, 11.005536>
  }
  cylinder { // GenTurnCutC
    <0,0,1>, <0,0,0>, 1
    scale <0.593224, 1.097748, 0.349086>
    rotate <-93.250099, 0.0, 0.0>
    translate  <4.467249, 2.606525, 11.236801>
  }
  object { GenTurnddd1 }
}
#declare GenTurn = intersection {
  object { GenTurnddd }
  box { // GenTurnCutB
    <-1, -1, -1>, <1, 1, 1>
    rotate 5.580261*y
    translate  <3.482377, 2.647822, 10.248521>
  }
  texture {
    EkerTex
  }
  rotate 8.558399*z
  translate  <0.432325, -1.127107, 0.010751>
}
#declare TurnMutter = intersection {
  box { // NavMutterBas12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.131705, 0.4>
    translate  <-0.030294, -1.872011, 0.0>
  }
  box { // NavMutterCut12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.3, 0.4>
    rotate -45.0*y
    translate  <-0.050094, -1.853825, 0.0>
  }
  texture {
    EkerTex
  }
  scale <0.5, 0.4, 0.5>
  rotate <0.0, -36.207138, 6.65344>
  translate  <3.350865, 2.60023, 10.845433>
}
// Include contains 'GenBox'
#include "school2.in4"

#declare GenBox = object {
  GenBox_Raw
  texture {
    EkerTex
  }
  scale <0.69613, 0.668519, 1.19857>
  rotate <0.0, -84.423477, 0.0>
  translate  <3.197203, 2.482088, 11.921384>
}
#declare SkarmSlutU1 = intersection {
  torus { // SkarmSlutUT
    1.5, 0.1  rotate -x*90
    texture {
      CykelTex
    }
    scale <1.25, 1.2, 1.25>
    rotate 67.110001*y
    translate  <-2.17288, 0.001802, 14.723487>
  }
  box { // SkarmSlutUC
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CykelTex
    }
    scale <1.044688, 1.690152, 1.441378>
    rotate -22.160727*y
    translate  <-2.941854, -0.00477, 17.289687>
  }
  texture {
    EkerTex
  }
  scale <1.0, 0.972843, 1.0>
  translate  <0.11952, 0.0, 0.15936>
}
#declare SkarmSlutU = union {
  object { SkarmSlutU1 }
  cylinder { // SkarmSlutUC1
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.127664, 0.141235, 1.0>
    rotate <-3.053499, -22.905481, 0.113453>
    translate  <-2.144616, -1.357485, 15.093886>
  }
  sphere { // SkarmSlutS1
    <0,0,0>,1
    texture {
      CykelTex
    }
    scale <0.128887, 0.141537, 0.123316>
    rotate <-3.855821, -22.75074, 1.522912>
    translate  <-2.14664, -1.357659, 15.09009>
  }
  cylinder { // SkarmSlutUC2
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.128013, 0.137519, 1.097339>
    rotate <2.909193, -22.844255, -0.368895>
    translate  <-2.107745, 1.357136, 15.003224>
  }
  sphere { // SkarmSlutS2
    <0,0,0>,1
    texture {
      CykelTex
    }
    scale <0.132771, 0.139872, 0.129132>
    rotate <2.372597, -22.699383, -0.889613>
    translate  <-2.103692, 1.357776, 15.004653>
  }
}
#declare SkarmSlutU2 = intersection {
  torus { // SkarmSlutUT1
    1.5, 0.1  rotate -x*90
    texture {
      CykelTex
    }
    scale <1.25, 1.2, 1.25>
    rotate 67.110001*y
    translate  <-2.17288, 0.001802, 14.723487>
  }
  box { // SkarmSlutUC3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CykelTex
    }
    scale <1.044688, 1.690152, 1.441378>
    rotate -22.160727*y
    translate  <-2.941854, -0.00477, 17.289687>
  }
  texture {
    EkerTex
  }
  scale <1.0, 0.972843, 1.0>
  translate  <0.11952, 0.0, 0.15936>
}
#declare SkarmSlutN = union {
  object { SkarmSlutU2 }
  cylinder { // SkarmSlutUC4
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.127664, 0.141235, 1.0>
    rotate <-3.053499, -22.905481, 0.113453>
    translate  <-2.144616, -1.357485, 15.093886>
  }
  sphere { // SkarmSlutS3
    <0,0,0>,1
    texture {
      CykelTex
    }
    scale <0.128887, 0.141537, 0.123316>
    rotate <-3.855821, -22.75074, 1.522912>
    translate  <-2.14664, -1.357659, 15.09009>
  }
  cylinder { // SkarmSlutUC5
    <0,0,1>, <0,0,0>, 1
    texture {
      CykelTex
    }
    scale <0.128013, 0.137519, 1.097339>
    rotate <2.909193, -22.844255, -0.368895>
    translate  <-2.107745, 1.357136, 15.003224>
  }
  sphere { // SkarmSlutS4
    <0,0,0>,1
    texture {
      CykelTex
    }
    scale <0.132771, 0.139872, 0.129132>
    rotate <2.372597, -22.699383, -0.889613>
    translate  <-2.103692, 1.357776, 15.004653>
  }
  rotate <-180.0, 22.778561, -180.0>
  translate  <5.165421, -0.040868, 4.978111>
}
#declare SkarmStang1 = intersection {
  torus { // StangTorus1
    1.5, 0.09  rotate -x*90
    scale <11.219849, 0.765547, 1.014371>
    rotate <0.294749, 22.624805, 0.436312>
    translate  <0.108247, -0.881848, -0.3017>
  }
  box { // StangCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <7.75546, 2.302999, 1.131135>
    rotate <-0.742819, 22.67058, -5.769085>
    translate  <7.622231, -2.652816, -3.140061>
  }
  texture {
    EkerTex
  }
  rotate <0.0, -16.761799, -0.789223>
  translate  <0.259248, 0.242235, 0.125073>
}
#declare StangSlutet = difference {
  torus { // StangSlut
    1.5, 0.5  rotate -x*90
    scale <0.162872, 0.157026, 0.227349>
    rotate 90.0*x
    translate  <0.769448, -2.036193, -0.393702>
  }
  box { // StangSlutCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.247023, 0.25376, 0.279042>
    translate  <1.056294, -2.008063, -0.057204>
  }
  texture {
    EkerTex
  }
  translate  <-0.048839, 0.217088, 0.001451>
}
#declare StangSkruv = difference {
  cylinder { // StangSkruvCyl
    <0,0,1>, <0,0,0>, 1
    scale <0.144127, 0.141929, 0.161483>
    rotate 90.0*x
    translate  <0.720473, -1.749816, -0.392919>
  }
  box { // StangSkruvCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024887, 0.056427, 0.259233>
    rotate <0.0, -11.324923, 0.0>
    translate  <0.717567, -1.907007, -0.404223>
  }
  texture {
    EkerTex
  }
}
#declare SkarmStangen = union {
  object { SkarmStang1 }
  object { StangSlutet }
  object { StangSkruv }
}
#declare CykelRorlig = union {
  torus { // Tire1
    1.5, 0.1  rotate -x*90
    texture {
      TireTex
    }
    scale 10.0
    rotate -90.0*x
  }
  object { Hjul1 }
  object { Nav1 }
  sphere { // NavMutter1
    <0,0,0>,1
    texture {
      EkerTex
    }
    scale <0.24, 0.98364, 0.24>
    translate  <-0.012449, -1.493954, -0.001448>
  }
  object { Generator }
  object { GaffelnV }
  object { EkrarnaTillVstr }
  object { Ventilen }
  cylinder { // GaffelTopHatt1
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.705868, 0.54039, 1.66751>
    rotate <0.375811, 4.336109, 0.035089>
    translate  <6.356507, -1.979406, 15.65342>
  }
  object { NavMuttern }
  object { EkrarnaTillHgr }
  object { StangSkruvB }
  cylinder { // GaffelTopHatt2
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.6834, 0.503427, 1.686666>
    rotate <-0.886633, 4.322068, -0.046948>
    translate  <6.366781, 1.97323, 15.641906>
  }
  object { GaffelH }
  object { SkarmStang2 }
  box { // SkarmHallarBox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.020974, 0.320178, 0.843388>
    rotate 3.742775*y
    translate  <7.205643, 0.0, 15.772908>
  }
  object { SkarmSkruv1 }
  object { SkarmSkruv2 }
  object { SkarmHallarNere }
  object { SkarmSkruv3 }
  object { Lyktan }
  object { SkurenSkarm }
  object { SkarmVanster }
  object { SkarmHoger }
  object { LampSkruv }
  object { GenMutter5 }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.946486, 0.568692, 0.463853>
    rotate 5.683897*y
    translate  <6.798881, 0.0, 30.052116>
  }
  object { StyrCSG2 }
  object { StyrCSG1 }
  cylinder { // StyrStangGanga
    <0,0,1>, <0,0,0>, 1
    texture {
      GangaTex
    }
    scale <0.14, 0.14, 1.4>
    rotate -3.313786*y
    translate  <4.483865, 0.0, 29.345021>
  }
  object { GenMutter6 }
  object { StyrSkruv }
  object { Styre }
  object { TireMonster }
  object { Handtaget }
  object { Handtaget1 }
  object { CSG002 }
  object { Ringklockan }
  cylinder { // Slut1
    <0,0,1>, <0,0,0>, 1
    texture {
      Vit
    }
    scale <0.7, 0.7, 0.08>
    rotate <-93.205887, -68.243835, 76.694504>
    translate  <8.943203, -9.084088, 33.517216>
  }
  cylinder { // Slut2
    <0,0,1>, <0,0,0>, 1
    texture {
      Vit
    }
    scale <0.7, 0.7, 0.08>
    rotate <-93.023689, -76.784752, 77.356308>
    translate  <14.264264, -10.568293, 33.469104>
  }
  cylinder { // Slut3
    <0,0,1>, <0,0,0>, 1
    texture {
      Vit
    }
    scale <0.7, 0.7, 0.08>
    rotate <73.102577, -83.405052, -61.351883>
    translate  <9.630202, 9.222585, 33.513286>
  }
  cylinder { // Slut4
    <0,0,1>, <0,0,0>, 1
    texture {
      Vit
    }
    scale <0.7, 0.7, 0.08>
    rotate <75.506119, -82.633827, -61.4184>
    translate  <15.048727, 10.579291, 33.732674>
  }
  object { KlockKddd }
  box { // KlockKKub1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.224761, 0.407889, 0.02>
    rotate <-28.086111, 6.845055, 8.580319>
    translate  <4.691183, -6.613533, 32.294163>
  }
  box { // KlockKKub2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.224761, 0.407889, 0.02>
    rotate <-28.086111, 6.845055, 8.580319>
    translate  <4.691183, -6.689504, 32.145075>
  }
  box { // KlockKKub3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.224761, 0.407889, 0.02>
    rotate <-28.086111, 6.845055, 8.580319>
    translate  <6.47198, -6.265001, 32.096933>
  }
  box { // KlockKKub4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.224761, 0.407889, 0.02>
    rotate <-28.086111, 6.845055, 8.580319>
    translate  <6.409821, -6.344479, 31.953714>
  }
  object { KlockMutter1 }
  cylinder { // KlockGanga1
    <0,0,1>, <0,0,0>, 1
    texture {
      GangaTex
    }
    scale <0.05, 0.05, 0.280117>
    rotate <-27.240076, 14.969273, -5.407406>
    translate  <4.715011, -6.747898, 32.014766>
  }
  object { KlockaSkruv1 }
  object { KlockMutter2 }
  object { KlockaSkruv2 }
  object { GeneratorKlamma }
  object { GenTurn }
  object { TurnMutter }
  cylinder { // TurnGanga
    <0,0,1>, <0,0,0>, 1
    texture {
      GangaTex
    }
    scale <0.1, 0.1, 0.500339>
    rotate <-90.0, 0.0, 5.94986>
    translate  <3.451832, 1.584792, 10.828302>
  }
  object { GenBox }
  sphere { // GenAxel
    <0,0,0>,1
    texture {
      EkerTex
    }
    scale 0.3
    translate  <1.7549, 2.022698, 12.031596>
  }
  box { // GenBoxPlatta
    <-1, -1, -1>, <1, 1, 1>
    texture {
      EkerTex
    }
    scale <0.572374, 0.018851, 0.483351>
    rotate <-0.020254, 5.098652, 7.460788>
    translate  <3.513089, 2.077881, 11.642242>
  }
  object { SkarmSlutU }
  object { SkarmSlutN }
  object { SkarmStangen }
  cylinder { // StavStang1
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.5, 0.5, 6.0>
    rotate 5.860619*y
    translate  <7.061745, 0.005643, 23.442546>
  }
  cylinder { // StangToppC
    <0,0,1>, <0,0,0>, 1
    texture {
      EkerTex
    }
    scale <0.7, 0.7, 1.6>
    rotate 5.332968*y
    translate  <7.606978, 0.0, 28.834483>
  }
  rotate <0.941536, -0.703749, 18.966326>
  translate  <0.388574, -1.749648, 0.013289>
}
union { // Cykel
  object { CykelFast }
  object { CykelRorlig }
  rotate 6.0*x
  translate  <29.0, 0.0, -1.0>
}




sphere { // Superklot
  <0,0,0>,1
  texture {
    Rusty_Iron1
  }
  scale 1000.0
}


blob {   // Blob001
  threshold 0.6
  component 1.0, 0.191439, <-0.616034, 0.0, 0.059072>

  component 1.0, 0.337251, <-0.632911, 0.0, -0.059072>

  component 1.0, 0.277649, <-0.447257, 0.0, 0.21097>

  component 1.0, 0.542637, <-0.396624, 0.0, 0.49789>

  component 1.0, 1.001709, <-1.004219, 0.0, 0.160338>

  component 1.0, 0.428071, <-0.582278, 0.0, -0.092827>

  component 1.0, 0.303734, <-0.14346, 0.0, -0.312236>

  component 1.0, 0.207286, <0.194093, 0.0, -0.295359>

  component 1.0, 0.270736, <0.396624, 0.0, -0.43038>

  component 1.0, 0.270736, <0.599156, 0.0, -0.582278>

  component 1.0, 0.128175, <0.869198, 0.0, -0.531646>

  component 1.0, 0.303734, <0.616034, 0.0, -0.413502>

  component 1.0, 0.191439, <0.936709, 0.0, -0.43038>

  component 1.0, 0.355493, <1.172996, 0.0, -0.548523>

  component 1.0, 0.270736, <1.257384, 0.0, -0.801688>

  component 1.0, 0.335372, <0.78481, 0.0, -0.78481>

  component 1.0, 0.238472, <0.970464, 0.0, -0.767932>

  component 1.0, 0.158981, <0.919831, 0.0, -0.565401>

  component 1.0, 0.270736, <1.324895, 0.0, -0.396624>

  component 1.0, 0.303734, <1.611814, 0.0, -0.413502>

  component 1.0, 0.071099, <1.814346, 0.0, -0.514768>

  component 1.0, 0.286608, <0.616034, 0.0, 0.43038>

  component 1.0, 0.128175, <0.177215, 0.0, 0.43038>

  component 1.0, 0.079491, <0.092827, 0.0, 0.329114>

  component 1.0, 0.621859, <0.278481, 0.0, 0.582278>

  component 1.0, 0.452469, <-0.109705, 0.0, 0.632911>

  component 1.0, 0.397454, <0.649789, 0.0, 0.548523>

  component 1.0, 0.337251, <0.987342, 0.0, 0.413502>

  component 1.0, 0.317963, <1.308017, 0.0, 0.43038>

  component 1.0, 0.224834, <1.611814, 0.0, 0.379747>

  component 1.0, 0.100549, <1.07173, 0.0, 0.649789>

  component 1.0, 0.25635, <1.156118, 0.0, 0.751055>

  component 1.0, 0.25635, <1.392405, 0.0, 0.700422>

  component 1.0, 0.177747, <1.594937, 0.0, 0.616034>

  component 1.0, 0.382878, <0.78481, 0.0, 0.78481>

  component 1.0, 0.100549, <0.616034, 0.0, 0.869198>

  component 1.0, 0.305807, <0.987342, 0.0, 0.953587>

  component 1.0, 0.25635, <0.481013, 0.0, 0.987342>

  component 1.0, 0.191439, <0.075949, 0.0, 0.919831>

  component 1.0, 0.112417, <-0.194093, 0.0, 0.902954>

  component 1.0, 0.335372, <-0.548523, 0.0, 0.835443>

  component 1.0, 0.177747, <-0.734177, 0.0, 0.700422>

  component 1.0, 0.227627, <-1.037975, 0.0, 0.7173>

  component 1.0, 0.227627, <-1.324895, 0.0, 0.514768>

  component 1.0, 0.277649, <-1.544304, 0.0, 0.008439>

  component 1.0, 0.277649, <-0.902954, 0.0, -0.261603>

  component 1.0, 0.258803, <-0.599156, 0.0, -0.43038>

  component 1.0, 0.238472, <-0.295359, 0.0, -0.481013>

  component 1.0, 0.305807, <-0.481013, 0.0, -0.21097>

  component 1.0, 0.392655, <-0.092827, 0.0, -0.447257>

  component 1.0, 0.207286, <0.092827, 0.0, -0.312236>

  component 1.0, 0.207286, <0.21097, 0.0, -0.464135>

  component 1.0, 0.286608, <0.008439, 0.0, -0.632911>

  component 1.0, 0.227627, <0.379747, 0.0, -0.7173>

  component 1.0, 0.201097, <0.413502, 0.0, -0.869198>

  component 1.0, 0.667911, <-0.7173, 0.0, -0.683544>

  pigment{color White}
  finish{ambient .5 diffuse .35}
  normal {bumps .8 scale 0.3}
  scale <7.435169, 7.022176, 1.8>//2.763485>
  rotate <-90.0, 0.0, 17.500952>
  translate  <27.167259, -2.210561, -17.749077>
}



#declare CSb6 = intersection {
  box { // CSb1Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <12.410411, -3.266372, -8.363884>
  }
  torus { // CSt6
    1.5, 0.32  rotate -x*90
    rotate -90.0*x
    translate  <11.409643, -4.509227, -9.360726>
  }
}
#declare CSb7 = intersection {
  box { // CSb2Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 1.0>
    translate  <-13.737099, -3.175355, 7.992035>
  }
  torus { // CSt7
    1.5, 0.24  rotate -x*90
    scale <1.31828, 0.905273, 1.312332>
    rotate -90.0*x
    translate  <-15.236365, -4.505017, 6.998485>
  }
  texture {
    Rusty_Iron1
  }
}
#declare CSb8 = intersection {
  torus { // CSt8
    1.5, 0.38  rotate -x*90
    scale <0.971027, 0.833696, 0.575821>
    translate  <-15.236061, -3.255926, 8.355041>
  }
  box { // CSt3Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <-16.235822, -3.073343, 8.479939>
  }
}
#declare CSb9 = intersection {
  torus { // CSt9
    1.5, 0.32  rotate -x*90
    rotate -90.0*x
    translate  <11.406404, -2.004173, -9.360726>
  }
  box { // CSb3Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <12.410411, -1.72317, -8.363884>
  }
  translate  0.00115*y
}
#declare CSb10 = intersection {
  torus { // CSt10
    1.5, 0.24  rotate -x*90
    scale <1.31828, 0.905273, 1.312332>
    rotate -90.0*x
    translate  <-15.236365, 1.24325, 6.99781>
  }
  box { // CSb4Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 1.0>
    translate  <-13.737099, 0.429217, 7.992035>
  }
  translate  -3.253771*y
}
#declare CS8 = union {
  cylinder { // CSc9
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 6.816213>
    translate  <12.913469, -4.516534, -16.173784>
  }
  cylinder { // CSc10
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 24.0>
    rotate <-178.553711, -81.06768, -179.980225>
    translate  <11.422294, -4.509765, -7.880006>
  }
  cylinder { // CSc11
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 23.0>
    translate  <-13.260312, -4.507048, -16.00361>
  }
  cylinder { // CSc12
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 23.0>
    translate  <-13.263095, -2.003525, -16.00361>
  }
  cylinder { // CSc13
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 24.700001>
    rotate <0.0, -90.0, 0.0>
    translate  <11.409796, -2.002701, -7.857787>
  }
  cylinder { // CSc14
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 6.816213>
    translate  <12.913469, -2.003517, -16.178883>
  }
  object { CSb6 }
  object { CSb7 }
  object { CSb8 }
  object { CSb9 }
  object { CSb10 }
  cylinder { // CSc15
    <0,0,1>, <0,0,0>, 1
    scale <0.337095, 0.32, 2.506283>
    rotate <-90.0, 0.0, 0.0>
    translate  <12.920807, -4.500811, -10.45678>
  }
  cylinder { // CSc16
    <0,0,1>, <0,0,0>, 1
    scale <0.337095, 0.32, 2.506283>
    rotate <-90.0, 0.0, 0.0>
    translate  <-13.25261, -4.500811, -6.982799>
  }
  object { // Cube6->Cube005
    Cube005
    scale <1.053421, 1.0, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.780626, -0.369419, -0.008253>
  }
  object { // Cube5->Cube004
    Cube004
    scale <1.053421, 1.0, 1.0>
    rotate <0.0, 0.0, 0.0>
    translate  <0.744553, -0.293508, -0.008253>
  }
  scale <0.949288, 1.0, 1.0>
  translate  <25.205094, 33.253771, -1.529807>
}
#declare CSb11 = intersection {
  box { // CSb1Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <12.410411, -3.266372, -8.363884>
  }
  torus { // CSt11
    1.5, 0.32  rotate -x*90
    rotate -90.0*x
    translate  <11.409643, -4.509227, -9.360726>
  }
}
#declare CSb12 = intersection {
  box { // CSb2Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 1.0>
    translate  <-13.737099, -3.175355, 7.992035>
  }
  torus { // CSt12
    1.5, 0.24  rotate -x*90
    scale <1.31828, 0.905273, 1.312332>
    rotate -90.0*x
    translate  <-15.512943, -4.500498, 7.040695>
  }
  texture {
    Rusty_Iron1
  }
  rotate 15.0*y
  translate  <0.536142, 0.0, -3.517747>
}
#declare CSb13 = intersection {
  torus { // CSt13
    1.5, 0.38  rotate -x*90
    scale <0.971027, 0.833696, 0.575821>
    translate  <-15.236061, -3.255926, 8.355041>
  }
  box { // CSt3Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <-16.235822, -3.073343, 8.479939>
  }
  rotate 15.0*y
  translate  <0.533654, 0.0, -3.517582>
}
#declare CSb14 = intersection {
  torus { // CSt14
    1.5, 0.32  rotate -x*90
    rotate -90.0*x
    translate  <11.406404, -2.004173, -9.360726>
  }
  box { // CSb3Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    translate  <12.410411, -1.72317, -8.363884>
  }
  translate  0.00115*y
}
#declare CSb15 = intersection {
  torus { // CSt15
    1.5, 0.24  rotate -x*90
    scale <1.31828, 0.905273, 1.312332>
    rotate -90.0*x
    translate  <-15.514332, 1.24325, 7.031356>
  }
  box { // CSb4Cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 2.0, 1.0>
    translate  <-13.737099, 0.429217, 7.992035>
  }
  rotate 15.0*y
  translate  <0.541269, -3.253771, -3.506071>
}
#declare CS9 = union {
  cylinder { // CSc17
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 6.816213>
    translate  <12.913469, -4.516534, -16.173784>
  }
  cylinder { // CSc18
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 24.700001>
    rotate <0.0, -90.0, 0.0>
    translate  <11.414492, -4.509765, -7.857787>
  }
  cylinder { // CSc19
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 10.0>
    translate  <-13.260312, -4.507048, -16.00361>
  }
  cylinder { // CSc20
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 10.0>
    translate  <-13.263095, -2.003525, -16.00361>
  }
  cylinder { // CSc21
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 24.700001>
    rotate <0.0, -90.0, 0.0>
    translate  <11.409796, -2.002701, -7.857787>
  }
  cylinder { // CSc22
    <0,0,1>, <0,0,0>, 1
    scale <0.32, 0.32, 6.816213>
    translate  <12.913469, -2.003517, -16.178883>
  }
  object { CSb11 }
  object { CSb12 }
  object { CSb13 }
  object { CSb14 }
  object { CSb15 }
  cylinder { // CSc23
    <0,0,1>, <0,0,0>, 1
    scale <0.337095, 0.32, 2.506283>
    rotate <-90.0, 0.0, 0.0>
    translate  <12.920807, -4.500811, -10.45678>
  }
  cylinder { // CSc24
    <0,0,1>, <0,0,0>, 1
    scale <0.337095, 0.32, 2.506283>
    rotate <-90.0, 0.0, 0.0>
    translate  <-13.25261, -4.500811, -6.982799>
  }
  cylinder { // CSextraC1
    <0,0,1>, <0,0,0>, 1
    texture {
      Rusty_Iron1
    }
    scale <0.3364, 0.32, 13.026835>
    rotate <0.0, 11.192237, 0.0>
    translate  <-13.250147, -4.506725, -6.072179>
  }
  cylinder { // CSextraC2
    <0,0,1>, <0,0,0>, 1
    texture {
      Rusty_Iron1
    }
    scale <0.3364, 0.32, 13.026835>
    rotate <0.0, 11.192237, 0.0>
    translate  <-13.250147, -2.014974, -5.957878>
  }
  scale <0.949288, 1.0, 1.0>
  translate  <78.929765, 93.253771, -1.529807>
}
#declare CSBasen = difference {
  box { // CStallBas
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rusty_Iron1
    }
    scale <11.8, 100.0, 1.0>
    rotate <0.0, 0.0, -40.0>
    translate  <53.140727, 66.752335, -16.757569>
  }
  box { // CSbasCut
    <-1, -1, -1>, <1, 1, 1>
    scale <11.6, 99.800003, 1.5>
    rotate -40.0*z
    translate  <53.186747, 66.716151, -16.828036>
  }
  scale <0.953726, 0.897234, 1.0>
  translate  <0.70258, -0.187355, 0.0>
}

intersection { // SladdMitt
  torus { // SladdMittT
    1.5, 0.05  rotate -x*90
    scale <2.239557, 0.986722, 1.046426>
    rotate <-94.073318, 29.947407, -15.253632>
    translate  <8.704927, 1.400653, 17.371561>
  }
  box { // SladdMittCut
    <-1, -1, -1>, <1, 1, 1>
    scale <3.417794, 1.669852, 1.126214>
    rotate 24.13715*y
    translate  <9.155079, 1.323052, 18.461495>
  }
  texture {
    Svart
  }
  scale <1.126418, 1.0, 0.968396>
  rotate <-20.892157, 7.379348, 19.612963>
  translate  <29.016472, -11.70745, 2.442562>
}


cylinder { // SladdHallare
  <0,0,1>, <0,0,0>, 1
  texture {
    Svart
  }
  scale <0.15, 0.15, 8.5>
  rotate <10.63967, 5.249541, 1.208711>
  translate  <33.380575, 0.752985, 9.380431>
}


intersection { // Sladd2Nere
  torus { // Sladd2NereT
    1.5, 0.05  rotate -x*90
    scale <1.190212, 1.556019, 0.9162>
    rotate <-111.644806, -54.029648, 31.748968>
    translate  <2.960577, 2.219884, 10.456318>
  }
  box { // Sladd2NereCut
    <-1, -1, -1>, <1, 1, 1>
    scale <2.618089, 1.0, 1.692574>
    rotate <0.0, 24.605415, 0.0>
    translate  <2.183498, 2.310276, 8.645904>
  }
  texture {
    Svart
  }
  rotate <-1.133775, -4.105541, 15.452397>
  translate  <30.04094, -3.205623, -1.091216>
}


intersection { // Sladd1Nere
  torus { // Sladd1NereT
    1.5, 0.05  rotate -x*90
    scale <1.396153, 1.594183, 0.863258>
    rotate <-90.847549, 4.685392, 9.951758>
    translate  <3.414352, 2.30432, 10.589554>
  }
  box { // Sladd1NereCut
    <-1, -1, -1>, <1, 1, 1>
    scale <2.391838, 1.0, 1.615045>
    rotate <0.0, 27.011139, 0.0>
    translate  <2.347421, 2.310276, 8.699247>
  }
  texture {
    Svart
  }
  scale <0.919337, 1.014187, 1.005431>
  rotate <-0.637964, -3.736981, 13.309617>
  translate  <29.918286, -3.027023, -1.043532>
}


intersection { // LampSladdUppe
  torus { // LampSladdUppeT
    1.5, 0.05  rotate -x*90
    scale <1.181991, 0.690343, 2.706989>
    rotate <-74.363335, 9.829802, 44.959152>
    translate  <4.596409, 0.928847, 19.103635>
  }
  box { // LampSUCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.573871, 2.412088, 5.705743>
    translate  <5.28233, 2.330528, 24.397337>
  }
  texture {
    Svart
  }
  scale <0.88811, 1.0, 0.991393>
  rotate 11.844118*z
  translate  <29.570458, -3.97987, -0.918154>
}

translate<-3,0,0>

} //SLUT P CYKELN






union { // CykelStallet
  object { CS1 }
  object { // CS2->CS1
    CS1
    rotate <0.0, 0.0, 0.0>
    translate  <13.3, 15.0, 0.0>
  }
  object { // CS3->CS1
    CS1
    rotate <0.0, 0.0, 0.0>
    translate  <40.0, 45.0, 0.0>
  }
  object { // CS4->CS1
    CS1
    rotate <0.0, 0.0, 0.0>
    translate  <53.33, 60.0, 0.0>
  }
  object { // CS5->CS1
    CS1
    rotate <0.0, 0.0, 0.0>
    translate  <66.66, 75.0, 0.0>
  }
  object { // CS6->CS1
    CS1
    rotate <0.0, 0.0, 0.0>
    translate  <93.137912, 105.0, 0.0>
  }
  object { // CS7->CS1
    CS1
    rotate <0.0, 0.0, 0.0>
    translate  <106.86895, 120.0, 0.0>
  }
  object { CS8 }
  object { CS9 }
  object { CSBasen }
  object { // Cube7->Cube004
    Cube004
    rotate <0.0, 0.0, 0.0>
    translate  <79.533851, 93.092307, 0.0>
  }
  object { // Cube8->Cube005
    Cube005
    rotate <0.0, 0.0, 0.0>
    translate  <78.226921, 93.151803, 0.0>
  }
  texture {
    Rusty_Iron1
  }

  rotate -z*5 //!!
}

plane { // Mark
  z,0
  /*texture {
    Vit
  }*/
  pigment{color Gray65}
  finish{ambient .5 diffuse .35}
  scale <20.0, 20.0, 1.0>
  translate  <-0.205046, 0.0, -17.623684>
}



scale 0.35
rotate -z*45
translate<-50,-35,-3.8> //x60
}






/*plane { // Wall
  z,0
  texture {
    WallTex
  }
  rotate <0.0, -90.0, -40.0>
  translate  <-162.901973, 173.196648, 0.441604>
}


plane { // Mark
  z,0
  texture {
    Vit
  }
  scale <20.0, 20.0, 1.0>
  translate  <-0.205046, 0.0, -17.623684>
}*/




