// Persistence of Vision Ray Tracer Scene Description File
// File: lumber.inc
// Vers: 3
// Desc: Support file for nschool, the racks of lumber in the back right
// Date: 970419
// Auth: Dick Balaska

#ifndef	(True)				// test render? use these
#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "golds.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"
#include "orngwood.map"
#include "ash.map"

#declare True=1
#declare False=0

#declare Test=1

global_settings {
	ambient_light rgb<1,1,1>
}

//  "real" position
//camera { location < 0, 11, 0>
//		 look_at  < 9, 2, 32> }

	camera { location <24, 6, 30>
	look_at <35, 6, 40> }

light_source { < 0, 50, 0 > color rgb 0.5 }
light_source { < 24, 50, 0 > color rgb 0.5 }
light_source { < 0, 50, 0 > color rgb 0.5 }
light_source { < 0, 50, 0 > color rgb 0.5 }

//        background { Black }
        background { White }
        //sky_sphere { S_Cloud1 rotate y * 180 }

        plane { y, 0
                pigment { color rgb < 0.6, 0.6, 0.6 > }
                // normal { crackle 0.2 scale 3 }
				}
#declare Local=1
#end

#declare inch= 0.1
#declare halfinch=(inch/2)
#declare foot=(inch*12)
#declare bdtexR=seed(402)
#declare bdsizR=seed(4001)

#declare board_spacing=15
#declare board_count=400
#declare board_colors=3

#declare bdwhichtex=int(rand(bdtexR)*5)
#debug "Creating lumber:"
#declare lumber_rack=
object {
	#declare board=0
	union {
		#while (board < board_count)
			#if (!mod(board,board_spacing))
				#declare bdwhichtex=int(rand(bdtexR)*board_colors)
				#debug concat(" ", str(bdwhichtex,0,0))
				box {
					<-halfinch, foot*3, -foot*2>
					< halfinch, foot*3.5, 1>
			    	texture { pigment { P_WoodGrain1A color_map { M_Wood1A }}
						rotate 90 translate <rand(bdtexR)*2, rand(bdtexR)*4, rand(bdtexR)*3>}
			    	texture { pigment { P_WoodGrain1B color_map { M_Wood1B }} }
					translate <(board*inch), 0, 0>
				}
			#else
				#declare bdheight= floor(rand(bdsizR)*4*2+4)
				#declare bdwidth= floor(rand(bdsizR)*3*2+4)
				#declare bdAmbient=0.0
				box {
					<-halfinch,            0,-inch*bdwidth>
					< halfinch,foot*bdheight, inch*0>
//					pigment {Red}
//					#declare bdwhichtex=4
					#switch (bdwhichtex)
						#case (2)		// walnut
					    	texture { pigment { P_WoodGrain1A color_map { M_Wood1A }} finish {ambient bdAmbient}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
					    	texture { pigment { P_WoodGrain1B color_map { M_Wood1B }} finish {ambient bdAmbient}}
							#declare null=int(rand(bdtexR)*5)
							
						#break
						#case (3)		// orange pine
						    texture{
		        				pigment {
				   				    P_WoodGrain3A
    		    				    color_map { M_Orangewood }
				   				    //scale 2
            						rotate y*(85+rand(bdtexR)*10)
									translate <rand(bdtexR)*10, rand(bdtexR)*10, rand(bdtexR)*10>
								}
								ambient bdAmbient
							}
						#break
						#case (5)		// cherry
						    texture { pigment { P_WoodGrain15A color_map { M_Wood14A }}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
						    texture { pigment { P_WoodGrain15B color_map { M_Wood14B }}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
						#break
						#case (4)		// ash
						    texture{
						        pigment {
						            P_WoodGrain3A
						            color_map { M_Ash }
						            scale 2
						            rotate x*90
//									ambient bdAmbient
						        }
						    }
						#break
						#case (0)		// green wood
						    texture { pigment { P_WoodGrain15A color_map { M_Wood11A }} finish {ambient bdAmbient}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
						    texture { pigment { P_WoodGrain15B color_map { M_Wood11B }} finish {ambient bdAmbient}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
						#break
						#case (1)		// 50's pine
						    texture { pigment { P_WoodGrain15A color_map { M_Wood10A }} finish {ambient bdAmbient}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
						    texture { pigment { P_WoodGrain15B color_map { M_Wood10B } } finish {ambient bdAmbient}
								rotate <0,90,90> translate <rand(bdtexR)*2, rand(bdtexR)*3, rand(bdtexR)*4> }
						#break
						#else
							#warning "No texture in lumber.inc\n"
					#end
					translate <(board*inch), 0, 0>
					rotate x*10
				}
			#end
			#declare board = board + 1
//			#declare null=int(rand(bdtexR)*5)
//			#declare null=int(rand(bdtexR)*5)
		#end
		box{
			<0, 0, -inch*10>
			<board_count*inch, inch*2, -inch*6>
		    texture{
		        pigment {
   				    P_WoodGrain3A
    		        color_map { M_Orangewood }
   				    //scale 2
            		rotate y*(85+rand(bdtexR)*10)
					translate <rand(bdtexR)*10, rand(bdtexR)*10, rand(bdtexR)*10>
				}
			}
		}
	}
}

#ifdef (Local)
object {lumber_rack translate <28, 0, 40>}
#end
