// Persistence of Vision Ray Tracer Scene Description File
// File: palette.inc
// Vers: 3
// Desc: A palette of wooden 2x4s
// Date: 970326
// Auth: Dick Balaska


#declare tbf1=seed(2000)

// An 8 foot 2x4
#declare twobyfour=
object {
	intersection {
		superellipsoid {
			<0.25 0.25>
			scale <16, 2/12, 4/12>
			//translate <-4, 1/12, 2/12>
			translate <-4, 1/12, 0>
		}
		box {
			<-4, -1, -1>
			< 4,  1,  1>
		}
		scale <1,.5,.5>
	}
}

#declare palette=
object {
	union {
		#declare tbfY=0
		#while (tbfY<24)
			#switch (tbfY)
				#range(0,20)
					#declare mtbfZ=12
					#break
				#range(21,22)
					#declare mtbfZ=9
					#break
				#case(23)
					#declare mtbfZ=6
					#break
				#case(24)
					#declare mtbfZ=4
					#break
			#end
			#if (!mod(tbfY, 6))
				// The braces under the palette
				object {
					twobyfour
			    	texture{
			        	pigment {
       				    	P_WoodGrain3A
		    		        color_map { M_Orangewood }
    	   				    //scale 2
	    	        		rotate y*(85+rand(tbf1)*10)
							translate <rand(tbf1)*10, rand(tbf1)*10, rand(tbf1)*10>
						}
					}
					scale <.75,1,1>
					rotate y*90
					translate <-2,tbfY*(2/12),0>
				}
				object {
					twobyfour
				    texture{
			    	    pigment {
       					    P_WoodGrain3A
	    		        	color_map { M_Orangewood }
	       				    //scale 2
		            		rotate y*(85+rand(tbf1)*10)
							translate <rand(tbf1)*10, rand(tbf1)*10, rand(tbf1)*10>
						}
					}
					scale <.75,1,1>
					rotate y*90
					translate <2,tbfY*(2/12),0.5>
				}
			#else
				#declare tbfZ=0
				#while (tbfZ<mtbfZ)
				object {
					twobyfour
				    texture{
				        pigment {
        				    P_WoodGrain3A
		    		        color_map { M_Orangewood }
        				    //scale 2
		            		rotate y*(85+rand(tbf1)*10)
							translate <rand(tbf1)*10, rand(tbf1)*10, rand(tbf1)*10>
						}
					}
					translate <0, tbfY*(2/12), 4-(tbfZ*(4/12))-1.5-(4/12)>
				}
				#declare tbfZ = tbfZ+1
				#end
			#end
			#declare tbfY=tbfY+1
		#end
#if (0)
		// The second to the top row
		#declare tbfZ=0
		#while (tbfZ<8)
		object {
			twobyfour
		    texture{
		        pigment {
      				    P_WoodGrain3A
    		        color_map { M_Orangewood }
      				    //scale 2
            		rotate y*(85+rand(tbf1)*10)
					translate <rand(tbf1)*10, rand(tbf1)*10, rand(tbf1)*10>
				}
			}
			translate <0, tbfY*(2/12), -((tbfZ*(4/12))-1.5-(4/12))>
		}
		#declare tbfZ = tbfZ+1
		#end
#end
	}
	scale 2
}

