// pot.inc
// declare a clay pot

#declare ClayColor	= rgb <0.7305, 0.3672, 0>
#declare ClayColor2	= rgb <0.4870, 0.2448, 0>
#declare ClayColor3	= rgb <0.3653, 0.1836, 0>

#declare Pot =
object {
	difference {
		merge {
			superellipsoid {
				<1, 0.25>
				rotate <90,0,0>
				scale <2, 0.5, 2>
				translate <0, 1.7, 0>
			}
			cone {
				<0, 2, 0>, 2.0,
				<0, 0, 0>, 1.5
			}
		}
		cone {
			<0, 2.3, 0>, 1.4,
			<0, 0, 0>, 0.7
		}
	}
	texture {
		pigment {
			marble
			color_map { [0.0 color ClayColor3] [0.1 color ClayColor2] [0.3 ClayColor] }
			turbulence 0.6
			//crand 0.2
			scale 0.1
		}
		normal {
			//bumps 0.3
			marble
			//scale <0.5, 0.5, 0.5>
		}
		finish {
			phong 0.1
			specular 0.025
		}
		rotate z*90
	}
	scale 2*BaseLen
}
