// projector.inc
// the projector object

#ifndef	(True)				// test render? use these
#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "golds.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"

#declare True=1
#declare False=0

#declare Test=1

//	camera { location < -2, 5, 28>
//	look_at < 9, 5, 28> }

	camera { location < 0, 8, 2>
	look_at < 9, 2, 32> }


//	camera { location < 0, 3, -8>
//	look_at < 0, 1, 0> }
//	camera { location < 0, 4, -13>
//	look_at < 0, 3, 0> }

//        light_source { < -100, 70, -100 > color rgb 2 }
//        light_source { <    0, 10, 00 > color White shadowless }

light_source { < 0, 50, 0 > color rgb 0.5 }
light_source { < 24, 50, 0 > color rgb 0.5 }
light_source { < 0, 50, 0 > color rgb 0.5 }
light_source { < 0, 50, 0 > color rgb 0.5 }

        background { Black }
//        background { White }
        //sky_sphere { S_Cloud1 rotate y * 180 }

        plane { y, 0
                pigment { color rgb < 0.6, 0.6, 0.6 > }
                // normal { crackle 0.2 scale 3 }
				}
#end

#declare projector_head =
object {
	difference {
		box {
			<0,0,0>
			<0.75, 0.75, 0.75>
		}
		box {
			<-0.1,-1,0>
			<0.76, 1.75, -0.75>
			rotate <45, 0, 0>
			translate <0,0.2,0>
		}
		texture { T_Chrome_1A }
	}
}

#declare projector =
object {
	union {
		difference {
			superellipsoid {
				<0.25 0.25>
				pigment { Brown }
			}
			box {
				<-0.75, -1.5, -0.75>
				< 0.75,  2,    0.75>
				pigment { White }
			}
		}
		box {
			<0, 0, 0 >
			<1, 1, 1 >
			pigment {
				image_map {
					gif "ostrich.gif"
					transmit all 0.2
				}
			}
			finish {
				ambient 1
				phong 1
			}
			scale <1.5, 1.5, 1.5>
			rotate <90,180,0>
			translate <0.75, 1.01, 0.75>
		}

		box {	// rotated arm
			<-0.1, -1, -0.1>
			< 0.1,  1,  0.1>
			texture { T_Chrome_1A }
			rotate <0,0,-20>
			translate <-0.79, 2, 0>
		}
		box {	// bottom arm
			<-0.1, -1.0, -0.1>
			< 0.1,  0.2,  0.1>
			texture { T_Chrome_1A }
			translate <-1.1, 1.0, 0>
		}
		box {	// top arm
			<-0.1, -0.2, -0.1>
			< 0.1,  0.2,  0.1>
			texture { T_Chrome_1A }
			translate <-0.45, 3.0, 0>
		}
		object {
			projector_head
			translate <-0.4, 2.8, -0.375>
		}
	}
}

#declare ptable_leg =
object {
	box {
		<-0.2, 0, -0.2>
		< 0.2, 0.95, 0.2>
		texture { T_Wood35 rotate x*90 }
	}
}

#declare projector_table =
object {
	union {
		box {
			<-1.25, 0.75, -1.25>
			<1.25, 1, 1.25>
			texture { T_Wood35 rotate y*90 }
		}
		object {
			ptable_leg
			translate <-1, 0, -1>
		}
		object {
			ptable_leg
			translate <1, 0, -1>
		}
		object {
			ptable_leg
			translate <-1, 0, 1>
		}
		object {
			ptable_leg
			translate <1, 0, 1>
		}
	}
}
object { projector		rotate <0,0,0> translate <9, 2, 25> }

//#if (!Test)
object { projector_table               translate <9, 0, 25> }
//#end

#declare projector_fog =
object {
	prism {
		conic_sweep
		linear_spline
		0,	// height 1
		1,	// height 2
		5,	// # of points making up the shape...
		<1,1>,<-1,1>,<-1,-1>,<1,-1>,<1,1>
		rotate <180,0,0>
		translate <0, 1, 0>
		rotate <90,0,0>
		pigment { Yellow }
		pigment {
			image_map {
				gif "ostrich.gif"
				transmit all 0.9
			}
			rotate <0,180,0>
			scale <2,1,2>
		}
		rotate <-90,0,0>
		scale <0.75,2,0.75>
		translate <0, 1, 0>
	}
}
object { projector_fog                 translate <9, 2, 25> }
object { projector_fog rotate <-100,0,0> scale 3.5 translate <9, 7.1, 35.9> }

#declare screen =
object {
	union {
		box {
			<3, 2, 32>
			<15, 10, 32>
			pigment { White }
		}
		box {
			<0, 0, 0 >
			<1, 1, 1 >
			pigment {
				image_map {
					gif "ostrich.gif"
					transmit all 0.1
				}
			}
			scale 5
			//rotate <0,180,0>
			translate <6.5, 4, 31.99>
		}
		box {
			<0, 0, 0 >
			<1, 1, 1 >
			pigment {
				image_map {
					gif "liftdrag.gif"
					transmit 0 1.0
				}
			}
			scale 3.2
			// rotate <90,180,0>
			translate <11.5, 6, 31.99>
		}

	}
}
//#if (!Test)
object { screen }
//#end

