// Persistence of Vision Ray Tracer Scene Description File
// File: saw.inc
// Vers: 3
// Desc:
// Date:
// Auth:


#declare sawb_texture=
	texture {T_Silver_5A}
//	texture {pigment {Red}}

// a saw blade
#declare blade_tooth=
object {
/*	union {
		intersection {
			box { <-1, -1.5, -0.1> < 1, 1.5,  0.1> }
			plane {<0,-1,0> 0 rotate z* 80 translate <0,0,0> }
			plane {<0,-1,0> 0 rotate z*-80 translate <0,0,0> }
		}*/
		intersection {
			difference {
				cylinder { <0.5,1.5, -0.1>, <0.5,1.5, 0.1> 0.75 texture {sawb_texture}}
				cylinder { <1.0,1.5, -0.2>, <1.0,1.5, 0.2> 0.7 texture {sawb_texture}}
			}
			plane { <0,-1,0> 2 }
		}
//	}
}

#declare saw_blade=
object {
	union {
	#declare bRot=0
	#while (bRot<360)
		object {blade_tooth rotate z*bRot}
		#declare bRot = bRot+20
	#end
	cylinder {<0,0,-0.1>, <0,0,0.1> 1.5}
	}
	texture {sawb_texture}
}
//object { saw_blade }

#declare saw_table_leg=
object {
	prism {
		conic_sweep
		linear_spline
		0,	// height 1
		1,	// height 2
		5,	// # of points making up the shape...
		<1,1>,<-1,1>,<-1,-1>,<1,-1>,<1,1>
		texture {
			pigment { Black }
			finish {
				ambient 0.1
				diffuse 0.1
				specular 1
				roughness 0.001
				reflection 0.2
				metallic
			}
		}
		scale <0.4,5.0,0.4>
	}
}

#declare saw_table=
object {
	union {
		union {
			difference {
				box { <-2, -0.125, -2.2> <2, 0.125, 2.2> texture {T_Chrome_5B} }
//				box { <-2, -0.125, -2.2> <2, 0.125, 2.2> texture {T_Brass_4E} }
				box { <-1.2, -1, -0.29> <1.2, 1, 0.29> pigment {Black} }
			}
			object {saw_blade scale 0.5 texture {sawb_texture} translate <0,-0.2, 0>}
			translate <0,4,0>
		}
	box { <-1.2, 2.5, -1> <1.2, 4, 1>
		texture {
			pigment {Black}
			finish {
				ambient 0.0
			}
		}
	}
	object {saw_table_leg rotate <10,0,-10> translate <-2,-1, -2>}
	object {saw_table_leg rotate <10,0,10> translate <2, -1, -2>}
	object {saw_table_leg rotate <-10,0,-10> translate <-2,-1, 2>}
	object {saw_table_leg rotate <-10,0,10> translate <2, -1, 2>}
	}
}
