// Scene Created by the Breeze Designer 2.0
// Written by Neville Richards

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "office.inc"
#include "teacher.pov"

// CAMERA POSITION
camera {
 right      < -1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1 >
 location   < 12, 3, -3 >
 look_at    < -1, 6, -1 >

 aperture 1                 // 0...N (bigger is narrower depth of field)
 blur_samples 30             // # of rays per pixel
 confidence 1
 focal_point <0,8,-1>       // x,y,z point that is in focus
}

box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
texture { pigment {
         image_map
         {
           tga "pupil.tga" // the file to read (iff/gif/tga/png/sys)
           map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
           interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
           once
           } } // END PIGMENT
           finish { ambient 0.3 }
           translate <-0.5,-0.5,-0.5>
           rotate <0,90,0>
         }
 scale  < 0.2, 10.02, 4.92 >
 translate  < 15, 1, -1 >
 }



// LIGHT (in office)
light_source { < 2, 9.5, -4 >
             color rgb <1,1,0.8>

             area_light
             <2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
             8, 8                // total number of lights in grid (4x*4z = 16 lights)
             adaptive 2          // 0,1,2,3...
             jitter              // adds random softening of light
             }

// LIGHT (outside window)
light_source { < -4, 9.5, 10 >
             color White

             area_light
             <1, 0, 0> <0, 0, 1> // lights spread out across this distance (x * z)
             4, 4                // total number of lights in grid (4x*4z = 16 lights)
             adaptive 2          // 0,1,2,3...
             jitter              // adds random softening of light
             }


// CYLINDER Cup
//cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
// pigment { White }
// scale  < 0.7, 0.7, 0.7 >
// translate  < -0.863354, 3.81548, -6.66304 >
// }

// Bookshelf
union {
  object { Shelf1 }
  object { Shelf2 }
  object { Shelf3 }
  object { Shelf4 }
  object { Shelf5 }
  object { ShelvesBack }
  object { ShelfSide }
  object { ShelfSide_6 }
  object { Shelf1_9 }
  object { Shelf2_9 }
  object { Shelf3_9 }
  object { Shelf4_9 }
  object { Shelf5_9 }
  object { ShelvesBack_9 }
  object { ShelfSide_9 }
  object { ShelfSide_6_9 }
}
// Wall with window
union {
  difference {
              object { Wall2_3 }
              object { Window }
              }
  object { WindowBorder_1 }
  object { WindowBorder_2 }
  object { WindowBorder_3 }
  object { WindowBorder_4 }
}

// Blackboard
union {
  object { Blackboard }
  object { Blackboard_1 }
  object { Blackboard_2 }
  object { Blackboard_3 }
  object { Blackboard_4 }
  object { Window_Glass }
}
