
// Plastics (back.inc)
// Lorenzo Quintana Juez (voyager@redestb.es)
// April 30, 1997

// _____ Screw _____

#declare T_Screw = texture {
  pigment { rgb .75 }
  finish { diffuse .4 ambient .3 brilliance 3 metallic
    specular .7 roughness .016 reflection .25 }
}

#declare Screw = difference {
  sphere { 0, .5 scale <.5,1,1> }
  merge {
    box { <.1,-.27,-.05>, <1,.27,.05> }
    box { <.1,-.05,-.27>, <1,.05,.27> }
  }
  texture { T_Screw }
}

// _____ Borrador _____

#declare T_Borrador_1 = texture {
  pigment { wood  turbulence .004 frequency 3
    color_map {
      [  0.18  rgb <.7, .4, 0> ]
      [  0.22  rgb <1, .68, .4> ]
      [  1.00  rgb <1, .68, .4> ] }
  }
  finish { diffuse .8 ambient .2 }
  rotate 94*y translate <0,5,3>
}

#declare T_Borrador_2 = texture {
  pigment { spotted
     color_map {
       [ 0.000 rgb <.9, .85, .9> ]
       [ 0.194 rgb <.9, .85, .9> ]
       [ 0.201 rgb <.6, .55, .6> ]
       [ 0.601 rgb <.6, .55, .6> ]
       [ 0.601 rgb <.7, .65, .7> ]
       [ 1.000 rgb <.7, .65, .7> ]
     }
     scale     <.3, .03, .3>
   }

  finish { diffuse .8 ambient .2 }
}

#declare Borrador = union {
  cylinder { <-5, 4, -1.5>, <5, 4, -1.5>, .4 }
  cylinder { <-5, 4, 1.5>, <5, 4, 1.5>, .4 }
  box { <-5, 4.4, -1.5>, <5, 2, 1.5> }
  cylinder { <-5, 2.6, -1.5>, <5, 2.6, -1.5>, .6 }
  cylinder { <-5, 2.6, 1.5>, <5, 2.6, 1.5>, .6 }
  superellipsoid { <.05, .05> rotate 90*x scale <6, 1.4, 3.25>
    translate 1.4*y texture { T_Borrador_2 }
  }
  texture { T_Borrador_1 }
}


// _____ Floor _____

#declare T_Floor = texture {
  pigment { spotted
    color_map {
      [ 0.00 rgb .7 ]
      [ 0.05 rgb .7 ]
      [ 0.06 rgb 0 ]
      [ 0.60 rgb 0 ]
      [ 0.60 rgb .2 ]
      [ 1.00 rgb .1 ]
    }
  scale .9
  }
  finish { diffuse .6 ambient .2 phong 1 phong_size 60 reflection .15 }
}

#declare Floor = box { <-1040, 0, -20>, <1020, -20, 1740> texture { T_Floor } }

// _____ Walls _____

// textures

#declare T_Walls = texture {
  pigment { rgb 1 }
  finish { diffuse .9 ambient .15 }
}

#declare T_Wall2 = texture {
  pigment { rgb .3 }
  finish { diffuse .8 ambient .15 }
}

#declare T_Wainscot = texture {
  pigment { rgb .6 }
  finish { diffuse .9 ambient .2 phong 1 phong_size 80 reflection .05 }
}

// objects

#declare Walls = union {
  box { <0,-1,0>, <-20,320,701> }
  box { <-45,-1,700>, <25,215,710> }
  box { <-1020,-1,1040>, <1000,320,1050> texture { T_Wall2 } }
  box { <-144,215,700>, <124,320,710> }
  box { <124,-1,700>, <1000,320,710> }
  box { <1000,-1,0>, <1020,320,710> }
  // roof
  box { <-1040, 320, -20>, <1020, 340, 1740> }
  // wainscot
  union {
  box { <0,-1,699>, <25,7,700> }
  cylinder { <0,7,700>, <25,7,700>, 1 }
  box { <124,-1,699>, <1000,7,700> }
  cylinder { <124,7,700>, <1000,7,700>, 1 }
  box { <1,-1,0>, <2,7,700> }
  cylinder { <1,7,0>, <1,7,700>, 1 }
  texture { T_Wainscot }
  }
  // windows
  box { <-20,-1,0>, <1020,102,-20> }
  box { <-20,300,0>, <1020,320,-20> }
  box { <-20,100,0>, <50,300,-20> }
  box { <-20,235,0>, <1020,240,-10> }
  texture { T_Walls }
}

// _____ Door _____

// textures

#declare T_Pomo = texture {
  pigment { rgb .95 }
  finish { diffuse .3 ambient .25 brilliance 2 metallic
    specular .8 roughness .05 reflection .1 }
}

#declare T_Door1 = texture {
  pigment { rgb <.1,.05,0> }
  finish { diffuse .8 ambient .2 phong .5 phong_size 45 }
}

#declare T_Door2 = texture {
  pigment { rgb <.4,.1,0> }
  finish { diffuse .8 ambient .2 phong .5 phong_size 45 }
}

#declare T_Pane = texture {
  pigment { rgbf <1,1,1,.99> }
  finish { diffuse 0 ambient 0 reflection .1 }
}

#declare T_Hinge = texture {
  pigment { rgb .95 }
  finish { diffuse .4 ambient .3 brilliance 3 metallic
    specular .7 roughness .016 reflection .25 }
}

// objects

#declare Hinge = union {
  sphere { 0, .7 }
  cylinder { 0, 3.9*y, .7}
  cylinder { 3.9*y, 4.1*y, .5}
  cylinder { 4.1*y, 8*y, .7}
  sphere { 8*y, .7 }
  texture { T_Hinge }
}

#declare Frame1 = union {
  box { <25, -1, 700>, <34, 206, 710> }
  box { <25, 206, 700>, <124, 215, 710> }
  box { <115, -1, 700>, <124, 206, 710> }
  texture { T_Door1 }
}

#declare Frame2 = union {
  box { <25, -1, 699>, <28, 212, 700> }
  box { <25, 212, 699>, <124, 215, 700> }
  box { <121, -1, 699>, <124, 212, 700> }
  texture { T_Door1 }
}

#declare Door = union {
  // door
  box { <34.5, .8, 700>, <114.5, 111, 706> }
  box { <34.5, 196.5, 700>, <114.5, 206, 706> }
  box { <34.5, 111, 700>, <43.5, 196.5, 706> }
  box { <105.5, 111, 700>, <114.5, 196.5, 706> }
  // pane
  box { <43.5,111,703.25>, <114.5,196.5,703.75> texture { T_Pane } }
  texture { T_Door2 }
}

// _____ Pomo _____

#declare Pomo = union {
  cone { 0, 2, -8*z, 1.5 }
  sphere { -8*z, 1.5 }
  cone { -8*z, 1.5, <-14,-1,-8>, 1.25 }
  sphere { <-14,-1,-8>, 1.25 }
  sphere { <-3,6,1>, 1 }
  cylinder { <-3,6,1>, <3,6,1>, 1 }
  sphere { <3,6,1>, 1 }
  cylinder { <3,6,1>, <3,-13,1>, 1 }
  sphere { <3,-12,1>, 1 }
  cylinder { <3,-13,1>, <-3,-13,1>, 1 }
  sphere { <-3,-13,1>, 1 }
  cylinder { <-3,-13,1>, <-3,6,1>, 1 }
  difference {
    box { <-3,6,0>, <3,-13,5> }
    union {
      cylinder { <0,-6.5,3>, <0,-6.5,-3>, .7 }
      box { <-.3, -6.5,3>, <.3,-9.4, -3> }
      pigment { rgb 0 }
    }
  }
  texture { T_Pomo }
}

// _____ Blackboard _____

// textures

#declare T_Bboard1 = texture {
  pigment { image_map { gif "blackb.gif" map_type 0 interpolate 0 } }
  finish { diffuse .8 ambient .2 }
  scale <300,120,1> rotate -90*y translate <0,75,200>
}

#declare T_Bboard2 = texture {
  pigment { rgb <0,.4,.2> }
  finish { diffuse .8 ambient .2 }
}

#declare T_Tiza = texture {
  pigment { bozo turbulence 1 color_map {
    [ 0 rgb 1 ] [ .1 rgb 1 ] [ .8 rgbt 1 ] [ 1 rgbt 1 ] } }
  finish { diffuse .8 ambient .5 }
  scale 15
}

#declare T_Bboard3 = texture {
  pigment { bozo turbulence .5 color_map {
    [ 0 rgb <0,.4,.2> ] [ .6 rgb <0,.4,.2> ] [ 1 rgb <.2,.6,.4> ] } }
  finish { diffuse .8 ambient .2 }
  scale 10
}

// objects

#declare Blackboard = union {
  // tablon
  box { <0,75,200>, <3.5,195,500> texture { T_Bboard1 } }
  // marco
  box { <0,70,195>, <5, 75, 505> texture { T_Bboard3 } }
  box { <0,195,195>, <5, 200, 505> }
  box { <0,75,195>, <5, 195, 200> }
  box { <0,75,500>, <5, 195, 505> }
  box { <0,69,195>, <10,70,505> }
  box { <10,69,195>, <11,72,505> }
  // tiza
  box { <0, 74, 195>, <4.99,75.4,500> texture { T_Tiza } }
  texture { T_Bboard2 }
}

// _____ Switch _____

// textures

#declare T_Switch1 = texture {
  pigment { rgb .95 }
  finish { diffuse .8 ambient .2 specular .9 roughness .05 }
}

#declare T_Switch2 = texture {
  pigment { rgb .9 }
  finish { diffuse .8 ambient .2 }
}

// objects

#declare Switch1 = union {
  box { <-1.3,-1,-1>,<1.3,2.9,1> rotate -10*x }
  box { <-1.3,1,-1>,<1.3,-2.9,1> rotate 10*x }
}

#declare Switch = union {
  difference {
  superellipsoid { < 0.1, .1> rotate 90*x scale <6,5.5,4> translate <139,85,702> }
  box { <136, 82,697>, < 142, 88, 699> }
  }
  object { Screw scale .8 rotate 90*y translate <134.5,85,698> }
  object { Screw scale .8 rotate 90*y translate <143.5,85,698> }
  object { Switch1 translate <137.5, 85, 698.5> }
  object { Switch1 translate <140.5, 85, 698.5> }
  texture { T_Switch1 }
}

// _____ Perch _____

// textures

#declare T_Perch1 = texture {
  pigment { rgb .95 }
  finish { diffuse .6 ambient .15 brilliance 5 metallic
    specular .8 roughness .01 reflection .65 }
}

#declare T_Perch2 = texture {
  pigment { rgb <.35,.1,0> }
  finish { diffuse .8 ambient .2 phong .5 phong_size 45 }
}

// objects

#declare PerchA = difference {
  torus { 3, .5 }
  box { <-5,-1,0>, <5,1,5> }
  rotate 90*x
}

#declare PerchB = intersection {
  torus { 3, .5 }
  box { -1*y, <5,1,-5> }
}

#declare PerchC = union {
  object { PerchA }
  object { PerchB rotate -90*z translate <3,0,3> }
  object { PerchB rotate -90*z translate <-3,0,3> }
  cylinder { <3, -3, 3>, <3, -3, 10>, .5 }
  cylinder { <-3, -3, 3>, <-3, -3, 10>, .5 }
  texture { T_Perch1 }
}

#declare Perch = union {
  box { <-10, -7, 10>, <100, 7, 13> texture { T_Perch2 } }
  #declare Np=0
  #while (Np<7)
  object { PerchC translate (15*Np)*x }
  #declare Np=Np+1
  #end
}

// _____ Posters _____

// letras

#declare Ld = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 43, 0> <10, 43, 0> <20, 43, 0> <29.5, 42.5, -6>
  <0, 20, 0> <10, 20, 0> <20, 20, 0> <30, 20, 0>
  <0, 10, 0> <10, 10, 0> <20, 10, 0> <30, 10, 0>
  <0, 0,  -1> <10, 0,  0> <20, 0,  0> <30, 0,  0>
  texture {
  pigment { image_map { gif "d.gif" map_type 0 interpolate 0 } }
  finish { diffuse .8 ambient .2 }
  scale <30,43,1> }
}

#declare Lt = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 43, 0> <10, 43, 0> <20, 43, 0> <30, 43, -2>
  <0, 20, 0> <10, 20, -2> <20, 20, 0> <30, 20, 0>
  <0, 10, 0> <10, 10, 0> <20, 10, 0> <30, 10, 0>
  <0, 0,  0> <10, 0,  0> <20, 0,  0> <30, 0,  0>
  texture {
  pigment { image_map { gif "t.gif" map_type 0 interpolate 0 } }
  finish { diffuse .8 ambient .2 }
  scale <30,43,1> }
}

#declare Lr = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 43, 0> <10, 43, 0> <20, 43, 0> <30, 43, 0>
  <0, 20, 0> <10, 20, 0> <20, 20, -1> <30, 20, 0>
  <0, 10, 0> <10, 10, 0> <20, 10, 0> <30, 10, 0>
  <0, 0,  0> <10, 0,  0> <20, 0,  0> <30, 0,  0>
  texture {
  pigment { image_map { gif "r.gif" map_type 0 interpolate 0 } }
  finish { diffuse .8 ambient .2 }
  scale <30,43,1> }
}

#declare Li = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 43, 0> <10, 43, 0> <20, 43, 0> <30, 43, 0>
  <0, 20, 0> <10, 20, 0> <20, 20, 0> <30, 20, 0>
  <0, 10, 0> <10, 10, 0> <20, 10, 0> <30, 10, 0>
  <0, 0,  0> <10, 0,  0> <20, 0,  0> <30, 0,  0>
  texture {
  pigment { image_map { gif "i.gif" map_type 0 interpolate 0 } }
  finish { diffuse .8 ambient .2 }
  scale <30,43,1> }
}

#declare Le = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 43, 0> <10, 43, 0> <20, 43, 0> <30, 43, 0>
  <0, 20, 0> <10, 20, 0> <20, 20, 0> <30, 20, 0>
  <0, 10, 0> <10, 10, 0> <20, 10, 0> <30, 10, 0>
  <0, 0,  0> <10, 0,  0> <20, 0,  0> <30, 0,  -7>
  texture {
  pigment { image_map { gif "e.gif" map_type 0 interpolate 0 } }
  finish { diffuse .8 ambient .2 }
  scale <30,43,1> }
}

#declare Arale = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 84, 0> <10, 84, 0> <45, 84, 0> <55, 84, 0>
  <0, 64, -.4> <10, 64, 0> <45, 64, 0> <55, 64, -.3>
  <0, 20, -.7> <10, 20, 0> <45, 20, 0> <55, 20, 0>
  <0, 0,  0> <10, 0,  -.3> <45, 0,  0> <55, 0,  -.5>
  texture {
  pigment { image_map { gif "arale.gif" map_type 0 interpolate 2 } }
  finish { diffuse .9 ambient .2 }
  scale <55,84,1> }
}

#declare Week = bicubic_patch { type 1 flatness 0.1 u_steps 3 v_steps 3
  <0, 80, 0> <10, 80, 0> <20, 80, 0> <50, 80, 0>
  <0, 20, 0> <10, 20, 0> <20, 20, 0> <50, 20, 0>
  <0, 10, 0> <10, 10, 0> <20, 10, 0> <50, 10, 0>
  <0, 0,  0> <10, 0,  0> <20,  0, 0> <50,  0, 0>
  texture {
  pigment { image_map { gif "week.gif" map_type 0 interpolate 2 } }
  finish { diffuse .9 ambient .2 }
  scale <50,80,1> }
}

// _____ Table 2 _____

#declare T_Wood35 =
  texture {
    pigment { wood turbulence 0.03725 omega 0.65725 lambda 2.425
      color_map {
        [0.250 rgbf <1.00000, 0.53373, 0.11665, 0.000>]
        [0.350 rgbf <0.66275, 0.28607, 0.00000, 0.000>]
        [0.525 rgbf <1.00000, 0.53363, 0.11715, 0.000>]
        [0.600 rgbf <0.66475, 0.28647, 0.00000, 0.000>]
        [0.750 rgbf <1.00000, 0.53353, 0.11565, 0.000>]
        [0.850 rgbf <0.66275, 0.28667, 0.00000, 0.000>]
        [1.000 rgbf <1.00000, 0.53143, 0.11795, 0.000>]
      }
      scale <0.25, 0.225, 1.0>
    }
  }
  texture {
    pigment { wood scale 1.01275 turbulence 0.0435 omega 0.65 lambda 3.15
      color_map {
        [0.200 color rgbf <0.56695, 0.17347, 0.00000, 0.8250>]
        [0.350 color rgbf <0.96471, 0.54510, 0.22753, 0.7710>]
        [0.400 color rgbf <0.56341, 0.17547, 0.00000, 0.9150>]
        [0.615 color rgbf <0.96472, 0.54510, 0.22553, 0.7590>]
        [0.700 color rgbf <0.56671, 0.17687, 0.00000, 0.7920>]
        [0.850 color rgbf <0.96485, 0.54510, 0.22453, 0.8975>]
        [1.000 color rgbf <0.56478, 0.17247, 0.00000, 0.9750>]
      }
      scale <0.225, 0.2725, 1.0>
      translate <-0.35, 0.095, 1.25>
    }
    finish { diffuse .6 ambient .1 phong .4 phong_size 60 reflection .04 }
    scale 5
}

#declare Table5 = union {
  box { 72*y, <120,75,55> texture { T_Wood35 rotate 90*x } }
  box { <5,0,5>, <8,73,50> texture { T_Wood35 rotate 90*x } }
  box { <112,0,5>, <115,73,50> texture { T_Wood35 rotate 90*x  } }
  box { <8,53,10>, <112,73,13> texture { T_Wood35 rotate 90*x } }
}

// _____ Background 2 _____

#declare Back = union {

// __ Floor __

object { Floor }

// __ Borrador __

object { Borrador rotate <-25,90,0> translate <9,71.4,476> }

// __ Walls __

object { Walls }

// __ Doors __

// Door 1
object { Door }
object { Frame1 }
object { Frame2 }
object { Hinge translate <34.25,188,699.3> }
object { Hinge translate <34.25,102,699.3> }
object { Hinge translate <34.25,16,699.3> }
// pomo
object { Pomo translate <107,96,699> }

// __ Blackboard __

object { Blackboard translate 14*z }

// __ Switch __

object { Switch }

// __ Perch __

object { Perch translate <200,140,687> }

// __ Posters __

object { Ld translate <132,163,699.5> }
object { Lt translate <166,181,699.5> }
object { Lr translate <199,160,699.5> }
object { Le translate <233,180,699.5> }
object { Li translate <269,161,699.5> }

object { Arale rotate -90*y translate <.2,110,610> }
// chinchetas
sphere { <.8,113,613>, .9 pigment { rgb .5 } }
sphere { <.8,191.5,613>, .9 pigment { rgb .5 } }
sphere { <.8,113,662>, .9 pigment { rgb .5 } }
sphere { <.8,191.5,662>, .9 pigment { rgb .5 } }

object { Week rotate -90*y translate <.4,100,550> }

// __ Table __

object { Table5 rotate-90*y translate <140,0,170> }

}
