
// Plastics (hands.inc)
// Lorenzo Quintana Juez (voyager@redestb.es)
// April 30, 1997

// textures

#declare T_Piel1 = texture {
  pigment { rgb <1,.8,.631> }
  finish { diffuse .8 ambient .2 }
}

#declare T_Piel2 = texture {
  pigment { rgb <.968,.76,.564> }
  finish { diffuse .8 ambient .2 }
}

#declare T_Piel3 = texture {
  pigment { rgb <1,.8,.631> }
  finish { diffuse .8 ambient .2 }
}

#declare T_Nails = texture {
  pigment { gradient z
  color_map {
  [  0.0  rgb <1,.862,.796>]
  [  0.7  rgb <1,.862,.796>]
  [  0.7  rgb <1,.9,.95>]
  [  1.0  rgb <1,.9,.95>] }
  rotate -40*x
  translate -.4*z
  }
  finish { diffuse .8 ambient .2 specular .5 roughness .005 }
}

// _____ Hand 1 _____

#declare Dedos1 = difference {
  union {
  // dedo 1
  sphere { 0, .7 }
  cone { 0, .7, <0,1,2.5>, .8 }
  sphere { <0,1,2.5>, .8 }
  cone { <0,1,2.5>, .8, <0,1.6,5>, .8 }
  sphere { <0,1.6,5>, .81 }
  // dedo 2
  sphere { <-1.7,0,-1>, .7 }
  cone { <-1.7,0,-1>, .7, <-1.7,1.1,2.5>, .8 }
  sphere { <-1.7, 1.1, 2.5>, .8 }
  cone { < -1.7, 1.1, 2.5 >, .8 < -1.7, 1.6, 5 >, .91 }
  sphere { <-1.7,1.6,5>, .91 }
  // dedo 3
  sphere { -3.4*x, .7 }
  cone { -3.4*x, .7, <-3.4,1,2.5>, .8 }
  sphere { <-3.4,1,2.5>, .8 }
  cone { <-3.4,1,2.5>, .8, <-3.4,1.6,5>, .89 }
  sphere { <-3.4,1.6,5>, .89 }
  // dedo 4
  sphere { <-5.1,0,1.5>, .6 }
  cone { <-5.1,0,1.5>, .6 <-5.1,1,4>, .7 }
  sphere { <-5.1,1,4>, .7 }
  cone { <-5.1,1,4>, .7, <-5.1,1.6,6>, .85 }
  sphere { <-5.1,1.6,6>, .85 }
  // pulgar
  sphere { <2,.7,3.8>, .7 }
  cone { <2,.7,3.8>, .7, <2.1,.8,5>, .8 }
  sphere { <2.1,.8,5>, .8 }
  cone { <2.1,.8,5>, .8, <2,1,7.5>, .81 }
  sphere { <2,1,7.5>, .8 }
  }
  // hueco unas
  sphere { 0, .7 scale <1,1,1.5> translate <2.6,.8,3.2> }
  sphere { 0, .7 scale <1,1,1.5> translate <0,.5,-.7> }
  sphere { 0, .7 scale <1,1,1.5> translate <-1.7,.5,-1.7> }
  sphere { 0, .7 scale <1,1,1.5> translate <-3.4,.5,-.7> }
  sphere { 0, .7 scale <.9,.9,1.4> translate <-5.1,.5,.8> }
  }

#declare Unas1 = union {
  sphere { 0, .7 scale <.9,.7,1.3> texture { T_Nails }
  rotate -27*x translate <0,.22,.2> }
  sphere { 0, .7 scale <.9,.7,1.3> texture { T_Nails }
  rotate -27*x translate <-1.7,.22,-.8> }
  sphere { 0, .7 scale <.9,.7,1.3> texture { T_Nails }
  rotate -27*x translate <-3.4,.22,.2> }
  sphere { 0, .7 scale <.8,.6,1.2> texture { T_Nails }
  rotate -27*x translate <-5.1,.22,1.7> }
  sphere { 0, .7 scale <.9,.7,1.2> texture { T_Nails }
  rotate <-23,-15,-79> translate <2.15,.75,3.9> }
}

#declare Palma1 = blob { threshold .5
  // dedo 1
  cylinder { <0,1.5,5>, <0,1.5,10>, 1.5, 1 }
  // dedo 2
  cylinder { <-1.7,1.5,5>, <-1.7,1.5,10>, 1.5, 1 }
   // dedo 3
  cylinder { <-3.4,1.5,5>, <-3.4,1.5,10>, 1.5, 1 }
  // dedo 4
  cylinder { <-5.1,1.5,6>, <-4.8,1.5,10>, 1.3, 1 }
  // pulgar
  cylinder { <2,1,7.5>, <1,1.4,10>, 1.5, 1 }
  // palma
  sphere { 0, 2, 1 scale <2.5,1,2> translate <-2.5,2,7.5> }
  sphere { 0, 2, 1 scale <2.6,1,2> translate <-2.3,2,10> }
  // muneca
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.2,2,11> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <-2.3,2,12> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <-2.3,2,13> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <-2.3,2,14> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <-2.3,2,15> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <-2.3,2,16> }
  sphere { 0, 2, .9 scale <1.6,1.1,2> translate <-2.3,2,17> }
  sphere { 0, 2, .9 scale <1.6,1.2,2> translate <-2.3,2,18> }
}

#declare Hand1 = union {
  object { Palma1 }
  object { Dedos1 }
  object { Unas1 }
  texture { T_Piel1 }
}

// _____ Hand 2 _____

#declare Dedos2 = difference {
  union {
  // dedo 1
  sphere { 0, .7 }
  cone { 0, .7, <0,1,2.5>, .8 }
  sphere { <0,1,2.5>, .8 }
  cone { <0,1,2.5>, .8, <0,1.6,5>, .8 }
  sphere { <0,1.6,5>, .81 }
  // dedo 2
  sphere { <1.7,0,-1>, .7 }
  cone { <1.7,0,-1>, .7, <1.7,1.1,2.5>, .8 }
  sphere { <1.7, 1.1, 2.5>, .8 }
  cone { < 1.7, 1.1, 2.5 >, .8 < 1.7, 1.6, 5 >, .91 }
  sphere { <1.7,1.6,5>, .91 }
  // dedo 3
  sphere { 3.4*x, .7 }
  cone { 3.4*x, .7, <3.4,1,2.5>, .8 }
  sphere { <3.4,1,2.5>, .8 }
  cone { <3.4,1,2.5>, .8, <3.4,1.6,5>, .89 }
  sphere { <3.4,1.6,5>, .89 }
  // dedo 4
  sphere { <5.1,0,1.5>, .6 }
  cone { <5.1,0,1.5>, .6 <5.1,1,4>, .7 }
  sphere { <5.1,1,4>, .7 }
  cone { <5.1,1,4>, .7, <5.1,1.6,6>, .85 }
  sphere { <5.1,1.6,6>, .85 }
  // pulgar
  sphere { <-2.5,.7,3.8>, .7 }
  cone { <-2.5,.7,3.8>, .7, <-2.1,.9,5>, .8 }
  sphere { <-2.1,.9,5>, .8 }
  cone { <-2.1,.9,5>, .8, <-2,1.2,7.5>, .81 }
  sphere { <-2,1.2,7.5>, .8 }
  }
  // hueco unas
  sphere { 0, .7 scale <1,1,1.5> translate <0,.5,-.7> }
  sphere { 0, .7 scale <1,1,1.5> translate <1.7,.5,-1.7> }
  sphere { 0, .7 scale <1,1,1.5> translate <3.4,.5,-.7> }
  sphere { 0, .7 scale <.9,.9,1.4> translate <5.1,.5,.8> }
}

#declare Unas2 = union {
  sphere { 0, .7 scale <.9,.7,1.3> texture { T_Nails }
  rotate -27*x translate <0,.22,.2> }
  sphere { 0, .7 scale <.9,.7,1.3> texture { T_Nails }
  rotate -27*x translate <1.7,.22,-.8> }
  sphere { 0, .7 scale <.9,.7,1.3> texture { T_Nails }
  rotate -27*x translate <3.4,.22,.2> }
  sphere { 0, .7 scale <.8,.6,1.2> texture { T_Nails }
  rotate -27*x translate <5.1,.22,1.7> }
}

#declare Palma2 = blob { threshold .5
  // dedo 1
  cylinder { <0,1.5,5>, <0,1.5,10>, 1.5, 1 }
  // dedo 2
  cylinder { <1.7,1.5,5>, <1.7,1.5,10>, 1.5, 1 }
  // dedo 3
  cylinder { <3.4,1.5,5>, <3.4,1.5,10>, 1.5, 1 }
  // dedo 4
  cylinder { <5.1,1.5,6>, <4.8,1.5,10>, 1.3, 1 }
  // pulgar
  cylinder { <-2,1.2,7.5>, <0,1.4,11>, 1.5, 1 }
  // palma
  sphere { 0, 2, 1 scale <2.5,1,2> translate <2.5,2,7.5> }
  sphere { 0, 2, 1 scale <2.6,1,2> translate <2.3,2,10> }
  // muneca
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.2,2,11> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <2.3,2,12> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <2.3,2,13> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <2.3,2,14> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <2.3,2,15> }
  sphere { 0, 2, .9 scale <1.6,1,2> translate <2.3,2,16> }
  sphere { 0, 2, .9 scale <1.6,1.1,2> translate <2.3,2,17> }
  sphere { 0, 2, .9 scale <1.6,1.2,2> translate <2.3,2,18> }
}

#declare Hand2 = union {
  object { Palma2 }
  object { Dedos2 }
  object { Unas2 }
  texture { T_Piel3 }
}

// _____ Hand 3 _____

#declare Dedos3 = union {
  // dedo 1
  sphere { <0,-2.1,7.5>, .7 }
  cone { <0,-2.1,7.5>, .7, <0,-2.1,5>, .8 }
  sphere { <0,-2.1,5>, .8 }
  cone { <0,-2.1,5>, .8, <0,1.6,5>, .8 }
  sphere { <0,1.6,5>, .81 }
  // dedo 2
  sphere { <1.7,-2.2,8>, .7 }
  cone { <1.7,-2.2,8>, .7, <1.7,-2.1,5>, .8 }
  sphere { <1.7, -2.2, 5>, .8 }
  cone { < 1.7, -2.2, 5 >, .8 < 1.7, 1.6, 5 >, .91 }
  sphere { <1.7,1.6,5>, .91 }
  // dedo 3
  sphere { <3.4,-2.2,7.5>, .7 }
  cone { <3.4,-2.2,7.5>, .7, <3.4,-2.3,5>, .8 }
  sphere { <3.4,-2.2,5>, .8 }
  cone { <3.4,-2.2,5>, .8, <3.4,1.6,5>, .89 }
  sphere { <3.4,1.6,5>, .89 }
  // dedo 4
  sphere { <4.8,-2,8.5>, .6 }
  cone { <4.8,-2,8.5>, .6 <4.8,-2,6>, .7 }
  sphere { <4.8,-2,5.5>, .7 }
  cone { <4.8,-2,5.5>, .7, <5.1,1.6,5.5>, .85 }
  sphere { <5.1,1.6,5.5>, .85 }
  // pulgar
  difference {
  union {
  sphere { <-1,-1,4.2>, .7 }
  cone { <-1,-1,4.2>, .7, <-1.8,0,6.6>, .81 }
  sphere { <-1.8,0,6.6>, .8 }
  }
  sphere { 0, .7 scale <1,1,1.5> translate <-1.6,-.9,3.6> }
  }
}

#declare Unas3 =   sphere { 0, .7 scale <.9,.7,1.2> texture { T_Nails }
  rotate <-23,15,79> translate <-1.2,-.9,4.4> }

#declare Palma3 = blob { threshold .5
  // dedo 1
  cylinder { <0,1.5,5>, <0,1.5,10>, 1.5, 1 }
  // dedo 2
  cylinder { <1.7,1.5,5>, <1.7,1.5,10>, 1.5, 1 }
   // dedo 3
  cylinder { <3.4,1.5,5>, <3.4,1.5,10>, 1.5, 1 }
  // dedo 4
  cylinder { <5.1,1.5,5.5>, <4.8,1.5,10>, 1.3, 1 }
  // pulgar
  cylinder { <-1.8,0,6.6>, <-1,1.4,10>, 1.5, 1 }
  // palma
  sphere { 0, 2, 1 scale <2.5,1,2> translate <2.5,2,7> }
  sphere { 0, 2, 1 scale <2.6,1,2> translate <2.3,2,10> }
  // muneca
  sphere { 0, 2, .9 scale <1.75,1,2> translate <2.2,2,11> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,12> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,13> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,14> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,15> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,16> }
  sphere { 0, 2, .9 scale <1.7,1.1,2> translate <2.3,2,17> }
  sphere { 0, 2, .9 scale <1.6,1.2,2> translate <2.3,2,18> }
  }

#declare Hand3 = union {
  object { Palma3 }
  object { Dedos3 }
  object { Unas3 }
  texture { T_Piel1 }
}

// _____ Hand 4 _____

#declare Dedos4 = union {
  // dedo 1
  sphere { <0,-2.1,7.5>, .7 }
  cone { <0,-2.1,7.5>, .7, <0,-2.1,5>, .8 }
  sphere { <0,-2.1,5>, .8 }
  cone { <0,-2.1,5>, .8, <0,1.6,5>, .8 }
  sphere { <0,1.6,5>, .81 }
  // dedo 2
  sphere { <1.7,-2.5,8>, .7 }
  cone { <1.7,-2.5,8>, .7, <1.7,-2.5,5>, .8 }
  sphere { <1.7, -2.5, 5>, .8 }
  cone { < 1.7, -2.5, 5 >, .8 < 1.7, 1.6, 5 >, .91 }
  sphere { <1.7,1.6,5>, .91 }
  // dedo 3
  sphere { <3.4,-2.3,7.5>, .7 }
  cone { <3.4,-2.3,7.5>, .7, <3.4,-2.3,5>, .8 }
  sphere { <3.4,-2.3,5>, .8 }
  cone { <3.4,-2.3,5>, .8, <3.4,1.6,5>, .89 }
  sphere { <3.4,1.6,5>, .89 }
  // dedo 4
  sphere { <4.8,-2,8.5>, .6 }
  cone { <4.8,-2,8.5>, .6 <4.8,-2,6>, .7 }
  sphere { <4.8,-2,5.5>, .7 }
  cone { <4.8,-2,5.5>, .7, <5.1,1.6,5.5>, .85 }
  sphere { <5.1,1.6,5.5>, .85 }
  // pulgar
  difference {
  union {
  sphere { <-1,0,4.2>, .7 }
  cone { <-1,0,4.2>, .7, <-1.8,1,6.6>, .81 }
  sphere { <-1.8,1,6.6>, .8 }
  cone { <-1.8,1,6.6>, .8, <-1.5,1.4,8>, .81 }
  }
  sphere { 0, .7 scale <1,1,1.5> translate <-1.6,.1,3.6> }
  }
}

#declare Unas4 =   sphere { 0, .7 scale <.9,.7,1.2> texture { T_Nails }
  rotate <-23,15,79> translate <-1.2,.1,4.4> }

#declare Palma4 = blob { threshold .5
  // dedo 1
  cylinder { <0,1.5,5>, <0,1.5,10>, 1.5, 1 }
  // dedo 2
  cylinder { <1.7,1.5,5>, <1.7,1.5,10>, 1.5, 1 }
   // dedo 3
  cylinder { <3.4,1.5,5>, <3.4,1.5,10>, 1.5, 1 }
  // dedo 4
  cylinder { <5.1,1.5,5.5>, <4.8,1.5,10>, 1.3, 1 }
  // pulgar
  cylinder { <-1.5,1.4,8>, <-1,1.4,10>, 1.5, 1 }
  // palma
  sphere { 0, 2, 1 scale <2.5,1,2> translate <2.5,2,7> }
  sphere { 0, 2, 1 scale <2.6,1,2> translate <2.3,2,10> }
  // muneca
  sphere { 0, 2, .9 scale <1.75,1,2> translate <2.2,2,11> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,12> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,13> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,14> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,15> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <2.3,2,16> }
  sphere { 0, 2, .9 scale <1.7,1.1,2> translate <2.3,2,17> }
  sphere { 0, 2, .9 scale <1.6,1.2,2> translate <2.3,2,18> }
}

#declare Hand4 = union {
  object { Palma4 }
  object { Dedos4 }
  object { Unas4 }
  texture { T_Piel2 }
}

// _____ Hand 5 _____

#declare Dedos5 = union {
  // dedo 1
  sphere { <0,-1,7>, .7 }
  cone { <0,-1,7>, .7, <0,-1.8,5>, .8 }
  sphere { <0,-1.8,5>, .8 }
  cone { <0,-1.8,5>, .8, <0,1.6,5>, .8 }
  sphere { <0,1.6,5>, .81 }
  // dedo 2
  sphere { <-1.7, -2.5, 5>, .8 }
  cone { < -1.7, -2.5, 5 >, .8 < -1.7, 1.6, 5 >, .91 }
  sphere { <-1.7,1.6,5>, .91 }
  // dedo 3
  sphere { <-3.4,-2.3,5>, .8 }
  cone { <-3.4,-2.3,5>, .8, <-3.4,1.6,5>, .89 }
  sphere { <-3.4,1.6,5>, .89 }
  // dedo 4
  sphere { <-4.8,-2,8.5>, .6 }
  cone { <-4.8,-2,8.5>, .6 <-4.8,-2,6>, .7 }
  sphere { <-4.8,-2,5.5>, .7 }
  cone { <-4.8,-2,5.5>, .7, <-5.1,1.6,5.5>, .85 }
  sphere { <-5.1,1.6,5.5>, .85 }
  // pulgar
  difference {
  union {
  sphere { <1.8,-.2,4.2>, .7 }
  cone { <1.8,-.2,4.2>, .7, <1.8,.5,6.6>, .8 }
  sphere { <1.8,.5,6.6>, .8 }
  cone { <1.8,.5,6.6>, .8, <1.5,1.2,9>, .8 }
  sphere { <1.5,1.2,9>, .8 }
  }
  sphere { 0, .7 scale <1,1,1.5> translate <1.94,-.1,3.6> }
  }
}

#declare Unas5 = sphere { 0, .7 scale <.9,.7,1.2> texture { T_Nails }
  rotate <-23,-15,-79> translate <2.13,0,4.5> }

#declare Palma5 = blob { threshold .5
  // dedo 1
  cylinder { <0,1.5,5>, <0,1.5,10>, 1.5, 1 }
  // dedo 2
  cylinder { <-1.7,1.5,5>, <-1.7,1.5,10>, 1.5, 1 }
   // dedo 3
  cylinder { <-3.4,1.5,5>, <-3.4,1.5,10>, 1.5, 1 }
  // dedo 4
  cylinder { <-5.1,1.5,5.5>, <-4.8,1.5,10>, 1.3, 1 }
  // pulgar
  cylinder { <1.5,1.2,9>, <0,1.5,12>, 1.45, 1 }
  // palma
  sphere { 0, 2, 1 scale <2.5,.9,2> translate <-2.5,2,7> }
  sphere { 0, 2, 1 scale <2.6,.9,2> translate <-2.3,2,10> }
  // muneca
  sphere { 0, 2, .9 scale <1.75,1,2> translate <-2.2,2,11> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,12> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,13> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,14> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,15> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,16> }
  sphere { 0, 2, .9 scale <1.7,1.1,2> translate <-2.3,2,17> }
  sphere { 0, 2, .9 scale <1.6,1.2,2> translate <-2.3,2,18> }
  }

#declare Hand5 = union {
  object { Palma5 }
  object { Dedos5 }
  object { Unas5 }
  texture { T_Piel3 }
}

// _____ Hand 6 _____

#declare Dedos6 = union {
  // dedo 1
  sphere { <0,-2,7.5>, .7 }
  cone { <0,-2,7.5>, .7, <0,-2.1,5>, .8 }
  sphere { <0,-2.1,5>, .8 }
  cone { <0,-2.1,5>, .8, <0,1.6,5>, .8 }
  sphere { <0,1.6,5>, .81 }
  // dedo 2
  sphere { <-1.7,-2,8>, .7 }
  cone { <-1.7,-2,8>, .7, <-1.7,-2.5,5>, .8 }
  sphere { <-1.7, -2.5, 5>, .8 }
  cone { < -1.7, -2.5, 5 >, .8 < -1.7, 1.6, 5 >, .91 }
  sphere { <-1.7,1.6,5>, .91 }
  // dedo 3
  sphere { <-3.4,-2,7.5>, .7 }
  cone { <-3.4,-2,7.5>, .7, <-3.4,-2.3,5>, .8 }
  sphere { <-3.4,-2.3,5>, .8 }
  cone { <-3.4,-2.3,5>, .8, <-3.4,1.6,5>, .89 }
  sphere { <-3.4,1.6,5>, .89 }
  // dedo 4
  sphere { <-4.8,-1.5,8.5>, .6 }
  cone { <-4.8,-1.5,8.5>, .6 <-4.8,-2,5.5>, .7 }
  sphere { <-4.8,-2,5.5>, .7 }
  cone { <-4.8,-2,5.5>, .7, <-5.1,1.6,5.5>, .85 }
  sphere { <-5.1,1.6,5.5>, .85 }
  // pulgar
  difference {
  union {
  sphere { <1,-2,4.2>, .7 }
  cone { <1,-2,4.2>, .7, <1.8,-1,6.6>, .81 }
  sphere { <1.8,-1,6.6>, .8 }
  }
  sphere { 0, .7 scale <1,1,1.5> translate <1.6,-2,3.6> }
  }
}

#declare Unas6 = sphere { 0, .7 scale <.9,.7,1.2> texture { T_Nails }
  rotate <-23,-15,-79> translate <1,-1.95,4.4> }

#declare Palma6 = blob { threshold .5
  // dedo 1
  cylinder { <0,1.5,5>, <0,1.5,10>, 1.5, 1 }
  // dedo 2
  cylinder { <-1.7,1.5,5>, <-1.7,1.5,10>, 1.5, 1 }
   // dedo 3
  cylinder { <-3.4,1.5,5>, <-3.4,1.5,10>, 1.5, 1 }
  // dedo 4
  cylinder { <-5.1,1.5,5.5>, <-4.8,1.5,10>, 1.3, 1 }
  // pulgar
  cylinder { <1.8,-1,6.6>, <1,1.2,11>, 1.5, 1 }
  // palma
  sphere { 0, 2, 1 scale <2.5,1,2> translate <-2.5,2,7> }
  sphere { 0, 2, 1 scale <2.6,1,2> translate <-2.3,2,10> }
  // muneca
  sphere { 0, 2, .9 scale <1.75,1,2> translate <-2.2,2,11> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,12> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,13> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,14> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,15> }
  sphere { 0, 2, .9 scale <1.7,1,2> translate <-2.3,2,16> }
  sphere { 0, 2, .9 scale <1.7,1.1,2> translate <-2.3,2,17> }
  sphere { 0, 2, .9 scale <1.6,1.2,2> translate <-2.3,2,18> }
}

#declare Hand6 = union {
  object { Palma6 }
  object { Dedos6 }
  object { Unas6 }
  texture { T_Piel2 }
}
