
// Plastics (plastics.inc)
// Lorenzo Quintana Juez (voyager@redestb.es)
// April 30, 1997

// _____ Table _____

// __ textures __

#declare Green1 = rgb <.2, .9, .5>

#declare P_Tablero1 = pigment { spotted
  color_map {
    [ 0.000 rgb<0.873, 0.381, 0.221> ]
    [ 0.194 rgb<0.873, 0.381, 0.221> ]
    [ 0.201 rgb<0.942, 0.603, 0.289> ]
    [ 0.601 rgb<0.942, 0.603, 0.289> ]
    [ 0.601 rgb<1.000, 0.726, 0.423> ]
    [ 1.000 rgb<1.000, 0.726, 0.423> ] }
    scale <.3, .03, .3>
  }

#declare T_Tablero1 = texture {
  pigment { gradient y
    pigment_map {
      [ 0.00 Green1 ]
      [ 0.05 Green1 ]
      [ 0.04 rgb 0 ]
      [ 0.09 rgb 0 ]
      [ 0.09 P_Tablero1 ]
      [ 0.91 P_Tablero1 ]
      [ 0.91 rgb 0 ]
      [ 0.96 rgb 0 ]
      [ 0.96 Green1 ]
      [ 1.00 Green1 ]
    }
  }
  finish { diffuse .8 ambient .2 phong .5 reflection .05 }
  scale 2
  translate 68*y
}

#declare T_Tablero2 = texture {
  pigment { gradient y
    color_map {
      [ 0.00 Green1 ]
      [ 0.04 Green1 ]
      [ 0.04 rgb 0 ]
      [ 0.07 rgb 0 ]
      [ 0.07 rgb <0,.2,0> ]
      [ 0.93 rgb <0,.2,0> ]
      [ 0.93 rgb 0 ]
      [ 0.96 rgb 0 ]
      [ 0.96 Green1 ]
      [ 1.00 Green1 ] }
  }
  finish { diffuse .8 ambient .2 phong .5 reflection .05 }
  scale 2
  translate 68*y
}

#declare T_Tube = texture {
  pigment { rgb <0,.3,.1> }
  finish { diffuse .8 ambient .2 specular .8 roughness .01 }
}

#declare T_Canto = texture {
  pigment { gradient z
    color_map {
      [ 0 rgb 0 ]
      [ .08 rgb 0 ]
      [ .08 Green1 ]
      [ 1 Green1 ]
    }
  }
  finish { diffuse .8 ambient .2 phong .5 reflection .05 }
}

// __ objects __

#declare Codo = intersection {
  torus { 6, 1.25 }
  box { -2*y, <8,2,-8> }
  rotate 90*x translate -6*x
}

#declare Patas = union {
  cylinder { <-22,0,17>, <-22,60.75,17>, 1.25 }
  cylinder { <-22,0,-17>, <-22,60.75,-17>, 1.25 }
  cylinder { <22,0,17>, <22,60.75,17>, 1.25 }
  cylinder { <22,0,-17>, <22,60.75,-17>, 1.25 }
  cylinder { <-17,66.5,17>, <17,66.75,17>, 1.25 }
  cylinder { <-17,66.5,-17>, <17,66.75,-17>, 1.25 }
  object { Codo translate <22,60.75,17> }
  object { Codo translate <22,60.75,-17> }
  object { Codo rotate 180*y translate <-22,60.75,17> }
  object { Codo rotate 180*y translate <-22,60.75,-17> }
  texture { T_Tube }
}

#declare Tablero1 = box { <-25,68,-21>, <25,70,21> texture { T_Tablero1 } }

#declare Tablero2 = box { <-25,68,-21>, <25,70,21> texture { T_Tablero2 } }

#declare Canto = box { <-1,68.1,0>, <1,69.9,-.1> texture { T_Canto } }

#declare Table1A = union {
  object { Canto scale <25,1,1> translate -21*z }
  object { Canto scale <21,1,1> rotate -90*y translate 25*x }
  object { Canto scale <21,1,1> rotate 90*y translate -25*x }
  object { Tablero1 }
  object { Patas }
}

#declare Table1B = union { // rota
  difference {
    object { Canto scale <25,1,1> translate -21*z }
    union {
    box { <-5,-3,0>, <3,3,-2>  rotate <0,20,-30>
    texture { T_Canto } translate <-22,69,-21> }
    sphere { 0, .1 scale <10,5,.5>
    texture { T_Canto } translate <-22,69.2,-21> }
    }
  }
  object { Canto scale <21,1,1> rotate -90*y translate 25*x }
  object { Canto scale <21,1,1> rotate 90*y translate -25*x }
  object { Tablero1 }
  object { Patas }
}

#declare Table2 = union {
  object { Tablero2 }
  object { Patas }
}

#declare Name = text { ttf "kidsn.ttf" " 1997 Lorenzo Quintana" .01, 0
  pigment { rgb <1,1,1> } finish { diffuse .8 ambient .3 }
}

object { Name rotate <9,-30,0> scale .02 translate <84.674,103.544,-163> }

// _____ Chair __________

// __ textures __

#declare T_Screw = texture {
  pigment { rgb .75 }
  finish { diffuse .4 ambient .3 brilliance 3 metallic
    specular .7 roughness .016 reflection .25 }
}

#declare T_Chair1 = texture {
  pigment { Green1  }
  finish { diffuse .8 ambient .2 phong .5 reflection .05 }
}

#declare T_Chair2 = texture {
  pigment { wood
    color_map {
      [ 0.0 Green1 ]
      [ 0.1 Green1 ]
      [ 0.1 rgb 0 ]
      [ 0.15 rgb 0 ]
      [ 0.15 rgb<0.87, 0.38, 0.22> ]
      [ 0.85 rgb<0.87, 0.38, 0.22> ]
      [ 0.85 rgb 0 ]
      [ 0.9 rgb 0 ]
      [ 0.9 Green1 ]
      [ 1.0 Green1 ]
   }
   scale 2.5 rotate 90*x  translate 55*x
  }
  finish { diffuse .8 ambient .2 phong .5 reflection .05 }
}

#declare T_Pie_Resp = texture {
  pigment { rgb .5 }
  finish { diffuse .8 ambient .2 phong .5 reflection .05 }
}

// __ objects __

#declare Screw = difference {
  sphere { 0, .5 scale <.5,1,1> }
  merge {
    box { <.1,-.27,-.05>, <1,.27,.05> }
    box { <.1,-.05,-.27>, <1,.05,.27> }
  }
  texture { T_Screw }
}

#declare Tubo_Resp = union {
  superellipsoid { <1, .2> rotate 90*x scale <1.25,1,1.25> }
  cylinder { 0, -30*y, 1.25 }
  texture { T_Tube }
}

#declare PiezaRes = box { <0,-1.5,-1>, <3,1.5,1> texture { T_Pie_Resp } }

#declare RespaldoA = intersection {
  difference {
    cylinder { 55*x, <55, 30, 0>, 55  }
    cylinder { <55, -1, 0> , <55, 31, 0>, 53.7  }
  }
  superellipsoid { <.2, .4> scale <10,10,15> translate 15*y }
  texture { T_Chair2 }
  }

#declare RespaldoB = intersection {
  difference {
    cylinder { 55*x, <55, 30, 0>, 54.9  }
    cylinder { <55, -1, 0> , <55, 31, 0>, 53.8  }
  }
  superellipsoid { <.2, .4> scale <10,10.1,15.1> translate 15*y }
  texture { T_Chair1 }
  }

#declare Respaldo = union {
  object { RespaldoA }
  object { RespaldoB }
  object { Screw rotate 14*y translate <2.3,9,10> }
  object { Screw rotate 14*y translate <2.3,20,10> }
  object { Screw rotate -14*y translate <2.3,9,-10> }
  object { Screw rotate -14*y translate <2.3,20,-10> }
  object { PiezaRes rotate 10*y translate <-1,9,10> }
  object { PiezaRes rotate 10*y translate <-1,20,10> }
  object { PiezaRes rotate -10*y translate <-1,9,-10> }
  object { PiezaRes rotate -10*y translate <-1,20,-10> }
  object { Tubo_Resp translate <-.5,22,10> }
  object { Tubo_Resp translate <-.5,22,-10> }
}

#declare Culo = box { <0,40,-15>, <30,38.5,15> texture { T_Chair1 } }

#declare Chair =  union {
  object { Respaldo scale .85 rotate 14*z translate 53*y }
  object { Culo }
}

// _____ Students _____

// _____ Girl 1 _____

// textures

#declare T_Piel3 = texture {
  pigment { rgb <1,.8,.631> }
  finish { diffuse .8 ambient .2 }
}

#declare T_Girl1a = texture {
  pigment { rgb 1 }
  normal { bumps .3 scale 5 }
  finish { diffuse .8 ambient .3 }
}

#declare T_Vestido1a = texture {
  pigment { granite turbulence 1 color_map {
    [ 0 rgb <.1,.1,.18> ]
    [ .5 rgb <.1,.1,.18> ]
    [ .5 rgb <.3,.2,.28> ]
    [ 1 rgb <.3,.2,.28> ]
    }
    scale .01
  }
  normal { waves .25 scale <.3,3,.1> translate <200,-100,0> turbulence .1  }
  finish { diffuse .8 ambient .2 }
}

#declare T_Vestido1b = texture {
  pigment { granite turbulence 1 color_map {
    [ 0 rgb <.1,.1,.18> ]
    [ .5 rgb <.1,.1,.18> ]
    [ .5 rgb <.3,.2,.28> ]
    [ 1 rgb <.3,.2,.28> ]
    }
    scale .01
    }
  finish { diffuse .8 ambient .2 }
}

// objects

// __ Vestido __

#declare Vest1 = union {
  difference {
  blob { threshold 0.6
  cylinder { <0,55,0>, <0,83,0>, 16.5 ,2 scale <.95,1,.8>
  rotate -11*x translate 25*z }
  sphere { 0, 20, 1 scale <.65,.15,1> rotate 55*x translate <0,75,10> }
  sphere { 0, 20, 1 scale <.60,.15,.9> rotate 40*x translate <0,60,11> }
  }
  union {
  // agujero cuello
  cylinder { <0,90,-40>, <0,96,40>, 5.5 }
  // agujero brazos
  cylinder { -25*x, 25*x, 4 scale <1,1.4,1> rotate 25*x translate <0,85,8> }
  }
  texture { T_Vestido1a }
  }
  union {
  sphere { <0,83,0>, 11 }
  cone { <0,83,0>, 11, <0,80.6,-25>, 10 }
  scale <.95,.69,.8> rotate -11*x translate 25*z
  texture { T_Vestido1b }
  }
  texture { T_Vestido1a }
}

// __ Camiseta __

#declare Cami1 = union {
  // tronco
  intersection {
  blob { threshold 0.6
  cylinder { <0,55,0>, <0,83,0>, 16.4 ,2 scale <.95,1,.8>
  rotate -11*x translate 25*z }
  }
  cylinder { <0,90,-40>, <0,96,40>, 5.5 }
  }
  blob { threshold 0.6
  // hombros
  cylinder { -11.4*x, <0,0,-2>, 8.5, 1 scale <1,1.4,1>
  rotate 25*x translate <0,85,8> }
  // right arm
  cylinder { <-13,85.5,8>, <-18,73,10>, 3, 1.5 }
  cylinder { <-18,73,10>, <-10.5,72.2,-9.5>, 3, 2 }
  sphere { 0, 4, 1 scale <.6,1.1,2> rotate -10*y translate <-10.5,72.2,-9.5> }
  sphere { 0, 4, 1 scale <.8,1.1,2> rotate -30*y translate <-14,72.5,-2> }
  sphere { 0, 4, 1 scale <.8,1.1,2> rotate -30*y translate <-17,73,3>
  }
  sphere { 0, 4, 1 scale <.8,1.1,2> rotate -30*y translate <-18,73,8> }
  sphere { 0, 4, 1 scale <1.3,2,1.2> translate <-17,75,9.5> }
  sphere { 0, 3, 1 scale <1.1,.6,1.3> translate <-16.5,76.6,8> }
  sphere { 0, 3, 1 scale <1.1,1.5,1.2> translate <-16,79,8> }
  sphere { 0, 4, 1 scale <1,2,1.1> translate <-15.5,80,8.5> }
  sphere { 0, 4, 1 scale <.9,2,1.2> translate <-14.5,83,8> }
  }
  texture { T_Girl1a }
}

// __ Piernas __

#declare Pier = union {
  // izq
  cone { <5,55,10>, 5, <4.2,49.5,-17>, 4 }
  sphere { <4,49.5,-17>, 4 }
  cone { <4,49.5,-17>, 4, <4,0,-13>,3 }
  // der
  cone { <-4.9,55,10>, 5, <-4,49,-17>, 4 }
  sphere { <-4,49,-17>, 4 }
  cone { <-4,49,-17>, 4, <-4,0,-13>,3 }
  texture { T_Piel3 }
}

// __ Girl 1 __

#declare Girl1 = union {
  object { Vest1 }
  object { Cami1 }
  object { Pier }
}

// _____ Boy 1 _____

// __ textures __

#declare T_Boy1a = texture {
  pigment { rgb <.1,0,.2> }
  finish { diffuse .7 ambient .3 }
}

// __ objects __

#declare Boy1 = difference {
  blob { threshold 0.6
  cylinder { <0,55,0>, <0,84,0>, 16.5 ,2 scale <.9,1,.8>
  rotate -11*x translate 25*z }
  // brazo izq
  sphere { 0, 4, 1 scale <1.2,1.5,2> rotate -1*y translate <16.8,73.7,-10> }
  sphere { 0, 4, 1 scale <1.3,1.4,2> rotate -1*y translate <16.8,73.7,-2.2> }
  sphere { 0, 4, 1 scale <1.35,1.4,2> translate <15.8,73.5,5> }
  sphere { 0, 4, 1 scale <1.15,1.6,1.8> translate <14.9,76,9> }
  sphere { 0, 4, 1 scale <1.25,1.7,1.6> translate <14.4,80,8> }
  sphere { 0, 4, 1 scale <1.25,1.9,1.4> translate <13.6,84,7> }
  sphere { 0, 4, .9 scale <1.9,1.6,1.6> translate <10.2,87.5,7> }
  sphere { 0, 4, -1 scale <.6,.75,1.5> rotate -1*y translate <17,73.7,-11> }
  sphere { 0, 4, -1 scale <3,3,1> rotate -1*y translate <17.8,73.7,-15> }
  // brazo der
  sphere { 0, 4, 1 scale <1.2,1.5,2> rotate -28*y translate <-7,73,-10> }
  sphere { 0, 3.9, -1 scale <.6,.75,1.5> rotate -28*y translate <-7,73,-10> }
  sphere { 0, 4, -1 scale <3,3,1> rotate -28*y translate <-8,73,-15> }
  sphere { 0, 4, 1 scale <1.2,1.4,2> rotate -33*y
  translate <-9.6,72,-4> }
  sphere { 0, 4, 1 scale <1.1,1.4,2> rotate -32*y
  translate <-10.9,72,-2> }
  sphere { 0, 4, 1 scale <1.1,1.4,1.7> rotate -32*y
  translate <-12.4,72.5,2> }
  sphere { 0, 4, 1 scale <1.3,1.4,2> translate <-14.5,72.5,5> }
  sphere { 0, 4, 1 scale <1.2,1.6,1.8> translate <-15.3,76,9> }
  sphere { 0, 4, 1 scale <1.2,1.7,1.6> translate <-14.8,80,8> }
  sphere { 0, 4, 1 scale <1.1,1.9,1.4> translate <-14.4,82.8,7> }
  sphere { 0, 4, .9 scale <2,1.5,1.6> translate <-10.6,87,6.5> }
  sphere { 0, 3, .9 scale <1.7,2.5,1.6> rotate 8*z translate <-8,82,5.5> }
  sphere { 0, 2, .9 scale <1.5,5,.9> rotate <-10,0,-7>
  translate <9.5,80,3.5> }
  sphere { 0, 4, .8 scale <2,2.5,1.5> translate <-4.9,84,4.4> }
  sphere { 0, 4, .8 scale <2,2.5,1.5> translate <0,82,4> }
  sphere { 0, 4, .8 scale <2,2.5,1.5> translate <5,84,4.4> }
  sphere { 0, 3.7, 1.2 scale <3.2,2.6,2.6> translate <0,75,6.8> }
  }
  cylinder { <2,90,-10>, <2,100,20>, 5 }
  texture { T_Boy1a  }
}

// _____ Girl 2 _____

// __ textures __

#declare T_Girl2a = texture {
  pigment { rgb 0 }
  finish { diffuse .7 ambient .3 }
}

// __ objects __

#declare Girl2 = difference {
  blob { threshold 0.6
  cylinder { <0,55,0>, <0,83,0>, 16.5 ,2 scale <.95,1,.8>
  rotate -11*x translate 25*z }
  // brazo izq
  sphere { 0, 4, 1 scale <1.4,1,2>  translate <15.65,72.5,-12> }
  sphere { 0, 4, -1 scale <.67,.47,1.5> translate <15.65,72.5,-12> }
  sphere { 0, 4, -1 scale <3,3,1> translate <16.65,72.5,-16> }
  sphere { 0, 4, 1 scale <1.4,1.4,2.2> translate <15.65,72.5,-4.3> }
  sphere { 0, 4, 1 scale <1.4,1.4,2> translate <15.5,72.5,3> }
  sphere { 0, 3.9, 1 scale <1.15,1.6,1.8> translate <14.5,75,7> }
  sphere { 0, 3.9, 1 scale <1.25,1.7,1.6> translate <14,79,7> }
  sphere { 0, 3.9, 1 scale <1.2,2,1.4> translate <13,82,7> }
  sphere { 0, 4, .9 scale <2,1.5,1.5> translate <10,86,6> }
  // brazo der
  sphere { 0, 4, 1 scale <1.4,1,2>  translate <-13.1,73,-10> }
  sphere { 0, 4, -1 scale <.67,.47,1.5> translate <-13.1,73,-10> }
  sphere { 0, 4, -1 scale <3,3,1> translate <-14,72.8,-14> }
  sphere { 0, 4, 1 scale <1.4,1.4,2.2> translate <-13.8,72.5,-2.3> }
  sphere { 0, 4, 1 scale <1.4,1.4,2> translate <-15,72,5> }
  sphere { 0, 3.5, 1.3 scale <1.15,1.7,1.8> translate <-14,74,10> }
  sphere { 0, 3.5, 1.3 scale <1.25,1.8,1.6> translate <-13,78,9> }
  sphere { 0, 3.5, 1.3 scale <1.2,2,1.4> translate <-13,82,8> }
  sphere { 0, 4, .9 scale <2,1.5,1.5> translate <-10,86,7> }
  }
  cylinder { <0,91,-40>, <0,96,40>, 7 }
  texture { T_Girl2a  }
}

// _____ Boy 2 _____

// textures

#declare T_Boy2 = texture {
  pigment { rgb <0,.18,0> }
  finish { diffuse .7 ambient .3 }
}

// objects

#declare Boy2 = blob { threshold 0.6
  cylinder { <0,55,0>, <0,84,0>, 16.5 ,2 scale <.9,1,.8>
  rotate -11*x translate 25*z }
  // brazo izq
  sphere { 0, 4, 1 scale <1.2,1.5,2> rotate -1*y translate <16.4,73.7,-10> }
  sphere { 0, 4, 1 scale <1.3,1.4,2> rotate -1*y translate <16.4,73.7,-2.2> }
  sphere { 0, 4, 1 scale <1.35,1.4,2> translate <15.4,73.5,5> }
  sphere { 0, 4, 1 scale <1.15,1.6,1.8> translate <14.5,76,9> }
  sphere { 0, 4, 1 scale <1.25,1.7,1.6> translate <14,80,8> }
  sphere { 0, 4, 1 scale <1.25,1.9,1.4> translate <13.2,84,7> }
  sphere { 0, 4, .9 scale <1.9,1.6,1.6> translate <10.2,87.5,7> }
  sphere { 0, 4, .9 scale <2,1.5,1.6> translate <-10.6,87,6.5> }
  sphere { 0, 3, .9 scale <1.7,2.5,1.6> rotate 8*z translate <-8,82,5.5> }
  sphere { 0, 2, .9 scale <1.5,5,.9> rotate <-10,0,-7> translate <9.5,80,3.5> }
  sphere { 0, 3.7, 1.2 scale <3.2,2.6,2.6> translate <0,75,6.8> }
  texture { T_Boy2  }
}
