/*

Ingersoll Regulator Schoolhouse Clock
Designed by: Robert E. Bolin

Design Notes:

This clock is actually based on two clocks.  The body is based on a
Seth Thomas Schoolhouse Regulator circa 1870 and the face plate is
based on a Waterbury Schoolhouse Regulator.  The Ingersoll name was
owned by Waterbury Clock Company for their watch line, but I liked
it so well that I thought it would work nice as an engraving on the
glass.

*/

#version 3.0
global_settings { assumed_gamma 2.2 }
global_settings { max_intersections 128 }
global_settings { max_trace_level 200 }

//#include "debug.inc"
//#include "atmos.inc"
//#include "chars.inc"
#include "colors.inc"
#include "finish.inc"
#include "glass.inc"
#include "metals.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "shapesq.inc"
#include "skies.inc"
//#include "stars.inc"
//#include "stones.inc"
#include "textures.inc"

// #default { finish { specular 0.15 roughness 0.025 ambient 0.25 } }
#default { finish {Glossy} }

#include "woods.inc"

// Background
background {SummerSky}

// Camera Placement

#declare camera_location  = <0, 0,  -40>
#declare camera_direction = <0, 0, 2.25>
#declare camera_look_at   = <0, 0,    1>

camera {
   location  camera_location
   direction camera_direction
   right x*4/3
   look_at   camera_look_at
}

// Lighting Placement
light_source {
  0*x
  color rgb <.6,.6,.6>
  translate <0, 35, -50>
  jitter
}

#declare flare_position = <-2000, -415, 6000>
#declare flare_type = 2
#declare flare_spots = false

#include "LensFlar.inc"

// Declarations

// Number Texture declaration
#declare N_Texture =
  texture {
    pigment {Black}
    finish {F_MetalB}
  }

// Solder Texture declaration
#declare Solder=
  texture {
    pigment {P_Silver1}
    finish {F_MetalB}
  }

// Clock Hands Texture declaration
#declare CH_Texture =
    texture {
      pigment {Black}
      finish {F_MetalA}
    }

// Hardware Texture declaration
#declare HW_Texture =
  texture {
    T_Brass_5A
  }

// Window Fram texture
#declare WF_Texture =
  texture {
    T_Wood1
    rotate x*90
    translate -x*1
  }

// Begin Border declarations
#declare FB_Texture =
  texture {
    T_Wood14
    rotate x*90
    translate -x*1
  }

#declare Pendulum_Border_Board =
  object {
    union {
      difference {
        box {<-5,.5,0>,<5,1.5,-1/3>}
        cylinder {<-10,0,0>,<10,0,0>,1/2 scale <1,1,4/15> translate -z*1/3 translate y*.5}
      }
      difference {
        cylinder {<-5,0,0>,<5,0,0>,1/2 scale <1,1,1/3> translate y*1.5 translate -z*1/3}
        box {<-10,1.5,-10>,<10,10,10>}
      }
      difference {
        cylinder {<-5,0,0>,<5,0,0>,1/2 scale <1,1,4/15> translate y*.5}
        box {<-10,-10,0>,<10,10,10>}
      }
    }
  }

#declare Face_Border_Board =
  object {
    difference {
      merge {
        cylinder {
          <-100, 0, 0>
          < 100, 0, 0>
          .75
        scale y*2/3
        }
        box {<-100,0,0>,<100,-4,-.75>}
      }
      box {<-200,-1,0>,<200,1,1>}
    }
  }

#declare Face_Border_Shape =
  object {
    difference {
      object { Face_Border_Board }
      box {
        <-200,-200,-200>
        <   0, 200, 200>
        rotate z*22.5
        translate -y*7.995
      }
      box {
        <   0,-200,-200>
        < 200, 200, 200>
        rotate -z*22.5
        translate -y*7.995
      }
    }
  }

#declare FB_Top =
  object {
    Face_Border_Shape
    texture {
      FB_Texture translate -x*10
    }
  translate y*8
  }

#declare FB_Bottom =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*4 translate -x*10
    }
  translate y*8
  rotate z*180
  }

#declare FB_UR =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*8 translate -x*10
    }
  translate y*8
  rotate z*45
  }

#declare FB_UL =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*12 translate -x*10
    }
  translate y*8
  rotate -z*45
  }

#declare FB_Right =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*16 translate -x*10
    }
  translate y*8
  rotate z*90
  }

#declare FB_Left =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*20 translate -x*10
    }
  translate y*8
  rotate -z*90
  }

#declare FB_LR =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*24 translate -x*10
    }
  translate y*8
  rotate z*135
  }

#declare FB_LL =
  object {
    Face_Border_Shape
    texture {
      FB_Texture
      translate -y*28 translate -x*10
    }
  translate y*8
  rotate -z*135
  }

#declare Face_Border =
  union {
    object { FB_Top }
    object { FB_UR }
    object { FB_Right }
    object { FB_LR }
    object { FB_Bottom }
    object { FB_LL }
    object { FB_Left }
    object { FB_UL }
  }
// End Border declarations

// Begin the completed clock
#declare Ingersoll_Regulator_Schoolhouse_Clock =
object {
  union {

// The Face Border and Brass Trim
difference {
  union {
    object { Face_Border }
    cylinder {
      <0,0,-.70>
      <0,0,-.80>
      6.35
      texture { HW_Texture }
    }
  }
  cone {
    <0,0,-.875>
    6.25
    <0,0, .055>
    5.65
    texture { HW_Texture }
  }
}

// The Clock Face
union {
  difference {
    cylinder {
      <0,0,-.375>
      <0,0,-.200>
      6
    }
    cylinder {
      <0,-3.0,-.376>
      <0,-3.0,0>
      .255
      rotate z*30
    }
    cylinder {
      <0,-3.0,-.376>
      <0,-3.0,0>
      .255
      rotate -z*30
    }
    texture {
      pigment {
        onion
        color_map {
          [0.00   color rgb < .80, .85, .80>]
          [0.02   color rgb < .90,1.00, .90>]
          [0.98   color rgb < .90,1.00, .90>]
          [1.00   color rgb < .80, .85, .80>]
        }
        turbulence .5
      }
      finish {Dull}
      rotate -x*90
    }
  }
  difference {
    cylinder {
      <0,-3.0,-.375>
      <0,-3.0,3>
      .26
      texture {finish {Dull} pigment {Black}}
    }
    cylinder {
      <0,-3.0,-.400>
      <0,-3.0,2.999>
      .25
      texture {finish {Dull roughness .5} pigment {Black}}
    }
    rotate z*30
  }
  difference {
    cylinder {
      <0,-3.0,-.375>
      <0,-3.0,3>
      .26
    }
    cylinder {
      <0,-3.0,-.400>
      <0,-3.0,2.999>
      .25
    }
    texture {HW_Texture pigment {Black}}
    rotate -z*30
  }
  intersection {
    union {
      cylinder {<0,0,2.999>,<0,0,-.275>,.125}
      sphere {<0,0,-.275>,.125}
    }
    plane {y,.095 rotate -z*30}
    plane {y,.095 rotate -z*150}
    plane {y,.095 rotate z*90}
    texture {
      gradient z
      texture_map {
        [0.000 Solder]
        [0.125 Solder]
        [0.250 HW_Texture pigment{Black}]
        [1.000 HW_Texture pigment{Black}]
      }
      scale 4.0
      translate -z*.4
    }
    translate -y*3
    rotate z*30
  }
  intersection {
    union {
      cylinder {<0,0,2.999>,<0,0,-.275>,.125}
      sphere {<0,0,-.275>,.125}
    }
    plane {y,.095 rotate -z*40}
    plane {y,.095 rotate z*80}
    plane {y,.095 rotate -z*160}
    texture {
      gradient z
      texture_map {
        [0.000 Solder]
        [0.125 Solder]
        [0.250 HW_Texture pigment{Black}]
        [1.000 HW_Texture pigment{Black}]
      }
      scale 4.0
      translate -z*.4
    }
    translate -y*3
    rotate -z*30
  }
  torus {
    .285
    .035
    texture {HW_Texture}
    rotate x*90
    translate -y*3
    rotate z*30
    translate -z*.375
  }
  torus {
    .285
    .035
    texture {HW_Texture}
    rotate x*90
    translate -y*3
    rotate -z*30
    translate -z*.375
  }
}

// Begin Hour marks
#declare Count=1
#while (Count < 13)
  #if (Count<5)
    #declare FaceString = "I"
    #declare FaceCount = Count-1
    #declare FaceCenter = FaceCount*.130
    #declare FaceCenter = FaceCenter+.140
    #while (FaceCount > 0)
      #declare FaceString = concat (FaceString,"I")
      #declare FaceCount = FaceCount-1
    #end
  #else
    #if (Count < 9)
      #declare FaceString = "V"
      #declare FaceCount = Count-5
      #declare FaceCenter = Count-5
      #declare FaceCenter = FaceCenter*.130
      #declare FaceCenter = FaceCenter+.245
      #while (FaceCount > 0)
        #declare FaceString = concat (FaceString,"I")
        #declare FaceCount = FaceCount-1
      #end
    #else
      #if (Count = 9)
        #declare FaceString = "IX"
        #declare FaceCenter = .375
      #else
        #declare FaceString = "X"
        #declare FaceCount = Count-10
        #declare FaceCenter = Count-10
        #declare FaceCenter = FaceCenter*.130
        #declare FaceCenter = FaceCenter+.245
        #while (FaceCount > 0)
          #declare FaceString = concat (FaceString,"I")
          #declare FaceCount = FaceCount-1
        #end
      #end
    #end
  #end
  object {
    text {
      ttf "MOD20.TTF",
      FaceString,
      .3, -x*.1
    }
    texture { N_Texture }
    scale <.75,1.25,1>
    translate -z*.4
    translate -x*FaceCenter

    translate y*3.75
    rotate -z*30*Count
  }
  #declare Count=Count+1
#end
// End Hour marks

// Begin Day marks
#declare Count = 1
#while (Count < 32)
  #declare FaceString = str(Count,0,0)
  #declare FaceCount = 0
  #declare FaceCenter = 0
  #declare FaceLength = strlen(FaceString)
  #while (FaceCount < FaceLength)
    #declare FaceMid = substr(FaceString,FaceCount,1)
    #declare FaceMidV = val(FaceMid)
    #if (FaceMidV=1)
      #declare FaceCenter = FaceCenter+.16
    #else
      #declare FaceCenter = FaceCenter+.2
    #end
    #declare FaceCount = FaceCount+1
  #end
  object {
    text {
      ttf "MOD20.TTF",
      FaceString,
      .3, 0
    }
    texture { N_Texture }
    scale <.75,.75,1>
    translate -z*.4
    translate -x*FaceCenter
    translate -y*.25

    rotate z*360*Count/31
    translate y*5.4
    rotate -z*360*Count/31
  }
  #declare Count = Count+1
#end
// End Day marks

// Brass rings on the face
torus {
  3.6
  .1
  rotate x*90
  translate -z*.375
  texture { HW_Texture }
}
torus {
  4.825
  .025
  rotate x*90
  translate -z*.375
  texture { HW_Texture }
}
torus {
  4.675
  .025
  rotate x*90
  translate -z*.375
  texture { HW_Texture }
}

// Begin the ring pins
#declare Count=0
#while (Count < 60)
  cylinder {
    <0,  0,-.375>
    <0,.15,-.375>
    .025
    texture { HW_Texture }
    translate y*4.675
    rotate -z*6*Count
  }
  #declare Count=Count+1
#end
#declare Count=0
#while (Count < 12)
  cylinder {
    <0,  0,-.375>
    <0,.15,-.375>
    .025
    texture { HW_Texture }
    scale x*3
    translate y*4.675
    rotate -z*30*Count
  }
  #declare Count=Count+1
#end
// End the ring pins

// Center pin
union {
  sphere {
    <0,0,-.70>
    .14
    texture{ HW_Texture }
  }
  cylinder {
    <0,0,-.375>
    <0,0,-.70>
    .1
    texture { CH_Texture }
  }
}

//Begin Day hand
union {
  cylinder {
    <0,   0,-.49>
    <0,5.60,-.49>
    .0075
    scale x*4
    texture {CH_Texture}
  }
  sphere {
    <0,5.60,-.49>
    .0075
    scale <4,4,1>
    texture {CH_Texture}
  }
  difference {
    union {
      cylinder {
        <0,  0,-.49>
        <0,-.95,-.49>
        .0075
        scale x*8
        texture {CH_Texture}
      }
      cone {
        <0,-.95,-.498>
        0
        <0,-.95,-.482>
        .57
        texture {CH_Texture}
      }  
    }
    cone {
      <0,-1.15,  -.5>
      .475
      <0,-1.15,-.480>
      .375
      texture {CH_Texture}
    }  
  }
  translate -z*.08
  rotate -z*360*10/31
}
// End Day hand

//Begin Hour hand
union {
  cylinder {
    <0,   0,-.49>
    <0,3.30,-.49>
    .0075
    scale x*4
    texture {CH_Texture}
  }
  sphere {
    <0,3.30,-.49>
    .0075
    scale <4,4,1>
    texture {CH_Texture}
  }
  difference {
    object {
      Lemniscate
      texture {CH_Texture}
      scale <1.2,.4,.4>
    }
    plane {
      -x, 0
      texture {CH_Texture}
    }
    plane {
      z, -.0075
      texture {CH_Texture}
    }
    plane {
      -z, .0075
      texture {CH_Texture}
    }
    translate -z*.49
    rotate z*90
    translate y*4.00
  }
  translate -z*.04
  rotate -z*360*(7+(29/60))/12
}
// End Hour hand

//Begin Minute hand
union {
  cylinder {
    <0,   0,-.49>
    <0,4.30,-.49>
    .0075
    scale x*4
    texture {CH_Texture}
  }
  sphere {
    <0,4.30,-.49>
    .0075
    scale <4,4,1>
    texture {CH_Texture}
  }
  difference {
    object {
      Lemniscate
      texture {CH_Texture}
      scale <1.2,.4,.4>
    }
    plane {
      -x, 0
      texture {CH_Texture}
    }
    plane {
      z, -.0075
      texture {CH_Texture}
    }
    plane {
      -z, .0075
      texture {CH_Texture}
    }
    translate -z*.49
    rotate z*90
    translate y*5.00
  }
  translate -z*.06
  rotate -z*360*29/60
}
// End Minute hand

// Begin Glass Case
union {
  torus {
    6.75
    1/6
    rotate x*90
    texture {HW_Texture}
  }
  difference {
    blob {
      threshold .60
      sphere { <11/12,.45,0>, .3, 1 }
      sphere { <11/12,-.45,0>, .3, 1 }
      sphere { <11/12,0,0>, .3, 1 }
      texture {Solder}
      translate x*6
    }
    box {
      <11/12,.6,-1/6>
      <3,-.6,0>
      texture {HW_Texture}
      translate x*6
    }
  }
  box {
    <11/12,.6,-1/6>
    <1,-.6,0>
    texture {HW_Texture}
    translate x*6
  }
  cylinder {
    <1,.6,0>
    <1,.305,0>
    .15
    texture {HW_Texture}
    translate x*6.15
  }
  cylinder {
    <1,-.005,0>
    <1,-.295,0>
    .15
    texture {HW_Texture}
    translate x*6.15
  }
  cylinder {
    <0,0,-.075>
    <0,0,.075>
    6.7
    texture {
      pigment { color rgbf <1,1,1,.9>}
      finish {F_Glass1}
    }
  }

  // Begin Glass rotation section 
  translate -x*6
  translate -x*11/12
  translate -x*.15
  rotate -y*0
  translate x*6
  translate x*11/12
  translate x*.15
  // End Glass rotation section 

  translate -z*11/12
}
// End Glass Case

// Begin Hinge Mount
union {
  cylinder {
    <1,.295,0>
    <1,.005,0>
    .15
    texture {HW_Texture}
    translate x*6.15
  }
  cylinder {
    <1,-.305,0>
    <1,-.600,0>
    .15
    texture {HW_Texture}
    translate x*6.15
  }
  box {
    <1,.6,.1575>
    <1.5,-.6,1/6>
    texture {HW_Texture}
    translate x*6
  }
  difference {
    sphere {
      <0,0,0>
      .05
      scale <2,2,1>
    }
    box {
      <-.15,-.0125,-.01>
      < .15, .0125,-.06>
      rotate z*35
    }
    translate x*7.35
    translate y*.45
    translate z*.1574
    texture {HW_Texture finish {F_MetalB}}
  }
  difference {
    sphere {
      <0,0,0>
      .05
      scale <2,2,.75>
    }
    box {
      <-.15,-.0125,-.01>
      < .15, .0125,-.06>
      rotate -z*85
    }
    texture {HW_Texture finish {F_MetalB}}
    translate x*7.35
    translate -y*.15
    translate z*.1574
  }
  cylinder {
    <1,.675,0>
    <1,-.62,0>
    .10
    texture {Solder}
    translate x*6.15
  }
  torus {
    .10
    .05
    texture {Solder}
    translate x*7.15
    translate y*.645
  }
  translate -z*11/12
}
// End Hinge Mount

// Begin Movement case
union {
  box {<-4   , 4   ,0>,< 4   , 3.75,3.75> texture {FB_Texture rotate y*90 rotate z*90 translate -z*32}}
  box {<-3.75,-4   ,0>,< 3.75,-3.75,3.75> texture {FB_Texture rotate y*90 rotate z*90 translate -z*36}}
  box {<-4   , 3.75,0>,<-3.75,-4   ,3.75> texture {FB_Texture rotate y*90 translate -z*40}}
  box {< 4   , 3.75,0>,< 3.75,-4   ,3.75> texture {FB_Texture rotate y*90 translate -z*44}}
  union {
    box {< 3.3,-4, 0>,< 2.5, -8,3>}
    box {< 3.3,-8,.5>,< 2.5,-16,3>}
    texture {FB_Texture rotate y*90 translate -z*48}
  }
  union {
    box {<-3.3,-4, 0>,<-2.5, -8,3>}
    box {<-3.3,-8,.5>,<-2.5,-16,3>}
    texture {FB_Texture rotate y*90 translate -z*52}
  }
  box {
    <-1.3,-17.5,.5>,<1.3,-16.7,3>
    texture {FB_Texture rotate y*90 rotate z*90 translate -z*56}
  }
  box {
    <0,.8,.5>,<2.5,0,3>
    texture {FB_Texture rotate y*90 rotate z*90 translate -z*60}
    rotate -z*(degrees(atan2(1.5,2)))
    translate -x*3.3
    translate -y*16
  }
  box {
    <0,.8,.5>,<-2.5,0,3>
    texture {FB_Texture rotate y*90 rotate z*90 translate -z*64}
    rotate z*(degrees(atan2(1.5,2)))
    translate x*3.3
    translate -y*16
  }
  object {
    Pendulum_Border_Board
    scale x*.66
    texture {FB_Texture translate -y*68 rotate y*90 rotate z*86}
    translate -y*9.5
    translate z*.5
  }
  object {
    Pendulum_Border_Board
    scale x*.8
    texture {FB_Texture translate -y*72 rotate y*90 rotate z*86}
    rotate z*90
    translate -x*1.8
    translate -y*12
    translate z*.5
  }
  object {
    Pendulum_Border_Board
    scale x*.8
    texture {FB_Texture translate -y*76 rotate y*90 rotate z*86}
    rotate -z*90
    translate x*1.8
    translate -y*12
    translate z*.5
  }
  object {
    Pendulum_Border_Board
    scale x*.26
    texture {FB_Texture translate -y*80 rotate y*90 rotate z*86}
    rotate z*180
    translate -y*16
    translate z*.5
  }
  object {
    Pendulum_Border_Board
    scale x*.25
    texture {FB_Texture translate -y*84 rotate y*90 rotate z*86}
    translate -x*1.25
    rotate z*180
    translate y*1.5
    rotate -z*(degrees(atan2(1.5,2)))
    translate -x*3.3
    translate -y*16
    translate z*.5
  }
  object {
    Pendulum_Border_Board
    scale x*.25
    translate x*1.25
    texture {FB_Texture translate -y*88 rotate y*90 rotate z*86}
    rotate z*180
    translate y*1.5
    rotate z*(degrees(atan2(1.5,2)))
    translate x*3.3
    translate -y*16
    translate z*.5
  }
  union {
    box {<-3, -3.75,2.75>,< 3,-16, 2.5>}
    intersection {
      cone {<0,-16,0>,3,<0,-17.25,0>,1.3}
      plane {z,.25 rotate y*180}
      plane {z,0}
      rotate y*180
      translate z*2.5
    }
    texture {FB_Texture translate -y*120}
  }
  difference {
    union {
      box {<-3, -3.75,.75>,< 3,-16, .625>}
      intersection {
        cone {<0,-16,0>,3,<0,-17.25,0>,1.3}
        plane {z,.125 rotate y*180}
        plane {z,0}
        rotate y*180
        translate z*.625
      }
      texture {
        pigment {color rgbf <1,1,1,.9>}
        finish {F_Glass1}
      }
    }
    height_field {
      gif "ingersol.gif"
      smooth
      water_level .01
      texture {
        pigment {color rgbf <1,1,1,.9>}
        finish {F_Glass1 roughness .075}
      }
      rotate -x*90
      scale <3.2, .8, .1>
      translate <-1.6, -13.9, .751>
    }
    translate -z*.125
  }
  union {
    cylinder {<0,0,2.0625>,<0,-15.38,2.0625>,.0625 texture {HW_Texture}}
    cylinder {<0,-14.625,2.0625>,<0,-15.125,2.0625>,.125 texture {HW_Texture}}
    cone {<0,-15.125,2.0625>,.15,<0,-15.375,2.0625>,.075 texture {HW_Texture}}
    difference {
      sphere {<0,0,0>,1.25 scale <2,2,1>}
      box {<-3,-3,-1>,<3,3,2>}
      texture {HW_Texture normal {onion} rotate -x*90}
      translate <0,-13.5,2.9>
    }
    translate -y*3
    rotate z*2
    translate y*3
  }
  object {
    text {
      ttf "TT0122M_.TTF",
      "EGULATO",
      1,0
    }
    texture { Polished_Brass pigment {BrightGold} }
    scale <7/16,7/16,.01>
    translate  z*.495
    translate -x*147/128
    translate -y*10.5
  }
  object {
    text {
      ttf "TT0122M_.TTF",
      "R",
      1,0
    }
    texture { Polished_Brass pigment {BrightGold} }
    scale <7/12,7/12,.01>
    translate  z*.495
    translate -x*105/64
    translate -y*10.5
    translate -y*1/16
  }
  object {
    text {
      ttf "TT0122M_.TTF",
      "R",
      1,0
    }
    texture { Polished_Brass pigment {BrightGold} }
    scale <7/12,7/12,.01>
    translate  z*.495
    translate x*161/128
    translate -y*10.5
    translate -y*1/16
  }
}
// End Movement Case

  }
}
// End the completed clock

//The Objects
sky_sphere {
  S_Cloud5
  rotate <0,150,0>
}

/*
sphere {
  <0,-5000,0>
  4940
  texture {
    pigment {SpringGreen}
    finish {Dull}
  }
}
*/

// Front Wall and Window Cutout
difference {
  box {<-72,-60,23.75>,<72,36,27.5>}
  box {<-41,-36,23>,<-5,12,28>}
  texture {
    pigment {
      image_map {
        png "orangewp.png"
      }
      scale <1.5,1.5,1>
    }
    finish {Dull diffuse .75}
  }
}

// Window Frame
superellipsoid {
  <.05, .05>
  scale <22,2.75,3.25>
  translate <-23,14.25,25.5>
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
}

superellipsoid {
  <.05, .05>
  scale <2,27,3>
  translate <-3.5,-12,25.5>
  texture {WF_Texture translate -y*400 rotate y*90}
}

box {
  <-41,-36,25.125>
  <-5,12,24.875>
  texture {
    pigment { color rgbf <1,1,1,.9>}
    finish {F_Glass1}
  }
}

#declare Pane_Brace =
  difference {
    box {<-24,-1,25>,<24,1,26>}
    cylinder {<-25,0,25>,<25,0,25>, 1/4 scale y*2 translate -y*1}
    cylinder {<-25,0,25>,<25,0,25>, 1/4 scale y*2 translate  y*1}
  }

object {
  Pane_Brace
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
  translate <-23,-12,0>
}

object {
  Pane_Brace
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
  translate <-23,0,0>
}

object {
  Pane_Brace
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
  translate <-23,-24,0>
}

object {
  Pane_Brace
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
  rotate z*90
  translate <-23,-12,0.1>
}

object {
  Pane_Brace
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
  rotate z*90
  translate <-32,-12,0.1>
}

object {
  Pane_Brace
  texture {WF_Texture translate -y*200 rotate y*90 rotate -z*90}
  rotate z*90
  translate <-14,-12,0.1>
}

// Floor
box {
  <-72,-59,-122>
  <72,-60,27.5>
  texture {
    pigment {
      image_map {
        png "woodparq.png"
      }
      scale <1.5,1.5,1>
      rotate y*90
    }
    finish {Shiny}
  }
}

// Ceiling
box {
  <-72,35,-122>
  <72,36,27.5>
  texture {
    pigment {
      image_map {
        png "plaster.png"
      }
      scale <2,1.5,1>
      rotate -y*90
    }
    finish {Dull diffuse .75}
  }
}

// Back Wall
box {
  <-72,-60,-120>
  <72,36,-123.75>
  texture {
    pigment {White}
    finish {Dull diffuse .75}
  }
}

// Left Wall
box {
  <-71,-60,27.5>
  <-72,36,-123.75>
  texture {
    pigment {White}
    finish {Dull diffuse .75}
  }
}

// Right Wall
box {
  <71,-60,27.5>
  <72,36,-123.75>
  texture {
    pigment {White}
    finish {Dull diffuse .75}
  }
}

union {
  object {
    Ingersoll_Regulator_Schoolhouse_Clock
    // Rotate and/or translate the whole darn clock
    translate y*4.5
    translate z*20
    translate x*8
  }
}
