global_settings
{ assumed_gamma 2.2
  max_intersections 64
  max_trace_level 5
/*  radiosity
  { brightness 6
    count 300
    distance_maximum 1
    error_bound .2
    gray_threshold .1
    low_error_factor .5
    minimum_reuse .001
    nearest_count 6
    recursion_limit  1
  }*/
}

camera
{ location  <5.200, -15.850, 21.000>
  direction <0.0,     0.0,  2.3451>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.484, 0.208, 0.173>
}

// *******  L I G H T S *******
light_source {   // Light001
  <25.700, -7.500, 19.250>
  color rgb <0.404, 0.404, 0.404>
}

light_source {   // Light1
  <-12.950, -11.400, 24.700>
  color rgb <1.000, 1.000, 1.000>
  atmosphere off
}


// ********  TEXTURES  *******
//

//  $MRY$: 'Plastic 1'
#declare Plastic_1 = texture {
   pigment {
     color rgb<0.000, 0.560, 1.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.030
     specular 0.500
     roughness 0.0500
   }

}



//  $MRY$: 'Paper1'
#declare Paper1 = texture {
   pigment {
     gradient z
     color_map {
       [ 0.000  color rgb<1.000, 1.000, 1.000> ]
       [ 0.101  color rgb<1.000, 1.000, 1.000> ]
       [ 0.108  color rgb<0.000, 0.000, 1.000> ]
       [ 0.698  color rgb<0.000, 0.000, 1.000> ]
       [ 0.698  color rgb<1.000, 1.000, 1.000> ]
       [ 1.000  color rgb<1.000, 1.000, 1.000> ]
     }
     scale     <1.0000, 1.0000, 2.0000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'Paper2'
#declare Paper2 = texture {
   pigment {
     color rgb<1.000, 1.000, 1.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'Chrome_Metal1'
#declare Chrome_Metal1 = texture {
   pigment {
     color rgb<0.659, 0.659, 0.659>
   }
   finish {
     diffuse 0.700
     ambient 0.300
     reflection 0.150
     specular 0.800
     roughness 0.1000
     brilliance 8.000
   }

}



//  $MRY$: 'DMFWood3'
#declare DMFWood3 = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.520, 0.370, 0.260> ]
       [ 0.100  color rgb<0.520, 0.370, 0.260> ]
       [ 0.900  color rgb<0.420, 0.260, 0.150> ]
       [ 1.000  color rgb<0.420, 0.260, 0.150> ]
     }
     turbulence 0.030
     octaves 4
     scale     <0.0500, 0.0500, 1.0000>
   }
   finish {
     reflection 0.050
     specular 0.300
     roughness 0.0500
   }

}



//  $MRY$: 'Paper3'
#declare Paper3 = texture {
   pigment {
     color rgb<0.9, 0.9, 0.9>
   }
   finish {
     diffuse 0.500
     ambient 0.200
   }
   normal
   { brick .05
     brick_size 1 mortar .6
     scale <.2,.1,.2>
   }
   rotate -z*75
}



//  $MRY$: 'Porcelain'
#declare Porcelain = texture {
   pigment {
     color rgb<1.000, 1.000, 1.000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.050
     specular 0.700
     roughness 0.0300
   }

}



//  $MRY$: 'Sauce texture'
#declare Sauce_texture = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgbf<0.497, 0.497, 0.000, 0.804> ]
       [ 0.299  color rgbf<0.503, 0.503, 0.000, 0.801> ]
       [ 0.399  color rgbf<0.703, 0.702, 0.000, 0.799> ]
       [ 1.000  color rgbf<0.699, 0.699, 0.000, 0.797> ]
     }
     scale     <0.2000, 0.2000, 0.2000>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.050
   }

}



//  $MRY$: 'Food texture'
#declare Food_texture = texture {
   pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.470, 0.310, 0.214> ]
       [ 0.273  color rgb<0.437, 0.356, 0.164> ]
       [ 0.288  color rgb<0.819, 0.000, 0.000> ]
       [ 0.299  color rgb<0.571, 0.365, 0.203> ]
       [ 0.360  color rgb<0.615, 0.368, 0.216> ]
       [ 0.414  color rgb<0.479, 0.546, 0.300> ]
       [ 0.478  color rgb<0.574, 0.601, 0.437> ]
       [ 0.561  color rgb<0.563, 0.356, 0.133> ]
       [ 0.637  color rgb<0.581, 0.437, 0.143> ]
       [ 0.777  color rgb<0.698, 0.328, 0.154> ]
       [ 0.802  color rgb<0.666, 0.135, 0.000> ]
       [ 0.806  color rgb<0.736, 0.000, 0.000> ]
       [ 0.809  color rgb<0.601, 0.342, 0.161> ]
       [ 1.000  color rgb<0.493, 0.287, 0.164> ]
     }
     turbulence 0.800
     scale     <0.5000, 0.5000, 0.5000>
   }
   normal {
     bumps 0.8000
     turbulence 0.300
     omega 2.000
     lambda 0.500
     scale     0.1000
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.150
     roughness 0.0700
     brilliance 1.004
     crand 0.300
   }

}



//  $MRY$: 'Bone texture'
#declare Bone_texture = texture {
   pigment {
     color rgb<1.000, 0.898, 0.601>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.400
     roughness 0.0100
     crand 0.050
   }

}



//  $MRY$: 'Counter texture1'
#declare Counter_texture1 = texture {
   pigment {
     color rgb<0.791, 0.605, 0.249>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     reflection 0.030
     specular 0.400
     roughness 0.0100
   }

}



//  $MRY$: 'Counter texture2'
#declare Counter_texture2 = texture {
   pigment {
     color rgb<0.465, 0.465, 0.465>
   }
   finish {
     diffuse 0.500
     ambient 0.200
     specular 0.200
     roughness 0.0100
   }

}



//  $MRY$: 'Vegetable1'
#declare Vegetable1 = texture {
   pigment {
     radial
     color_map {
       [ 0.000  color rgb<0.000, 0.296, 0.000> ]
       [ 0.500  color rgb<0.000, 0.497, 0.000> ]
       [ 1.000  color rgb<0.000, 0.298, 0.000> ]
     }
     frequency 25.000
     rotate -90*x
   }
   finish {
     diffuse 0.500
     ambient 0.200
   }

}



//  $MRY$: 'Vegetable2'
#declare Vegetable2 = texture {
   pigment {
     wood
     color_map {
       [ 0.000  color rgb<0.000, 0.398, 0.000> ]
       [ 0.500  color rgb<0.000, 0.601, 0.000> ]
       [ 1.000  color rgb<0.000, 0.400, 0.000> ]
     }
     frequency 4.000
   }
   finish {
     diffuse 0.500
     ambient 0.200
   }

}



// ********  REFERENCED OBJECTS  *******

#declare Veg = union { // Veg
  cylinder { // Veg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Vegetable1
    }
  }
  cylinder { // Veg2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Vegetable2
    }
    scale <0.95, 0.95, 1.0>
    translate  0.05*z
  }
  scale <0.1, 0.1, 0.05>
  rotate <0.0, 15.0, 0.0>
  translate  <-0.25, -2.45, 0.15>
}
#declare Veg4 = object {
  object { // Veg4->Veg
    Veg
    scale <1.4, 1.4, 1.05>
    rotate <10.0, -15.0, 0.0>
    translate  <1.35, 0.5, 0.7>
  }
}




#declare Counter2 = union {
  box { // Counter_part2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.05, 0.15>
    translate  <0.0, -3.4, -0.5>
  }
  cylinder { // Counter_part3
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <0.0, -90.0, 0.0>
    translate  <1.0, -3.4, -0.35>
  }
  texture {
    Counter_texture2
  }
  scale <100.0, 1.0, 1.0>
}




// ********  OBJECTS  *******

object { // Veg7->Veg
  Veg
  rotate <0.0, 0.0, 0.0>
  translate  <1.95, 2.15, 0.0>
}


object { // Veg6->Veg
  Veg
  rotate <10.0, 0.0, 0.0>
  translate  <-1.3, 0.25, 0.4>
}


object { // Veg5->Veg4
  Veg4
  rotate <0.0, 15.0, 0.0>
  translate  <-1.85, 0.05, 0.15>
}


object { Veg4 }


object { // Veg3->Veg
  Veg
  rotate <-5.513852, -24.898375, 2.327299>
  translate  <0.4, -0.85, -0.05>
}


object { Veg }


union { // Counter
  box { // Counter1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Counter_texture1
    }
    scale <100.0, 5.9, 2.55>
    translate  <0.35, -0.05, -3.2>
  }
  object { Counter2 }
  object { // Counter3->Counter2
    Counter2
    translate  6.7*y
  }
  box { // Counter4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Counter_texture1
    }
    scale <100.0, 3.65, 2.55>
    translate  <0.35, 9.5, -0.5>
  }
}


#declare Food1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.009867, 0.048772, 0.330545>, <0.038234, 0.067776, 0.330545>, <0.005328, 0.045328, 0.347743>, <-0.001797, 0.010382, 0.339144>, 
      <-0.872426, -0.084914, 0.642172>, <-0.872426, -0.550000, 0.563939>, <-0.479835, -1.000000, 0.563939>, <0.000000, -1.000000, 0.563939>, 
      <-1.018514, -0.241742, 1.511054>, <-1.164603, -0.701026, 1.758493>, <-0.479835, -1.000000, 1.127879>, <-0.179655, -0.674855, 1.127879>, 
      <-0.527620, 0.176580, 1.873762>, <-0.396425, -0.222230, 1.827435>, <-0.659987, -0.650193, 1.691818>, <-0.468779, -0.614771, 1.691818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001797, 0.010382, 0.339144>, <-0.008921, -0.024564, 0.330545>, <0.034662, 0.015350, 0.330545>, <0.072061, 0.000882, 0.330545>, 
      <0.000000, -1.000000, 0.563939>, <0.479835, -1.000000, 0.563939>, <1.540310, -0.755945, 1.449961>, <1.285126, 0.097534, 0.776699>, 
      <-0.179655, -0.674855, 1.127879>, <0.120525, -0.349709, 1.127879>, <0.437473, -0.224855, 1.127879>, <0.654950, 0.162573, 1.127879>, 
      <-0.468779, -0.614771, 1.691818>, <-0.203341, -0.668621, 1.691818>, <0.386498, -0.236766, 1.691818>, <0.712332, 0.134891, 1.691818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.072061, 0.000882, 0.330545>, <0.109461, -0.013585, 0.330545>, <-0.018377, 0.024564, 0.330545>, <-0.011252, -0.002532, 0.330545>, 
      <1.285126, 0.097534, 0.776699>, <1.029942, 0.951013, 0.103436>, <0.111045, 0.575892, 0.795038>, <-0.358325, 0.789199, 0.795038>, 
      <0.654950, 0.162573, 1.127879>, <0.872426, 0.550000, 1.127879>, <-0.029087, 0.577311, 1.545210>, <-0.254461, 0.788656, 1.336544>, 
      <0.712332, 0.134891, 1.691818>, <1.019058, 0.600698, 1.691818>, <0.302025, 0.806625, 2.109917>, <0.092712, 0.907367, 1.900867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.011252, -0.002532, 0.330545>, <-0.004128, -0.029627, 0.330545>, <-0.018499, 0.029767, 0.330545>, <0.009867, 0.048772, 0.330545>, 
      <-0.358325, 0.789199, 0.795038>, <-0.827695, 1.002506, 0.795038>, <-0.872426, 0.380171, 0.720405>, <-0.872426, -0.084914, 0.642172>, 
      <-0.254461, 0.788656, 1.336544>, <-0.479835, 1.000000, 1.127879>, <-0.872426, 0.217542, 1.263615>, <-1.018514, -0.241742, 1.511054>, 
      <0.092712, 0.907367, 1.900867>, <-0.246559, 1.054541, 1.691818>, <-0.714685, 0.544360, 1.920089>, <-0.527620, 0.176580, 1.873762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.527620, 0.176580, 1.873762>, <-0.396425, -0.222230, 1.827435>, <-0.659987, -0.650193, 1.691818>, <-0.468779, -0.614771, 1.691818>, 
      <-0.092596, 0.563872, 2.236470>, <0.371752, 0.256566, 1.896377>, <-0.840140, -0.300387, 2.255757>, <-0.683674, -0.643960, 2.255757>, 
      <-0.803641, 0.792454, 2.276863>, <-0.807506, 1.235742, 2.041426>, <-0.840140, -0.300387, 2.819697>, <-0.683674, -0.643960, 2.819697>, 
      <-0.112194, 0.069280, 2.970455>, <-0.130308, 0.059225, 2.970455>, <-0.017014, 0.049168, 2.970455>, <0.035411, 0.003834, 2.970455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.468779, -0.614771, 1.691818>, <-0.203341, -0.668621, 1.691818>, <0.386498, -0.236766, 1.691818>, <0.712332, 0.134891, 1.691818>, 
      <-0.683674, -0.643960, 2.255757>, <-0.527208, -0.987534, 2.255757>, <0.335524, -0.248678, 2.255757>, <0.750607, 0.201359, 2.255757>, 
      <-0.683674, -0.643960, 2.819697>, <-0.527208, -0.987534, 2.819697>, <0.045353, -1.157245, 2.819697>, <0.493479, -0.368260, 2.819697>, 
      <0.035411, 0.003834, 2.970455>, <0.087835, -0.041499, 2.970455>, <0.113533, -0.080271, 2.970455>, <0.187036, -0.064135, 2.970455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.712332, 0.134891, 1.691818>, <1.019058, 0.600698, 1.691818>, <0.302025, 0.806625, 2.109917>, <0.092712, 0.907367, 1.900867>, 
      <0.750607, 0.201359, 2.255757>, <1.165690, 0.651395, 2.255757>, <0.633137, 1.035939, 2.674623>, <0.309927, 1.072511, 2.465190>, 
      <0.493479, -0.368260, 2.819697>, <0.941604, 0.420725, 2.819697>, <0.560497, 0.528875, 2.545267>, <0.273607, 0.818979, 2.682482>, 
      <0.187036, -0.064135, 2.970455>, <0.260538, -0.047999, 2.970455>, <0.162540, -0.049213, 2.970455>, <0.073532, 0.009681, 2.970455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.092712, 0.907367, 1.900867>, <-0.246559, 1.054541, 1.691818>, <-0.714685, 0.544360, 1.920089>, <-0.527620, 0.176580, 1.873762>, 
      <0.309927, 1.072511, 2.465190>, <-0.013284, 1.109083, 2.255757>, <-0.556944, 0.871178, 2.576562>, <-0.092596, 0.563872, 2.236470>, 
      <0.273607, 0.818979, 2.682482>, <-0.013284, 1.109083, 2.819697>, <-0.799776, 0.349166, 2.512300>, <-0.803641, 0.792454, 2.276863>, 
      <0.073532, 0.009681, 2.970455>, <-0.015476, 0.068575, 2.970455>, <-0.094080, 0.079335, 2.970455>, <-0.112194, 0.069280, 2.970455>
    }
  }
  texture {
    Food_texture
  }
  scale <0.8, 1.6, 1.3>
  rotate <0.0, 90.0, 0.0>
  translate  <-2.06, -1.39, 0.76>
}
#declare Bone = union {
  cylinder { // Bone1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.2>
    translate  <1.36, -1.48, 0.94>
  }
  sphere { // Bone3
    <0,0,0>,1
    scale 0.12
    translate  <1.31, -1.48, 2.12>
  }
  sphere { // Bone4
    <0,0,0>,1
    scale 0.12
    translate  <1.42, -1.48, 2.12>
  }
  texture {
    Bone_texture
  }
  rotate <64.299057, 31.772026, 47.570942>
  translate  <-0.19, -0.92, 2.25>
}
#declare Stain6 = blob {
  threshold 0.6
  component 1.0, 1.256356, <-0.008439, 0.0, -0.008439>
  component 1.0, 0.708315, <0.548523, 0.0, 0.227848>
  component 1.0, 0.355493, <0.126582, 0.0, -0.599156>
  component 1.0, 0.620843, <-0.666667, 0.0, -0.008439>
  component 1.0, 0.428071, <-0.548523, 0.0, 0.413502>
  
sturm
  texture {
    Sauce_texture
  }
  scale <0.1, 0.05, 0.03>
  rotate <85.957687, -19.857939, -26.716812>
  translate  <1.96, -1.76, 1.12>
}

#declare Stain4 = blob {
  threshold 0.6
  component 1.0, 1.256356, <-0.008439, 0.0, -0.008439>
  component 1.0, 0.708315, <0.548523, 0.0, 0.227848>
  component 1.0, 0.355493, <0.126582, 0.0, -0.599156>
  component 1.0, 0.620843, <-0.666667, 0.0, -0.008439>
  component 1.0, 0.428071, <-0.548523, 0.0, 0.413502>
  
sturm
  texture {
    Sauce_texture
  }
  scale <0.1, 0.04, 0.35>
  rotate <-101.501869, -15.016539, 4.757701>
  translate  <-0.82, -0.99, 1.34>
}

#declare Stain3 = blob {
  threshold 0.6
  component 1.0, 1.256356, <-0.008439, 0.0, -0.008439>
  component 1.0, 0.708315, <0.548523, 0.0, 0.227848>
  component 1.0, 0.355493, <0.126582, 0.0, -0.599156>
  component 1.0, 0.620843, <-0.666667, 0.0, -0.008439>
  component 1.0, 0.428071, <-0.548523, 0.0, 0.413502>
  
sturm
  texture {
    Sauce_texture
  }
  scale <0.3, 0.1, 0.45>
  rotate 80.0*x
  translate  <0.33, -1.28, 1.11>
}

union { // Food
  object { Food1 }
  object { Bone }
  object { Stain6 }
  object { Stain4 }
  object { Stain3 }
}


#declare Dish3 = difference {
  torus { // Dish2
    3.2, 0.7  rotate -x*90
  }
  torus { // Dish_diff1
    3.2, 0.6  rotate -x*90
  }
}
#declare Dish5 = intersection {
  cylinder { // Dish_diff2
    <0,0,1>, <0,0,0>, 1 
    scale <3.2, 3.2, 0.8>
  }
  object { Dish3 }
  scale <1.0, 1.0, 0.8>
}
union { // Dish
  cylinder { // Sauce
    <0,0,1>, <0,0,0>, 1 
    texture {
      Sauce_texture
    }
    scale <2.6, 2.6, 0.1>
    translate  0.1*z
  }
  cylinder { // Dish1
    <0,0,1>, <0,0,0>, 1 
    scale <2.6, 2.6, 0.1>
  }
  object { Dish5 }
  torus { // Plate6
    3.2, 0.05  rotate -x*90
    scale <1.0, 1.0, 0.8>
    translate  <0.0, 0.0, 0.52>
  }
  texture {
    Porcelain
  }
  translate  <0.05, -1.0, 0.0>
}


union { // Napkin
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.121039, -3.733969, -0.002152>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-1.160659, -3.443901, 0.044422>, <-1.427493, -2.489224, 0.080906>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-0.200278, -3.170960, 0.113833>, <-0.478941, -2.210574, 0.111579>, <-0.757604, -1.250187, 0.060732>, <0.121198, -1.125094, 0.030366>, 
      <0.765560, -2.892310, 0.081732>, <0.481440, -1.931924, 0.106767>, <0.195812, -0.971537, 0.101324>, <0.501793, -0.428797, 0.070653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.765560, -2.892310, 0.081732>, <0.481440, -1.931924, 0.106767>, <0.195812, -0.971537, 0.101324>, <0.501793, -0.428797, 0.070653>, 
      <1.731399, -2.613660, 0.049630>, <1.441820, -1.653274, 0.101954>, <1.149228, -0.692887, 0.141915>, <0.882389, 0.267499, 0.103975>, 
      <2.689284, -2.335010, 0.004963>, <2.416545, -1.374624, 0.010193>, <2.123538, -0.414237, 0.094888>, <1.844875, 0.546149, 0.092633>, 
      <3.650588, -2.056360, 0.001148>, <3.362582, -1.095974, 0.008237>, <3.070457, -0.135587, 0.037735>, <2.798525, 0.824799, 0.061650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.121198, -1.125094, 0.030366>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.501793, -0.428797, 0.070653>, <0.807775, 0.113943, 0.033018>, <2.000000, 0.000000, 0.000000>, <2.966730, -0.018281, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.501793, -0.428797, 0.070653>, <0.807775, 0.113943, 0.033018>, <2.000000, 0.000000, 0.000000>, <2.966730, -0.018281, 0.000000>, 
      <0.882389, 0.267499, 0.103975>, <0.615550, 1.227885, 0.066035>, <2.000000, 1.000000, 0.000000>, <2.933459, 0.963437, 0.000000>, 
      <1.844875, 0.546149, 0.092633>, <1.566212, 1.506535, 0.090378>, <1.306986, 2.466922, 0.039532>, <2.860334, 2.511184, 0.000000>, 
      <2.798525, 0.824799, 0.061650>, <2.526593, 1.785185, 0.085566>, <2.247930, 2.739989, 0.033065>, <2.666557, 3.330454, -0.002687>
    }
  }
  texture {
    Paper3
  }
  bounded_by { // Bound00005
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.05, 4.4, 0.1>
      rotate -35.0*z
      translate  <1.85, -1.35, 0.05>
    }
  }
  scale <0.7, 0.7, 2.2>
  rotate 20.0*z
  translate  <3.65, -1.55, 0.0>
}




#declare Tray3 = difference {
  cylinder { // Tray2
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, -0.1>
  }
  cylinder { // Tray_diff1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate 90.0*y
    translate  <-7.4, -5.2, -0.1>
  }
  box { // Tray_diff2
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.35, 0.2>
    translate  <-0.2, -5.2, -0.3>
  }
  box { // Tray_diff3
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.2, 0.2>
    translate  <-0.2, -5.4, 0.05>
  }
}
#declare Tray5 = union {
  object { Tray3 }
  cylinder { // Tray4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.03, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, 0.15>
  }
}
#declare Tray7 = difference {
  cylinder { // Tray6
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, -0.1>
  }
  cylinder { // Tray_diff4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate 90.0*y
    translate  <-7.4, -5.2, -0.1>
  }
  box { // Tray_diff5
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.35, 0.2>
    translate  <-0.2, -5.2, -0.3>
  }
  box { // Tray_diff6
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.2, 0.2>
    translate  <-0.2, -5.4, 0.05>
  }
}
#declare Tray9 = union {
  object { Tray7 }
  cylinder { // Tray8
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.03, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, 0.15>
  }
  rotate 180.0*z
}
#declare Tray11 = difference {
  cylinder { // Tray10
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, -0.1>
  }
  cylinder { // Tray_diff7
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate 90.0*y
    translate  <-7.4, -5.2, -0.1>
  }
  box { // Tray_diff8
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.35, 0.2>
    translate  <-0.2, -5.2, -0.3>
  }
  box { // Tray_diff9
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.2, 0.2>
    translate  <-0.2, -5.4, 0.05>
  }
}
#declare Tray13 = union {
  object { Tray11 }
  cylinder { // Tray12
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.03, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, 0.15>
  }
  scale <0.715, 1.0, 1.0>
  rotate -90.0*z
  translate  -2.0*x
}
#declare Tray15 = difference {
  cylinder { // Tray14
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, -0.1>
  }
  cylinder { // Tray_diff10
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 15.0>
    rotate 90.0*y
    translate  <-7.4, -5.2, -0.1>
  }
  box { // Tray_diff11
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.35, 0.2>
    translate  <-0.2, -5.2, -0.3>
  }
  box { // Tray_diff12
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.2, 0.2>
    translate  <-0.2, -5.4, 0.05>
  }
}
#declare Tray17 = union {
  object { Tray15 }
  cylinder { // Tray16
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.03, 14.0>
    rotate 90.0*y
    translate  <-7.0, -5.2, 0.15>
  }
  scale <0.715, 1.0, 1.0>
  rotate 90.0*z
  translate  2.0*x
}
union { // Tray
  box { // Tray1
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 5.0, 0.1>
    translate  -0.1*z
  }
  object { Tray5 }
  object { Tray9 }
  object { Tray13 }
  object { Tray17 }
  texture {
    DMFWood3
  }
}


#declare Fork5 = union {
  cone { // Fork_part6
    <0,0,0>, 0.4, <0,0,1>, 0.5
    scale <1.0, 1.0, 8.0>
    rotate -90.0*y
    translate  7.0*x
  }
  sphere { // Fork_part7
    <0,0,0>,1
    scale <0.6, 0.5, 0.5>
    translate  -1.0*x
  }
  torus { // Fork_part8
    0.4, 0.1  rotate -x*90
    rotate 90.0*y
    translate  6.9*x
  }
  translate  -2.0*x
}
#declare Knife1 = difference {
  object { Fork5 }
  torus { // Fork_diff13
    0.4, 0.1  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate <0.0, 90.0, 0.0>
    translate  4.6*x
  }
  scale <0.3, 0.5, 0.2>
  translate  0.025*y
}
#declare Knife6 = intersection {
  cylinder { // Knife4
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 0.04>
    translate  <2.390218, 2.739251, -0.02>
  }
  box { // Knife5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.038269, 0.14894, 0.03>
    translate  <2.5, -0.16, 0.0>
  }
}
#declare Stain = blob {
  threshold 0.6
  component 1.0, 1.256356, <-0.008439, 0.0, -0.008439>
  component 1.0, 0.708315, <0.548523, 0.0, 0.227848>
  component 1.0, 0.355493, <0.126582, 0.0, -0.599156>
  component 1.0, 0.620843, <-0.666667, 0.0, -0.008439>
  component 1.0, 0.428071, <-0.548523, 0.0, 0.413502>
  
sturm
  texture {
    Sauce_texture
  }
  scale <0.099884, 0.02, 0.16686>
  rotate <90.0, 0.0, -94.169899>
  translate  <2.598509, -0.04193, 0.02>
}

#declare Stain1 = blob {
  threshold 0.6
  component 1.0, 1.256356, <-0.008439, 0.0, -0.008439>
  component 1.0, 0.708315, <0.548523, 0.0, 0.227848>
  component 1.0, 0.355493, <0.126582, 0.0, -0.599156>
  component 1.0, 0.620843, <-0.666667, 0.0, -0.008439>
  component 1.0, 0.428071, <-0.548523, 0.0, 0.413502>
  
sturm
  texture {
    Sauce_texture
  }
  scale <0.029965, 0.02, 0.08343>
  rotate <-90.0, 0.0, 85.830101>
  translate  <2.008368, 0.009989, 0.02>
}

union { // Knife
  object { Knife1 }
  box { // Knife2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.02>
    translate  <2.5, 0.06, 0.0>
  }
  cylinder { // Knife3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.04>
    translate  <3.5, 0.06, -0.02>
  }
  object { Knife6 }
  object { Stain }
  object { Stain1 }
  texture {
    Chrome_Metal1
  }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.35, 0.28, 0.1>
      translate  1.26*x
    }
  }
  scale <1.2, 1.0, 1.0>
  rotate 95.0*z
  translate  <-4.15, -3.4, 0.1>
}


#declare Fork1 = union {
  cone { // Fork_part1
    <0,0,0>, 0.4, <0,0,1>, 0.5
    scale <1.0, 1.0, 8.0>
    rotate -90.0*y
    translate  7.0*x
  }
  sphere { // Fork_part2
    <0,0,0>,1
    scale <0.4, 0.5, 0.5>
    translate  -1.0*x
  }
  torus { // Fork_part3
    0.4, 0.1  rotate -x*90
    rotate 90.0*y
    translate  6.9*x
  }
  translate  -2.0*x
}
#declare Fork2 = difference {
  object { Fork1 }
  torus { // Fork_diff1
    0.4, 0.1  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate <0.0, 90.0, 0.0>
    translate  4.6*x
  }
  scale <1.0, 1.0, 0.4>
}
#declare Fork3 = difference {
  cylinder { // Fork_part4
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    rotate 90.0*x
    translate  <5.0, 0.3, -0.4>
  }
  cylinder { // Fork_diff2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.7>
    rotate 90.0*x
    translate  <5.0, 0.35, -0.6>
  }
  box { // Fork_diff3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.35, 0.35>
    translate  <4.7, 0.0, -0.2>
  }
  box { // Fork_diff4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.35, 0.35>
    translate  <5.55, 0.0, -0.25>
  }
  cylinder { // Fork_diff6
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
    translate  <5.0, -1.25, -0.25>
  }
  cylinder { // Fork_diff7
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.4>
    translate  <5.0, 1.25, -0.25>
  }
  scale <1.0, 1.1, 1.0>
}
#declare Fork4 = difference {
  cylinder { // Fork_part5
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 1.2>
    rotate 90.0*x
    translate  <5.786655, 0.6, 0.43576>
  }
  cylinder { // Fork_diff8
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 1.3>
    rotate 90.0*x
    translate  <5.665382, 0.65, 0.476337>
  }
  box { // Fork_diff5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.35, 0.35>
    translate  <5.05, 0.0, 0.1>
  }
  box { // Fork_diff11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.6, 0.3>
    translate  <6.15, 0.0, -0.1>
  }
}
#declare Fork9 = intersection {
  object { Fork4 }
  cylinder { // Fork_diff9
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    translate  <5.9, -0.5, -0.4>
  }
  cylinder { // Fork_diff10
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    translate  <5.9, 0.5, -0.4>
  }
  scale <1.0, 1.1, 1.0>
}
#declare Fork14 = intersection {
  cylinder { // Fork_part12
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 0.564761, 0.6>
    translate  <6.25, 0.0, -0.5>
  }
  cylinder { // Fork_part13
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 1.25>
    rotate 90.0*x
    translate  <6.2, 0.65, 3.606738>
  }
}
#declare Fork15 = difference {
  object { Fork14 }
  cylinder { // Fork_part14
    <0,0,1>, <0,0,0>, 1 
    scale <3.969344, 3.767085, 1.25>
    rotate 90.0*x
    translate  <6.2, 0.65, 3.606738>
  }
  box { // Fork_diff12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.6, 0.3>
    translate  <5.149567, 0.0, -0.099811>
  }
  box { // Fork_diff15
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.909091, 0.3>
    translate  <7.25, 0.0, -0.2>
  }
  scale <1.0, 1.1, 1.0>
}
#declare Fork_diff30 = intersection {
  box { // Fork_diff20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate -3.0*z
    translate  <7.8, 0.0, -0.3>
  }
  box { // Fork_diff21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate 3.0*z
    translate  <7.8, 0.0, -0.3>
  }
}
#declare Fork_diff31 = union {
  box { // Fork_diff22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate -3.0*z
    translate  <7.8, 0.0, -0.3>
  }
  box { // Fork_diff23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate 3.0*z
    translate  <7.8, 0.0, -0.3>
  }
}
#declare Fork_diff33 = difference {
  object { Fork_diff31 }
  box { // Fork_diff32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.1, 0.3>
    translate  <7.5, 0.0, -0.3>
  }
}
#declare Fork20 = union {
  object { Fork_diff30 }
  object { Fork_diff33 }
  cylinder { // Fork_part20
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.024, 0.4>
    translate  <7.3, 0.0, -0.5>
  }
  scale <1.5, 1.5, 1.0>
  translate  -4.15*x
}
#declare Fork_diff34 = intersection {
  box { // Fork_diff24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate -3.0*z
    translate  <7.8, 0.0, -0.3>
  }
  box { // Fork_diff25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate 3.0*z
    translate  <7.8, 0.0, -0.3>
  }
}
#declare Fork_diff35 = union {
  box { // Fork_diff26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate -3.0*z
    translate  <7.8, 0.0, -0.3>
  }
  box { // Fork_diff27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate 3.0*z
    translate  <7.8, 0.0, -0.3>
  }
}
#declare Fork_diff37 = difference {
  object { Fork_diff35 }
  box { // Fork_diff36
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.1, 0.3>
    translate  <7.5, 0.0, -0.3>
  }
}
#declare Fork21 = union {
  object { Fork_diff34 }
  object { Fork_diff37 }
  cylinder { // Fork_part21
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.024, 0.4>
    translate  <7.3, 0.0, -0.5>
  }
  scale <1.5, 1.5, 1.0>
  translate  <-4.15, 0.3, 0.0>
}
#declare Fork_diff38 = intersection {
  box { // Fork_diff28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate -3.0*z
    translate  <7.8, 0.0, -0.3>
  }
  box { // Fork_diff29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate 3.0*z
    translate  <7.8, 0.0, -0.3>
  }
}
#declare Fork_diff41 = union {
  box { // Fork_diff39
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate -3.0*z
    translate  <7.8, 0.0, -0.3>
  }
  box { // Fork_diff40
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.05, 0.2>
    rotate 3.0*z
    translate  <7.8, 0.0, -0.3>
  }
}
#declare Fork_diff43 = difference {
  object { Fork_diff41 }
  box { // Fork_diff42
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.1, 0.3>
    translate  <7.5, 0.0, -0.3>
  }
}
#declare Fork22 = union {
  object { Fork_diff38 }
  object { Fork_diff43 }
  cylinder { // Fork_part22
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.024, 0.4>
    translate  <7.3, 0.0, -0.5>
  }
  scale <1.5, 1.5, 1.0>
  translate  <-4.15, -0.3, 0.0>
}
#declare Fork18 = difference {
  box { // Fork16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.621237, 0.115>
    translate  <7.25, 0.0, -0.274265>
  }
  box { // Fork_diff16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.8, 0.2>
    rotate -3.0*y
    translate  <7.35, 0.0, -0.55>
  }
  box { // Fork_diff17
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.2, 0.2>
    rotate 4.0*z
    translate  <7.25, -0.76, -0.25>
  }
  box { // Fork_diff18
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.2, 0.2>
    rotate -4.0*z
    translate  <7.25, 0.76, -0.25>
  }
  object { Fork20 }
  object { Fork21 }
  object { Fork22 }
}
#declare Stain2 = blob {
  threshold 0.6
  component 1.0, 1.256356, <-0.008439, 0.0, -0.008439>
  component 1.0, 0.708315, <0.548523, 0.0, 0.227848>
  component 1.0, 0.355493, <0.126582, 0.0, -0.599156>
  component 1.0, 0.620843, <-0.666667, 0.0, -0.008439>
  component 1.0, 0.428071, <-0.548523, 0.0, 0.413502>
  
sturm
  texture {
    Sauce_texture
  }
  scale <0.2, 0.04, 0.3>
  rotate <89.589523, 1.127622, -20.00404>
  translate  <6.350576, 0.321808, -0.15303>
}

union { // Fork
  object { Fork2 }
  object { Fork3 }
  object { Fork9 }
  object { Fork15 }
  object { Fork18 }
  object { Stain2 }
  texture {
    Chrome_Metal1
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <6.0, 0.7, 0.35>
      rotate 1.2*y
      translate  2.45*x
    }
  }
  scale 0.5
  rotate <0.0, -1.2, 100.0>
  translate  <-5.25, -2.9, 0.1>
}


union { // Milk
  superellipsoid { // Milk_part1
    <0.02, 0.02>
    texture {
      Paper1
  translate <0.000000, 0.000000, 0.850000>
    }
    translate  1.0*z
  }
  superellipsoid { // Milk_part2
    <2.0, 2.0>
    scale <1.35, 1.35, 0.75>
    rotate -45.0*z
    translate  2.0*z
  }
  box { // Milk_part3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.95, 0.6>
    rotate 52.0*y
    translate  <-0.51, 0.0, 2.35>
  }
  box { // Milk_part4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.95, 0.6>
    rotate <0.0, 52.0, 180.0>
    translate  <0.5, 0.0, 2.35>
  }
  box { // Milk_part5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.95, 0.2>
    translate  <-0.025, 0.0, 2.9>
  }
  box { // Milk_part6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015, 0.95, 0.2>
    translate  <0.025, 0.0, 2.9>
  }
  texture {
    Paper2
  }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.047329, 1.047329, 1.596982>
      translate  1.550347*z
    }
  }
  rotate 55.0*z
  translate  <-4.9, 3.05, 0.0>
}


#declare Mug_Diff1 = union {
  cone { // Mug_part1
    <0,0,0>, 0.95, <0,0,1>, 1.0
    scale <1.0, 1.0, 1.4>
  }
  cone { // Mug_part2
    <0,0,0>, 1.1, <0,0,1>, 1.2
    scale <1.0, 1.0, 1.85>
    translate  1.4*z
  }
  torus { // Mug_part3
    1.0, 0.1  rotate -x*90
    translate  1.4*z
  }
}
#declare Mug_Diff2 = union {
  cone { // Mug_part4
    <0,0,0>, 0.95, <0,0,1>, 1.0
    scale <1.0, 1.0, 1.4>
  }
  cone { // Mug_part5
    <0,0,0>, 1.1, <0,0,1>, 1.2
    scale <1.0, 1.0, 1.85>
    translate  1.4*z
  }
  torus { // Mug_part6
    1.0, 0.1  rotate -x*90
    translate  1.4*z
  }
  scale <0.9, 0.9, 1.0>
  translate  0.1*z
}
#declare Mug_1 = difference {
  object { Mug_Diff1 }
  object { Mug_Diff2 }
}
union { // Mug
  torus { // Mug_2
    1.137, 0.063  rotate -x*90
    translate  3.25*z
  }
  object { Mug_1 }
  texture {
    Plastic_1
  }
  bounded_by { // Bound00002
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.254333, 1.254333, 1.729333>
      translate  <0.0, 0.0, 1.675>
    }
  }
  translate  <4.65, 2.9, 0.0>
}




