//Phillip A. Conophy
//"Among the Crystal Reefs"
//4-21-97

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#declare StarField =
	texture {
		pigment {
			granite color_map {
				[ 0.00  0.35 color Black  color Black ]
				[ 0.35  0.351 color Gray20 color Gray40 ]
				[ 0.351  0.3515 color Gray80 color White ]
				[ 0.3515  0.85 color Black color Black ]
				[ 0.85  0.851 color Gray20 color Gray40 ]
				[ 0.851  0.852 color Gray60 color Gray80 ]
				[ 0.852  0.853 color Gray40 color Gray60 ]
				[ 0.853  1.00 color Black color Black ]
            }
        }
		finish {
			ambient 1
			diffuse 0
		}
	}

#declare Nebula_Cloud =
sphere {
	0,
	1
	pigment {
		color rgbt <1, 1, 1, 1>
	}
	halo {
		emitting
	    spherical_mapping
		linear
	    turbulence 1.5
		color_map {
			[ 0 color rgbt <0.4, 0.4, 0.8, 0.8> ]
			[ 1 color rgbt <0.2, 0.2, 0.8, -1.0> ]
	    }
		frequency 2
	    samples 20
	    scale 0.5
	}
	hollow
	scale 2.5
}

#declare Space=
union {
    object {
		Nebula_Cloud
        scale <2000, 500, 500>
        rotate<0, 20, 40>
		translate <-240,-60,5000>
	}
    object {
		Nebula_Cloud
        scale <2000, 400, 400>
        rotate<0, 10, 60>
		translate <1000,20,4000>
	}

    sphere {
		<0,0,0>,
		5000
		texture {
			StarField
		}
		hollow
	}
}
