
// Persistence of Vision Ray Tracer Scene Description File
// File: thacher.pov
// Vers: 3.01
// Desc: See .txt
// Date: End of April, 1997
// Auth: Casey Maloney Rosales Muller <cmuller@thacher.org>

// setup

#include "colors.inc"
#include "metals.inc"

global_settings { assumed_gamma 1.9 }


// camera

camera
{
location <0,100,20>
look_at <4,103,0>
}

// planet

sphere
{
<0,0,0>, 100
texture {
        pigment {
        bozo
        turbulence 0.65
        octaves 4
        omega .8
        lambda 1.9
        color_map {
                  [0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.75, 0.75, 0.75>]
                  [0.1 0.5 color rgb <0.75, 0.75, 0.75> color rgb <.5, .5, 1>]
                  [0.5 1.0 color rgb <.5, .5, 1> color rgbt <.5, 1, .5>]
                  }
        scale <0.2, 0.5, 0.2>
        }
        }
}

//probe

union
{

    cylinder
    {
    <0,106,0>, <0,110,0>, .5
    }

    sphere
    {
    <0,106,0>,1
    }

    sphere
    {
    <0,110,0>,1
    }
    texture { T_Silver_4C }

}

//thacher logo

cylinder
{
<0,107,0>, <0,109,0>, .501
           texture {
                   pigment {
                           image_map {
                                     gif "thacher.gif"
                                     map_type 2
                                     once
                                     interpolate 4
                                     filter 0, 1.0
                                     }
                           translate y*107.5
                           rotate <0,40,0>
                           }
                   }

}

//stars

plane
{
z,-101
texture {
        pigment
        {
                image_map
                {
                gif "starfld.gif"
                }
        }
        }
}

//attempted sun

light_source
{
    <5,100,-25>
    color <1, .95, .9>
    area_light <0,4,0>, <0,0,4>, 4, 4
    adaptive 1
    jitter
}


sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 color rgbt <1, .6, .5, -0.5> ]
      [ 1 color rgbt <1, 1, .6, -1.0> ]
    }
    samples 10
  }
  hollow
  no_shadow
  scale 4
  translate <5,98,-25>
}

sphere { 0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0 color rgbt <1, 0, 0,  1.0> ]
      [ 1 color rgbt <1, 1, 0, -1.0> ]
    }
    samples 10
  }
  hollow
  no_shadow
  scale 5
  translate <4,99,-25>
}


//moon

light_source {
    <8.1,109.1,0.1>
    color <.76,.75,1,-1>
    area_light <0,4,0>, <0,0,4>, 4, 4
    adaptive 1
    jitter
  }

sphere { <13,114,5>, 5
texture {
  pigment {
      wrinkles
    color_map {
     [0 0.3*White]
     [1 White]
    }
  }
finish { crand .005
       }
}
}

