// Persistence of Vision Ray Tracer Scene Description File
// File: THREE-AM.pov
// Vers: 3.01 Watcom Win32
// Desc: 3:00 am in the computer labs
// Date: March 12, 1997
// Auth: Sonya Roberts
// Note:


// ==== Standard Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"
#include "custom.inc"

#declare True = 1
#declare False = 0

// ---- Create Basic Room and the Objects Within
#declare UseCamera=2
#switch (UseCamera)
	#case (1)
		#debug "CAMERA - Centered looking at window from front of class\n"
		camera {
			location	<0,5.9,1>
			up		<0,1,0>
			right		<1.33,0,0>
			direction	<0,0,.7>
			look_at		<0,5,20>
		}
	#break
	#case (2)
		#debug "CAMERA - Looking at wall with posters from in front of main doorway\n"
		camera {
			location	<-11,5.5,1.5>
			up		<0,1,0>
			right		<1.33,0,0>
			look_at		<0,5,14>
		}
	#break
	#case (3)
		#debug "CAMERA - Looking at front of class from way in back\n"
		camera {
			location	<12,5.5,39>
			up		<0,1,0>
			right		<1.33,0,0>
			look_at		<0,5,14>
		}
	#break
	#case (4)
		#debug "CAMERA - Sitting at computer\n"
		// NOTE - to change computers, change X by +-5 to move to left or right,
		//        and/or change Z by +-10 to move forwards or backwards in the class.
		//        To turn, make the "look_at" Z value be three units to the other
		//        side of the "location" Z value.

		camera {
			location	<-7,4,35>
			up		<0,1,0>
			right		<1.33,0,0>
			look_at		<-7,3.6,38>
		}
	#break
	#case (5)
		#debug "CAMERA - Sitting at computer with pop & cookies\n"
		camera {
			location	<-7.25,3.65,5.75>
			up		<0,1,0>
			right		<1.33,0,0>
			direction	<0,0,.8>
			look_at		<-7.25,3.6,7.5>
		}
	#break
#end

#declare BasicRoom=True
#declare Furnish=True
#declare UseStuff=True
#declare UseLights=True
#declare MonitorGlow=True
#declare Ambience=True
#declare DetailedCeiling=True

#if (BasicRoom=True)
	#debug "Creating Room...\n"

	#declare I_Posters=True
	#declare I_Warnings=True
	#declare I_TrackLights=True
	#declare I_TV=True
	#declare I_Camera=True
	#declare I_WhiteBoard=True
	#include "room.pov"
#end

#if (Furnish=True)
	#debug "Creating furnishings...\n"

	#declare I_Desks=True
	#declare I_Chairs=True
	#declare I_PCCase=True
	#declare I_Monitor=True
	#declare I_Keyboard=True
	#declare I_Mouse=True
	#declare I_Mousepad=True	// NOTE - Mousepads only appear at computers with something on the monitor (and not all of those)
	#declare I_ZipDrives=True	// NOTE - Zip drives only appear if PCCase=True
	#include "furnish.pov"
#end

#if (UseStuff=True)
	#debug "Making miscellaneous junk...\n"

	#declare I_Popcans=True
	#declare I_Cookies=True
	#declare I_Pizza=True
	#declare I_Candles=True
	#include "stuff.pov"
#end


// ---- Assemble Everything in the Finished Scene ---------------------------------------------------------------------
#if (Furnish=True)
	#debug "Using Furnishings\n"
	object {Furnishings}
#end

#if (UseStuff=True)
	#debug "My but these students are messy!\n"
	object {Stuff}
#end

#if (Ambience=True)
	#debug "Going for a little ambience\n"
	atmosphere {
		type 4
		samples 40
		distance 60
		scattering 0.2
		aa_level 4
		aa_threshold 0.15
		jitter 0.3
	}
#end

#if (UseLights=False | DetailedCeiling=False)
	#debug "Using Default Light Sources\n"
	light_source {
		<0,10,1>,
		color Gray50
	}
	light_source {
		<-14,10,39>,
		color Gray50
	}
#end
