
#declare LegTransLeft =
	transform {
		scale <1.4,0.25,0.25>
		rotate y*14
		translate <0,0,0.4>
	}

#declare LegTransRight =
	transform {
		scale <1.4,0.25,0.25>
		rotate y*-14
		translate <0,0,-0.4>
	}

#declare JointPoint = <0.9,2,0>

#declare Stand =
	difference {
		blob {
			threshold 0.5
			cylinder {
				<0,0,0>
				<0,1,0>
				1
				strength 1
				transform LegTransLeft
			}
			cylinder {
				<0,0,0>
				<0,1,0>
				1
				strength 1
				transform LegTransRight
			}

			cylinder {
				<0.2,0.35,0.4>
				<-0.4,0.7,0.3>
				0.1
				strength 0.8
				rotate y*-22
			}

			cylinder {
				<0.2,0.35,-0.4>
				<-0.4,0.7,-0.3>
				0.1
				strength 0.8
				rotate y*+22
			}

			cylinder {
				<0.2,0.7,0>
				<-0.16,1.2,0>
				0.3
				strength 0.8
			}
			sphere {
				<-0.16,1.3,0>
				0.2
				strength -0.4
			}

			sphere {
				<0.4,0.4,0>
				0.8
				strength 0.2
			}

			cylinder {
				<0.4,0.4,0>
				JointPoint
				0.6
				strength 0.6
			}

			#declare c=4
			#while (c)
				cylinder {
					<0.4,0.9-c*0.0800,-0.3> <0.7,0.9-c*0.0800,-0.3>, 0.1
					strength 0.6
				}
				#declare c=c-1
			#end

			sturm
		}

		union {
			box {
				<-0.2,-0.1,-0.1>
				<+0.2,+0.1,+0.1>
				rotate z*-20
				translate JointPoint + <0,0.1,0>
			}

			// ports box
			box {
				<0.4,0.58,-0.40>
				<0.7,0.82,-0.30>
			}
		}
	}

#declare Ports =
	union {
		box {
			<0.42,0.60,-0.38>
			<0.68,0.80,-0.35>
		}
		union {
			cone {
				<0,0,0>,0.04
				<0,0,-0.02>,0.03
			}
			cylinder {
				<0,0,0>
				<0,0,-0.021>, 0.028
				pigment { colour Green }
				finish { Luminous }
			}
			translate <0.48,0.74,-0.37>
		}
		union {
			cone {
				<0,0,0>,0.04
				<0,0,-0.02>,0.03
			}
			cylinder {
				<0,0,0>
				<0,0,-0.021>, 0.028
				pigment { colour Red/2 }
			}
			translate <0.48,0.66,-0.37>
		}
		text {
			ttf "cyrvetic.ttf" // Anything will do
			"SM451"
			0.01,0*x
			scale <0.045,0.05,1>
			translate <0.53,0.74,-0.385>
			pigment { colour White }
		}
		text {
			ttf "cyrvetic.ttf" // Anything will do
			"INSTRUCTOR UNIT"
			0.01,0*x
			scale <0.061,0.05,1>/4
			translate <0.53,0.72,-0.385>
			pigment { colour White }
		}
		difference {
			cylinder {
				<0,0,0>
				<0,0,-0.06>,0.02
			}
			cylinder {
				<0,0,0.1>
				<0,0,-0.07>,0.015
			}
			translate <0.60,0.66,-0.35>
			pigment { colour White }
		}
		texture { PolishedSteel }
	}

#declare CraniatorSupport =
	difference {
		blob {
			threshold 0.5

			cylinder {
				<0,0,0>
				<0,1,0>
				0.4
				strength 0.6
			}

			sphere {
				<-0.2,1,0>
				0.6
				strength 1
			}
			sphere {
				<-0.3,0.9,0>
				0.4
				strength -0.6
			}
			sphere {
				<-0.3,0.93,0>
				0.2
				strength -0.6
			}
		}

		cylinder {
			<0,0,+0.095>
			<0,0,+0.2>
			0.17
		}
		cylinder {
			<0,0,-0.095>
			<0,0,-0.2>
			0.17
		}
	}


#declare ZorberXForm =
	transform {
		rotate x*90
		translate <-0.1,-0.2,0>
	}

#declare ZorberTipAngle	= 89-178*ZorbersExtended
#declare Zorber =
	union {
		difference {
			torus {
				0.2,0.04
			}
			plane {
				x,0
				rotate y*-90
				rotate y*-ZorberTipAngle
			}
			plane {
				x,0
			}
			texture {
				pigment { ZorberPigment }
				finish { Dull }
				normal {
					radial 0.1
					frequency 50
				}
			}
		}
		union {
			cone {
				<0,0,0.2>,0.04
				<-0.1,0,0.2>,0.01
			}
			sphere {
				<-0.1,0,0.2>,0.01
			}
			texture {
				pigment { ZorberPigment }
				finish { Dull }
			}
		}
		rotate y*ZorberTipAngle
		transform ZorberXForm
	}

#declare ZorberHoles =
	union {
		#declare NZorbers=9
		#declare Zorbers=NZorbers
		#while (Zorbers)
			torus {
				0.2,0.05
				transform ZorberXForm
				rotate x*(Zorbers*360/NZorbers+180)
			}
			#declare Zorbers=Zorbers-1
		#end
	}

#declare CraniatorXForm =
	transform {
		rotate z*30
		translate <-0.2,1,0>
	}

#declare Craniator =
	union {
		blob {
			threshold 0.5
			sphere { <0,0,0> 0.5 strength 1 }
			sphere { <-0.2,0,0> 0.22 strength -1.2 }

			pigment { ZorberPigment }
			finish { Dull }
			normal {
				radial 0.1
				frequency 60
				rotate z*-90
			}
		}
		union {
			#declare NZorbers=9
			#declare Zorbers=NZorbers
			#while (Zorbers)
				object { Zorber rotate x*(Zorbers*360/NZorbers+180) }
				#declare Zorbers=Zorbers-1
			#end
		}
		transform CraniatorXForm
	}

#declare ZorberHoles =
	object { ZorberHoles transform CraniatorXForm }

#declare SupportedCraniator =
	union {
		difference {
			object { CraniatorSupport }
			object { ZorberHoles }
		}
		object { Craniator }
	}

#declare ArmRest =
	union {
		intersection {
			torus { 1,0.1 }
			box { <0,-1,0> <2,2,2> }
			rotate z*-90
			translate <0,1,0>
			//rotate x*90
			scale <0.5,0.3,0.16>
			texture { PolishedSteel }
		}
		superellipsoid {
			<0.1,0.1>
			scale <0.25,0.022,0.08>
			translate <0,0.3,0.15>
			texture { BlackVinyl }
		}
		translate <0.06,0,0.3>
	}

#declare Seat =
	union {
		difference {
			sphere {
				<0,0,0>,1
				scale <2,0.3,1>
			}
			plane { -y,-0.1 }
			plane { x,-0.5 }
			sphere {
				<0,0,0>,1
				scale <1.6,0.1,0.35>
				translate <-0.5,0.12,0.4>
			}
			sphere {
				<0,0,0>,1
				scale <1.6,0.1,0.35>
				translate <-0.5,0.12,-0.4>
			}

			texture { BlackVinyl }
			scale <0.25,0.35,0.35>
		}
		object { ArmRest }
		object { ArmRest scale <1,1,-1> }

		translate <-0.25,1.25,0>
	}

#declare ShoePrint =
	union {
		intersection {
			cylinder { <0,0,0> <0,0.1,0>, 0.3 }
			plane { -x, +0.1 }
			scale <1,1,0.45>
			translate <0.4,0,0>
		}
		intersection {
			cylinder { <0,0,0> <0,0.1,0>, 0.3 }
			plane { +x, +0.2 }
			scale <1.6,1,0.6>
			translate <-0.2,0,0>
		}
		rotate y*5
		translate <0,0.19,0.30>
	}

#declare FootRest =
	difference {
		cone {
			<0,0,0>,0.9
			<0,0.2,0>,1.0
		}
		cone {
			<0,0,0>,1.1
			<0,0.3,0>,0.8
			inverse
		}
		object { ShoePrint }
		object { ShoePrint scale <1,1,-1> }

		scale <0.3,0.3,0.5>
		scale 0.8
		translate <-0.5,0.7,0>

		texture { BlackVinyl }
	}

#declare SM451 =
	union {
		object { Seat }
		object { FootRest }
		object { Stand }
		object { Ports }
		object {
			SupportedCraniator
			rotate z*(60*CraniatorLowered)
			translate JointPoint
		}
		texture { OrwellianSteel }
	}


