#include "consts.inc"
#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "skies.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"


global_settings {
     radiosity {
       // brightness FLOAT
       // count INTEGER
       distance_maximum 15
       // error_bound FLOAT
       // gray_threshold FLOAT
       // low_error_factor FLOAT
       // minimum_reuse FLOAT
       // nearest_count INTEGER
       // recursion_limit INTEGER
     }
   }


#declare LIGHTS_ABOVE=1
#declare INSTRUCTORS=1

#declare PolishedSteel = texture { Polished_Chrome }

#declare ZorberPigment =
	pigment {
		colour White
	}

#declare BlackVinyl =
	texture {
		pigment { rgb <0.1,0.1,0.1> }
		finish { Glossy }
	}

#declare OrwellianSteel =
//#if (0)
//	texture {
//		pigment { White }
//	}
//#else
	texture {
		pigment {
			granite
			colour_map {
			 [ 0 rgb<0,76,80>/200 ]
			 [ 1 rgb<0,76,80>/250 ]
			}
			scale 0.05
		}
		normal {
			bumps 0.1
			scale 0.004
		}
		finish { F_MetalB }
	}
//#end


plane { y,0 pigment { rgb<0.6,0.6,0.6> } }

global_settings {
	adc_bailout 4/255
	max_trace_level 3
	radiosity {
		distance_maximum 10 // XXX Not tested
	}
}

#declare RightVector = x*4/3

#declare FromAbove =
	camera {
		orthographic
		location <2.7,30,2.7>
		//direction z right RightVector look_at <1.5,0,2>
		direction -y up -x*18 right z*18*4/3
	}

#declare AtStandJoint =
	camera {
		location <0,3,-3>
		direction z*5
		right RightVector
		look_at <0.8,2,0>
	}

#declare AtFootRestSide =
	camera {
		location <-0.3,1.5,-4>
		direction z*3
		right RightVector
		look_at <-0.3,1.1,0>
	}

#declare AtFootRestAbove =
	camera {
		location <-1.0,2.5,0>
		direction z*1
		right RightVector
		look_at <-0.6,0.7,0>
	}

#declare AtFootRestFront =
	camera {
		location <-4,1,0>
		direction z*3
		right RightVector
		look_at <-0.4,0.7,0>
	}

#declare AtSeatFront =
	camera {
		location <-3,1.7,0>
		direction z*2
		right RightVector
		look_at <-0.4,1.1,0>
	}

#declare AtSeatSide =
	camera {
		location <0,1.7,-3>
		direction z*3
		right RightVector
		look_at <-0.1,1.1,0>
	}

#declare FromFront =
	camera {
		location <-9,1.5,0>
		direction z*2.5
		right RightVector
		look_at <0,1.5,0>
	}

#declare FromBack =
	camera {
		location <+9,1.5,0>
		direction z*2.5
		right RightVector
		look_at <0,1.5,0>
	}

#declare FromSide =
	camera {
		location <-0,1.5,-9>
		direction z*2.5
		right RightVector
		look_at <0,1.5,0>
	}

#declare AtPorts =
	camera {
		location <0.55,0.6,-3>
		direction z*4
		right RightVector
		look_at <0.55,0.6,0>
	}

#declare AtPortsToSide =
	camera {
		location <0.05,0.65,-1.2>
		direction z*2
		right RightVector
		look_at <0.65,0.65,-0.3>
	}

#declare AtJustPorts =
	camera {
		location <0.55,0.6,-3>
		direction z*6
		right RightVector
		look_at <0.55,0.6,0>
	}

#declare AtRaisedCraniator =
	camera {
		location <-1,2.8,0>
		direction z*1.5
		right RightVector
		look_at <0,2.8,0>
	}

#declare AtLoweredCraniator =
	camera {
		location <-1,2,-0.5>
		direction z*1
		right RightVector
		look_at <0,2.2,0>
	}

#declare AestheticWhole =
	camera {
		location <-3,1,-6>
		direction z*1
		right RightVector
		look_at <2,2,0>
	}

#declare AestheticCloser =
	camera {
		location <-1.7,0.5,-4.0>
		direction z*0.8
		right RightVector
		look_at <2.0,2,0>
	}

#declare AestheticEvenCloser =
	camera {
		location <-1.4,0.5,-3.9>
		direction z*0.9
		right RightVector
		look_at <2.0,1.8,0>
	}

#declare AestheticEvenCloserStill =
	camera {
		location <-2.0,0.5,-2.5>
		direction z*0.9
		right RightVector
		look_at <2.0,1.6,0.8>
	}

#if (INSTRUCTORS)

#declare R=seed(1)

#declare Row = 5
#while (Row>=0)
	#declare Col = 4
	#while (Col>=0)
		#if (Row=0 & Col=0)
			#declare ZorbersExtended = 0.7
			#declare CraniatorLowered = 1
		#else
			#declare ZorbersExtended = rand(R)
			#declare CraniatorLowered = rand(R)
		#end
		#include "sm451.inc"
		object { SM451 translate z*2.4*Col rotate y*0*Col translate x*3*Row }
		#declare Col=Col-1
	#end
	#declare Row=Row-1
#end

#end

#declare RADIUS=20
#declare FALLOFF=26

#if (LIGHTS_ABOVE)

#declare Row = 3
#while (Row>=0)
	#declare Col = 3
	#while (Col>=0)
		#if ((Row=2 & Col=3) | (Row=3 & Col=1))
			// Burning out
			#declare OldBulbLight = <255,250,190>/350+<0.05,0,0>
		#else
			#if ((Row=2 & Col=0) | (Row=0 & Col=3))
				#declare OldBulbLight = <255,252,200>/255 // Nearly new!
			#else
				#declare OldBulbLight = <255,250,190>/255
			#end
		#end
		light_source {
			#include "light.inc"
			translate <-0.8+3.7*Row,0,-0.8+3.7*Col>
		}
		#declare Col=Col-1
	#end
	#declare Row=Row-1
#end

#end


#declare LRBorder=0.05
#declare TBorder=0.11
#declare BBorder=0.25
#declare Height=1.2

#declare TapeReelSide =
	difference {
		cylinder { <0,0,0><0,0,-0.1>,1 scale 0.999 }
		difference {
			cylinder { <0,0,0.001><0,0,-0.1>,0.75 }
			merge {
				cylinder { <0,0,0.002><0,0,-0.1>,0.20 scale 1.0001 }
				box { <0,-0.08,-0.1><1,+0.08,1> scale 1.0001 rotate z*20 }
				box { <0,-0.08,-0.1><1,+0.08,1> scale 1.0001 rotate z*140 }
				box { <0,-0.08,-0.1><1,+0.08,1> scale 1.0001 rotate z*260 }
			}
		}
		cylinder { <0,0,0.1><0,0,-0.2>,0.10 }
		scale <1,1,0.3>
	}
#declare TapeReel =
	union {
		object { TapeReelSide }
		object { TapeReelSide translate <0,0,-0.25> }
		difference {
			cylinder { <0,0,0.1><0,0,-0.25>,0.19 }
			cylinder { <0,0,0.1001><0,0,-0.25001>,0.10 }
		}
		pigment { White }
		finish { Dull }
		scale <1,1,0.8>
	}
#declare TapeReelTape1 =
	difference {
		cylinder { <0,0,0.09><0,0,-0.20>,0.20 }
		cylinder { <0,0,0.0901><0,0,-0.20001>,0.11 }

		pigment {
			wood
			colour_map {
			 [ 0 colour <98,65,0>/255 ]
			 [ 1 colour <98,65,0>/150 ]
			}
			scale 0.1
		}
		finish { Dull }
		scale <1,1,0.8>
	}
#declare TapeReelTape2 =
	difference {
		cylinder { <0,0,0.09><0,0,-0.20>,0.40 }
		cylinder { <0,0,0.0901><0,0,-0.20001>,0.11 }

		pigment {
			wood
			colour_map {
			 [ 0 colour <98,65,0>/255 ]
			 [ 1 colour <98,65,0>/200 ]
			}
			scale 0.03
		}
		finish { Dull }
		scale <1,1,0.8>
	}

#declare InsetDepth=0.1

#declare Console =
union {
	light_source {
		<1-0.065,Height-0.065,-0.04>
		colour White*2
		spotlight
		point_at <0.4,0.4,-0.01>
		radius 90
		falloff 100
		fade_distance 1
		fade_power 3
		looks_like {
			sphere {
				<0,0,0>,0.02
				pigment { White }
				finish { Luminous }
			}
		}
	}
	difference {
		intersection {
			box {
				<0,0,0>,<1,1,1>
			}
			plane {
				x,0.8
				rotate y*-45
			}
		}
		box {
			<-1,0.05,-0.1>
			<+1,0.95,+1>
			rotate y*-35
		}
		translate <-0.5,-0.5,0>
		scale 0.08
		rotate z*45
		translate <1-0.065,Height-0.065,-0.0799>
	}
	difference {
		box {
			<0,0,0>
			<1,Height,0.4>
		}
		box {
			<LRBorder,BBorder,-0.01>
			<1-LRBorder,Height-TBorder,InsetDepth>
		}
	}
	box {
		<LRBorder,BBorder,InsetDepth*0.999>
		<1-LRBorder,Height-TBorder,InsetDepth>
		pigment { colour <0.5,0.5,0.5> }
		finish { Dull }
	}
	union {
		object { TapeReel
			scale 0.18
			rotate z*75
			translate <0.3,0,0>
		}
		object { TapeReel
			pigment {
				image_map {
					tga "discmap.tga"
				}
				translate <-0.5,-0.5,0>
				scale 2.05
			}
			scale 0.18
			translate <0.7,0,0>
		}
		object { TapeReelTape1 scale 0.18 translate <0.3,0,0> }
		object { TapeReelTape2 scale 0.18 translate <0.7,0,0> }
		box {
			<0,0,0> <sqrt(pow(0.3,2)+pow(0.29*0.18,2)),0,0.29*0.18>
			rotate z*degrees(atan2(0.2*0.18,0.3))
			translate <0.3,0.2*0.18,-0.2*0.18>
			pigment { colour <98,65,0>/255 }
		}
		translate <0,0.8,InsetDepth*0.9>
	}
	// das blinkenlights
	union {
		#declare R=seed(2)
		#declare XX=0
		#while (XX<2)
			#declare Y=0
			#while (Y<15)
				#declare MX=int(rand(R)*16)
				#declare X=0
				#while (X<16)
					sphere {
						<XX*30+X*1.1,Y*1.5,0>, 0.5 
						#if (X>MX)
							finish { Shiny }
							#declare D=4
						#else
							finish { Luminous }
							#declare D=1
						#end
						pigment {
						#if (X > 10)
							colour rgb<1,0,0>/D
						#else
							colour rgb<0,1,0>/D
						#end
						}
					}
					#declare X=X+1
				#end
				#declare Y=Y+1
			#end
			#declare XX=XX+1
		#end
		scale <0.008,0.006,0.001>*2
		translate <LRBorder+0.06,BBorder+0.04,InsetDepth>
	}
	rotate y*30 translate <0,0,-1.7>
	//translate <0,0,-2.5>
	texture { OrwellianSteel }
	//finish { ambient 0.9 }
}

object { Console }

#declare AtConsoleLight =
	camera {
		location <1-0.05,Height-0.05,-4>
		direction z*10
		right RightVector
		look_at <1-0.05,Height-0.05,-2.5>
	}

#declare AtDasBlinkenLights =
	camera {
		location <0.5,0.5,-4>
		direction z*2
		right RightVector
		look_at <0.5,0.5,-2.5>
	}

#declare AtConsole =
	camera {
		location <0,1,-6>
		direction z*2
		right RightVector
		look_at <1,0.5,0>
	}

#declare AtConsoleFromSide =
	camera {
		location <-3,1,-3>
		direction z*3
		right RightVector
		look_at <1,0.5,-2.5>
	}


atmosphere {
	type 1
	samples 20
	distance 40
	scattering 0.02
	aa_level 8
	aa_threshold 0.1
	jitter 0.2
	//colour rgbf<>
}


camera { AtStandJoint }
camera { AtFootRestAbove }
camera { AtRaisedCraniator }
camera { AtFootRestFront }
camera { AtSeatSide }
camera { AtLoweredCraniator }
camera { FromBack }
camera { AtSeatFront }
camera { AtPorts }
camera { AtJustPorts }
camera { AtPortsToSide }
camera { FromFront }
camera { FromSide }
camera { FromAbove }
camera { AtConsoleLight }
camera { AtConsoleFromSide }
camera { AtDasBlinkenLights }
camera { AtConsole }
camera { AestheticCloser }
camera { AestheticEvenCloser }
camera { AestheticEvenCloserStill }
camera { AestheticWhole }
