
// ==== Standard POV-Ray Includes ====
//#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

//camera {
//	location <0,2,-10>
//	look_at  <0,2,0>
//}

//light_source {<0,2,-6> color White}

#include "woods.inc"

#declare Davinci_copter =
union {

// rotor shaft
cylinder {<0,0,0><0,6,0>,0.15 texture{T_Wood15}}
cone {<0,6,0>,0.15,<0,6.25,0>,0 texture{T_Wood15}}

// base plate
cylinder {<0,0,0><0,0.15,0>,2 texture{T_Wood15}}
cylinder {<0,-0.4,0><0,-0.55,0>,2 texture{T_Wood15}}

#declare Base_plate_part1 =
cylinder {<1.9,-0.4,0><1.9,0,0>,0.1 texture{T_Wood22}}

#declare Number_of_arms = 16
#declare Count = 0
#while (Count < Number_of_arms)
	object {Base_plate_part1 rotate <0,(Count * (360 / Number_of_arms)),0>}
	#declare Count = (Count + 1)
#end

#declare Base_plate_part2 =
cylinder {<1.9,0.4,0><1.9,0,0>,0.05 texture{T_Wood22}}

#declare Number_of_arms = 16
#declare Count = 0
#while (Count < Number_of_arms)
	object {Base_plate_part2 rotate <0,(Count * (360 / Number_of_arms)),0>}
	#declare Count = (Count + 1)
#end

// rail
torus {2,0.05 texture{T_Wood15} translate <0,0.4,0>}

// one arm
#declare Heli_arm =
cylinder {<0,0,0><0,3.5,0>,0.075 texture{T_Wood13}
	rotate <0,0,-30>
	translate <-1.9,0,0>
}

#declare Number_of_arms = 8
#declare Count = 0
#while (Count < Number_of_arms)
	object {Heli_arm rotate <0,(Count * (360 / Number_of_arms)),0>}
	#declare Count = (Count + 1)
#end

torus {1.5,0.05 texture{T_Wood13} translate <0,1,0>}
torus {0.8,0.05 texture{T_Wood13} translate <0,2,0>}

#include "13davinci.pov"
object {djBox scale <4,1.5,4> translate <0,4,0> pigment{White}finish{phong .25 ambient .3}}

// spring
cylinder {<0,0.05,0><0,0.15,0>,.5 pigment{Gray50}finish{phong .5 metallic}}
cylinder {<0,0.2,0><0,0.3,0>,.5 pigment{Gray50}finish{phong .5 metallic}}
cylinder {<0,0.35,0><0,0.45,0>,.5 pigment{Gray50}finish{phong .5 metallic}}

// cables
#declare Cable =
cylinder {<0,0,0><0,4.5,0>,0.025 texture{T_Wood10}
	rotate <0,0,20>
	translate <-1.9,0.4,0>
}

#declare Number_of_arms = 8
#declare Count = 0
#while (Count < Number_of_arms)
	object {Cable rotate <0,(Count * (360 / Number_of_arms)),0>}
	#declare Count = (Count + 1)
#end

}
