//-----------------------------------------------------------
// Tripoutre de Penrose
//-----------------------------------------------------------

#declare lng = 11
#declare lar = lng/8
#declare dim = (lng+lar)/2

#declare textu = texture {
  T_Wood35
  scale 3
  rotate <0, 30, 0>
}

#declare poutre_1 = box {
  <-dim, -dim, dim>, <-dim+lar, -dim+lar, -dim+lar>
}

#declare poutre_2 = box {
  <-dim, -dim, -dim+lar>, <dim-lar, -dim+lar, -dim>
}

#declare poutre_3 = difference {
  box {
    <dim-lar, -dim, -dim+lar>, <dim, dim-lar+0.05, -dim>
  }
  box {
    <-3*lar, 0, -3*lar>, <3*lar, 3*lar, 3*lar>
    rotate <0, 0, 45.2>
    translate <dim-lar/2, dim-3*lar/2+0.05, -dim>
  }
  no_shadow
}

#declare penrose = union {
  object {
    poutre_1
  }
  object {
    poutre_2
  }
  object {
    poutre_3
  }
  texture {
    textu
  }
  finish {
    ambient 0.8
  }
  translate <0, dim, 0>
}
