//
// ANOTHER WORLD (ESCHER)
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "noeud.inc"
#include "moebius.inc"
#include "glass.inc"

//---------------------------------------------------------
// Commutateurs
//---------------------------------------------------------

#declare ciel_com = on
#declare mer_com = on
#declare structure_bas_com = on
#declare structure_fast_com = off
#declare arcane_com = on
#declare colonne_com = on
#declare pantin_com = on
#declare noeud_com = on
#declare moebius_com = on
#declare vingt_cinq_com = on
#declare choixDragon = 1  // 1 = hilbert curve
#declare nombreJours = 4

//---------------------------------------------------------
// Parametres de mise au point
//---------------------------------------------------------

#declare lux_ambient = 0.7

//---------------------------------------------------------
// Etapes de l'animation
//---------------------------------------------------------

// 1ere etape : passage de 1 personnage a 3 personnages
#declare NB_IMAGES_PHASE_1 = 50
// 2eme etape : passage de 3 personnages a 1 seul vu de loin sur l'horizon de droite
#declare NB_IMAGES_PHASE_2 = 50
// 3eme etape : rotation vue de loin depuis 1 perso jusqu'a 1 25
#declare NB_IMAGES_PHASE_3 = 80
// 4eme etape : passage de 1 25 a 3 25
#declare NB_IMAGES_PHASE_4 = 50
// 5eme etape : passage de 3 25 a 1 perso different du 1er !! (le 3eme en fait)
#declare NB_IMAGES_PHASE_5 = 80

#declare NB_IMAGES = 310

#if (clock > 0)
  #if (clock <= NB_IMAGES_PHASE_1)
    #declare camera_dz = 18.5/7+(18.5/10.2-18.5/7)*clock/NB_IMAGES_PHASE_1
    #declare camera_r1 = clock*33/NB_IMAGES_PHASE_1
    #declare camera_r2 = clock*39/NB_IMAGES_PHASE_1
    #declare camera_r3 = 0
    #declare camera_t1 = 3-clock*3/NB_IMAGES_PHASE_1
    #declare camera_t2 = -5+clock*5/NB_IMAGES_PHASE_1
    #declare camera_t3 = 2-clock*2/NB_IMAGES_PHASE_1
  #end
#end
#if (clock > NB_IMAGES_PHASE_1)
  #if (clock <= NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2)
    #declare camera_dz = 18.5/10.2+(0.48-18.5/10.2)*(clock-NB_IMAGES_PHASE_1)/NB_IMAGES_PHASE_2
    #declare camera_r1 = 33+(-90-33)*(clock-NB_IMAGES_PHASE_1)/NB_IMAGES_PHASE_2
    #declare camera_r2 = 39+(0-39)*(clock-NB_IMAGES_PHASE_1)/NB_IMAGES_PHASE_2
    #declare camera_r3 = -90*(clock-NB_IMAGES_PHASE_1)/NB_IMAGES_PHASE_2
    #declare camera_t1 = 0
    #declare camera_t2 = 0
    #declare camera_t3 = 0
  #end
#end
#if (clock > NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2)
  #if (clock <= NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2+NB_IMAGES_PHASE_3)
    #declare camera_dz = 0.48
    #declare camera_r1 = -90
    #declare camera_r2 = 0
    #declare camera_r3 = -90+(0+90)*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2)/NB_IMAGES_PHASE_3
    #declare camera_t1 = 0
    #declare camera_t2 = 0
    #declare camera_t3 = 0
  #end
#end
#if (clock > NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2+NB_IMAGES_PHASE_3)
  #if (clock <= NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2+NB_IMAGES_PHASE_3+NB_IMAGES_PHASE_4)
    #declare camera_dz = 0.48+(0.60-0.48)*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3)/
                         NB_IMAGES_PHASE_4
    #declare camera_r1 = -90+(-137+90)*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3)/
                         NB_IMAGES_PHASE_4
    #declare camera_r2 = 49*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3)/
                         NB_IMAGES_PHASE_4
    #declare camera_r3 = 0
    #declare camera_t1 = 0
    #declare camera_t2 = 0
    #declare camera_t3 = 0
  #end
#end
#if (clock > NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2+NB_IMAGES_PHASE_3+NB_IMAGES_PHASE_4)
  #if (clock <= NB_IMAGES_PHASE_1+NB_IMAGES_PHASE_2+NB_IMAGES_PHASE_3+NB_IMAGES_PHASE_4+NB_IMAGES_PHASE_5)
    #declare camera_dz = 0.60+(18.5/7-0.60)*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3
                         -NB_IMAGES_PHASE_4)/NB_IMAGES_PHASE_5
    #declare camera_r1 = -137+(-270+137)*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3
                         -NB_IMAGES_PHASE_4)/NB_IMAGES_PHASE_5
    #declare camera_r2 = 49+(-90-49)*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3
                         -NB_IMAGES_PHASE_4)/NB_IMAGES_PHASE_5
    #declare camera_r3 = 0
    #declare camera_t1 = 5*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3
                         -NB_IMAGES_PHASE_4)/NB_IMAGES_PHASE_5
    #declare camera_t2 = -2*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3
                         -NB_IMAGES_PHASE_4)/NB_IMAGES_PHASE_5
    #declare camera_t3 = 3*(clock-NB_IMAGES_PHASE_1-NB_IMAGES_PHASE_2-NB_IMAGES_PHASE_3
                         -NB_IMAGES_PHASE_4)/NB_IMAGES_PHASE_5
  #end
#end

// exception : si clock = 0 image choisie
#if (clock = 0)
  #declare camera_dz = 0.5
  #declare camera_r1 = -90
  #declare camera_r2 = 0
  #declare camera_r3 = -90
  #declare camera_t1 = 0
  #declare camera_t2 = 0
  #declare camera_t3 = 0
#end

//---------------------------------------------------------
// FOG
//---------------------------------------------------------

fog {
  color White
  distance 3*300
}

//---------------------------------------------------------
// MER
//---------------------------------------------------------

#declare mer =
difference {
  union {
    sphere {
      <0,0,0>, 1
      texture {
        pigment {color rgb<0.0, 0.1, 0.6>}
        normal {bumps 0.08 scale .003}
        finish {phong 1 reflection .5 ambient 0.1 diffuse 0.2}
      }
      rotate <clock*(360/NB_IMAGES)/4 , 0, 0>
      scale <300, 10, 300>
      clipped_by {
        plane {
          <0, 1, 0>, 0
        }
      }
    }
    height_field {
      gif "ocean.gif"
      texture {
        pigment {
          image_map {
            gif "ocean.gif"
          }
          rotate x*90
        }
        finish {crand 0.05 reflection 0.1 diffuse 0.7 ambient 0.6}
      }
      scale <240*2, 25, 240*2>
      translate <-240, -14.7, -240>
      clipped_by {
        plane {
          <0, -1, 0>, 10
        }
      }
    }
  }
  box {
    <-10, -11, -9000>, <9000, 11, 10>
  }
  pigment {
    Clear
  }
}

//---------------------------------------------------------
// CIEL
//---------------------------------------------------------

#declare Colors3 =
color_map  {
  [0.0 0.1 color SlateBlue color SlateBlue]
  [0.70 color rgb <4/5, 4/5, 5/6>]
  [1.0 color White]
}

#declare CloudSky =
texture {
  pigment {
    bozo
    turbulence 0.6
    octaves 3
    lambda 6
    color_map {
      Colors3
    }
  }
  finish {
    ambient 1
    diffuse 0
  }
  scale 1/6
}

#declare SkySphere =
sphere {
  <0,0,0>, 1
  texture {
    CloudSky
    scale 1/3
  }
  rotate <-clock*(360/NB_IMAGES)/4 , 0, 0>
  scale <300, 10, 300>
}

#declare ciel =
difference {
  object {
    SkySphere
  }
  box {
    <-10, -11, -9000>, <9000, 11, 10>
  }
  pigment {
    Clear
  }
  clipped_by {
    plane {
      <0, -1, 0>, 0
    }
  }
}

//---------------------------------------------------------
// generation du dragon
//---------------------------------------------------------

// **** segment ****
#declare segment = union {
  #declare unite = 1
  #declare largeur = unite/3
  #declare hauteur = unite/3
  box {
    <0, -largeur/2, -hauteur/2>, <unite, largeur/2, hauteur/2>
  }
  cylinder {
    <0, 0, -hauteur/2>, <0, 0, hauteur/2>, largeur/2
  }
  cylinder {
    <unite, 0, -hauteur/2>, <unite, 0, hauteur/2>, largeur/2
  }
}

// **** generateur de dragon ****
#if (choixDragon = 1)
  #declare nomDragon = "hilber"
  #declare nombreEnfants = 4
  #declare nbSecteurs = 4
  #declare taille = unite / (pow(2, nombreJours))
  #declare dragon =  union {
    #include "goDragon.inc"
    translate <-unite/2, -unite/2, 0>
    texture {
      T_Copper_2C
    }
    finish {
      ambient lux_ambient
    }
  }
#end

//---------------------------------------------------------
// CUBE
//---------------------------------------------------------

#declare long_poutre = 6

#declare nb_pico_spheres = 20

#declare rayon_poutre = 1.5/(2+4*3.14159265357/nb_pico_spheres)

#declare poutre =
cylinder {
  <0, -long_poutre/2, 0>, <0, long_poutre/2, 0>, rayon_poutre
  texture {
    T_Stone19
    scale 4
  }
}

#declare rayon_pico_spheres = 3.14159265357*rayon_poutre/nb_pico_spheres

#declare pico_sphere =
sphere {
  <0, 0, 0>, rayon_pico_spheres
  translate <rayon_poutre, 0, 0>
}

#declare couronne =
union {
  object {
    pico_sphere
    rotate <0, 0*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 1*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 2*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 3*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 4*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 5*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 6*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 7*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 8*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 9*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 10*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 11*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 12*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 13*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 14*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 15*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 16*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 17*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 18*360/nb_pico_spheres, 0>
  }
  object {
    pico_sphere
    rotate <0, 19*360/nb_pico_spheres, 0>
  }
  texture {
    T_Stone21
    scale 7
  }
}

#declare embase_colonne =
union {
  torus {
    rayon_poutre+rayon_pico_spheres,
    rayon_pico_spheres
  }
  cylinder {
    <0, -rayon_pico_spheres, 0>,
    <0, +rayon_pico_spheres, 0>,
    rayon_poutre+rayon_pico_spheres
  }
  texture {
    T_Stone24
    scale 1
  }
}

#declare rotule_colonne =
intersection {
  sphere {
    <1.5, 0.65, 1.5> 1.25
    scale <1, 1.75, 1>
  }
  box {
    <0.75, -1.5, 0.75>, <2.25, 0, 2.25>
  }
  texture {
    T_Stone12
    scale 0.6
  }
}

#declare plateau_colonne =
merge {
  box {
    <0, 0.39, 0>, <2, 0.65, 2>
  }
  triangle {
    <0, 0.4, 0>, <2, 0.4, 0>, <0, 0.4, 2>
  }
  triangle {
    <0, 0.4, 2>, <2, 0.4, 2>, <2, 0.4, 0>
  }
  triangle {
    <0.25, 0, 0.25>, <1.75, 0, 0.25>, <0, 0.4, 0>
  }
  triangle {
    <1.75, 0, 0.25>, <0, 0.4, 0>, <2, 0.4, 0>
  }
  triangle {
    <0.25, 0, 0.25>, <0.25, 0, 1.75>, <0, 0.4, 2>
  }
  triangle {
    <0, 0.4, 2>, <0.25, 0, 0.25>, <0, 0.4, 0>
  }
  triangle {
    <1.75, 0, 0.25>, <2, 0.4, 0>, <1.75, 0, 1.75>
  }
  triangle {
     <2, 0.4, 0>, <1.75, 0, 1.75>, <2, 0.4, 2>
  }
  triangle {
    <0.25, 0, 1.75>, <1.75, 0, 1.75>, <0, 0.4, 2>
  }
  triangle {
    <1.75, 0, 1.75>, <0, 0.4, 2>, <2, 0.4, 2>
  }
  triangle {
    <0.25, 0, 0.25>, <1.75, 0, 0.25>, <0.25, 0, 1.75>
  }
  triangle {
    <0.25, 0, 1.75>, <1.75, 0, 1.75>, <1.75, 0, 0.25>
  }
  texture {
    T_Stone18
    scale 1.5
  }
}

#declare colonne =
union {
  object {
    plateau_colonne
    translate <0, 10.85, 0>
  }
  object {
    rotule_colonne
    translate <-0.5, 10.85, -0.5>
  }
  object {
    couronne
    translate <0.25+2*rayon_pico_spheres+rayon_poutre,
               10,
               0.25+2*rayon_pico_spheres+rayon_poutre>
  }
  object {
    poutre
    translate <0.25+2*rayon_pico_spheres+rayon_poutre,
               7,
               0.25+2*rayon_pico_spheres+rayon_poutre>
  }
  object {
    couronne
    translate <0.25+2*rayon_pico_spheres+rayon_poutre,
               4-rayon_pico_spheres,
               0.25+2*rayon_pico_spheres+rayon_poutre>
  }
  object {
    embase_colonne
    translate <0.25+2*rayon_pico_spheres+rayon_poutre,
               4-3*rayon_pico_spheres,
               0.25+2*rayon_pico_spheres+rayon_poutre>
  }
}

#declare hauteur_cube_bas_colonne = 4-4*rayon_pico_spheres

#declare recouvrement = 0.01

#declare structure_bas =
union {
  box {
    <-10, -10, -10>,
    <-10+2, 10, -10+3>
  }
  box {
    <-10, -10, -10+3-recouvrement>,
    <-10+2, -10+hauteur_cube_bas_colonne, -10+5>
  }
  box {
    <-10, -10, -10+5-recouvrement>,
    <-10+2, -10+3, 10-2+recouvrement>
  }
  box {
    <-10, -10, 10-2>,
    <-10+2, -10+hauteur_cube_bas_colonne, 10>
  }
  box {
    <-10+2-recouvrement, -10, 10-2>,
    <10-5+recouvrement, -10+3, 10>
  }
  box {
    <10-5, -10, 10-2>,
    <10-3+recouvrement, -10+hauteur_cube_bas_colonne, 10>
  }
  box {
    <10-3, -10, 10-2>,
    <10, 10, 10>
  }
  box {
    <-10, 10-3, 10-2>,
    <10-3+recouvrement, 10, 10>
  }
  box {
    <-10, 10-3, -10+3-recouvrement>,
    <-10+2, 10, 10>
  }
  texture {
    #if (structure_fast_com = on)
      pigment { Gray }
    #else
      T_Stone13
    #end
    finish {
      ambient lux_ambient
    }
    scale 1
  }
}

#declare arcane =
difference {
  box {
    <-17/2+0.25, 0, 0>, <17/2, 5.5, 1.5>
  }
  cylinder {
    <0, 0, -0.1>, <0, 0, 1.6>, 4.5
    scale <13.4/9, 1, 1>
  }
  texture {
    T_Stone23
    scale 3
  }
  finish {
    ambient lux_ambient
  }
}

#declare pantin =
merge {
  sphere {
    <0, 0, 0>, 0.5
    texture {
      New_Brass
    }
  }
  sphere {
    <0, -0.8, 0>, 0.6
    scale <1, 1.7, 1.2>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0.1, -0.8, 0.65>, 0.3
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0.1, -0.8, -0.65>, 0.3
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <-0.1, -2.1, 0>, 0.6
    scale <1, 1, 1.2>
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <-0.35, -2.25, -0.4>, 0.3
    scale <2.7, 1, 1>
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <-1.7, -2.25, -0.4>, 0.3
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <-0.35, -2.25, 0.4>, 0.3
    scale <2.7, 1, 1>
    rotate <0, 0, -45>
    translate <1.5, -1, 0>
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <-1.28, -1.38, 0.4>, 0.3
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <-0.9, -2.27, -0.4>, 0.25
    scale <2.6, 1, 1>
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    scale <1, 2.1, 1.2>
    rotate <0, 0, 20>
    translate <-3.1, -2.13, -0.4>
    pigment {
      Flesh
    }
  }
  sphere {
    <-0.9, -2.27, 0.4>, 0.25
    scale <2.6, 1, 1>
    rotate <0, 0, 50>
    translate <-1.9, 1.45, 0>
    texture {
      pigment { DarkSlateBlue }
      finish { Dull }
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    scale <1, 2.1, 1.2>
    rotate <0, 0, 88>
    translate <-2.2, -2.3, 0.4>
    pigment {
      Flesh
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    scale <1, 2, 1>
    translate <0.1, -1.27, -0.9>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    translate <0.1, -1.71, -0.9>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0, 0, 0>, 0.16
    scale <1, 2.85, 1>
    translate <0.1, -2.15, -0.9>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    scale <1.1, 1.3, 0.7>
    translate <0.1, -2.75, -0.9>
    texture {
      New_Brass
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    scale <1, 2, 1>
    rotate <0, 0, -70>
    translate <-0.35, -0.98, 0.9>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    translate <-0.75, -1.12, 0.9>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0, 0, 0>, 0.16
    scale <1, 2.85, 1>
    rotate <110, 0, 0>
    rotate <0, 45, 0>
    translate <-1.15, -1, 0.67>
    texture {
      Water pigment{SkyBlue}
    }
  }
  sphere {
    <0, 0, 0>, 0.2
    scale <1.1, 1.3, 0.7>
    rotate <45, 0, 0>
    rotate <0, 30, 0>
    translate <-1.4, -0.95, 0.3>
    texture {
      New_Brass
    }
  }
}

#declare vingt_cinq =
height_field {
  gif "25.gif"
  water_level 0.01
  texture {
    T_Gold_5C
    //T_Stone21
    scale <2/6, 1, 2/5>
    translate <0.3, 0, 0>
  }
  finish {
    specular 0.1
    roughness 0.7
  }
  scale <6, 1, 5>
  rotate <-90, 0, 0>
  rotate <0, -90, 0>
  translate <-9.5, -2, -1.5>
}

#declare fil =
cylinder {
  <0, 0, 0>, <0, 3.5, 0>, 0.08
  texture {
    EMBWood1
    scale <0.4, 0.18, 0.4>
  }
}

//---------------------------------------------------------
// SCENE
//---------------------------------------------------------

#declare motif =
union {
  #if (structure_bas_com = on)
    object {
      structure_bas
    }
  #end
  #if (arcane_com = on)
    object {
      arcane
      translate <-10+17/2, 1.5, 8.25>
    }
    object {
      arcane
      rotate <0, 90, 0>
      translate <-10+0.25, 1.5, 10-17/2>
    }
  #end
  #if (colonne_com = on)
    object {
      colonne
      translate <-10, -10, -7>
    }
    object {
      colonne
      translate <-10, -10, 8>
    }
    object {
      colonne
      translate <5, -10, 8>
    }
  #end
  #if (pantin_com = on)
    object {
      pantin
      translate <4.5, -4.5, 8.7>
    }
  #end
  #if (ciel_com = on)
    object {
      ciel
    }
  #end
  #if (mer_com = on)
    object {
      mer
    }
  #end
  #if (vingt_cinq_com = on)
    object {
      vingt_cinq
    }
    object {
      fil
      rotate <0, 90, 0>
      translate <-9, 2.8, 0>
    }
    object {
      fil
      translate <-9, 2.8, 3>
    }
  #end
  #if (choixDragon = 1)
    object {
      dragon
      translate <taille/2, 0, 0>
      scale <7, 7, 1>
      translate <1.5-3, 0.1, 9>
    }
    object {
      fil
      translate <0.2-3, 3.2, 9>
    }
    object {
      fil
      rotate <0, 90, 0>
      translate <2.8-3, 3.2, 9>
    }
  #end
  #if (noeud_com = on)
    object {
      noeud
      pigment {
        radial
      }
      rotate <-10, 0, 0>
      scale 0.3
      translate <0, 0, 11+8.5>
      rotate <17.5, -20, 0>
      translate <0, 0, -8.5>
    }
  #end
  #if (moebius_com = on)
    object {
      ruban_moebius
      pigment {
        radial rotate <0, 90, 0>
      }
      finish {
        ambient lux_ambient-0.3
      }
      scale 0.4
      translate <0, 0, 9.5+8.5>
      rotate <18.2, -32, 0>
      translate <0, 0, -8.5>
    }
  #end
}

union {
  object {
    motif
  }
  object {
    motif
    rotate <0, 0, -90>
    rotate <0, 90, 0>
  }
  object {
    motif
    rotate <0, 0, 90>
    rotate <90, 0, 0>
  }
}

//---------------------------------------------------------
// LUMIERES
//---------------------------------------------------------

//light_source { <-55, 330, 18> color White }
light_source {
  <5, 5, -5>
  color LightGray
}
light_source {
  <-11, 9.5, 11>
  color White
}
light_source {
  <-5, -5, -5>
  color LightGray
}
light_source {
  <11, 11, -9.5>
  color White
}
light_source {
  <-5, 5, 5>
  color LightGray
}
light_source {
  <-9.5, -11, -11>
  color White
}

//---------------------------------------------------------
// CAMERA
//---------------------------------------------------------

camera {
  location  <0, 0, -8.5>
  direction <0, 0, camera_dz>
  up <0, 1, 0>
  right <1.22222222222222222 , 0, 0>
  look_at  <0, 0, 10>
  rotate <camera_r1, camera_r2, camera_r3>
  translate <camera_t1, camera_t2, camera_t3>
}
