#declare NB_BAGUETTES = 40
#declare pas = 2*pi/(NB_BAGUETTES-5)

#declare ruban_moebius = union {
  #declare param = -pi
  #while (param<pi)

    bicubic_patch {
      type 1
      flatness 0.01
      u_steps 4
      v_steps 4

      #declare i = 0
      #while (i<4)
        #declare param_int = param+i*pas/3
        #declare mx = (pi/3)*sin(2*param_int)
        #declare my = pi*sin(param_int-pi/2)
        #declare mz = pi*sin(param_int)
        #if (param<0)
          #declare ry = -(pi/2)-(pi/4)*sin(param_int+pi/2)
        #else
          #declare ry=-pi+(pi/4)*sin(param_int+pi/2)
        #end
        #declare bx = cos(ry)
        #declare by = 0
        #declare bz = -sin(ry)

        <mx-bx, my-by, mz-bz>, <mx-bx/2, my-by/2, mz-bz/2>, <mx+bx/2, my+by/2, mz+bz/2>, <mx+bx, my+by, mz+bz>

        #declare i = i+1
      #end
    }
    #declare param = param+pas
  #end

  bounded_by {
    box {
      <-2.1, -3.24, -4.24>, <2.1, 3.24, 3.24>
    }
  }
}
