#include "colors.inc"
#include "finish.inc"

#declare Leather = texture {
pigment {
	granite
	color_map {
		[0.00 color Brown]
		[0.60 color rgbf <0.60, 0.11, 0.11, 0.7>]
		[0.80 color rgbf <0.68, 0.18, 0.15, 0.9>]
		[1.00 color rgbf <0.70, 0.20, 0.17, 0.7>]
		}
	}
finish { specular 0.1 roughness 0.5 }
}


#declare Cover = superellipsoid
{
	<0.05, 0.05>
	scale <2.4, 3, 0.1>
	texture { Leather }
}
#declare PlainCover = superellipsoid
{
	<0.05, 0.05>
	scale <2.4, 3, 0.1>
}

#declare Bind_proto = 
difference {
cylinder { <0, 1, 0>, <0, -1, 0>, 0.5 }
box { <0, 1.5, 1.5>, <1, -1.5, -1.5> }
}

#declare Bind = object { Bind_proto
	texture { Leather}
	scale <1, 3, 1>
	translate <-2.4, 0, 0.5>
}

#declare Pages = box
{
	<-2.4, 2.85, 0.1>, <2.25, -2.85, 0.9>
/*
	pigment {
		gradient y
		frequency 10
		color_map {
			[0.25 color White]
			[0.5 color White*0.5]
			[0.75 color White*0.75]
			[1.00 color Black]
		 }
	}
*/
	texture {
		pigment { color White*0.85 }
		finish { diffuse 0.8 roughness 0.01 }
		normal { bumps scale 0.1 }
		}
}


#declare Book = union {
	object { Bind }
	object { Cover}
	object { Cover translate z*1 }
	object { Pages}
}
		
#declare ImageTitle =
union {
	text { ttf "timrom.ttf" "Color by Numbers" 1, 0
		pigment { BrightGold }
		finish { Glossy ambient 0.9 diffuse 0.5 }
		translate <-3.75, 2.5, -0.7>
		scale <0.5, 0.7, 1>
	     }
	text { ttf "timrom.ttf" "Aaron Gage" 0.8, 0
		pigment { BrightGold }
		finish { Glossy ambient 0.9 diffuse 0.5 }
		translate <-2.4, -2, -0.7>
		scale <0.6, 0.6, 1>
	     }
}

#declare Book1 = 
union {
  difference { 
	object { Book }
	object { ImageTitle texture { Leather } }
	}
  object { ImageTitle translate z*0.68 }
}

#declare PlainBook = 
union {
  difference { 
	object { PlainCover pigment { Brown }}
	object { ImageTitle }
	}
  object { ImageTitle translate z*0.68 }
}

