#include "colors.inc"
#include "finish.inc"

#declare GroundTexture = 
texture {
    pigment {
        crackle
        turbulence 0.3
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.45
        rotate <0, 5, 60>
        color_map {
            [0.02 color rgbf <0.35, 0.07, 0.08, 0.0> ]
            [0.06 color rgbf <0.45, 0.10, 0.10, 0.0> ]
            [0.10 color rgbf <0.55, 0.12, 0.12, 0.0> ]
            [1.00 color rgbf <0.65, 0.16, 0.16, 0.0> ]
        }
    }
}

#declare GrassTexture1 =
texture {
    pigment {
	wrinkles
        turbulence 0.4
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.45
        rotate <0, 5, 60>
        color_map {
            [0.10 color Clear ]
            [0.20 color rgbf <0.06, 0.75, 0.01, 0.9> ]
            [0.45 color rgbf <0.06, 0.75, 0.01, 0.6> ]
            [0.65 color rgbf <0.07, 0.85, 0.02, 0.25> ]
            [0.85 color rgbf <0.08, 0.90, 0.04, 0.15> ]
            [1.00 color rgbf <0.12, 1.00, 0.06, 0.0> ]
        }
    }
/*
	  normal {
	    bump_map {
	      tga "grass.tga"
	      bump_size 5.0
		    }
		  }
*/

    finish { Dull }
}

#declare GrassTexture2 =
texture {
    pigment {
        wrinkles
        turbulence 1.25
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.35
        rotate <0, 5, 60>
        color_map {
            [0.10 color Clear ]
            [0.20 color rgbf <0.20, 0.75, 0.01, 0.9> ]
            [0.45 color rgbf <0.20, 0.75, 0.01, 0.6> ]
            [0.65 color rgbf <0.25, 0.85, 0.02, 0.25> ]
            [0.85 color rgbf <0.28, 0.90, 0.04, 0.15> ]
            [1.00 color rgbf <0.31, 1.00, 0.06, 0.0> ]
        }
    }
/*
	  normal {
	    bump_map {
	      tga "grass.tga"
	      bump_size 4.0
		    }
	  }
*/
    finish { Dull }
}

#declare GrassTexture3 =
texture {
    pigment {
        wrinkles
        turbulence 0.3
        lambda 2.4
        omega 0.79
        octaves 5
        scale 0.25
        rotate <0, 5, 60>
        color_map {
            [0.90 color Clear ]
            [0.94 color rgbf <0.75, 0.85, 0.12, 0.65> ]
            [0.98 color rgbf <0.85, 0.90, 0.16, 0.55> ]
            [1.00 color rgbf <0.95, 1.00, 0.19, 0.25> ]
        }
    }
/*
	normal {
	    bump_map {
	      tga "grass.tga"
	      bump_size 5.0
		    }
	  }
*/

    finish { Dull }
}


#declare FlowerTexture1 =
texture {
    pigment {
        granite
        turbulence 0.5
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.35
        rotate <0, 5, 60>
        color_map {
            [0.70 color Clear ]
            [0.78 color rgbf <0.58, 0.68, 0.02, 0.6> ]
            [0.88 color rgbf <0.68, 0.78, 0.22, 0.4> ]
            [1.00 color rgbf <0.79, 0.92, 0.42, 0.0> ]
        }
    }
    normal { bumps 1.5 scale 0.5 }
    finish { Glossy }
}

#declare FlowerTexture2 =
texture {
    pigment {
        granite
        turbulence 0.6
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.35
        rotate <0, 5, 60>
        color_map {
            [0.70 color Clear ]
            [0.80 color rgbf <0.60, 0.30, 0.02, 0.6> ]
            [0.90 color rgbf <0.75, 0.50, 0.22, 0.4> ]
            [1.00 color rgbf <0.97, 0.80, 0.42, 0.0> ]
        }
    }
    normal { bumps 1.6 scale 0.6}
    finish { Glossy }
}

#declare Terrain =
  height_field {
    tga "groundhf.tga"
    smooth
    pigment { Brown }
    normal {crackle 0.3 scale 2}
  }

#declare Mountains = 
  height_field {
    tga "image2.tga"
    smooth
    pigment { Brown }
    normal {crackle 0.3 scale 2}
  }

#declare Atmos = atmosphere {
  type 2
  samples 2        // Number of samples in first distance interval
  distance 400       // Atmosphere density, similar to fog
  scattering 0.01    // Reflectivity of atmosphere, determines brightness
  aa_level 4        // Level of binary subdivision in case of aa
  aa_threshold 0.1  // Threshold for aa to push in
  jitter 0.15        // Amount of sample jittering
}

#declare MountainTexture = 
texture {
    pigment {
        wrinkles
        turbulence 1.25
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.35
        rotate <0, 5, 60>
        color_map {
            [0.30 color Clear ]
            [0.65 color rgbf <0.25, 0.55, 0.02, 0.75> ]
            [0.85 color rgbf <0.28, 0.70, 0.04, 0.55> ]
        }
    }
    normal { bumps 0.3 scale 10 }
    finish { Dull }
}

