
#ifndef (ABCDE)
#include "defaults.inc"

#include "floor.pov"
#include "stones2.inc"
#end
//============================================================
#declare WaterTex =
   texture { pigment { color Cyan}
   finish{ ambient .4
           diffuse .5
           reflection 0.1
           phong 0.9
           phong_size 200
         }
   normal { ripples 10 turbulence 2 }
   scale .25
}

#declare FoutainBed =
union{
   difference{
     cylinder {  < 0, -.4, 0>   < 0,  .4,  0> 4.25 texture {T_Stone30  }}
     cylinder {  < 0, -.4, 0>   < 0,  .5,  0> 4.00 texture {T_Stone30  }}
   }
  cylinder  {  < 0, -.4, 0>   < 0,  .1,  0> 4.00 texture {WaterTex }}
 translate < 0, -6, 0 >
}

/*
SPLEENWORT FERNs variation 2
*/
#declare Loops = 0
#declare MaxLoops = 2000

#declare CaseSeed = seed(400)
#declare Xseed    = seed(100)
#declare Yseed    = seed(20000)
 #declare X = rand(Xseed)
 #declare Y = rand(Yseed)

#declare Fern2 =
mesh {
#while ( Loops <= MaxLoops )
 #switch(rand(CaseSeed))
   #range ( 0.00,  0.01) // .01
     #declare X = ( (0 * X ) + (0.00 * Y + 0))
     #declare Y = ( (.0002 * X ) + (0.1599 * Y + 0))
   #break
   #range ( 0.01,  0.73)  //.51
     #declare X = ( ( 0.8492 * X ) + (0.20371 * Y + 0.0 ))
     #declare Y =(  (-0.1371 * X ) + (0.9492 * Y + 1.6 ))
   #break
   #range ( 0.73,  0.89)  //.89
     #declare X = ( ( 0.1968 * X ) +  (-0.2264 * Y + 0.0 ))
     #declare Y = ( ( 0.2264 * X ) +  ( 0.1968 * Y + 1.6 ))
   #break
   #range ( 0.89,  1.00)  // 1
     #declare X = ( (-0.15 * X ) + (0.2834 * Y + 0.00 ))
     #declare Y = ( ( 0.2598 * X ) + (0.2378 * Y + 0.44 ))
   #break
  #end

triangle { < X -.1, Y, 0 >, < X , Y + .1, 0 >, < X + .1, Y, 0 >  }
#declare Loops = Loops + 1 #end
texture { WaterTex }
rotate < 0, 0, 15 >
scale .2
translate < 0, -4, 0 >
}

#declare Loops = -2
#declare MaxLoops = 2
 #declare X = 0
 #declare Y = 0

#declare F1 =
mesh {
#while ( Loops <= MaxLoops )
 #declare X =  Loops
#declare Y = (X*X) + X
   triangle{ < X -.1, Y, 0  >, < X, Y + .02, 0 >, < X + .1, Y, 0 > }
#declare Loops = Loops + .01 #end
texture { WaterTex }
rotate < 0, 0, 180 >
translate < -1.5, 0, 0 >
}

#declare Foutain =
union {
cylinder{  -7*y,  -.4*y,  .5  open texture {T_Stone30  }}
#declare X = 0
#while ( X <= 360 )
object { Fern2  scale 1.1 translate < -2, .5, 0 > rotate < 0, X, 0 >}
object { Fern2  scale 1.5 translate < -2.7, -.1, 0 > rotate < 0, X, 0 >}
#declare X = X + 10 #end
#declare X = 0
#while ( X <= 360 )
   object { F1 translate < -.1, 0, 0> rotate < 0, X, 0> }
#declare X = X + 10 #end
object {FoutainBed}
}

object { Foutain scale .5 translate < 6.2, 3, 10> }
