/*
BBall.inc

Copyright Martin Vilcans 1997
*/

#declare BBall_r = 57.15/2		// pocket billiard ball radius according to BCA (millimeters)

#declare T_BBall = texture {
	finish {
		ambient 0.3
		diffuse 0.5
		reflection 0.2
		phong 0.9
		phong_size 70 //250
		//specular 0.9
		//roughness 0.005
	}
}

#declare BBall = union {
	sphere { < 0,0,0 >, BBall_r
		texture {
			T_BBall
			pigment {
				gradient y
				color_map {
					[ 0.00 BBallCol1 ]
					[ 0.30 BBallCol1 ]
					[ 0.30 BBallCol2 ]
					[ 0.70 BBallCol2 ]
					[ 0.70 BBallCol1 ]
					[ 1.00 BBallCol1 ]
				}
				scale BBall_r*2
				translate -BBall_r
			}
		}
	}
	union {
		intersection {
			cylinder { < 0,0,-100>, <0,0,100>, 9 }
			sphere { < 0,0,0 >, BBall_r+0.0001 }
			texture {
				T_BBall
				pigment { color White }
			}
		}
		#if ((strcmp(BBallText,"")!=0) & do_btext )
		intersection {
			text {
				ttf BBallFont,
				BBallText,big,0
				scale 20
				translate x*(BBallTextXOffs-5)
				translate y*(BBallTextYOffs-5)
				translate z*-1000
			}
			sphere { < 0,0,0 >, BBall_r+0.0002 }
			texture {
				T_BBall
				pigment { color Black }
			}
		}
		#end
	}
}
